/*************************************************************************
 *
 *  $RCSfile: rapofflineprovider.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINEPROVIDER_HXX
#include "rapofflineprovider.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINECONTENT_HXX
#include "rapofflinecontent.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINECONTENTTYPEDATA_HXX
#include "rapofflinecontenttypedata.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEDBADAPTER_HXX
#include "rapofflinedbadapter.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEPERSISTENTSTORAGEFACTORY_HXX
#include "rapofflinepersistentstoragefactory.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGE_HXX
#include "rapofflinestorage.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEERROR_HXX
#include "rapofflinestorageerror.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#include "rapofflinestoragenode.hxx"
#endif

#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include "com/sun/star/io/XOutputStream.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_SYNC_XDBADAPTER_HPP_
#include "com/sun/star/sync/XDBAdapter.hpp"
#endif
#ifndef _COM_SUN_STAR_SYNC_XPERSISTENTSTORAGEFACTORY_HPP_
#include "com/sun/star/sync/XPersistentStorageFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_SYNC_XSYNCADAPTER_HPP_
#include "com/sun/star/sync/XSyncAdapter.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include "com/sun/star/ucb/CommandAbortedException.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include "com/sun/star/ucb/XContent.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIER_HPP_
#include "com/sun/star/ucb/XContentIdentifier.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include "com/sun/star/uno/Exception.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _RTL_USTRING_H_
#include "rtl/ustring.h"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

using namespace com::sun;
using ucprmt::offline::ContentContainer;
using ucprmt::offline::ContentTypeData;
using ucprmt::offline::DBAdapter;
using ucprmt::offline::PersistentStorageFactory;
using ucprmt::offline::Provider;
using ucprmt::offline::Storage;
using ucprmt::offline::StorageError;

Provider::Provider(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
    rtl::Reference< Storage > const & rStorage):
    m_xServiceFactory(rServiceFactory),
    m_xStorage(rStorage),
    m_xContentTypeData(new ContentTypeData),
    m_xContents(new ContentContainer(rServiceFactory,
                                     rStorage,
                                     m_xContentTypeData))
{
    OSL_ASSERT(m_xStorage.is());
}

Provider::~Provider()
{}

star::uno::Reference< star::ucb::XContent > SAL_CALL
Provider::queryContent(
    star::uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier)
    throw (star::ucb::IllegalIdentifierException, star::uno::RuntimeException)
{
    rtl::OUString aId;
    if (rIdentifier.is())
        aId = rIdentifier->getContentIdentifier();
    star::uno::Reference< star::ucb::XContent > xContent;
    try
    {
        xContent = m_xContents->queryContent(aId);
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
#if 0
    if (!xContent.is()
        && rIdentifier.is()
        && rIdentifier->getContentProviderScheme().
                            equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
                                             "vnd.sun.star.pkg")))
    {
        star::uno::Reference< star::ucb::XContentProvider > xProvider;
        if (m_xServiceFactory.is())
            try
            {
                xProvider
                    = star::uno::Reference< star::ucb::XContentProvider >(
                          m_xServiceFactory->
                              createInstance(
                                  rtl::OUString(
                                      RTL_CONSTASCII_USTRINGPARAM(
                                 "com.sun.star.ucb.PackageContentProvider"))),
                          star::uno::UNO_QUERY);
            }
            catch (star::uno::RuntimeException &)
            {
                throw;
            }
            catch (star::uno::Exception &)
            {
                OSL_ASSERT(false);
            }
        OSL_ASSERT(xProvider.is());
        if (xProvider.is())
            xContent = xProvider->queryContent(rIdentifier);
    }
#endif // 0
    return xContent;
}

sal_Int32 SAL_CALL
Provider::compareContentIds(
    star::uno::Reference< star::ucb::XContentIdentifier > const & rId1,
    star::uno::Reference< star::ucb::XContentIdentifier > const & rId2)
    throw (star::uno::RuntimeException)
{
    rtl::OUString aURI1;
    if (rId1.is())
        aURI1 = rId1->getContentIdentifier();
    rtl::OUString aURI2;
    if (rId2.is())
        aURI2 = rId2->getContentIdentifier();
    return aURI1.compareTo(aURI2);
}

sal_Int32 SAL_CALL
Provider::getFileProviderLocality(rtl::OUString const & rBaseURL)
    throw (star::uno::RuntimeException)
{
    return 0; //TODO!
}

rtl::OUString SAL_CALL
Provider::getFileURLFromSystemPath(rtl::OUString const & rBaseURL,
                                   rtl::OUString const & rSystemPath)
    throw (star::uno::RuntimeException)
{
    return rtl::OUString(); //TODO!
}

rtl::OUString SAL_CALL
Provider::getSystemPathFromFileURL(rtl::OUString const & rURL)
    throw (star::uno::RuntimeException)
{
    return rtl::OUString(); //TODO!
}

void Provider::synchronize(rtl::OUString const & rClientId,
                           rtl::OUString const & rConnectionData)
    SAL_THROW((star::ucb::CommandAbortedException,
               star::uno::RuntimeException))
{
    star::uno::Reference< star::sync::XSyncAdapter > xSyncAdapter;
    if (m_xServiceFactory.is())
        try
        {
            xSyncAdapter
                = star::uno::Reference< star::sync::XSyncAdapter >(
                      m_xServiceFactory->
                          createInstance(
                              rtl::OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                                      "com.sun.star.sync.SyncAdapter"))),
                      star::uno::UNO_QUERY);
        }
        catch (star::uno::RuntimeException const &)
        {
            throw;
        }
        catch (star::uno::Exception const &)
        {
            OSL_ASSERT(false);
        }
    if (!xSyncAdapter.is())
        throw
            star::ucb::CommandAbortedException(
                rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                  "ucprmt::offline::Provider::synchronize():"
                                      " bad com.sun.star.sync.SyncAdapter")),
                0);

    rtl::OUString aPath;
    //TODO!

    xSyncAdapter->sync(0,
                       new PersistentStorageFactory(m_xServiceFactory, aPath),
                       new DBAdapter(m_xServiceFactory,
                                     m_xStorage->getNodes()),
                       rConnectionData,
                       rClientId);
}
