/*************************************************************************
 *
 *  $RCSfile: rmtprov.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:54:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTPROV_HXX_
#define _UCPRMT_RMTPROV_HXX_

#include <map>

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPARAMETERIZEDCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XParameterizedContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_ 
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_ 
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_ 
#include <cppuhelper/weak.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_REF_HXX_ 
#include <rtl/ref.hxx>
#endif
#ifndef _SAL_TYPES_H_ 
#include <sal/types.h>
#endif

#ifndef _UCB_REGEXPMAP_HXX_
#include <regexpmap.hxx>
#endif

namespace com { namespace sun { namespace star {
    namespace lang { class XMultiServiceFactory; }
    namespace uno { class XInterface; }
} } }
namespace rtl { class OUString; }

namespace ucprmt {

class Connection;
class ConnectionMap;

//============================================================================
class ContentProvider:
        public cppu::OWeakObject,
        public com::sun::star::lang::XServiceInfo,
        public com::sun::star::lang::XTypeProvider,
        public com::sun::star::ucb::XContentProvider,
        public com::sun::star::ucb::XContentIdentifierFactory,
        public com::sun::star::ucb::XParameterizedContentProvider
{
public:
    ContentProvider(
        com::sun::star::uno::Reference<
                com::sun::star::lang::XMultiServiceFactory > const &
            rTheFactory);

    //========================================================================
    // com::sun::star::uno::XInterface:

    virtual com::sun::star::uno::Any SAL_CALL
    queryInterface(com::sun::star::uno::Type const & rType)
        throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

    //========================================================================
    // com::sun::star::lang::XServiceInfo:

    virtual rtl::OUString SAL_CALL getImplementationName()
        throw (com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL supportsService(rtl::OUString const &
                                                  rServiceName)
        throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL
    getSupportedServiceNames() throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::lang::XTypeProvider:

    virtual
    com::sun::star::uno::Sequence< com::sun::star::uno::Type > SAL_CALL
    getTypes() throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL
    getImplementationId() throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::ucb::XContentProvider:

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
    queryContent(com::sun::star::uno::Reference<
                         com::sun::star::ucb::XContentIdentifier > const &
                     rIdentifier)
        throw (com::sun::star::ucb::IllegalIdentifierException,
               com::sun::star::uno::RuntimeException);

    virtual sal_Int32 SAL_CALL
    compareContentIds(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rId1,
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XContentIdentifier > const &
            rId2)
        throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::ucb::XContentIdentifierFactory:

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
    SAL_CALL
    createContentIdentifier(rtl::OUString const & rContentId)
        throw (com::sun::star::uno::RuntimeException);

    //========================================================================
    // com::sun::star::ucb::XParameterizedContentProvider:

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentProvider >
    SAL_CALL
    registerInstance(rtl::OUString const & rTemplate,
                     rtl::OUString const & rArguments,
                     sal_Bool bReplaceExisting)
        throw (com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    virtual
    com::sun::star::uno::Reference< com::sun::star::ucb::XContentProvider >
    SAL_CALL
    deregisterInstance(rtl::OUString const & rTemplate,
                       rtl::OUString const & rArguments)
        throw (com::sun::star::lang::IllegalArgumentException,
               com::sun::star::uno::RuntimeException);

    //========================================================================
    // Service Implementation:

    static sal_Char const * getImplementationName_static();

    static com::sun::star::uno::Sequence< rtl::OUString >
    getSupportedServiceNames_static();

    static
    com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
    createInstance(
        com::sun::star::uno::Reference<
                com::sun::star::lang::XMultiServiceFactory > const &
            rTheFactory);

    //========================================================================
    // Implementation:

    rtl::Reference< Connection >
    findConnection(com::sun::star::uno::Reference<
                           com::sun::star::ucb::XContentIdentifier > const &
                       rIdentifier)
        throw (com::sun::star::uno::RuntimeException);

private:
    struct ConnectionCount
    {
        int m_nConnections;
        int m_nOfflineModes;

        inline ConnectionCount() throw ():
            m_nConnections(0), m_nOfflineModes(0) {}
    };

    struct ConnectionComp
    {
        inline bool operator ()(rtl::Reference< Connection > const & rConn1,
                                rtl::Reference< Connection > const & rConn2)
            const
        { return (rConn1 < rConn2) != false; }
    };

    typedef std::map< rtl::Reference< Connection >,
                      ConnectionCount,
                      ConnectionComp >
        ConnectionCountMap;

    typedef ucb::RegexpMap< rtl::Reference< Connection > >
    RegexpToConnectionMap;

    osl::Mutex m_aMutex;
    com::sun::star::uno::Reference<
            com::sun::star::lang::XMultiServiceFactory >
        m_xFactory;
    rtl::Reference< ConnectionMap > m_xConnectionMap;
    ConnectionCountMap m_aRegisteredConnections;
    RegexpToConnectionMap m_aUriToRegisteredConnectionMap;

    bool parseArguments(rtl::OUString const & rArguments,
                        rtl::OUString * pRemoteProviderURL,
                        bool * pOffline);
};

}

#endif // _UCPRMT_RMTPROV_HXX_
