/*************************************************************************
 *
 *  $RCSfile: salinst.h,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: pluby $ $Date: 2000/11/27 01:47:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *		 - GNU Lesser General Public License Version 2.1
 *		 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALINST_H
#define _SV_SALINST_H

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _VOS_MUTEX_HXX
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_THREAD_HXX
#include <vos/thread.hxx>
#endif

#ifndef _SV_VCLWINDOW_H
#include <VCLWindow.h>
#endif

#ifdef __cplusplus

class SalYieldMutex;

#else // __cplusplus

#define SalYieldMutex void

#endif // __cplusplus

// -----------------
// - SalYieldMutex -
// -----------------

class SalYieldMutex : public NAMESPACE_VOS(OMutex)
{
	ULONG										mnCount;
	NAMESPACE_VOS(OThread)::TThreadIdentifier	mnThreadId;

public: 
												SalYieldMutex();
	virtual void								acquire();
	virtual void								release();
	virtual sal_Bool							tryToAcquire();
	ULONG										GetAcquireCount() const { return mnCount; }
	NAMESPACE_VOS(OThread)::TThreadIdentifier	GetThreadId() const { return mnThreadId; }
};

// -------------------
// - SalInstanceData -
// -------------------

struct SalInstanceData
{
public:
	void*				mpFilterInst;
	void*				mpFilterCallback;
	SalYieldMutex*		mpSalYieldMutex;		// Sal-Yield-Mutex
};

#endif // _SV_SALINST_H
