/*************************************************************************
 *
 *	$RCSfile: font.hxx,v $
 *
 *	$Revision: 1.6 $
 *
 *	last change: $Author: pl $ $Date: 2001/08/01 12:32:45 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_FONT_HXX
#define _SV_FONT_HXX

#ifndef _TOOLS_GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _TOOLS_STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_LANG_HXX
#include <tools/lang.hxx>
#endif
#ifndef _SV_COLOR_HXX
#include <color.hxx>
#endif
#ifndef _VCL_VCLENUM_HXX
#include <vclenum.hxx>
#endif
#ifndef _VCL_FNTSTYLE_HXX
#include <fntstyle.hxx>
#endif

#ifdef SMART_UNO_GENERATION
class Font_Type;
class Font_Size;
class Font_Attribs;
#endif

class SvStream;
#define FontAlign TextAlign

// ------------
// - Impl_Font -
// ------------

class Impl_Font
{
	friend class Font;

private:
	USHORT				mnRefCount;
	XubString			maName;
	XubString			maStyleName;
	Size				maSize;
	Color				maColor;		// compatibility, now on output device
	Color				maFillColor;	// compatibility, now on output device
	rtl_TextEncoding	meCharSet;
	LanguageType		meLanguage;
	LanguageType		meCJKLanguage;
	FontFamily			meFamily;
	FontPitch			mePitch;
	TextAlign			meAlign;
	FontWeight			meWeight;
	FontWidth			meWidthType;
	FontItalic			meItalic;
	FontUnderline		meUnderline;
	FontStrikeout		meStrikeout;
	FontRelief			meRelief;
	FontEmphasisMark	meEmphasisMark;
	FontType			meType;			// used by metrics only
	short				mnOrientation;
	FontKerning 		mnKerning;
	BOOL				mbWordLine:1,
						mbOutline:1,
						mbShadow:1,
						mbVertical:1,
                                   mbTransparent:1;	// compatibility, now on output device

	friend SvStream&	operator>>( SvStream& rIStm, Impl_Font& rImplFont );
	friend SvStream&	operator<<( SvStream& rOStm, const Impl_Font& rImplFont );

public:
						Impl_Font();
						Impl_Font( const Impl_Font& rImplFont );
};

// --------
// - Font -
// --------

class Font
{
private:
	Impl_Font*			mpImplFont;

	void				MakeUnique();

public:
						Font();
						Font( const Font& rFont );
						Font( const XubString& rName, const Size& rSize );
						Font( const XubString& rName, const XubString& rStyleName,
							  const Size& rSize );
						Font( FontFamily eFamily, const Size& rSize );
						~Font();

	void				SetColor( const Color& rColor );
	const Color&		GetColor() const { return mpImplFont->maColor; }
	void				SetFillColor( const Color& rColor );
	const Color&		GetFillColor() const { return mpImplFont->maFillColor; }
	void				SetTransparent( BOOL bTransparent );
	BOOL				IsTransparent() const { return mpImplFont->mbTransparent; }
	void				SetAlign( FontAlign eAlign );
	FontAlign			GetAlign() const { return mpImplFont->meAlign; }

	void				SetName( const XubString& rName );
	const XubString&	GetName() const { return mpImplFont->maName; }
	void				SetStyleName( const XubString& rStyleName );
	const XubString&	GetStyleName() const { return mpImplFont->maStyleName; }
	void				SetSize( const Size& rSize );
	const Size& 		GetSize() const { return mpImplFont->maSize; }
	void				SetHeight( long nHeight ) { SetSize( Size( mpImplFont->maSize.Width(), nHeight ) ); }
	long				GetHeight() const { return mpImplFont->maSize.Height(); }
	void				SetWidth( long nWidth ) { SetSize( Size( nWidth, mpImplFont->maSize.Height() ) ); }
	long				GetWidth() const { return mpImplFont->maSize.Width(); }

	void				SetFamily( FontFamily eFamily );
	FontFamily			GetFamily() const { return mpImplFont->meFamily; }
	void				SetCharSet( rtl_TextEncoding eCharSet );
	rtl_TextEncoding	GetCharSet() const { return mpImplFont->meCharSet; }
	void				SetLanguage( LanguageType eLanguage );
	LanguageType		GetLanguage() const { return mpImplFont->meLanguage; }
	void				SetCJKContextLanguage( LanguageType eLanguage );
	LanguageType		GetCJKContextLanguage() const { return mpImplFont->meCJKLanguage; }
	void				SetPitch( FontPitch ePitch );
	FontPitch			GetPitch() const { return mpImplFont->mePitch; }

	void				SetOrientation( short nLineOrientation );
	short				GetOrientation() const { return mpImplFont->mnOrientation; }
	void				SetVertical( BOOL bVertical );
	BOOL				IsVertical() const { return mpImplFont->mbVertical; }
	void				SetKerning( FontKerning nKerning );
	FontKerning 		GetKerning() const { return mpImplFont->mnKerning; }
	BOOL				IsKerning() const { return (mpImplFont->mnKerning & KERNING_FONTSPECIFIC) != 0; }

	void				SetWeight( FontWeight eWeight );
	FontWeight			GetWeight() const { return mpImplFont->meWeight; }
	void				SetWidthType( FontWidth eWidth );
	FontWidth			GetWidthType() const { return mpImplFont->meWidthType; }
	void				SetItalic( FontItalic eItalic );
	FontItalic			GetItalic() const { return mpImplFont->meItalic; }
	void				SetOutline( BOOL bOutline );
	BOOL				IsOutline() const { return mpImplFont->mbOutline; }
	void				SetShadow( BOOL bShadow );
	BOOL				IsShadow() const { return mpImplFont->mbShadow; }
	void				SetRelief( FontRelief eRelief );
	FontRelief			GetRelief() const { return mpImplFont->meRelief; }
	void				SetUnderline( FontUnderline eUnderline );
	FontUnderline		GetUnderline() const { return mpImplFont->meUnderline; }
	void				SetStrikeout( FontStrikeout eStrikeout );
	FontStrikeout		GetStrikeout() const { return mpImplFont->meStrikeout; }
	void				SetEmphasisMark( FontEmphasisMark eEmphasisMark );
	FontEmphasisMark	GetEmphasisMark() const { return mpImplFont->meEmphasisMark; }
	void				SetWordLineMode( BOOL bWordLine );
	BOOL				IsWordLineMode() const { return mpImplFont->mbWordLine; }

	void				Merge( const Font& rFont );

	Font&				operator=( const Font& rFont );
	BOOL				operator==( const Font& rFont ) const;
	BOOL				operator!=( const Font& rFont ) const
							{ return !(Font::operator==( rFont )); }
	BOOL				IsSameInstance( const Font& rFont ) const
							{ return (mpImplFont == rFont.mpImplFont); }

	friend SvStream&	operator>>( SvStream& rIStm, Font& rFont );
	friend SvStream&	operator<<( SvStream& rOStm, const Font& rFont );

#ifdef SMART_UNO_GENERATION
	void				getType( Font_Type& ) const;
	void				setType( const Font_Type& );

	void				getSize( Font_Size& ) const;
	void				setSize( const Font_Size& );

	void				getAttribs( Font_Attribs& ) const;
	void				setAttribs( const Font_Attribs& );
#endif

};

#ifndef NOOLDSV
#define SetLineOrientation			SetOrientation
#define GetLineOrientation			GetOrientation
#endif

#endif	// _VCL_FONT_HXX
