/*************************************************************************
 *
 *  $RCSfile: metaact.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sj $ $Date: 2002/10/25 12:28:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_METAACT_HXX
#define _SV_METAACT_HXX

#ifndef _SV_GRADIENT_HXX
#include <gradient.hxx>
#endif
#ifndef _SV_HATCH_HXX
#include <hatch.hxx>
#endif
#ifndef _SV_WALL_HXX
#include <wall.hxx>
#endif
#ifndef _SV_FONT_HXX
#include <font.hxx>
#endif
#ifndef _SV_POLY_HXX
#include <poly.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <bitmap.hxx>
#endif
#ifndef _SV_BITMAPEX_HXX
#include <bitmapex.hxx>
#endif
#ifndef _SV_REGION_HXX
#include <region.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <graph.hxx>
#endif
#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif
#ifndef _SV_GDIMTF_HXX
#include <gdimtf.hxx>
#endif
#ifndef _GFXLINK_HXX
#include <gfxlink.hxx>
#endif
#ifndef _SV_LINEINFO_HXX
#include <lineinfo.hxx>
#endif

class SvStream;

// -----------
// - Defines -
// -----------

#define META_NULL_ACTION					(0)
#define META_PIXEL_ACTION					(100)
#define META_POINT_ACTION					(101)
#define META_LINE_ACTION					(102)
#define META_RECT_ACTION					(103)
#define META_ROUNDRECT_ACTION				(104)
#define META_ELLIPSE_ACTION 				(105)
#define META_ARC_ACTION 					(106)
#define META_PIE_ACTION 					(107)
#define META_CHORD_ACTION					(108)
#define META_POLYLINE_ACTION				(109)
#define META_POLYGON_ACTION 				(110)
#define META_POLYPOLYGON_ACTION 			(111)
#define META_TEXT_ACTION					(112)
#define META_TEXTARRAY_ACTION				(113)
#define META_STRETCHTEXT_ACTION 			(114)
#define META_TEXTRECT_ACTION				(115)
#define META_BMP_ACTION 					(116)
#define META_BMPSCALE_ACTION				(117)
#define META_BMPSCALEPART_ACTION			(118)
#define META_BMPEX_ACTION					(119)
#define META_BMPEXSCALE_ACTION				(120)
#define META_BMPEXSCALEPART_ACTION			(121)
#define META_MASK_ACTION					(122)
#define META_MASKSCALE_ACTION				(123)
#define META_MASKSCALEPART_ACTION			(124)
#define META_GRADIENT_ACTION				(125)
#define META_HATCH_ACTION					(126)
#define META_WALLPAPER_ACTION				(127)
#define META_CLIPREGION_ACTION				(128)
#define META_ISECTRECTCLIPREGION_ACTION 	(129)
#define META_ISECTREGIONCLIPREGION_ACTION	(130)
#define META_MOVECLIPREGION_ACTION			(131)
#define META_LINECOLOR_ACTION				(132)
#define META_FILLCOLOR_ACTION				(133)
#define META_TEXTCOLOR_ACTION				(134)
#define META_TEXTFILLCOLOR_ACTION			(135)
#define META_TEXTALIGN_ACTION				(136)
#define META_MAPMODE_ACTION 				(137)
#define META_FONT_ACTION					(138)
#define META_PUSH_ACTION					(139)
#define META_POP_ACTION 					(140)
#define META_RASTEROP_ACTION				(141)
#define META_TRANSPARENT_ACTION 			(142)
#define META_EPS_ACTION 					(143)
#define META_REFPOINT_ACTION				(144)
#define META_TEXTLINECOLOR_ACTION			(145)
#define META_TEXTLINE_ACTION				(146)
#define META_FLOATTRANSPARENT_ACTION		(147)
#define META_GRADIENTEX_ACTION				(148)
#define META_LAYOUTMODE_ACTION 				(149)

#define META_COMMENT_ACTION 				(512)

// ------------------------------------------------------------------------

struct ImplMetaReadData
{
	rtl_TextEncoding		meActualCharSet;
};

// ------------------------------------------------------------------------

struct ImplMetaWriteData
{
	rtl_TextEncoding		meActualCharSet;
};

// ------------------------------------------------------------------------

#define DECL_META_ACTION( Name, nType ) 									\
						Meta##Name##Action();								\
	virtual 			~Meta##Name##Action();								\
	virtual void		Execute( OutputDevice* pOut );						\
	virtual MetaAction* Clone();											\
	virtual void		Write( SvStream& rOStm, ImplMetaWriteData* pData ); \
	virtual void		Read( SvStream& rIStm, ImplMetaReadData* pData );

#define IMPL_META_ACTION( Name, nType ) 								\
Meta##Name##Action::Meta##Name##Action() :								\
	MetaAction( nType ) {}												\
Meta##Name##Action::~Meta##Name##Action() {}

// --------------
// - MetaAction -
// --------------

class MetaAction
{
private:
	USHORT				mnRefCount;
	UINT16				mnType;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						MetaAction();
						MetaAction( USHORT nType );
	virtual 			~MetaAction();

	virtual void		Execute( OutputDevice* pOut );

	virtual MetaAction* Clone();

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	virtual void		Write( SvStream& rOStm, ImplMetaWriteData* pData );
	virtual void		Read( SvStream& rIStm, ImplMetaReadData* pData );

	sal_Bool			IsEqual( const MetaAction& ) const;

	USHORT				GetType() const { return mnType; }
	USHORT				GetRefCount() const { return mnRefCount; }
	void				ResetRefCount() { mnRefCount = 1; }
	void				Duplicate()  { mnRefCount++; }
	void				Delete() { if ( 0 == --mnRefCount ) delete this; }

public:
	static MetaAction*	ReadMetaAction( SvStream& rIStm, ImplMetaReadData* pData );
};

// -------------------
// - MetaPixelAction -
// -------------------

class MetaPixelAction : public MetaAction
{
private:
	Point				maPt;
	Color				maColor;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Pixel, META_PIXEL_ACTION )

						MetaPixelAction( const Point& rPt, const Color& rColor );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Point&		GetPoint() const { return maPt; }
	const Color&		GetColor() const { return maColor; }
};

// -------------------
// - MetaPointAction -
// -------------------

class MetaPointAction : public MetaAction
{
private:
	Point				maPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Point, META_POINT_ACTION )

						MetaPointAction( const Point& rPt );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Point&		GetPoint() const { return maPt; }
};

// ------------------
// - MetaLineAction -
// ------------------

class MetaLineAction : public MetaAction
{
private:

	LineInfo			maLineInfo;
	Point				maStartPt;
	Point				maEndPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Line, META_LINE_ACTION )

						MetaLineAction( const Point& rStart, const Point& rEnd );
						MetaLineAction( const Point& rStart, const Point& rEnd,
										const LineInfo& rLineInfo );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Point&		GetStartPoint() const { return maStartPt; }
	const Point&		GetEndPoint() const { return maEndPt; }
	const LineInfo& 	GetLineInfo() const { return maLineInfo; }
};

// ------------------
// - MetaRectAction -
// ------------------

class MetaRectAction : public MetaAction
{
private:

	Rectangle			maRect;

	virtual	sal_Bool	Compare( const MetaAction& ) const;
public:
						DECL_META_ACTION( Rect, META_RECT_ACTION )

						MetaRectAction( const Rectangle& rRect );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
};

// -----------------------
// - MetaRoundRectAction -
// -----------------------

class MetaRoundRectAction : public MetaAction
{
private:

	Rectangle			maRect;
	ULONG				mnHorzRound;
	ULONG				mnVertRound;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( RoundRect, META_ROUNDRECT_ACTION )

						MetaRoundRectAction( const Rectangle& rRect,
											 long nHorzRound, long nVertRound );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	ULONG				GetHorzRound() const { return mnHorzRound; }
	ULONG				GetVertRound() const { return mnVertRound; }
};

// ---------------------
// - MetaEllipseAction -
// ---------------------

class MetaEllipseAction : public MetaAction
{
private:

	Rectangle			maRect;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Ellipse, META_ELLIPSE_ACTION )

						MetaEllipseAction( const Rectangle& rRect );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
};

// -----------------
// - MetaArcAction -
// -----------------

class MetaArcAction : public MetaAction
{
private:

	Rectangle			maRect;
	Point				maStartPt;
	Point				maEndPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Arc, META_ARC_ACTION )

						MetaArcAction( const Rectangle& rRect,
									   const Point& rStart, const Point& rEnd );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	const Point&		GetStartPoint() const { return maStartPt; }
	const Point&		GetEndPoint() const { return maEndPt; }
};

// -----------------
// - MetaPieAction -
// -----------------

class MetaPieAction : public MetaAction
{
private:

	Rectangle			maRect;
	Point				maStartPt;
	Point				maEndPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Pie, META_PIE_ACTION )

						MetaPieAction( const Rectangle& rRect,
									   const Point& rStart, const Point& rEnd );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	const Point&		GetStartPoint() const { return maStartPt; }
	const Point&		GetEndPoint() const { return maEndPt; }
};

// -------------------
// - MetaChordAction -
// -------------------

class MetaChordAction : public MetaAction
{
private:

	Rectangle			maRect;
	Point				maStartPt;
	Point				maEndPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Chord, META_CHORD_ACTION )

						MetaChordAction( const Rectangle& rRect,
										 const Point& rStart, const Point& rEnd );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	const Point&		GetStartPoint() const { return maStartPt; }
	const Point&		GetEndPoint() const { return maEndPt; }
};

// ----------------------
// - MetaPolyLineAction -
// ----------------------

class MetaPolyLineAction : public MetaAction
{
private:

	LineInfo			maLineInfo;
	Polygon 			maPoly;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( PolyLine, META_POLYLINE_ACTION )

						MetaPolyLineAction( const Polygon& rPoly );
						MetaPolyLineAction( const Polygon& rPoly, const LineInfo& rLineInfo );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Polygon&		GetPolygon() const { return maPoly; }
	const LineInfo& 	GetLineInfo() const { return maLineInfo; }
};

// ---------------------
// - MetaPolygonAction -
// ---------------------

class MetaPolygonAction : public MetaAction
{
private:

	Polygon 			maPoly;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Polygon, META_POLYGON_ACTION )

						MetaPolygonAction( const Polygon& rPoly );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Polygon&		GetPolygon() const { return maPoly; }
};

// -------------------------
// - MetaPolyPolygonAction -
// -------------------------

class MetaPolyPolygonAction : public MetaAction
{
private:

	PolyPolygon 		maPolyPoly;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( PolyPolygon, META_POLYPOLYGON_ACTION )

						MetaPolyPolygonAction( const PolyPolygon& rPolyPoly );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const PolyPolygon&	GetPolyPolygon() const { return maPolyPoly; }
};

// ------------------
// - MetaTextAction -
// ------------------

class MetaTextAction : public MetaAction
{
private:

	Point				maPt;
	XubString			maStr;
	USHORT				mnIndex;
	USHORT				mnLen;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Text, META_TEXT_ACTION )

						MetaTextAction( const Point& rPt, const XubString& rStr,
										USHORT nIndex, USHORT nLen );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Point&		GetPoint() const { return maPt; }
	const XubString&	GetText() const { return maStr; }
	USHORT				GetIndex() const { return mnIndex; }
	USHORT				GetLen() const { return mnLen; }
};

// -----------------------
// - MetaTextArrayAction -
// -----------------------

class MetaTextArrayAction : public MetaAction
{
private:

	Point				maStartPt;
	XubString			maStr;
	long*				mpDXAry;
	USHORT				mnIndex;
	USHORT				mnLen;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						MetaTextArrayAction();
						MetaTextArrayAction( const MetaTextArrayAction& rAction );
						MetaTextArrayAction( const Point& rStartPt,
											 const XubString& rStr,
											 const long* pDXAry,
											 USHORT nIndex,
											 USHORT nLen );
	virtual 			~MetaTextArrayAction();

	virtual void		Execute( OutputDevice* pOut );

	virtual MetaAction* Clone();

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	virtual void		Write( SvStream& rOStm, ImplMetaWriteData* pData );
	virtual void		Read( SvStream& rIStm, ImplMetaReadData* pData );

	const Point&		GetPoint() const { return maStartPt; }
	const XubString&	GetText() const { return maStr; }
	USHORT				GetIndex() const { return mnIndex; }
	USHORT				GetLen() const { return mnLen; }
	long*				GetDXArray() const { return mpDXAry; }
};

// -------------------------
// - MetaStretchTextAction -
// -------------------------

class MetaStretchTextAction : public MetaAction
{
private:

	Point				maPt;
	XubString			maStr;
	ULONG				mnWidth;
	USHORT				mnIndex;
	USHORT				mnLen;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( StretchText, META_STRETCHTEXT_ACTION )

						MetaStretchTextAction( const Point& rPt, ULONG nWidth,
											   const XubString& rStr,
											   USHORT nIndex, USHORT nLen );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Point&		GetPoint() const { return maPt; }
	const XubString&	GetText() const { return maStr; }
	ULONG				GetWidth() const { return mnWidth; }
	USHORT				GetIndex() const { return mnIndex; }
	USHORT				GetLen() const { return mnLen; }
};

// ----------------------
// - MetaTextRectAction -
// ----------------------

class MetaTextRectAction : public MetaAction
{
private:

	Rectangle			maRect;
	XubString			maStr;
	USHORT				mnStyle;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( TextRect, META_TEXTRECT_ACTION )

						MetaTextRectAction( const Rectangle& rRect,
											const XubString& rStr, USHORT nStyle );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	const XubString&	GetText() const { return maStr; }
	USHORT				GetStyle() const { return mnStyle; }
};

// ----------------------
// - MetaTextLineAction -
// ----------------------

class MetaTextLineAction : public MetaAction
{
private:

	Point				maPos;
	long				mnWidth;
	FontStrikeout		meStrikeout;
	FontUnderline		meUnderline;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( TextLine, META_TEXTLINE_ACTION )

						MetaTextLineAction( const Point& rPos, long nWidth,
											FontStrikeout eStrikeout,
											FontUnderline eUnderline );
	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Point&		GetStartPoint() const { return maPos; }
	long				GetWidth() const { return mnWidth; }
	FontStrikeout		GetStrikeout() const { return meStrikeout; }
	FontUnderline		GetUnderline() const { return meUnderline; }
};

// -----------------
// - MetaBmpAction -
// -----------------

class MetaBmpAction : public MetaAction
{
private:

	Bitmap				maBmp;
	Point				maPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Bmp, META_BMP_ACTION )

						MetaBmpAction( const Point& rPt, const Bitmap& rBmp );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Bitmap&		GetBitmap() const { return maBmp; }
	const Point&		GetPoint() const { return maPt; }
};

// ----------------------
// - MetaBmpScaleAction -
// ----------------------

class MetaBmpScaleAction : public MetaAction
{
private:

	Bitmap				maBmp;
	Point				maPt;
	Size				maSz;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( BmpScale, META_BMPSCALE_ACTION )

						MetaBmpScaleAction( const Point& rPt, const Size& rSz,
											const Bitmap& rBmp );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Bitmap&		GetBitmap() const { return maBmp; }
	const Point&		GetPoint() const { return maPt; }
	const Size& 		GetSize() const { return maSz; }
};

// --------------------------
// - MetaBmpScalePartAction -
// --------------------------

class MetaBmpScalePartAction : public MetaAction
{
private:

	Bitmap				maBmp;
	Point				maDstPt;
	Size				maDstSz;
	Point				maSrcPt;
	Size				maSrcSz;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( BmpScalePart, META_BMPSCALEPART_ACTION )

						MetaBmpScalePartAction( const Point& rDstPt, const Size& rDstSz,
												const Point& rSrcPt, const Size& rSrcSz,
												const Bitmap& rBmp );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Bitmap&		GetBitmap() const { return maBmp; }
	const Point&		GetDestPoint() const { return maDstPt; }
	const Size& 		GetDestSize() const { return maDstSz; }
	const Point&		GetSrcPoint() const { return maSrcPt; }
	const Size& 		GetSrcSize() const { return maSrcSz; }
};

// -----------------
// - MetaBmpExAction -
// -----------------

class MetaBmpExAction : public MetaAction
{
private:

	BitmapEx			maBmpEx;
	Point				maPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( BmpEx, META_BMPEX_ACTION )

						MetaBmpExAction( const Point& rPt, const BitmapEx& rBmpEx );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const BitmapEx& 	GetBitmapEx() const { return maBmpEx; }
	const Point&		GetPoint() const { return maPt; }
};

// ----------------------
// - MetaBmpExScaleAction -
// ----------------------

class MetaBmpExScaleAction : public MetaAction
{
private:

	BitmapEx			maBmpEx;
	Point				maPt;
	Size				maSz;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( BmpExScale, META_BMPEXSCALE_ACTION )

						MetaBmpExScaleAction( const Point& rPt, const Size& rSz,
											  const BitmapEx& rBmpEx ) ;

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const BitmapEx& 	GetBitmapEx() const { return maBmpEx; }
	const Point&		GetPoint() const { return maPt; }
	const Size& 		GetSize() const { return maSz; }
};

// ----------------------------
// - MetaBmpExScalePartAction -
// ----------------------------

class MetaBmpExScalePartAction : public MetaAction
{
private:

	BitmapEx			maBmpEx;
	Point				maDstPt;
	Size				maDstSz;
	Point				maSrcPt;
	Size				maSrcSz;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( BmpExScalePart, META_BMPEXSCALEPART_ACTION )

						MetaBmpExScalePartAction( const Point& rDstPt, const Size& rDstSz,
												  const Point& rSrcPt, const Size& rSrcSz,
												  const BitmapEx& rBmpEx );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const BitmapEx& 	GetBitmapEx() const { return maBmpEx; }
	const Point&		GetDestPoint() const { return maDstPt; }
	const Size& 		GetDestSize() const { return maDstSz; }
	const Point&		GetSrcPoint() const { return maSrcPt; }
	const Size& 		GetSrcSize() const { return maSrcSz; }
};

// ------------------
// - MetaMaskAction -
// ------------------

class MetaMaskAction : public MetaAction
{
private:

	Bitmap				maBmp;
	Color				maColor;
	Point				maPt;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Mask, META_MASK_ACTION )

						MetaMaskAction( const Point& rPt,
										const Bitmap& rBmp,
										const Color& rColor );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Bitmap&		GetBitmap() const { return maBmp; }
	const Color&		GetColor() const { return maColor; }
	const Point&		GetPoint() const { return maPt; }
};

// -----------------------
// - MetaMaskScaleAction -
// -----------------------

class MetaMaskScaleAction : public MetaAction
{
private:

	Bitmap				maBmp;
	Color				maColor;
	Point				maPt;
	Size				maSz;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( MaskScale, META_MASKSCALE_ACTION )

						MetaMaskScaleAction( const Point& rPt, const Size& rSz,
											 const Bitmap& rBmp,
											 const Color& rColor );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Bitmap&		GetBitmap() const { return maBmp; }
	const Color&		GetColor() const { return maColor; }
	const Point&		GetPoint() const { return maPt; }
	const Size& 		GetSize() const { return maSz; }
};

// ---------------------------
// - MetaMaskScalePartAction -
// ---------------------------

class MetaMaskScalePartAction : public MetaAction
{
private:

	Bitmap				maBmp;
	Color				maColor;
	Point				maDstPt;
	Size				maDstSz;
	Point				maSrcPt;
	Size				maSrcSz;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( MaskScalePart, META_MASKSCALEPART_ACTION )

						MetaMaskScalePartAction( const Point& rDstPt, const Size& rDstSz,
												 const Point& rSrcPt, const Size& rSrcSz,
												 const Bitmap& rBmp,
												 const Color& rColor );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Bitmap&		GetBitmap() const { return maBmp; }
	const Color&		GetColor() const { return maColor; }
	const Point&		GetDestPoint() const { return maDstPt; }
	const Size& 		GetDestSize() const { return maDstSz; }
	const Point&		GetSrcPoint() const { return maSrcPt; }
	const Size& 		GetSrcSize() const { return maSrcSz; }
};

// ----------------------
// - MetaGradientAction -
// ----------------------

class MetaGradientAction : public MetaAction
{
private:

	Rectangle			maRect;
	Gradient			maGradient;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Gradient, META_GRADIENT_ACTION )

						MetaGradientAction( const Rectangle& rRect, const Gradient& rGradient );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	const Gradient& 	GetGradient() const { return maGradient; }
};

// ------------------------
// - MetaGradientExAction -
// ------------------------

class MetaGradientExAction : public MetaAction
{
private:

	PolyPolygon 		maPolyPoly;
	Gradient			maGradient;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( GradientEx, META_GRADIENTEX_ACTION )

						MetaGradientExAction( const PolyPolygon& rPolyPoly, const Gradient& rGradient );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const PolyPolygon&	GetPolyPolygon() const { return maPolyPoly; }
	const Gradient& 	GetGradient() const { return maGradient; }
};

// -------------------
// - MetaHatchAction -
// -------------------

class MetaHatchAction : public MetaAction
{
private:

	PolyPolygon 		maPolyPoly;
	Hatch				maHatch;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Hatch, META_HATCH_ACTION )

						MetaHatchAction( const PolyPolygon& rPolyPoly, const Hatch& rHatch );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const PolyPolygon&	GetPolyPolygon() const { return maPolyPoly; }
	const Hatch&		GetHatch() const { return maHatch; }
};

// -----------------------
// - MetaWallpaperAction -
// -----------------------

class MetaWallpaperAction : public MetaAction
{
private:

	Rectangle			maRect;
	Wallpaper			maWallpaper;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Wallpaper, META_WALLPAPER_ACTION )

						MetaWallpaperAction( const Rectangle& rRect,
											 const Wallpaper& rPaper );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
	const Wallpaper&	GetWallpaper() const { return maWallpaper; }
};

// ------------------------
// - MetaClipRegionAction -
// ------------------------

class MetaClipRegionAction : public MetaAction
{
private:

	Region				maRegion;
	BOOL				mbClip;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( ClipRegion, META_CLIPREGION_ACTION )

						MetaClipRegionAction( const Region& rRegion, BOOL bClip );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Region&		GetRegion() const { return maRegion; }
	BOOL				IsClipping() const { return mbClip; }
};

// ---------------------------------
// - MetaISectRectClipRegionAction -
// ---------------------------------

class MetaISectRectClipRegionAction : public MetaAction
{
private:

	Rectangle			maRect;

	virtual	sal_Bool	Compare( const MetaAction& ) const;


public:
						DECL_META_ACTION( ISectRectClipRegion, META_ISECTRECTCLIPREGION_ACTION )

						MetaISectRectClipRegionAction( const Rectangle& rRect );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Rectangle&	GetRect() const { return maRect; }
};

// -----------------------------------
// - MetaISectRegionClipRegionAction -
// -----------------------------------

class MetaISectRegionClipRegionAction : public MetaAction
{
private:

	Region				maRegion;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( ISectRegionClipRegion, META_ISECTREGIONCLIPREGION_ACTION )

						MetaISectRegionClipRegionAction( const Region& rRegion );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const Region&		GetRegion() const { return maRegion; }
};

// ----------------------------
// - MetaMoveClipRegionAction -
// ----------------------------

class MetaMoveClipRegionAction : public MetaAction
{
private:

	long				mnHorzMove;
	long				mnVertMove;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( MoveClipRegion, META_MOVECLIPREGION_ACTION )

						MetaMoveClipRegionAction( long nHorzMove, long nVertMove );

	virtual void		Scale( double fScaleX, double fScaleY );

	long				GetHorzMove() const { return mnHorzMove; }
	long				GetVertMove() const { return mnVertMove; }
};

// -----------------------
// - MetaLineColorAction -
// -----------------------

class MetaLineColorAction : public MetaAction
{
private:

	Color				maColor;
	BOOL				mbSet;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( LineColor, META_LINECOLOR_ACTION )

						MetaLineColorAction( const Color& rColor, BOOL bSet );

	const Color&		GetColor() const { return maColor; }
	BOOL				IsSetting() const { return mbSet; }
};

// -----------------------
// - MetaFillColorAction -
// -----------------------

class MetaFillColorAction : public MetaAction
{
private:

	Color				maColor;
	BOOL				mbSet;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( FillColor, META_FILLCOLOR_ACTION )

						MetaFillColorAction( const Color& rColor, BOOL bSet );

	const Color&		GetColor() const { return maColor; }
	BOOL				IsSetting() const { return mbSet; }
};

// -----------------------
// - MetaTextColorAction -
// -----------------------

class MetaTextColorAction : public MetaAction
{
private:

	Color				maColor;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( TextColor, META_TEXTCOLOR_ACTION )

						MetaTextColorAction( const Color& rColor );

	const Color&		GetColor() const { return maColor; }
};

// ---------------------------
// - MetaTextFillColorAction -
// ---------------------------

class MetaTextFillColorAction : public MetaAction
{
private:

	Color				maColor;
	BOOL				mbSet;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( TextFillColor, META_TEXTFILLCOLOR_ACTION )

						MetaTextFillColorAction( const Color& rColor, BOOL bSet );

	const Color&		GetColor() const { return maColor; }
	BOOL				IsSetting() const { return mbSet; }
};

// ---------------------------
// - MetaTextLineColorAction -
// ---------------------------

class MetaTextLineColorAction : public MetaAction
{
private:

	Color				maColor;
	BOOL				mbSet;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( TextLineColor, META_TEXTLINECOLOR_ACTION )

						MetaTextLineColorAction( const Color& rColor, BOOL bSet );

	const Color&		GetColor() const { return maColor; }
	BOOL				IsSetting() const { return mbSet; }
};

// -----------------------
// - MetaTextAlignAction -
// -----------------------

class MetaTextAlignAction : public MetaAction
{
private:

	TextAlign			maAlign;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( TextAlign, META_TEXTALIGN_ACTION )

						MetaTextAlignAction( TextAlign aAlign );

	TextAlign			GetTextAlign() const { return maAlign; }
};

// ---------------------
// - MetaMapModeAction -
// ---------------------

class MetaMapModeAction : public MetaAction
{
private:

	MapMode 			maMapMode;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( MapMode, META_MAPMODE_ACTION )

						MetaMapModeAction( const MapMode& rMapMode );

	virtual void		Scale( double fScaleX, double fScaleY );

	const MapMode&		GetMapMode() const { return maMapMode; }
};

// ---------------------
// - MetaFontAction -
// ---------------------

class MetaFontAction : public MetaAction
{
private:

	Font				maFont;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Font, META_FONT_ACTION )

						MetaFontAction( const Font& rFont );

	virtual void		Scale( double fScaleX, double fScaleY );

	const Font& 		GetFont() const { return maFont; }
};

// ------------------
// - MetaPushAction -
// ------------------

class MetaPushAction : public MetaAction
{
private:

	USHORT				mnFlags;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Push, META_PUSH_ACTION )

						MetaPushAction( USHORT nFlags );

	USHORT				GetFlags() const { return mnFlags; }
};

// -----------------
// - MetaPopAction -
// -----------------

class MetaPopAction : public MetaAction
{
public:

		DECL_META_ACTION( Pop, META_POP_ACTION )
};

// ----------------------
// - MetaRasterOpAction -
// ----------------------

class MetaRasterOpAction : public MetaAction
{
private:

	RasterOp			meRasterOp;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( RasterOp, META_RASTEROP_ACTION )

						MetaRasterOpAction( RasterOp eRasterOp );

	RasterOp			GetRasterOp() const { return meRasterOp; }
};

// -------------------------
// - MetaTransparentAction -
// -------------------------

class MetaTransparentAction : public MetaAction
{
private:

	PolyPolygon 		maPolyPoly;
	USHORT				mnTransPercent;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( Transparent, META_TRANSPARENT_ACTION )

						MetaTransparentAction( const PolyPolygon& rPolyPoly, USHORT nTransPercent );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const PolyPolygon&	GetPolyPolygon() const { return maPolyPoly; }
	USHORT				GetTransparence() const { return mnTransPercent; }
};

// ------------------------------
// - MetaFloatTransparentAction -
// ------------------------------

class MetaFloatTransparentAction : public MetaAction
{
private:

	GDIMetaFile 		maMtf;
	Point				maPoint;
	Size				maSize;
	Gradient			maGradient;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( FloatTransparent, META_FLOATTRANSPARENT_ACTION )

						MetaFloatTransparentAction( const GDIMetaFile& rMtf, const Point& rPos,
													const Size& rSize, const Gradient& rGradient );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const GDIMetaFile&	GetGDIMetaFile() const { return maMtf; }
	const Point&		GetPoint() const { return maPoint; }
	const Size& 		GetSize() const { return maSize; }
	const Gradient& 	GetGradient() const { return maGradient; }
};

// ---------------------
// - MetaDrawEPSAction -
// ---------------------

class MetaEPSAction : public MetaAction
{
private:

	GfxLink 			maGfxLink;
	GDIMetaFile 		maSubst;
	Point				maPoint;
	Size				maSize;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( EPS, META_EPS_ACTION )

						MetaEPSAction( const Point& rPoint, const Size& rSize,
									   const GfxLink& rGfxLink, const GDIMetaFile& rSubst );

	virtual void		Move( long nHorzMove, long nVertMove );
	virtual void		Scale( double fScaleX, double fScaleY );

	const GfxLink&		GetLink() const { return maGfxLink; }
	const GDIMetaFile&	GetSubstitute() const { return maSubst; }
	const Point&		GetPoint() const { return maPoint; }
	const Size& 		GetSize() const { return maSize; }
};

// ----------------------
// - MetaRefPointAction -
// ----------------------

class MetaRefPointAction : public MetaAction
{
private:

	Point				maRefPoint;
	BOOL				mbSet;

	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( RefPoint, META_REFPOINT_ACTION )

						MetaRefPointAction( const Point& rRefPoint, BOOL bSet );

	const Point&		GetRefPoint() const { return maRefPoint; }
	BOOL				IsSetting() const { return mbSet; }
};

// ---------------------
// - MetaCommentAction -
// ---------------------

class MetaCommentAction : public MetaAction
{
private:

	ByteString			maComment;
	long				mnValue;
	ULONG				mnDataSize;
	BYTE*				mpData;

	void				ImplInitDynamicData( const BYTE* pData, ULONG nDataSize );
	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						MetaCommentAction( long nValue = 0L );
						MetaCommentAction( const MetaCommentAction& rAct );
						MetaCommentAction( const ByteString& rComment, long nValue = 0L, const BYTE* pData = NULL, ULONG nDataSize = 0UL );
						MetaCommentAction( const BYTE* pData, ULONG nDataSize );
						~MetaCommentAction();

	virtual void		Execute( OutputDevice* pOut );
	virtual MetaAction* Clone();
	virtual void		Write( SvStream& rOStm, ImplMetaWriteData* pData );
	virtual void		Read( SvStream& rIStm, ImplMetaReadData* pData );

	const ByteString&	GetComment() const { return maComment; }
	long				GetValue() const { return mnValue; }
	ULONG				GetDataSize() const { return mnDataSize; }
	const BYTE* 		GetData() const { return mpData; }
};

// ------------------------
// - MetaLayoutModeAction -
// ------------------------

class MetaLayoutModeAction : public MetaAction
{
private:
	
    ULONG    			mnLayoutMode;
	virtual	sal_Bool	Compare( const MetaAction& ) const;

public:
						DECL_META_ACTION( LayoutMode, META_LAYOUTMODE_ACTION )

						MetaLayoutModeAction( ULONG nLayoutMode );

    ULONG               GetLayoutMode() const { return mnLayoutMode; }
};

#endif // _SV_METAACT_HXX
