/*************************************************************************
 *
 *  $RCSfile: salinst.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: th $ $Date: 2001/07/25 10:54:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALINST_HXX
#define _SV_SALINST_HXX

#ifdef __cplusplus

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#endif // __cplusplus

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_SALINST_H
#include <salinst.h>
#endif

#ifdef __cplusplus

struct SystemParentData;
struct SalPrinterQueueInfo;
struct SalStatus;
struct ImplJobSetup;
class SalGraphics;
class SalFrame;
class SalObject;
class SalVirtualDevice;
class SalInfoPrinter;
class SalPrinter;
class ImplPrnQueueList;

namespace vos { class IMutex; }

// ---------------
// - SalInstance -
// ---------------

class SalInstance
{
    friend SalInstance* CreateSalInstance();
    friend void DestroySalInstance( SalInstance* );

private:
                            SalInstance();
                            ~SalInstance();

public:                     // public for Sal Implementation
    SalInstanceData         maInstData;

#ifdef _INCL_SAL_SALINST_IMP
#include <salinst.imp>
#endif

public:
                            // Frame
                            // DisplayName for Unix ???
    SalFrame*               CreateChildFrame( SystemParentData* pParent, ULONG nStyle );
    SalFrame*               CreateFrame( SalFrame* pParent, ULONG nStyle );
    void                    DestroyFrame( SalFrame* pFrame );

                            // Object (System Child Window)
    SalObject*              CreateObject( SalFrame* pParent );
    void                    DestroyObject( SalObject* pObject );

                            // VirtualDevice
                            // nDX and nDY in Pixeln
                            // nBitCount: 0 == Default / 1 == Mono
    SalVirtualDevice*       CreateVirtualDevice( SalGraphics* pGraphics,
                                                 long nDX, long nDY,
                                                 USHORT nBitCount );
    void                    DestroyVirtualDevice( SalVirtualDevice* pDevice );

                            // Printer
                            // pSetupData->mpDriverData can be 0
                            // pSetupData must be updatet with the current
                            // JobSetup
    SalInfoPrinter*         CreateInfoPrinter( SalPrinterQueueInfo* pQueueInfo,
                                               ImplJobSetup* pSetupData );
    void                    DestroyInfoPrinter( SalInfoPrinter* pPrinter );
    SalPrinter*             CreatePrinter( SalInfoPrinter* pInfoPrinter );
    void                    DestroyPrinter( SalPrinter* pPrinter );

    void                    GetPrinterQueueInfo( ImplPrnQueueList* pList );
    void                    GetPrinterQueueState( SalPrinterQueueInfo* pInfo );
    void                    DeletePrinterQueueInfo( SalPrinterQueueInfo* pInfo );
    XubString               GetDefaultPrinter();

                            // YieldMutex
    vos::IMutex*            GetYieldMutex();
    ULONG                   ReleaseYieldMutex();
    void                    AcquireYieldMutex( ULONG nCount );

                            // wait next event and dispatch
                            // must returned by UserEvent (SalFrame::PostEvent)
                            // and timer
    void                    Yield( BOOL bWait );
    static BOOL             AnyInput( USHORT nType );

    // methods for XDisplayConnection

    // the parameters for the callbacks are:
    //    void* pInst:          pInstance form the SetCallback call
    //    void* pEvent:         address of the system specific event structure
    //    int   nBytes:         length of the system specific event structure
    void                    SetEventCallback( void* pInstance, bool(*pCallback)(void*,void*,int));
    void                    SetErrorEventCallback( void* pInstance, bool(*pCallback)(void*,void*,int));

    enum ConnectionIdentifierType { AsciiCString, Blob };
    void*                   GetConnectionIdentifier( ConnectionIdentifierType& rReturnedType, int& rReturnedBytes );
};

// called from SVMain
SalInstance* CreateSalInstance();
void DestroySalInstance( SalInstance* pInst );

// -------------------------
// - SalInstance-Functions -
// -------------------------

void SalAbort( const XubString& rErrorText );

#endif // __cplusplus

// -----------
// - SalData -
// -----------

void InitSalData();                         // called from Application-Ctor
void DeInitSalData();                       // called from Application-Dtor
void SetFilterCallback( void* pCallback, void* pInst );

void InitSalMain();
void DeInitSalMain();

// ----------
// - SVMain -
// ----------

// Callbacks (indepen in \sv\source\app\svmain.cxx)
BOOL SVMain();

#endif // _SV_SALINST_HXX
