/*************************************************************************
 *
 *  $RCSfile: wrkwin.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/11 17:27:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WRKWIN_HXX
#define _SV_WRKWIN_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_SYSWIN_HXX
#include <syswin.hxx>
#endif

namespace com { namespace sun { namespace star { namespace uno { class Any; }}}}
struct SystemParentData;

// ----------------------
// - WorkWindow - Types -
// ----------------------

// Presentation Flags
#define PRESENTATION_HIDEALLAPPS    ((USHORT)0x0001)
#define PRESENTATION_NOFULLSCREEN   ((USHORT)0x0002)
#define PRESENTATION_NOAUTOSHOW     ((USHORT)0x0004)
#ifndef NOOLDSV
#define PRESENTATION_NOTFULLSCREEN  PRESENTATION_NOFULLSCREEN
#define PRESENTATION_NOTAUTOSHOW    PRESENTATION_NOAUTOSHOW
#endif

// --------------
// - WorkWindow -
// --------------

class WorkWindow : public SystemWindow
{
private:
    USHORT          mnPresentationFlags;
    BOOL            mbPresentationMode:1,
                    mbPresentationVisible:1,
                    mbPresentationFull:1,
                    mbFullScreenMode:1,
                    mbDummy0:1,
                    mbDummy1:1,
                    mbDummy2:1,
                    mbDummy3:1,
                    mbDummy4:1,
                    mbDummy5:1,
                    mbDummy6:1,
                    mbDummy7:1;

#ifdef _SV_WRKWIN_CXX
    void            ImplInitData();
    void            ImplInit( Window* pParent, WinBits nStyle, const ::com::sun::star::uno::Any& aSystemWorkWindowToken );
#endif

protected:
                    WorkWindow( WindowType nType );
    void            ImplInit( Window* pParent, WinBits nStyle, SystemParentData* pSystemParentData = NULL );
    void            ImplLoadRes( const ResId& rResId );
    void            ImplSetFrameState( ULONG aFrameState );

public:
                    WorkWindow( Window* pParent, const ResId& rResId );
                    WorkWindow( Window* pParent, WinBits nStyle = WB_STDWORK );
                    WorkWindow( Window* pParent, const ::com::sun::star::uno::Any& aSystemWorkWindowToken, WinBits nStyle = WB_STDWORK );
                    WorkWindow( SystemParentData* pParent ); // Not in the REMOTE-Version
                    ~WorkWindow();

    void            ShowFullScreenMode( BOOL bFullScreenMode = TRUE );
    void            EndFullScreenMode() { ShowFullScreenMode( FALSE ); }
    BOOL            IsFullScreenMode() const { return mbFullScreenMode; }

    void            StartPresentationMode( BOOL bPresentation = TRUE, USHORT nFlags = 0 );
    void            EndPresentationMode() {  StartPresentationMode( FALSE ); }
    BOOL            IsPresentationMode() const { return mbPresentationMode; }

    BOOL            IsMinimized() const;

    BOOL			SetPluginParent( SystemParentData* pParent );

#ifndef NOOLDSV
    void            Minimize();
    void            Maximize();
    void            Restore();

    BOOL            IsMaximized() const;

    void            SetOptOutputSizePixel( const Size& ) {}
    Size            GetOptOutputSizePixel() const { return Size(); }
#endif
};

#endif // _SV_WRKWIN_HXX
