/*************************************************************************
 *
 *  $RCSfile: MacUtil.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _MACUTIL_HXX
#define _MACUTIL_HXX

#include <Mac_Start.h>

#ifndef __TYPES__
  #include <Types.h>
#endif

#include <Mac_End.h>

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

// Wichtig, Strukturen muessen kompatibel zu 68k Strukturen sein !
#if defined(powerc) || defined (__powerc)
#pragma options align=mac68k
#endif

// --------------------------------------------------
// struct MacPoint
// --------------------------------------------------

/*
	MacPoint ist komaptibel zum Macintosh Point (MAC_Point) gleichzeitig aber
	auch kompatibel zum StarView Point, er kann weitestgehend wie ein MAC_Point
	verwendet werden (CastOperator auf MAC_Point und MAC_Point*)
	
	z.B.
	
	MacPoint aMacPoint = rSVPoint;
	aMacPoint += pMyWin->aImpOpd.aMacWinOffset;
	MoveTo(aMacPoint.v,aMacPoint.h);
*/

struct MacPoint
{
	inline MacPoint() { };
	inline MacPoint( short vP, short hP);
	inline MacPoint( MAC_Point aPoint);
	inline MacPoint( const Point& rPoint);
	inline MacPoint( const Size&  rSize);
	
	inline operator MAC_Point() const;
	inline operator MAC_Point*() const;
	inline operator Point() const;

	inline MacPoint& operator+=(MacPoint rP);
	inline MacPoint& operator-=(MacPoint rP);
	inline MacPoint& operator+=(MAC_Point rP);
	inline MacPoint& operator-=(MAC_Point rP);
	inline MacPoint& operator+=(const Point& rP);
	inline MacPoint& operator-=(const Point& rP);

	friend inline MacPoint operator+(const MacPoint& rP1,const MacPoint& rP2);
	friend inline MacPoint operator-(const MacPoint& rP1,const MacPoint& rP2);

	friend inline int operator==(MacPoint& rP1,MacPoint& rP2);
	friend inline int operator!=(MacPoint& rP1,MacPoint& rP2);

	short	v;
	short	h;
};

inline MacPoint::MacPoint(short vP, short hP)
{
	v = vP;	
	h = hP;
};

inline MacPoint::MacPoint(MAC_Point aPoint)
{
	v = aPoint.v;	
	h = aPoint.h;
};

inline MacPoint::MacPoint( const Point& rPoint)
{
	h = (short) rPoint.X();	
	v = (short) rPoint.Y();
}

inline MacPoint::MacPoint( const Size&  rSize)
{
	v = (short) rSize.Height();	
	h = (short) rSize.Width();
}

inline MacPoint& MacPoint::operator+=(MacPoint rP)
{
	h += rP.h;
	v += rP.v;
	return *this;
}

inline MacPoint& MacPoint::operator-=(MacPoint rP)
{
	h -= rP.h;
	v -= rP.v;
	return *this;
}

inline MacPoint& MacPoint::operator+=(MAC_Point rP)
{
	h += rP.h;
	v += rP.v;
	return *this;
}

inline MacPoint& MacPoint::operator-=(MAC_Point rP)
{
	h -= rP.h;
	v -= rP.v;
	return *this;
}

inline MacPoint& MacPoint::operator+=(const Point& rP)
{
	h += (short) rP.X();
	v += (short) rP.Y();
	return *this;
}

inline MacPoint& MacPoint::operator-=(const Point& rP)
{
	h -= (short) rP.X();
	v -= (short) rP.Y();
	return *this;
}

inline MacPoint operator+(const MacPoint& rP1,const MacPoint& rP2)
{
	MacPoint result;
	result.h = rP1.h + rP2.h;
	result.v = rP1.v + rP2.v;
	return result;
}

inline MacPoint operator-(const MacPoint& rP1,const MacPoint& rP2)
{
	MacPoint result;
	result.h = rP1.h - rP2.h;
	result.v = rP1.v - rP2.v;
	return result;
}

inline int operator== (MacPoint& rP1,MacPoint& rP2)
{
	return (rP1.h == rP2.h) && (rP1.v == rP2.v);
}

inline int operator!= (MacPoint& rP1,MacPoint& rP2)
{
	return (rP1.h != rP2.h) || (rP1.v != rP2.v);
}

inline MacPoint::operator MAC_Point () const
{
	return *((MAC_Point*) this);
}

inline MacPoint::operator MAC_Point* () const
{
	return (MAC_Point*) this;
}

inline MacPoint::operator Point () const
{
	return Point(h,v);
}

// --------------------------------------------------
// struct MacRect
// --------------------------------------------------

/*
	MacRect ist komaptibel zum Macintosh Rechteck (Rect) gleichzeitig aber
	auch kompatible zum StarView Rectangle, er kann weitestgehend wie ein Rect
	verwendet werden (CastOperator auf Rect und Rect*), Seine Konstuktoren
	und Memberfunktionen ersparen den Aufruf von Funktionen wie SetRect,
	OffsetRect oder InsetRect.
	
	z.B.
	
	MacRect aMacRect = rSVRect;
	MacPoint anOffset = pMyWin->aImpOpd.aMacWinOffset;
	aMacPoint.Offest(anOffset);
	aMacRect.Inset(1);		// Um Einen Pixel kleiner
	FrameRect(aMacRect);	// Man beachte: kein & ntig ...

*/

struct MacRect
{
	inline MacRect() { };
	inline MacRect( short topP, short leftP, short bottomP, short rightP);
	inline MacRect( MacPoint topLeft, MacPoint bottomRight);
	inline MacRect( const Point& rTopLeft, const Size& rSize);
	inline MacRect( const Rect& rRect);
	inline MacRect( const Rectangle& rRect);
	
	inline operator Rect() const;
	inline operator Rect*() const;
	inline operator Rectangle() const;

	inline MacPoint& TopLeft() const;
	inline const MacPoint& BottomRight() const;
	inline MacPoint& BottomRight();

	inline Size GetSize();
	inline MacRect& SetSize(const Size& rSize);

	inline short Width();
	inline short Height();

	inline int Empty();	// == EmptyRect
	inline MacRect& Offset(short dh, short dv);		// == OffsetRect
	inline MacRect& Offset(MacPoint aPoint);		// == OffsetRect
	inline MacRect& Offset(const Point& rPoint);	// == OffsetRect
	inline MacRect& Inset(short dh, short dv);		// == Inset Rect
	inline MacRect& Inset(short s);					// == Inset Rect

	friend inline int operator==(MacRect& rR1,MacRect& rR2);

	short						top;
	short						left;
	short						bottom;
	short						right;
};

inline MacRect::MacRect( short topP, short leftP, short bottomP, short rightP)
{
	top		= topP;
	left	= leftP;
	bottom	= bottomP;
	right	= rightP;
}

inline MacRect::MacRect( MacPoint topLeft, MacPoint bottomRight)
{
	top		= topLeft.v;
	left	= topLeft.h;
	bottom	= bottomRight.v;
	right	= bottomRight.h;
}

inline MacRect::MacRect( const Point& rTopLeft, const Size& rSize)
{
	top		= (short) rTopLeft.Y();
	left	= (short) rTopLeft.X();
	bottom	= top   + (short) rSize.Height();
	right	= left  + (short) rSize.Width();
}

inline MacRect::MacRect(const Rect& rRect)
{
	*((Rect*) this) = rRect;
}

inline MacRect::MacRect(const Rectangle& rRect)
{
	top		= (short) rRect.Top();
	left	= (short) rRect.Left();
	bottom	= (short) rRect.Bottom();
	right	= (short) rRect.Right();
}

inline MacRect::operator Rect() const
{
	return *((Rect*) this);
}

inline MacRect::operator Rect*() const
{
	return (Rect*) this;
}

inline MacRect::operator Rectangle() const
{
	Rectangle result(left,top,right,bottom);
	return result;
}

inline MacPoint& MacRect::TopLeft() const
{
	return *((MacPoint*) this);
}

inline const MacPoint& MacRect::BottomRight() const
{
	return *((MacPoint*) &bottom);
}

inline MacPoint& MacRect::BottomRight()
{
	return *((MacPoint*) &bottom);
}

inline Size MacRect::GetSize()
{
	return Size(right - left, bottom - top);
}

inline MacRect&  MacRect::SetSize(const Size& rSize)
{
	right  = left + (short) rSize.Width();
	bottom = top  + (short) rSize.Height();
	return *this;
}

inline short MacRect::Width()
{
	return right - left;
}

inline short MacRect::Height()
{
	return bottom - top;
}

inline int MacRect::Empty()
{
	return (right <= left) || (bottom <= top);
}

inline MacRect& MacRect::Offset( short dh, short dv )
{
	left	+= dh;
	right	+= dh;
	top 	+= dv;
	bottom 	+= dv;
	return *this;
}

inline MacRect& MacRect::Offset(MacPoint aPoint)
{
	left	+= aPoint.h;
	right	+= aPoint.h;
	top 	+= aPoint.v;
	bottom 	+= aPoint.v;
	return *this;
}

inline MacRect& MacRect::Offset(const Point& rPoint)
{
	left	+= (short) rPoint.X();
	right	+= (short) rPoint.X();
	top 	+= (short) rPoint.Y();
	bottom 	+= (short) rPoint.Y();
	return *this;
}

inline MacRect& MacRect::Inset( short dh, short dv )
{
	left	+= dh;
	right	-= dh;
	top 	+= dv;
	bottom 	-= dv;
	return *this;
}

inline MacRect& MacRect::Inset(short s)
{
	left	+= s;
	right	-= s;
	top 	+= s;
	bottom 	-= s;
	return *this;
}

inline int operator== (MacRect& rR1,MacRect& rR2)
{
	return (rR1.top		== rR2.top)		&& 
		   (rR1.left	== rR2.left)	&&
		   (rR1.bottom	== rR2.left)	&&
		   (rR1.right 	== rR2.right);
}

// --------------------------------------------------
// class MacTempPort
// --------------------------------------------------

/*
	MacTempPort kann immer dann verwendet werden wenn es noetig ist
	den aktuellen Port wegzusichern. Gleichzeitig kann im Konstruktor
	ein neuer Port mitgegeben werden. Durch zusaetzliche Konstruktoren
	entfallen einige sonst noetige Casts. Im Destructor wird der Port
	dann wieder zurueckgesetzt.
	
	z.B.
	{
		MacTemPort aSavePort;
		pMyThig->CallHandler();	// Kann Port evtl. verstellen ...
	}
*/

class MacTempPort
{
	GrafPtr pOldPort;
  public:
	MacTempPort();		
	MacTempPort(GrafPtr pNewPort);
	MacTempPort(CGrafPtr pNewPort);
	MacTempPort(WindowPeek pWindow);
	~MacTempPort();
};

inline MacTempPort::MacTempPort()
{
	GetPort(&pOldPort);
}

inline MacTempPort::MacTempPort(GrafPtr pNewPort)
{
	GetPort(&pOldPort);
	SetPort(pNewPort);
}

inline MacTempPort::MacTempPort(WindowPeek pWindow)
{
	GetPort(&pOldPort);
	SetPort((GrafPtr) pWindow);
}

inline MacTempPort::MacTempPort(CGrafPtr pNewPort)
{
	GetPort(&pOldPort);
	SetPort((GrafPtr) pNewPort);
}

inline MacTempPort::~MacTempPort()
{
	SetPort(pOldPort);
}


// --------------------------------------------------
// class MacTempGWorld
// --------------------------------------------------

/*
	MacTempGWorld kann genau wie MacTemPort verwendet werden,
	ist aber fuer GWorlds gedachtet. Es hat sich gezeigt, dass
	Aufrufe von GetPort/SetPort nicht mit GetGWorld/SetGWorld
	gemicht werden knnen, da das zu Chaos fhrt. MacTempGWorld
	arbeitet deswegen mit GetPort/SetPort. Sollte ganz StarView
	auf GetGWorld/SetGWorld (bzw. MacTemPort) umgestellt sein, knnte
	man es nocheinmal mit einer Umstellung versuchen :-/
*/

class MacTempGWorld
{
	CGrafPtr pOldPort;
	GDHandle hOldDevice;
  public:
	MacTempGWorld();
	MacTempGWorld(	CGrafPtr pNewPort,
					GDHandle hNewDevice = NULL);
	~MacTempGWorld();
};

inline MacTempGWorld::MacTempGWorld()
{
	GetGWorld(&pOldPort,&hOldDevice);
	SetPort(LMGetWMgrPort());
}

inline MacTempGWorld::MacTempGWorld(CGrafPtr pNewPort,GDHandle hNewDevice )
{
	GetGWorld(&pOldPort,&hOldDevice);
	SetGWorld(pNewPort,hNewDevice);
}

inline MacTempGWorld::~MacTempGWorld()
{
	SetGWorld(pOldPort,hOldDevice);
}

// --------------------------------------------------
// class MacColor
// --------------------------------------------------

/*
	MacColor ist eine Hilfsklasse die ein Bindegleid zwischen RGBColor und
	Der StarView Klasse Color darstellt. In Mac Funktionen kann sie wie
	RGBColor verwendet werden, da sie ueber entsprechende CastOperatoren
	verfuegt.
	
	z.B.
	
	MacColor aLightColor  ( *ImpGetColorData( COL_3DLIGHT ));
	RGBForeColor(aLightColor);	// Man beachte kein & noetig
*/

struct MacColor
{
	inline MacColor() { };
	inline MacColor( unsigned short nRed,unsigned short nGreen,unsigned short nBlue);
	inline MacColor( UINT8 nRed,UINT8 nGreen,UINT8 nBlue);
	inline MacColor(const MacColor& rColor);
	inline MacColor(const RGBColor& rColor);
//	inline MacColor(const Color& rColor);
//	inline MacColor(const ImpColorData& rColor);
	
	inline operator RGBColor() const;
	inline operator RGBColor*() const;
//	inline operator Color() const;

	friend inline int operator==(const MacColor& rC1,const MacColor& rC2);
	friend inline int operator!=(const MacColor& rC1,const MacColor& rC2);

	unsigned short red;	
	unsigned short green;
	unsigned short blue; 
};

inline MacColor::MacColor( unsigned short nRed,unsigned short nGreen,unsigned short nBlue)
{
	red 	= nRed;
	green 	= nGreen;
	blue  	= nBlue;
}

inline MacColor::MacColor( UINT8 nRed,UINT8 nGreen,UINT8 nBlue)
{
	red 	= ( nRed << 8 ) + nRed;
	green 	= ( nGreen << 8 ) + nGreen;
	blue  	= ( nBlue << 8 ) + nBlue;
}

inline MacColor::MacColor(const MacColor& rColor)
{
	red 	= rColor.red;
	green 	= rColor.green;
	blue  	= rColor.blue;
}

inline MacColor::MacColor(const RGBColor& rColor)
{
	red 	= rColor.red;
	green 	= rColor.green;
	blue  	= rColor.blue;
}

//inline MacColor::MacColor(const Color& rColor)
//{
//	red 	= rColor.GetRed();
//	green 	= rColor.GetGreen();
//	blue  	= rColor.GetBlue();
//}

//inline MacColor::MacColor(const ImpColorData& rColor)
//{
//	red 	= rColor.nRed;
//	green 	= rColor.nGreen;
//	blue  	= rColor.nBlue;
//}
	
inline MacColor::operator RGBColor() const
{
	return *((RGBColor*) this);
}

inline MacColor::operator RGBColor*() const
{
	return ((RGBColor*) this);
}

//inline MacColor::operator Color() const
//{
//	Color result(red,green,blue);
//	return result;
//}


inline int operator==(const MacColor& rC1,const MacColor& rC2)
{
	return (rC1.red		== rC2.red)		&& 
		   (rC1.green	== rC2.green)	&&
		   (rC1.blue	== rC2.blue);
}

inline int operator!=(const MacColor& rC1,const MacColor& rC2)
{
	return (rC1.red		!= rC2.red)		||
		   (rC1.green	!= rC2.green)	||
		   (rC1.blue	!= rC2.blue);
}

// --------------------------------------------------
// class MacTextState
// --------------------------------------------------

/*
	MacTextState dient dazu den Zustand der Textvariablen im aktuellen Port
	zu sichern (z.B. im WindowMgrPort) Dananch kann dann Gefahrlos der
	Font gendert oder der Textmode gendert werden. 
	
	z.B.
	{	
		LMGetWMgrPort(&pWmgrPort);
		MacTempPort aWmgrPort(pWmgrPort);	// verwende Wmgr Port ...
	
		MacTextState aSavedState;			// Textzustand wegsichern
		TextFont(geneva);
		MoveTo(aTextPoint.h,aTextPoint.v);
		DrawString(aText.GetPascalStr());
	}
*/
	
struct MacTextState
{
	inline MacTextState();
	inline ~MacTextState();
	
	short txFace;  //Typeface
	Style txStyle; //Typestyle
	short txMode;  //How is text drawn?
	short txSize;  //Typesize
};

MacTextState::MacTextState()
{
	GrafPtr CurrPort; //-> Current graphics port

	GetPort (&CurrPort);
	txFace  = CurrPort->txFont;
	txStyle = CurrPort->txFace;
	txMode  = CurrPort->txMode;
	txSize  = CurrPort->txSize;
}

MacTextState::~MacTextState()
{
	TextFont (txFace);
	TextFace (txStyle);
	TextMode (txMode);
	TextSize (txSize);
}

// --------------------------------------------------
// class MacSaveClip
// --------------------------------------------------

/*
	Die Klasse MacSaveRegion kann verwendet werden wenn es naetig
	ist die ClipRegion temporaer zu sichern. In den Konstruktoren
	Kann eine Neue Region bzw.ein ClipRechteck angegeben werden,
	auf die dann geclipt wird.
*/
	
struct MacSaveClip
{
	RgnHandle	hRegion;

	inline MacSaveClip();
	inline MacSaveClip(RgnHandle hNewClip);
	inline MacSaveClip(Rect* pClipRect);
	inline ~MacSaveClip();
};

inline MacSaveClip::MacSaveClip()
{
	hRegion = NewRgn();
	GetClip(hRegion);
}

inline MacSaveClip::MacSaveClip(RgnHandle hNewClip)
{
	hRegion = NewRgn();
	GetClip(hRegion);
	SetClip(hNewClip);
}

inline MacSaveClip::MacSaveClip(Rect* pClipRect)
{
	hRegion = NewRgn();
	GetClip(hRegion);
	ClipRect(pClipRect);
}

inline MacSaveClip::~MacSaveClip()
{
	SetClip(hRegion);
	DisposeRgn(hRegion);
}

#pragma options align=reset

#endif
