/*************************************************************************
 *
 *  $RCSfile: macsysexchange.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _MAC_SYSEXCHANGE_HXX
#define _MAC_SYSEXCHANGE_HXX

#ifndef __cplusplus
#error Vitamin C - Nimm 2
#endif
#include <mac_start.h>
#include <Types.h>
#include <mac_end.h>

#include <sysexchg.hxx>

// MacFormatItem

class MacFormatItem
{
public:
	MacFormatItem(const String&, UINT32);
	
	inline virtual ResType	getResType() const { return m_ResType; }
	inline virtual UINT32	getFormatID() const { return m_FormatID; }
protected:
	ResType	m_ResType;
	UINT32	m_FormatID;
};

// XMacExchangeList

DECLARE_LIST(MacFormatList, MacFormatItem *);
class XMacExchangeList:  public MacFormatList, public XSystemExchange
{
public:
	XMacExchangeList();
	virtual ~XMacExchangeList();
	
	virtual void registerFormatName(const String &rName, UINT32 nFormatID);

	virtual ResType getResType(UINT32 nFormatID);
//protected:
	static XMacExchangeList	theExchangeList;
	
	friend XSystemExchange* GetSystemExchange();
};

// XMacDataTrans

class XMacDataTrans : public XDTrans
{
public:
	XMacDataTrans() : m_nRefCount(1) {}

	virtual void aquire();
	virtual void release();
	
	virtual UINT32	*getTypeList(UINT32 &rSize) const;
	virtual BYTE	*getData(UINT32 nFormat, UINT32 &rSize);

protected:
	virtual ~XMacDataTrans() {}
	
	ULONG	m_nRefCount;
};


class XMacSystemClipboard : public XSystemClipboard
{
public:
	XMacSystemClipboard();
	virtual ~XMacSystemClipboard();
	
	virtual void copy( XDTrans* pData ) ;
	virtual XDTrans* paste();
	virtual void clear();
	
	virtual void flush();
	virtual void cleared();
	virtual void changed();

	virtual void registerListener( XClipboardListener& xListener );
//protected:
	XClipboardListener	*pListener;
	XDTrans				*pLastData;
	
	static XMacSystemClipboard theSystemClipboard;
	
	friend void UpdateSystemClipboard();
	friend XSystemClipboard* GetSystemClipboard();
};

#endif // _MAC_SYSEXCHANGE_HXX
