/*************************************************************************
 *
 *  $RCSfile: main.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <svmac.h>



#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif



#ifndef _SV_MEMORY_H

#include <SV_Memory.H>

#endif



#include <SVAPP.HXX>



#include <main.h>



void BuildMenuBars(void);

pascal OSErr MyHandleQUIT( AppleEvent*, AppleEvent*, long );

void InstallAEHandlers();



// -----------------------------------------------------------------------



#ifndef _MAX_PATH

	#define _MAX_PATH 255

#endif



#if defined(__powerc)

	QDGlobals qd;

#endif



BOOL	bMacMemInit = FALSE;			// bMacMemInit = FALSE;



// -----------------------------------------------------------------------



static OSErr GetPathFromDirID( long DirID, short VRefNum, char *pPath )

{

	CInfoPBRec		paramBlock;

	unsigned char	dirName[256]; /* Pascal string */

	int				len;

	OSErr			err;

	

	*pPath = '\0';

	len = 0;

	

	paramBlock.dirInfo.ioNamePtr = dirName;

	paramBlock.dirInfo.ioDrParID = DirID;

	

	do { 

		paramBlock.dirInfo.ioVRefNum = VRefNum;

		paramBlock.dirInfo.ioFDirIndex = -1;

		paramBlock.dirInfo.ioDrDirID = paramBlock.dirInfo.ioDrParID;

		

		err = PBGetCatInfoSync( &paramBlock );

		

		if (err == noErr)

		{

			if ( len + 1 + dirName[0] + 1 > _MAX_PATH )

				err = -1;

			else

			{

				memmove( pPath + dirName[0] + 1, pPath, len + 1 );

				memcpy( pPath, &dirName[1], dirName[0] );

				pPath[ dirName[0] ] = ':';

				len += dirName[0] + 1;

			}		

		}

	} while ( ( err == noErr ) && ( paramBlock.dirInfo.ioDrDirID != fsRtDirID ) );

	

	return err;

}



// -----------------------------------------------------------------------



void AlertUser( ConstStr255Param pString )

{

	Str15		dummy;



	MAC_SetCursor(&qd.arrow);

	dummy[0] = 0;



	ParamText(pString, dummy, dummy, dummy);

	Alert(rUserAlert, nil);

}



// -----------------------------------------------------------------------



void AlertUser( short error )

{

	Str255		message;



	GetIndString(message, kErrStrings, error);

	AlertUser(message);

}



// =======================================================================



// -----------------------------------------------------------------------

// Default menu handling funcs

// defautl Menu resource IDs



#define APPLE_MENU	128

#define APPLE_ABOUT 1



#define FILE_MENU	129

#define FILE_QUIT	1



// -----------------------------------------------------------------------



void BuildMenuBars(void)

{

	MenuHandle	hMenu;

	String		aMenuName;



	aMenuName = (char) appleMark;

	hMenu = NewMenu( APPLE_MENU, aMenuName.GetPascalStr() );

	

	aMenuName = ImplGetMacResString( eAboutItem );

	AppendMenu( hMenu, aMenuName.GetPascalStr() );

	AppendResMenu( hMenu, 'DRVR' );	/* add DA names to Apple menu */

	InsertMenu( hMenu, 0 );



	aMenuName = ImplGetMacResString( eFileItem );

	hMenu = NewMenu( FILE_MENU, aMenuName.GetPascalStr() );

	aMenuName = ImplGetMacResString( eQuitItem );

	AppendMenu( hMenu, aMenuName.GetPascalStr() );

	InsertMenu( hMenu, 0 );



	InvalMenuBar();

}



// -----------------------------------------------------------------------



static int gTheQuitMenuWasPressed=0L;



// -----------------------------------------------------------------------



static void RunDeskAccesory(short item)

{

	GrafPtr		savePort;

	short		daRefNum;

	Str255		daName;

	

	GetPort(&savePort);

	GetMenuItemText(GetMenuHandle(APPLE_MENU), item, daName);

	daRefNum = OpenDeskAcc(daName);

	SetPort(savePort);

}



// -----------------------------------------------------------------------



static void ChooseApple( short itemNumber )

{

	if(itemNumber == APPLE_ABOUT)

	{

		Alert( 132, nil );

	}

	else

		RunDeskAccesory( itemNumber );

}



// -----------------------------------------------------------------------



static void ChooseFile(short item)

{

	switch(item) {

		case FILE_QUIT	:	gTheQuitMenuWasPressed = true;

							break;

		default:			break;

	}

}



// -----------------------------------------------------------------------



static void ChooseEdit(short item)

//	Does not support edit menu.  Assumes that if the edit menu is enabled

//	that it is for desk accessories.  (pre MF or system 7, or MF with optionkey)

{

	SystemEdit(item-1);

}



int MenuDispatch(short menuNumber,short itemNumber)

{

	if(menuNumber != 0)

	{	switch(menuNumber)

		{

			case APPLE_MENU : 	ChooseApple(itemNumber);

								break;

			case FILE_MENU :	ChooseFile(itemNumber);

								break;

			default :			break;

		}

	}

	HiliteMenu(0);				// remove menu title hiliting

	return gTheQuitMenuWasPressed;

}



// -----------------------------------------------------------------------



pascal OSErr MyHandleQUIT( AppleEvent*, AppleEvent*, long )

{

	GetSalData()->mbEnde = TRUE;

	return noErr;

}



// -----------------------------------------------------------------------



pascal OSErr MyHandleODOC( AppleEvent *messagein, AppleEvent*, long /* refIn */ )

{

	FSSpec		aFSS;

	AEDescList	aDocList;

	OSErr		aErr;

	long		i, nAnz;

	AEKeyword	aKeywd;

	DescType	aType;

	MAC_Size	aActSize;

	Str255		aPath;

	String		aFileList;



	aErr = AEGetParamDesc( messagein, keyDirectObject,

						   typeAEList, &aDocList );

	aErr = AECountItems( &aDocList, &nAnz );



	for ( i=1; i<= nAnz; i++ )

	{

		if ( i > 1 )

			aFileList += APPEVENT_PARAM_DELIMITER;



		aErr = AEGetNthPtr( &aDocList, i, typeFSS, &aKeywd,

							&aType, (MAC_Ptr)&aFSS, sizeof( aFSS ),

							&aActSize );

		GetPathFromDirID( aFSS.parID, aFSS.vRefNum, (char*)aPath );

		aFileList += String( (const char*)&aPath[0] );

		aFileList += String( (const char*)&(aFSS.name[1]), aFSS.name[0] );

	}



	aErr = AEDisposeDesc( &aDocList );



//	GetSVData()->aAEData.nLastEventType = DISPATCH_OPEN;



	if ( ImplGetSVData()->maAppData.mbInAppExecute )

	{

		GetpApp()->AppEvent( ApplicationEvent( ImplGetSVEmptyStr(),

											   ImplGetSVEmptyStr(),

											   String(APPEVENT_OPEN_STRING),

											   aFileList ) );

	}

	else

	{

		AppEventList	*pData = new AppEventList;

		

		pData->mpAppEvent = new ApplicationEvent( ImplGetSVEmptyStr(),

												  ImplGetSVEmptyStr(),

												  String(APPEVENT_OPEN_STRING),

												  aFileList );

		pData->mpNext = GetSalData()->mpAppEventList;

	}



	return noErr;

}



// -----------------------------------------------------------------------



pascal OSErr MyHandlePDOC( AppleEvent *messagein, AppleEvent*, long /* refIn */)

{

	FSSpec		aFSS;

	AEDescList	aDocList;

	OSErr		aErr;

	long		i, nAnz;

	AEKeyword	aKeywd;

	DescType	aType;

	MAC_Size	aActSize;

	Str255		aPath;

	String		aFileList;



	aErr = AEGetParamDesc( messagein, keyDirectObject,

						   typeAEList, &aDocList );

	aErr = AECountItems( &aDocList, &nAnz );



	for ( i=1; i<= nAnz; i++ )

	{

		if ( i > 1 )

			aFileList += APPEVENT_PARAM_DELIMITER;



		aErr = AEGetNthPtr( &aDocList, i, typeFSS, &aKeywd,

							&aType, (MAC_Ptr)&aFSS, sizeof( aFSS ),

							&aActSize );

		GetPathFromDirID( aFSS.parID, aFSS.vRefNum, (char*)aPath );

		aFileList += String( (const char*)&aPath[0] );

		aFileList += String( (const char*)&(aFSS.name[1]), aFSS.name[0] );

	}



	aErr = AEDisposeDesc( &aDocList );



//	GetSVData()->aAEData.nLastEventType = DISPATCH_PRINT;



	if ( ImplGetSVData()->maAppData.mbInAppExecute )

	{

		GetpApp()->AppEvent( ApplicationEvent( ImplGetSVEmptyStr(),

											   ImplGetSVEmptyStr(),

											   String(APPEVENT_PRINT_STRING),

											   aFileList ) );

	}

	else

	{

		AppEventList	*pData = new AppEventList;

		

		pData->mpAppEvent = new ApplicationEvent( ImplGetSVEmptyStr(),

												  ImplGetSVEmptyStr(),

												  String(APPEVENT_PRINT_STRING),

												  aFileList );

		pData->mpNext = GetSalData()->mpAppEventList;

	}



	return noErr;

}



// -----------------------------------------------------------------------



void InstallAEHandlers()

{

	AEEventHandlerUPP pProcPtr;

	OSErr nErr;



	pProcPtr = NewAEEventHandlerProc( MyHandleODOC );

	nErr = AEInstallEventHandler( kCoreEventClass, kAEOpenDocuments,

								  pProcPtr, 0, false );

	pProcPtr = NewAEEventHandlerProc( MyHandlePDOC );

	nErr = AEInstallEventHandler( kCoreEventClass, kAEPrintDocuments,

								  pProcPtr, 0, false );

	pProcPtr = NewAEEventHandlerProc( MyHandleQUIT );

	nErr = AEInstallEventHandler( kCoreEventClass, kAEQuitApplication,

								  pProcPtr, 0, false );

}



// -----------------------------------------------------------------------



void InitSystem()

{

	SalData* pSalData = GetSalData();

	pSalData->mpMemData = &aMemData;

	

	// install the sal apple event handler

	InstallAEHandlers();

	// show our default menbar, if available

	BuildMenuBars();

#ifndef DBG_UTIL

	// install our memory exception handler 

	DoMemoryException();

#endif

	return;

}






