/*************************************************************************
 *
 *  $RCSfile: macdrag.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>

#include <mac_start.h>
#include <Types.h>
#include <Memory.h>
#include <Drag.h>
#include <Files.h>
#include <Finder.h>
#include <mac_end.h>

#include <window.hxx>
#include <svdata.hxx>
#include <svapp.hxx>
#include <drag.hxx>
#include <exchange.hxx>
#include <sysexchg.hxx>
#include <getsys.hxx>

#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif

#ifndef _SV_SALFRAME_HXX
#include <salframe.hxx>
#endif

#ifndef _NEW_HXX
#include <tools/new.hxx>
#endif

#include <salinst.hxx>
#include <salctype.hxx>
#include <saldata.hxx>

#include <ptrstyle.hxx>

#include <macexchg.hxx>


//====================================================================================

class XDTransMacDrag : public XDTrans
{
public:
	XDTransMacDrag(DragReference theDragRef);
	virtual ~XDTransMacDrag() {}
	
	virtual void aquire();
	virtual void release();
	
	virtual UINT32 *getTypeList(UINT32 &rSize) const;
	virtual BYTE *getData(UINT32 nFormat, UINT32 &rSize);

protected:	
	BOOL hasFormat(UINT32 nFormat) const;
	BYTE *getItemData(long nItem, UINT32 nFormat, UINT32 &rSize);

protected:
	int mnRefCount;
	DragReference	maDragRef;
};

//------------------------------------------------------------------------------------

XDTransMacDrag::XDTransMacDrag(DragReference theDragRef) :
	mnRefCount( 0 ),
	maDragRef( theDragRef)
{
}

//------------------------------------------------------------------------------------

void XDTransMacDrag::aquire()
{
	mnRefCount++;
}

//------------------------------------------------------------------------------------

void XDTransMacDrag::release()
{
	if (--mnRefCount <= 0)
		delete this;
}

//------------------------------------------------------------------------------------

BOOL XDTransMacDrag::hasFormat(UINT32 nFormat) const
{
	BOOL	bHasType = FALSE;
	OSErr	error;
	unsigned short	numItems;
	
	if ((error = CountDragItems(maDragRef, &numItems)) == noErr)
	{
		for (unsigned short nItem = 1; nItem <= numItems; nItem++)
		{
			ItemReference	theItemRef;
			unsigned short	numFlavors;
			
			error = GetDragItemReferenceNumber(maDragRef, nItem, &theItemRef);
			if (error == noErr)
				error = CountDragItemFlavors(maDragRef, theItemRef, &numFlavors);
			
			for (unsigned short nFlavor = 1; error == noErr && nFlavor <= numFlavors; nFlavor++)
			{
				FlavorType	theFlavorType;
				
				error = GetFlavorType (maDragRef, theItemRef, nFlavor, &theFlavorType);
				if (error == noErr)
				{
					switch (theFlavorType)
					{
						case MAC_FORMAT_TEXT:
							bHasType = (BOOL)(nFormat == FORMAT_STRING);
							break;
						case MAC_FORMAT_PICT:
							bHasType = (BOOL)(nFormat == FORMAT_BITMAP || nFormat == FORMAT_GDIMETAFILE);
							break;
						case MAC_FORMAT_FILE:
							bHasType = (BOOL)(nFormat == FORMAT_FILE || nFormat == FORMAT_FILE_LIST);
							break;
						default:
							break;
					}
				}
			}
			
		}
	}
	
	return bHasType;
}

UINT32 *XDTransMacDrag::getTypeList(UINT32 &rSize) const
{
	UINT32	tempList[10];
	UINT32	*pTypeList = NULL;
	
	rSize = 0;
	
	if (hasFormat(FORMAT_STRING))
		tempList[rSize++] = FORMAT_STRING;
	if (hasFormat(FORMAT_BITMAP))
		tempList[rSize++] = FORMAT_BITMAP;
	if (hasFormat(FORMAT_GDIMETAFILE))
		tempList[rSize++] = FORMAT_GDIMETAFILE;
	if (hasFormat(FORMAT_FILE))
		tempList[rSize++] = FORMAT_FILE;
	if (hasFormat(FORMAT_FILE_LIST))
		tempList[rSize++] = FORMAT_FILE_LIST;
		
	if (rSize > 0)
	{
		pTypeList = new UINT32[rSize];
		
		if (pTypeList)
			memcpy(pTypeList, tempList, sizeof(UINT32) * rSize);
		else
			rSize = 0;
	}
	
	return pTypeList;
}


//------------------------------------------------------------------------------------

BYTE *XDTransMacDrag::getItemData(long nItem, UINT32 nFormat, UINT32 &rSize)
{
	ItemReference	theItemRef;
	unsigned short	numFlavors;
	OSErr			error;
	BYTE			*pData = NULL;

	rSize = 0;
	
	error = GetDragItemReferenceNumber(maDragRef, nItem, &theItemRef);
	
	if (error == noErr)
		error = CountDragItemFlavors(maDragRef, theItemRef, &numFlavors);
	
	for (unsigned short nFlavor = 1; nFlavor <= numFlavors && error == noErr && pData == NULL; nFlavor++)
	{
		FlavorType	theFlavorType;
		long	theSize;
		
		error = GetFlavorType (maDragRef, theItemRef, nFlavor, &theFlavorType);
		if (error == noErr)
			error = GetFlavorDataSize(maDragRef, theItemRef, theFlavorType, &theSize);
		if (error == noErr)
		{
			BYTE *pTempData = new BYTE[theSize];
			if (pTempData)
			{
				error = GetFlavorData(maDragRef, theItemRef, theFlavorType, pTempData, &theSize, nil);
				if (error == noErr)
					pData = ConvertResType2Format(theFlavorType, nFormat, pTempData, theSize, rSize);
				delete pTempData;
			}
		}
	}
	
	return pData;
}

BYTE *XDTransMacDrag::getData(UINT32 nFormat, UINT32 &rSize)
{
	unsigned short	numItems;
	OSErr			error;
	BYTE			*pData = NULL;
	
	rSize = 0;
	
	if ((error = CountDragItems(maDragRef, &numItems)) == noErr && numItems >= 1)
	{
		if (nFormat == FORMAT_FILE_LIST)
		{
			char 	*pFileData[512];
			UINT32	nFileSize[512];
			UINT32	sumSize = 0;
			SysexchgFileList header;
			
			for (unsigned short nItem = 1; nItem <= numItems; nItem++)
			{
				((BYTE *)pFileData[nItem-1]) = getItemData(nItem, FORMAT_FILE, nFileSize[nItem-1]);
				rSize += nFileSize[nItem-1];
			}
			rSize += 1 + 20;
			pData = new BYTE[rSize];
			memcpy(pData, &header, 20);

			int index = 20;
			for (nItem = 1; nItem <= numItems; nItem++)
			{
				memcpy(&pData[index], pFileData[nItem-1], nFileSize[nItem-1]);
				index += nFileSize[nItem-1];
			}
			
			pData[index] = 0;
		}
		else
			pData = getItemData(1, nFormat, rSize);
	}
	
	return pData;
}


//====================================================================================

class XMacDragManager : public XSystemDragManager
{
protected:
	XDragDropListener	*pListener;
	SalFrame			*pSalFrame;
	WindowPtr			pMacWindow;
	RgnHandle			hMacWindowRgn;
	XDTrans				*pMyOwnDrag;
	
public:
	XMacDragManager();
	virtual ~XMacDragManager();
	
	virtual SysDropAction executeDrag( XDTrans* pData, USHORT nOptions );

	virtual void registerListener( XDragDropListener& xListener );

	virtual void enableDrop( SalFrame* pFrame, BOOL bEnable );

protected:	
	OSErr DragInput(MAC_Point *mouse,
           			short *modifiers,
           			DragReference theDragRef);
							  
	static pascal OSErr DragInputWrapper(MAC_Point *mouse,
                      			short *modifiers,
								void  *dragInputRefCon,
                      			DragReference theDragRef);
								
	OSErr DragReceive(WindowPtr theWindow, DragReference theDragRef);					
								
	static pascal OSErr DragReceiveWrapper(WindowPtr theWindow,
    	                             void *handlerRefCon,
        	                         DragReference theDragRef);					

	OSErr DragTrack(DragTrackingMessage message, WindowPtr theWindow, DragReference theDragRef);

	static pascal OSErr DragTrackingWrapper(DragTrackingMessage message,
                                  WindowPtr theWindow,
                                  void *handlerRefCon,
                                  DragReference theDragRef);
								  
	static XMacDragManager theDragManager;

	friend XSystemDragManager* GetSystemDragManager();
};


//------------------------------------------------------------------------------------

XMacDragManager XMacDragManager::theDragManager;

//------------------------------------------------------------------------------------

pascal OSErr XMacDragManager::DragInputWrapper(MAC_Point *mouse,
                      			short *modifiers,
								void  *dragInputRefCon,
                      			DragReference theDragRef)
{
	return ((XMacDragManager *)dragInputRefCon)->DragInput(mouse, modifiers, theDragRef);
}

//------------------------------------------------------------------------------------

pascal OSErr XMacDragManager::DragReceiveWrapper(WindowPtr theWindow,
    	                             void *handlerRefCon,
        	                         DragReference theDragRef)
{
	return ((XMacDragManager *)handlerRefCon)->DragReceive(theWindow, theDragRef);
}

//------------------------------------------------------------------------------------

pascal OSErr XMacDragManager::DragTrackingWrapper(DragTrackingMessage message,
                                  WindowPtr theWindow,
                                  void *handlerRefCon,
                                  DragReference theDragRef)
{
	return ((XMacDragManager *)handlerRefCon)->DragTrack(message, theWindow, theDragRef);
}

//------------------------------------------------------------------------------------

XMacDragManager::XMacDragManager() :
	pListener(NULL),
	pMacWindow(NULL),
	pSalFrame(NULL),
	pMyOwnDrag(NULL),
	hMacWindowRgn(0)
{
}

//------------------------------------------------------------------------------------

XMacDragManager::~XMacDragManager()
{
}

//------------------------------------------------------------------------------------

void XMacDragManager::registerListener( XDragDropListener& xListener )
{
	pListener = &xListener;
}

//------------------------------------------------------------------------------------

SysDropAction XMacDragManager::executeDrag( XDTrans *pDataInterface, USHORT nOptions)
{
	OSErr			error;
	DragReference	theDragRef;
	EventRecord		*pEvent = &GetSalData()->maLastMouseDown;
	
	if (pDataInterface == NULL)
		return DROP_NONE;
		
	error = NewDrag(&theDragRef);
	
	if (error != noErr)
		return DROP_NONE;
		
	pDataInterface->aquire();
	pMyOwnDrag = pDataInterface;
	
	SetDragInputProc(theDragRef, NewDragSendDataProc(DragInputWrapper), (void*)this);

	{
	UINT32	nSize;
	BYTE *pData;
	
	pData = pDataInterface->getData(FORMAT_STRING, nSize);
	
	if (pData)
	{
		nSize--;
		AddDragItemFlavor(theDragRef, 1, MAC_FORMAT_TEXT, pData, nSize, 0);
		delete pData;
	}

/*
	pData = pDataInterface->getData(FORMAT_FILE, nSize);
	
	if (pData)
	{
		HFSFlavor	*pHFSData = MakeHFSFlavor((const char *)pData);
		delete pData;
		if (pHFSData)
		{
			AddDragItemFlavor(theDragRef, 1, MAC_FORMAT_FILE, pHFSData, sizeof(HFSFlavor), 0);
			delete pHFSData;
		}
	}
*/
	}

	pEvent->modifiers |= activeFlag;
	TrackDrag(theDragRef, pEvent, nil);
	DisposeDrag(theDragRef);
	
	pDataInterface->release();
	pMyOwnDrag = NULL;
	return DROP_MOVE;
}

//------------------------------------------------------------------------------------

void XMacDragManager::enableDrop( SalFrame *pFrame, BOOL bEnable )
{
	if (pFrame == NULL)
		pFrame = GetSalData()->mpFirstFrame;

	pMacWindow = &pFrame->maFrameData.mpMacWin->port;
	hMacWindowRgn = pFrame->maFrameData.mpMacWin->contRgn;
	pSalFrame = pFrame;

	if (bEnable)
	{
		InstallReceiveHandler(NewDragReceiveHandlerProc(DragReceiveWrapper), pMacWindow, (void *)this);
		InstallTrackingHandler(NewDragTrackingHandlerProc(DragTrackingWrapper), pMacWindow, (void *)this);
	}
	else
	{
//		RemoveTrackingHandler(DragTracking, pMacWindow);
//		RemoveReceiveHandler(DragReceive, pMacWindow);
	}
}

//------------------------------------------------------------------------------------

OSErr XMacDragManager::DragReceive(WindowPtr theWindow, DragReference theDragRef)
{
	MAC_Point	macMouse;
	short		nFind;
	
	if (pListener == NULL)
		return noErr;
	
	GetDragMouse(theDragRef, &macMouse, nil);
	nFind = FindWindow(macMouse, &theWindow);
	
	GlobalToLocal(&macMouse);
	
	Point	salMouse(macMouse.h, macMouse.v);

	if (nFind == inContent)	
		pListener->drop(salMouse, pSalFrame, DROP_COPY);
	return noErr;
}

//------------------------------------------------------------------------------------

OSErr XMacDragManager::DragTrack(DragTrackingMessage message, WindowPtr theWindow, DragReference theDragRef)
{
	MAC_Point		macMouse;
	short			nFind;
	SysDropAction	eAction = DROP_NONE;
	
	if (pListener == NULL)
		return noErr;
	
	GetDragMouse(theDragRef, &macMouse, nil);
	nFind = FindWindow(macMouse, &theWindow);
	
	GlobalToLocal(&macMouse);
	
	Point	salMouse(macMouse.h, macMouse.v);
	
	switch (message)
	{
		case dragTrackingEnterHandler:
			if (pMyOwnDrag)
				pListener->beginDragDrop(pMyOwnDrag, DRAG_COPYABLE);
			else
				pListener->beginDragDrop(new XDTransMacDrag(theDragRef), DRAG_COPYABLE);
			break;
		case dragTrackingEnterWindow:
		case dragTrackingInWindow:
			if (nFind == inContent)
				eAction = pListener->queryDrop(salMouse, pSalFrame, 0);
			break;
		case dragTrackingLeaveWindow:
			if (nFind == inContent)
				eAction = pListener->queryDrop(salMouse, NULL, 0);
			break;
		case dragTrackingLeaveHandler:
			if (nFind != inContent)
				pListener->endDragDrop();
			if (pSalFrame)
				pSalFrame->SetPointer(POINTER_ARROW);
			break;
		default:
			break;
	}

	PointerStyle	nStyle = POINTER_ARROW;
	
	switch (eAction)
	{
		case DROP_MOVE:
			nStyle = POINTER_MOVEDATA;
			break;
		case DROP_COPY:
			nStyle = POINTER_COPYDATA;
			break;
		case DROP_LINK:
			nStyle = POINTER_LINKFILE;
			break;
		case DROP_PRINT:
			nStyle = POINTER_MOVEDATA;
			break;
		case DROP_DISCARD:
		case DROP_CANCEL:
		default:
			nStyle = POINTER_NOTALLOWED;
			break;
	}
	
	if (pSalFrame)
		pSalFrame->SetPointer(nStyle);

	return noErr;
}

//------------------------------------------------------------------------------------

OSErr XMacDragManager::DragInput(MAC_Point *mouse,
           			short *modifiers,
           			DragReference theDragRef)
{
	return noErr;
}

//------------------------------------------------------------------------------------

XSystemDragManager* GetSystemDragManager()
{
	return &XMacDragManager::theDragManager;
}
