/*************************************************************************
 *
 *  $RCSfile: getstyle-gnome.c,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:58:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/*
 *  to produce getstyle-gnome compile this file like this:
 *  $(CC) `pkg-config --cflags gtk+-2.0` `pkg-config --libs gtk+-2.0` -o getstyle-gnome getstyle-gnome.c ; strip getstyle-gnome
 *  where $(CC) is the c-compiler of your choice
 */

#include <stdio.h>
#include <stdarg.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pango/pango.h>

#include <X11/Xlib.h>

#include "../dtsetenum.hxx"

char* pBuffer = NULL;
char* pCurrent = NULL;
int   nBufLen = 0;

#ifdef GDK_TYPE_DISPLAY
GdkWindow* pOutputWindow = NULL;
#else
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#endif
Window	   nOutputWindow = 0;
GdkAtom aPropertyName;
GdkAtom aPropertyType;

void buffer_print( const char* pFormat, ... )
{
    va_list ap;
    int nLen;
    char* pOldBuffer;

    if( !pBuffer )
    {
        pBuffer = pCurrent = (char*)malloc( nBufLen = 1024 );
        if( ! pBuffer )
            return;
    }

    /* check length of string to append */
    va_start(ap, pFormat);
    nLen = vsnprintf( NULL, 0, pFormat, ap );
    va_end(ap);

    if( (pCurrent-pBuffer)+nLen <= nBufLen )
    {
        pOldBuffer = pBuffer;
        while( nBufLen <= (pCurrent-pBuffer)+nLen )
            nBufLen = nBufLen*2;

        pBuffer = (char*)realloc(pBuffer, nBufLen);
        if( !pBuffer )
        {
            free( pOldBuffer );
            return;
        }
        pCurrent = pBuffer + (pCurrent-pOldBuffer);
    }

    va_start(ap, pFormat);
    nLen = vsnprintf( pCurrent, nBufLen - (pCurrent-pBuffer), pFormat, ap );
    va_end(ap);

    pCurrent += nLen;
}

void printColor( int eStyle, GdkColor* pColor )
{
    buffer_print( "%d=(%d,%d,%d)\n",
                  eStyle,
                  pColor->red/256,
                  pColor->green/256,
                  pColor->blue/256 );
}

void printFont( int eStyle, PangoFontDescription* pFont )
{
    PangoWeight eWeight;
    PangoStyle eItalic;

    buffer_print( "%d=\"%s\",%d",
                  eStyle,
                  pango_font_description_get_family( pFont ),
                  pango_font_description_get_size( pFont )/PANGO_SCALE );
    eWeight = pango_font_description_get_weight( pFont );
    if( eWeight >= PANGO_WEIGHT_BOLD )
        buffer_print( ",bold" );
    else if( eWeight <= PANGO_WEIGHT_LIGHT )
        buffer_print( ",light" );
    eItalic = pango_font_description_get_style( pFont );
    if( eItalic == PANGO_STYLE_ITALIC || eItalic == PANGO_STYLE_OBLIQUE )
        buffer_print( ",italic" );
    buffer_print( "\n" );
}

void printToolbarSize( int eSize )
{
    const char* pSize;
    switch( eSize )
    {
        case GTK_ICON_SIZE_SMALL_TOOLBAR:
        default:
            pSize = "small";
            break;
        case GTK_ICON_SIZE_LARGE_TOOLBAR:
            pSize = "large";
            break;
    }
    buffer_print( "%d=%s\n",
                  ToolbarIconSize,
                  pSize );
}

static GtkWidget* mainwin = NULL;
static GtkWidget* toolbar = NULL;

void printVCLStyle( GtkWidget* widget )
{
    PangoFontDescription* pDesc = NULL;
    GtkStyle* pStyle = gtk_widget_get_style( widget );

    if( pStyle )
    {
        pCurrent = pBuffer;
        printColor( AllTextColors, &pStyle->text[GTK_STATE_NORMAL] );
        printColor( AllBackColors, &pStyle->bg[GTK_STATE_NORMAL] );
        printColor( HighlightColor, &pStyle->base[GTK_STATE_SELECTED] );
        printColor( HighlightTextColor, &pStyle->text[GTK_STATE_SELECTED] );
        printColor( FieldColor, &pStyle->base[GTK_STATE_NORMAL] );
        printColor( WindowColor, &pStyle->base[GTK_STATE_NORMAL] );
        
        printFont( UIFont, pStyle->font_desc );

        printToolbarSize( gtk_toolbar_get_icon_size( GTK_TOOLBAR(toolbar) ) );

        /* output the buffer to the VCL_SYSTEM_SETTINGS property of the
           VCL reference window. */
#ifdef GDK_TYPE_DISPLAY
        gdk_property_change( pOutputWindow,
                             aPropertyName,
                             aPropertyType,
                             8,
                             GDK_PROP_MODE_REPLACE,
                             (unsigned char*)pBuffer,
                             pCurrent - pBuffer );
#else
	XChangeProperty( gdk_x11_get_default_xdisplay(),
			 nOutputWindow,
			 XInternAtom( gdk_x11_get_default_xdisplay(),
				      "VCL_SYSTEM_SETTINGS",
				      False ),
			 XA_STRING,
			 8,
			 PropModeReplace,
			 (unsigned char*)pBuffer,
			 pCurrent - pBuffer );

#endif
    }
}

void style_set( GtkWidget* widget,
                GtkStyle* style,
                gpointer data
                )
{
    printVCLStyle( widget );
}

GdkFilterReturn reference_window_deleted( GdkXEvent* xevent,
                                          GdkEvent* event,
                                          gpointer data )
{
    if( ((XEvent*)xevent)->type == DestroyNotify &&
        ((XEvent*)xevent)->xdestroywindow.window == nOutputWindow )
        gtk_main_quit();

    return GDK_FILTER_CONTINUE;
}

int main (int argc, char **argv)
{
#ifdef GDK_TYPE_DISPLAY
    GdkDisplay* pDisplay = NULL;
#endif
    int i;

    /* get the reference window */
    for( i=1; i < argc-1; i++ )
    {
        if( !strcmp( argv[i], "--vcl-system-settings-window" ) )
        {
            sscanf( argv[i+1], "%d", &nOutputWindow );
            break;
        }
    }

    if( nOutputWindow != 0 )
    {
    
        /* Initialize i18n support */
        gtk_set_locale ();

        /* Initialize the widget set */
        gtk_init (&argc, &argv);

        /* Create the main window */
        mainwin = gtk_window_new (GTK_WINDOW_POPUP);
        
        g_signal_connect (G_OBJECT(mainwin), "style-set",
                          G_CALLBACK (style_set), NULL );

        /* Create a toolbar (for toolbar icon size */
        toolbar = gtk_toolbar_new();
        gtk_container_add(GTK_CONTAINER(mainwin),
                          toolbar );

        /* prepare VCL ref window */
#ifdef GDK_TYPE_DISPLAY
        pDisplay = gtk_widget_get_display( mainwin );
        pOutputWindow = gdk_window_foreign_new_for_display( pDisplay, nOutputWindow );
        gdk_window_set_events( pOutputWindow, GDK_STRUCTURE_MASK );
        gdk_window_add_filter( pOutputWindow, reference_window_deleted, NULL );

        /* prepare property name and type */
        aPropertyName = gdk_atom_intern( "VCL_SYSTEM_SETTINGS", FALSE );
        aPropertyType = gdk_atom_intern( "STRING", FALSE );
#else
        XSelectInput( gdk_x11_get_default_xdisplay(),
                      nOutputWindow,
                      StructureNotifyMask );
        gdk_window_add_filter( NULL, reference_window_deleted, NULL );
#endif

        /* realize the widgets, do not show it to avoid flicker */
        gtk_widget_realize(mainwin);
        gtk_widget_realize(toolbar);

        /* Enter the main event loop, and wait for user interaction */
        gtk_main ();
        
        gtk_widget_destroy( toolbar );
        gtk_widget_destroy( mainwin );

        free( pBuffer );
    }
    
    return 0;
}
