 /*************************************************************************
 *
 *  $RCSfile: DBMetaData.java,v $
 *
 *  $Revision: 1.34 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 10:15:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 */

package com.sun.star.wizards.report;

import com.sun.star.wizards.common.Tools;
import com.sun.star.wizards.common.UNODialogs;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XElementAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameContainer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XMultiPropertySet;

import com.sun.star.comp.servicemanager.ServiceManager;

import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdb.XBookmarksSupplier;

import com.sun.star.sdbc.*;
import com.sun.star.sdbc.XStatement;
import com.sun.star.sdb.XCompletedExecution;
import com.sun.star.sdb.XResultSetAccess;
import com.sun.star.sdb.*;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.sheet.*;
import com.sun.star.document.*;
import com.sun.star.table.*;
import com.sun.star.text.XTextRange;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.sdb.XSQLQueryComposerFactory;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatTypes;

import com.sun.star.util.NumberFormat;
import com.sun.star.util.XFlushable;

import com.sun.star.lang.Locale;
import com.sun.star.lang.*;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.EventObject;

import com.sun.star.awt.XListBox;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.MouseEvent;
import com.sun.star.frame.XFrame;

import java.io.*;
import java.util.*;


public class DBMetaData extends ReportWizard{
    public XNameAccess xColumns;
    public XRow xRow;
    public XRow xResultSetRow;
    public XInterface xRowSet;
    public XInterface xDatabaseContext;
    public XCompletedExecution xExecute;
    public XInteractionHandler xInteraction;
    public XDatabaseMetaData xDBMetaData;
    public int FieldCount;
    public int CommandType;
    public int[] SelColIndices = null;
    public int[] GroupColIndices = null;
    public String MainCommandName;
    public String[] DataSourceNames;
    public String[] AllFieldNames;
    public String[] FieldNames;
    public String[] FieldTitles;
    public String[] CommandNames;
    public FieldColumn[] DBFieldColumns;
    public String[] GroupFieldNames;
    public String[] RecordFieldNames;
    public String[][] SortFieldNames;
    public String OldMainCommandName;
    public String[] OldFieldNames;
    public String[] OldGroupFieldNames;
    public String[][] OldSortFieldNames;
    public String[] OldFieldTitles;
    public int[] CommandTypes;
    public boolean bConnectionOvergiven = true;
    public Object DataSource;
    public String Command;
    public String DataSourceName;
    public XResultSet ResultSet;
    public XStatement Statement;
    public XColumnsSupplier xRowSetColumnsSupplier;
    public com.sun.star.sdbc.XConnection DBConnection;
    public XSQLQueryComposer SQLQueryComposer;
    public XMultiServiceFactory xMSF;
    public XComponent xComponent;
    public XComponent xRowSetComponent;
    public long lDateCorrection;
    public final String BlindText =    "Ut wisi enim ad minim veniam, quis nostrud exerci tation " +
			"ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor " +
			"in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at " +
			"vero et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore " +
			"te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy " +
			"nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, " +
			"quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. " +
			"Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum " +
			"dolore eu feugiat nulla facilisis at vero et accumsan et iusto odio dignissim qui blandit praesent " +
			"luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Nam liber tempor cum soluta nobis " +
			"eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum.";
    public String[] BlindTextArray;
    
    
    private int iDateFormatKey;
    private int iDateTimeFormatKey;
    private int iNumberFormatKey;
    private int iTextFormatKey;
    private int iTimeFormatKey;
    private int iLogicalFormatKey;
    

    public DBMetaData(XMultiServiceFactory xMSF, Locale CharLocale, XNumberFormats NumberFormats) {
    try{
	// Todo: getDatabaseContext
	this.xMSF = xMSF;
	xDatabaseContext = (XInterface) xMSF.createInstance("com.sun.star.sdb.DatabaseContext");
        XNameAccess xNameContext = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xDatabaseContext);
        DataSourceNames = xNameContext.getElementNames();
	XInterface oInteraction = (XInterface) xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
	xInteraction = (XInteractionHandler) UnoRuntime.queryInterface(XInteractionHandler.class, oInteraction);
	xRowSet = (XInterface) xMSF.createInstance("com.sun.star.sdb.RowSet");
	xRowSetColumnsSupplier = (XColumnsSupplier) UnoRuntime.queryInterface(XColumnsSupplier.class, xRowSet);
	xRowSetComponent = (XComponent) UnoRuntime.queryInterface(XComponent.class, xRowSet);
	xExecute = (XCompletedExecution) UnoRuntime.queryInterface(XCompletedExecution.class, xRowSet);
	
        String FormatString = "[=1]" + '"' + (char)9745 + '"' + ";[=0]" + '"' + (char)58480 + '"' + ";";
        XNumberFormatTypes xNumberFormatTypes = (XNumberFormatTypes) UnoRuntime.queryInterface(XNumberFormatTypes.class, NumberFormats);	
	iLogicalFormatKey = NumberFormats.queryKey(FormatString, CharLocale, true);
        if (iLogicalFormatKey == -1){
	    iLogicalFormatKey = NumberFormats.addNew(FormatString, CharLocale);
	}
	iDateFormatKey = xNumberFormatTypes.getStandardFormat(com.sun.star.util.NumberFormat.DATE, CharLocale);
	iDateTimeFormatKey = xNumberFormatTypes.getStandardFormat(com.sun.star.util.NumberFormat.DATETIME, CharLocale);
	iTimeFormatKey = xNumberFormatTypes.getStandardFormat(com.sun.star.util.NumberFormat.TIME, CharLocale);
	iNumberFormatKey = xNumberFormatTypes.getStandardFormat(com.sun.star.util.NumberFormat.NUMBER, CharLocale);
	iTextFormatKey = xNumberFormatTypes.getStandardFormat(com.sun.star.util.NumberFormat.TEXT, CharLocale);
        BlindTextArray = Tools.ArrayoutofString(BlindText, " ");
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}
    
    
    public void initializeFields(String[] FieldNames, boolean breset){
	if (breset){
	    GroupFieldNames = null;
	    SortFieldNames = null;
	    RecordFieldNames = null;
	}
	FieldCount = FieldNames.length;
	this.FieldNames = FieldNames;					    //	xSelFieldsListBox.getItems();
	FieldTitles = null;
	FieldTitles = Tools.copyStringArray(FieldNames);
	DBFieldColumns = new FieldColumn[FieldCount];
	for (int i = 0; i< FieldCount; i++){
	    DBFieldColumns[i] = new FieldColumn(FieldNames[i]);
	}
    }

    public FieldColumn getFieldColumn(String ColumnName){
	for (int i = 0; i < FieldCount; i++){
	    if (DBFieldColumns[i].FieldName.equals(ColumnName))
		return DBFieldColumns[i];
	}
	throw new com.sun.star.uno.RuntimeException();
    }
    

    public void createCommandTypeList(){
    int TableCount;
    int QueryCount;
    int CommandCount;
    int i;
    int a;
	TableCount = Tools.getArraylength(TableNames);
	QueryCount = Tools.getArraylength(QueryNames);
	CommandCount = TableCount + QueryCount;
        CommandTypes = new int[CommandCount];
        if (TableCount > 0){
            for (i = 0; i< TableCount; i++){
		CommandTypes[i] = com.sun.star.sdb.CommandType.TABLE;
            }
            a = i;
            for (i=0; i<QueryCount; i++){
		CommandTypes[a] = com.sun.star.sdb.CommandType.QUERY;
		a +=1;
            }
        }
    }

    
    public int getCommandTypeIndex() throws Tools.TerminateWizardException{
	int TypeIndex = -1;
	int StartIndex = 0;
	boolean bleaveLoop = false;
	do{	    
	    TypeIndex =  Tools.FieldInList(CommandNames, MainCommandName, StartIndex);
	    if (TypeIndex == -1)
		throw new Tools.TerminateWizardException(xMSF);
	    else if(CommandType == CommandTypes[TypeIndex])
		bleaveLoop = true;
	    else
		StartIndex =  TypeIndex +1;
	}
	while (bleaveLoop == false);
	return TypeIndex;
    }

    
    public String adjustBlindTextlength(FieldColumn CurDBField, boolean bIsCurLandscape){
    //try{
	String BlindTextString = "";
	if (Tools.FieldInList(GroupFieldNames, CurDBField.FieldName) > -1){
	    return getBlindTextString(CurDBField, CurDBField.FieldWidth);
	}
	int MaxFieldCount = getMaxFieldCount(bIsCurLandscape);	
	if (RecordFieldNames.length <= 2 * MaxFieldCount){
	    if (RecordFieldNames.length <= MaxFieldCount)
	        BlindTextString = getBlindTextString(CurDBField, CurDBField.FieldWidth);
	    else
		BlindTextString = getBlindTextString(CurDBField, (int) (0.5 * CurDBField.FieldWidth));
	}
	else
	    BlindTextString = getBlindTextString(CurDBField, (int) 1.1 * CurDBField.FieldTitle.length());
	return BlindTextString;
//    }
//    catch (com.sun.star.lang.IllegalArgumentException exception){
//	exception.printStackTrace(System.out);
//	return "";
    }//}
    

    public int getMaxFieldCount(boolean bIsCurLandscape){
	if (bIsCurLandscape == true)
	    return 5;
	else
	    return 3;
    }
    
    public String getBlindTextString(FieldColumn CurDBField, int MaxWidth){
	String PartBlindText = BlindTextArray[0];
	String NewPartBlindText;
	int MaxHeaderWidth;
	int iWidth = CurDBField.FieldWidth;
	String FieldTitle = CurDBField.FieldTitle;
	int Titlelength = (int) 1.1 * FieldTitle.length();	    // We assume that the TableHeading is bold    
	    
	if (Titlelength > PartBlindText.length())
	    MaxHeaderWidth = Titlelength;	    
	else
	    MaxHeaderWidth = PartBlindText.length();	    
	if (MaxHeaderWidth > MaxWidth)
	    MaxWidth = MaxHeaderWidth;		
    
	int i = 1;
	do{
	    NewPartBlindText = PartBlindText + " " + BlindTextArray[i];
	    if (NewPartBlindText.length() < MaxWidth){
		PartBlindText = NewPartBlindText;
		i +=1;
	    }
	} while (NewPartBlindText.length() < MaxWidth);
	return PartBlindText;
    }

    
    public void getSpecificFieldNames(int[][] WidthList){
    try{
        Object oField;
        Vector ResultFieldNames = new java.util.Vector(10);
	String[] FieldNames;
	FieldNames = xColumns.getElementNames();
	Arrays.sort(FieldNames);
	FieldCount = FieldNames.length;
        if (FieldCount > 0){
	    for (int n = 0; n < FieldCount; n++){
		oField = xColumns.getByName(FieldNames[n]);
		int iType = AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Type"));
		if (Tools.FieldInIntTable(WidthList, iType) >= 0){
		    ResultFieldNames.addElement(FieldNames[n]);
		}
	    }
	    FieldNames = new String[FieldCount];
	    FieldTitles = new String[FieldCount];
            AllFieldNames = new String[ResultFieldNames.size()];
            ResultFieldNames.copyInto(AllFieldNames);
	}
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}    
    

    public int[] getSelectedQueryFields(String[] FieldNames) throws Tools.InvalidQueryException{
    try{
	String CurFieldName;
	SQLQueryComposer = getSQLQueryComposer();
	SQLQueryComposer.setQuery(Command);
	XColumnsSupplier xColSuppl = (XColumnsSupplier) UnoRuntime.queryInterface(XColumnsSupplier.class, SQLQueryComposer);
	XNameAccess xColumns = xColSuppl.getColumns();
	String[] AllQueryFieldNames = xColumns.getElementNames();
	int FieldCount = FieldNames.length;
	int[] SelColIndices = Tools.initializeintArray(FieldCount, -1);
	for (int i=0; i<FieldCount; i++){
	    CurFieldName = FieldNames[i];
	    SelColIndices[i] = Tools.FieldInList(AllQueryFieldNames, CurFieldName) + 1;
	    if (SelColIndices[i] == -1)
		throw new Tools.InvalidQueryException(xMSF, Command);
	}
	return SelColIndices;
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
	return null;
    }}

    
    public Object getColumnStringValue(int ColIndex){
    try{
	Type CurType;
	Object oAny;
	String sValue = xResultSetRow.getString(ColIndex);			//???
	CurType = new Type(String.class);
	oAny = AnyConverter.toObject(CurType, sValue);
	return oAny;
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
	return null;
    }}    
    
    
    public Object getColumnDoubleValue(int ColIndex, boolean bisDate){
    try{
	Double DblValue;
	if (bisDate)
	    DblValue = new Double(xResultSetRow.getDouble(ColIndex) + (double) lDateCorrection);		
	else
	    DblValue = new Double(xResultSetRow.getDouble(ColIndex));		
	return DblValue;
    }
    catch(com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
	return null;
    }}
        
    
    
    public Object getColumnValue(int ColIndex, int iType){
	boolean bResult;
	Object oAny = null;
	switch (iType) {
	    case com.sun.star.sdbc.DataType.BIT:				// ==  -7;
		oAny = getColumnDoubleValue(ColIndex, false);
                break;
		
	    case com.sun.star.sdbc.DataType.TINYINT:			// ==  -6;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;
		
	    case com.sun.star.sdbc.DataType.BIGINT:			// ==  -5;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;

	    case com.sun.star.sdbc.DataType.CHAR:			// ==   1;
		oAny = getColumnStringValue(ColIndex);
		break;

	    case com.sun.star.sdbc.DataType.VARCHAR:			// ==  12;
		oAny = getColumnStringValue(ColIndex);
		//		double sResult = xResultSetRow.getClob(ColIndex);		//???
		break;

	    case com.sun.star.sdbc.DataType.LONGVARCHAR:		// ==  -1;
		oAny = getColumnStringValue(ColIndex);
		//		double sResult = xResultSetRow.getCharacterStream(ColIndex);
		break;

	    case com.sun.star.sdbc.DataType.NUMERIC:			// ==   2;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;

	    case com.sun.star.sdbc.DataType.INTEGER:			// ==   4;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;

	    case com.sun.star.sdbc.DataType.SMALLINT:			// ==   5;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;
		
	    case com.sun.star.sdbc.DataType.DECIMAL:			// ==   3;  [mit Nachkommastellen]
		oAny = getColumnDoubleValue(ColIndex, false);
		break;	     
		
	    case com.sun.star.sdbc.DataType.FLOAT:			// ==   6;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;
		
	    case com.sun.star.sdbc.DataType.REAL:			// ==   7;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;
		
	    case com.sun.star.sdbc.DataType.DOUBLE:			// ==   8;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;

	    case com.sun.star.sdbc.DataType.DATE:			// ==  91;
		oAny = getColumnDoubleValue(ColIndex, true);
		break;
		
	    case com.sun.star.sdbc.DataType.TIME:			// ==  92;
		oAny = getColumnDoubleValue(ColIndex, false);
		break;
		
	    case com.sun.star.sdbc.DataType.TIMESTAMP:			// ==  93;
		oAny = getColumnDoubleValue(ColIndex, true);
		break;
	}	
	
    // Is the index OK; increment?
//	String sValue =  xResultSetRow.getString(ColIndex);
	return oAny;
    }
    

    public String[] getDBMetaData(){
        try{
            XElementAccess xDBElements = (XElementAccess) UnoRuntime.queryInterface(XElementAccess.class, xDatabaseContext);
            if (xDBElements.hasElements()){
                XTablesSupplier xDBTables = (XTablesSupplier) UnoRuntime.queryInterface(XTablesSupplier.class, DBConnection);
		xDBMetaData = DBConnection.getMetaData();
//		CurDBMetaData.bGroupByIsSupported = xDBMetaData.supportsGroupBy();
                xTableNames = (XNameAccess) xDBTables.getTables();
                TableNames = (String[]) xTableNames.getElementNames();
                int Tablelen = TableNames.length;
                XQueriesSupplier xDBQueries = (XQueriesSupplier) UnoRuntime.queryInterface(XQueriesSupplier.class, DBConnection);
                xQueryNames = (XNameAccess) xDBQueries.getQueries();
                QueryNames = xQueryNames.getElementNames();
                Arrays.sort(QueryNames);
                Arrays.sort(TableNames);
                int Querylen = QueryNames.length;
                CommandNames = new String[Querylen + Tablelen];
                System.arraycopy(TableNames, 0, CommandNames, 0, Tablelen);
                System.arraycopy(QueryNames, 0, CommandNames, Tablelen, Querylen);
		createCommandTypeList();
                return CommandNames;
            }
            else{
                throw new com.sun.star.uno.RuntimeException();
            }
        }
        catch(Exception exception){
            exception.printStackTrace(System.out);
            return null;
        }
    }

    
    public static int[][] InitializeWidthList(){
        int[][] WidthList = new int[16][2];
        WidthList[0][0] = com.sun.star.sdbc.DataType.BIT;   		// ==  -7;
      	WidthList[1][0] = com.sun.star.sdbc.DataType.TINYINT;		// ==  -6;
        WidthList[2][0] = com.sun.star.sdbc.DataType.BIGINT;		// ==  -5;
       	WidthList[3][0] = com.sun.star.sdbc.DataType.LONGVARCHAR;       // ==  -1;
      	WidthList[4][0] = com.sun.star.sdbc.DataType.CHAR;		// ==   1;
        WidthList[5][0] = com.sun.star.sdbc.DataType.NUMERIC;		// ==   2;
       	WidthList[6][0] = com.sun.star.sdbc.DataType.DECIMAL;		// ==   3;  [mit Nachkommastellen]
        WidthList[7][0] = com.sun.star.sdbc.DataType.INTEGER;		// ==   4;
        WidthList[8][0] = com.sun.star.sdbc.DataType.SMALLINT;		// ==   5;
       	WidthList[9][0] = com.sun.star.sdbc.DataType.FLOAT;		// ==   6;
       	WidthList[10][0] = com.sun.star.sdbc.DataType.REAL;		// ==   7;
       	WidthList[11][0] = com.sun.star.sdbc.DataType.DOUBLE;		// ==   8;
       	WidthList[12][0] = com.sun.star.sdbc.DataType.VARCHAR;		// ==  12;
       	WidthList[13][0] = com.sun.star.sdbc.DataType.DATE;		// ==  91;
       	WidthList[14][0] = com.sun.star.sdbc.DataType.TIME;             // ==  92;
       	WidthList[15][0] = com.sun.star.sdbc.DataType.TIMESTAMP;	// ==  93;
	return WidthList;
    }


    public boolean getConnection(String sMsgNoConnection, String sMsgConnectionImpossible){
    try{
	int iMsg = 0;
        boolean bgetConnection = false;
        if (DBConnection != null){
	    xComponent.dispose();
        }
        XNameAccess xNameAccess = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xDatabaseContext);
        DataSource = xNameAccess.getByName(DataSourceName);
        XPropertySet xPSet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, DataSource);
        boolean bPasswordIsRequired = ((Boolean) xPSet.getPropertyValue("IsPasswordRequired")).booleanValue();
	if (bPasswordIsRequired == false){
            XDataSource xDataSource = (XDataSource) UnoRuntime.queryInterface(XDataSource.class, DataSource);
            DBConnection = xDataSource.getConnection("","");
	    bgetConnection = true;
        }
        else{
            XInterface xInteractionHandler = (XInterface) xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
            XInteractionHandler oInteractionHandler = (XInteractionHandler) UnoRuntime.queryInterface(XInteractionHandler.class, xInteractionHandler);
            boolean bExitLoop = true;
            do {
                XCompletedConnection xCompleted = (XCompletedConnection) UnoRuntime.queryInterface(XCompletedConnection.class, DataSource);
                try{
                    DBConnection = xCompleted.connectWithCompletion(oInteractionHandler);
		    bgetConnection = DBConnection != null;
		    if (bgetConnection == false)
			bExitLoop = true;
                }
                catch(Exception exception){
		    // Note:  WindowAttributes from toolkit/source/awt/vclxtoolkit.cxx
		    iMsg = UNODialogs.showMessageBox(xMSF, "QueryBox", com.sun.star.awt.VclWindowPeerAttribute.RETRY_CANCEL, sMsgNoConnection);
		    bExitLoop = iMsg == 0;
		    bgetConnection = false;
                }
	    } while (bExitLoop == false);
        }
	if (bgetConnection == false)
	    UNODialogs.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMsgConnectionImpossible);
	else
	    xComponent = (XComponent) UnoRuntime.queryInterface(XComponent.class, DBConnection);
	return bgetConnection;
    }
    catch(Exception exception){
	UNODialogs.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMsgConnectionImpossible);
        exception.printStackTrace(System.out);
	return false;
    }}


    public boolean addtoSelectClause(String CurFieldName){
    boolean bAddToClause = true;
    try{
	bAddToClause = true;
/*        if (xDBMetaData.supportsGroupBy() == true)
            // if xMetaData.supportsGroupByUnrelated() // dann Groupby Feldnamen nicht ins select clause
	    bAddToClause = (Tools.FieldInList(GroupFieldNames, CurFieldName) < 0) && (xDBMetaData.supportsGroupByUnrelated() == false);
	    if (bAddToClause == false)
	        bAddToClause = (Tools.FieldInTable(SortFieldNames, CurFieldName) < 0) && (xDBMetaData.supportsOrderByUnrelated() == false); */
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
	bAddToClause = false;
    }
    return bAddToClause;
    }


    public String QuoteName(String sName, String sQuote){
	if (sName == null)
	    sName = "";
	if (sQuote == null)
	    sQuote = "";
	String ReturnQuote = null;
	ReturnQuote = sQuote + sName + sQuote;
	return ReturnQuote;
    }


    public DBMetaData.ComposedName getQualifiedNameComponents(String ComposeName){
    DBMetaData.ComposedName oComposedName = new DBMetaData.ComposedName();
    try{
	int iIndex;
	String sCatalogSep = xDBMetaData.getCatalogSeparator();
	boolean bCatalogAtStart = xDBMetaData.isCatalogAtStart();
        if (xDBMetaData.supportsCatalogsInDataManipulation() == true){  	// ...dann Catalog mit in TableName
	    iIndex = ComposeName.indexOf(sCatalogSep);
	    if (iIndex >= 0){
		if (bCatalogAtStart == true){
		    oComposedName.CatalogName = ComposeName.substring(0, iIndex);
		    ComposeName = ComposeName.substring(iIndex + 1,ComposeName.length());
		}
		else{
		    oComposedName.CatalogName = ComposeName.substring(iIndex + 1,ComposeName.length());
		    ComposeName = ComposeName.substring(0, iIndex);
		}
	    }
	}
	if (xDBMetaData.supportsSchemasInDataManipulation() == true){
	    String[] NameList;
	    NameList = new String[0];
	    NameList = Tools.ArrayoutofString(ComposeName, ".");
	    oComposedName.SchemaName = NameList[0];
	    oComposedName.TableName = NameList[1];	// Todo: Was ist mit diesem Fall: CatalogSep = "." und CatalogName = ""
	}
	else
	    oComposedName.TableName = ComposeName;
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }
    return oComposedName;
    }


    public String composeTableName(String Quotes, DBMetaData.ComposedName oComposedName){
    String ComposedName = "";
    try{
	String sCatalogSep = xDBMetaData.getCatalogSeparator();
	boolean bCatalogatStart = xDBMetaData.isCatalogAtStart();
	if (oComposedName.CatalogName != null){
	    if (bCatalogatStart == true){
		ComposedName =  QuoteName(oComposedName.CatalogName, Quotes);
		ComposedName += sCatalogSep;
	    }
	}
	if (oComposedName.SchemaName != null){
	    ComposedName += QuoteName(oComposedName.SchemaName, Quotes);
	    ComposedName += ".";
	}
	if (ComposedName == "")
	    ComposedName = QuoteName(oComposedName.TableName, Quotes);
	else
	    ComposedName += QuoteName(oComposedName.TableName, Quotes);
	if ((bCatalogatStart == false) && (oComposedName.CatalogName != null)){
	    ComposedName += sCatalogSep;
	    ComposedName += QuoteName(oComposedName.CatalogName, Quotes);
	}
	return ComposedName;
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
	return ComposedName;
    }}


    public String[] setRecordFieldNames(){
    String CurFieldName;
    int GroupFieldCount;
    int TotFieldCount = FieldNames.length;
//    int SortFieldCount = SortFieldNames[0].length;
    GroupFieldCount = Tools.getArraylength(GroupFieldNames);
    String[] LocRecordFieldNames = new String[TotFieldCount-GroupFieldCount];

    int a = 0;
    // Resort the RecordFieldNames by posing the Sortcriterias at the front
    int MaxSortIndex = SortFieldNames.length-1;
    if (MaxSortIndex + 1  > 0){
	for (int i=0; i <MaxSortIndex + 1; i++){
	    LocRecordFieldNames[a] = SortFieldNames[i][0];
	    a +=1;
	}
    }
    for (int i=0; i<TotFieldCount; i++){
	CurFieldName = FieldNames[i];
	if (Tools.FieldInTable(SortFieldNames, CurFieldName) < 0){
	    if (Tools.FieldInList(GroupFieldNames, CurFieldName) < 0){
		LocRecordFieldNames[a] = CurFieldName;
		a += 1;
	}}
    }
    return LocRecordFieldNames;
    }


    public void createDBLink(Object oDataSource, String StorePath){
    try{
    	String sBookmarkName = Tools.getFileDescription(StorePath);
	XBookmarksSupplier xBookmarksSuppl = (XBookmarksSupplier) UnoRuntime.queryInterface(XBookmarksSupplier.class, oDataSource);
	XNameAccess xBookmarks = xBookmarksSuppl.getBookmarks();
	boolean bLinkexists = true;
	String sBaseBookmarkName = sBookmarkName;
	int i = 1;
	while (bLinkexists == true){
	    bLinkexists = xBookmarks.hasByName(sBookmarkName);
	    if (bLinkexists == true){
		i += 1;
		sBookmarkName = sBaseBookmarkName + "_" + Integer.toString(i);
	    }
	    else{
		XNameContainer xNameCont = (XNameContainer) UnoRuntime.queryInterface(XNameContainer.class, xBookmarks);
		xNameCont.insertByName(sBookmarkName, StorePath);
		XFlushable xFlush = (XFlushable) UnoRuntime.queryInterface(XFlushable.class, xBookmarks);
		xFlush.flush();
	    }
	}
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}

    
    public Object getGroupColumnValue(int ColIndex){
	int FinalColIndex;
	Object oValue;
	if ((CommandType == com.sun.star.sdb.CommandType.QUERY) || (CommandType == com.sun.star.sdb.CommandType.COMMAND))
	    FinalColIndex = GroupColIndices[ColIndex];
	else
	    FinalColIndex = ColIndex;
	oValue = getColumnValue(ColIndex + 1, DBFieldColumns[FinalColIndex].FieldType);
	return oValue;
    }
    

    public boolean getcurrentRecordData( int ColIndex, int FieldCount, int RecordFieldCount, java.util.Vector DataVector, String sMsgQueryCreationImpossible){
    Object[] RecordValueArray = new Object[RecordFieldCount];
    FieldColumn CurDBFieldColumn;
	if ((CommandType == com.sun.star.sdb.CommandType.QUERY) || (CommandType == com.sun.star.sdb.CommandType.COMMAND)){
	    int SelCount = SelColIndices.length;
	    int FinalColIndex;
	    if (SelCount > 0){
		for (int i = 0; i < SelCount; i ++){
		    FinalColIndex = SelColIndices[i];
		    RecordValueArray[i] = getColumnValue(FinalColIndex, DBFieldColumns[ColIndex].FieldType);
		}
	    }
	}
	else{
	    int i = 0;
	    while (ColIndex < FieldCount){
		CurDBFieldColumn = getFieldColumn(RecordFieldNames[i]);
		RecordValueArray[i] = getColumnValue(ColIndex + 1, CurDBFieldColumn.FieldType);
		ColIndex +=1;
		i +=1;
	    }
	}
	DataVector.addElement(RecordValueArray);
	return true;
    }

    
    public XSQLQueryComposer getSQLQueryComposer(){
    try{
        XSQLQueryComposerFactory xSQLComposerFactory = (XSQLQueryComposerFactory) UnoRuntime.queryInterface(XSQLQueryComposerFactory.class, DBConnection);
	XSQLQueryComposer xSQLComposer = xSQLComposerFactory.createQueryComposer();
	return xSQLComposer;
    }
    catch(Exception exception){
	exception.printStackTrace(System.out);  
	return null;
    }}


    public void addSortingCriteria(String SortingColumnName, boolean bAscend){
    try{
	SQLQueryComposer.setQuery(Command);
	XColumnsSupplier xColSuppl = (XColumnsSupplier) UnoRuntime.queryInterface(XColumnsSupplier.class, SQLQueryComposer);
	XNameAccess xColumns = xColSuppl.getColumns();
	Object oColumn =  xColumns.getByName(SortingColumnName);
	XPropertySet xColumn = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, oColumn);
	
	SQLQueryComposer.appendOrderByColumn(xColumn, bAscend);
	Command = SQLQueryComposer.getComposedQuery();
    }
    catch(Exception exception){
	exception.printStackTrace(System.out);  
    }}

    
    // Todo: this method should not be called when it is not really necessary. At least this is for the execution of the query
    public void combineSelectStatement(String ComposedName){
    XResultSet xResultSet;
    try{
	String SelectString = "";
	int GroupFieldCount = Tools.getArraylength(GroupFieldNames);
	if ((CommandType == com.sun.star.sdb.CommandType.QUERY) || (CommandType == com.sun.star.sdb.CommandType.COMMAND)){
	    boolean bAscend;
	    SQLQueryComposer = getSQLQueryComposer();
	    for (int i = 0; i < GroupFieldCount; i++){
		bAscend = true;
		addSortingCriteria(GroupFieldNames[i], bAscend);
	    }
	    for (int i = 0; i < SortFieldNames.length; i++){
		bAscend = SortFieldNames[i][1] == "ASC";
		addSortingCriteria(SortFieldNames[i][0], bAscend);
	    }
	}
	else{
	    String CurFieldName = "";
	    String SortClause = "";
	    String CatalogName = "";
	    String SchemaName = "";
	    String TableName = "";
	    int iGroupIndex;
	    int iSortIndex;
	    DBMetaData.ComposedName oComposedName = new DBMetaData.ComposedName();
	    String sQuote = xDBMetaData.getIdentifierQuoteString();
	    oComposedName = getQualifiedNameComponents(ComposedName);
	    String SelComposedName = composeTableName(sQuote, oComposedName);
	    int RecordFieldCount = Tools.getArraylength(RecordFieldNames);
	    //	String QuotedTableAliasName = QuoteName("Table1", sQuote);
//	    String TableAliasPrefix = QuotedTableAliasName + ".";

	    String QuotedTableAliasName = "";  // Todo: Sobald wir mehrere Tabellen untersttzen muss die Zeile vorher wieder rein!!!!!!!
	    String TableAliasPrefix = "";
	
	    String FromClause = " FROM " + SelComposedName + " " + QuotedTableAliasName;  // Todo: Wie luft es bei Queries mit mehreren Tabellen?

	    String SelectClause = "SELECT ";
	    int FieldCount = FieldNames.length;
	    for (int i=0; i <GroupFieldCount;i++){
                CurFieldName = GroupFieldNames[i];
		SelectClause += TableAliasPrefix + QuoteName(CurFieldName, sQuote) + ", ";
	    }
	    for (int i=0; i <RecordFieldCount; i++){
		CurFieldName = RecordFieldNames[i];
		SelectClause += TableAliasPrefix + QuoteName(CurFieldName, sQuote) + ", ";
	    }
	    SelectClause = SelectClause.substring(0, SelectClause.length()-2);
        
	    if (GroupFieldCount > 0){
		SortClause = " ORDER BY";
		for (int i = 0; i < GroupFieldCount; i++){
		    SortClause += " " + TableAliasPrefix  + QuoteName(GroupFieldNames[i], sQuote) + " ASC";
		    if (i < GroupFieldCount-1)
			SortClause += ", ";
		}
	    }
	    if (MaxSortIndex >= 0){				    // FieldCount oder MaxIndex???
		if (GroupFieldCount == 0)
		    SortClause = " ORDER BY";
		else
		    SortClause += ", ";
		for (int i = 0; i <= MaxSortIndex; i++){
		    SortClause += " " + TableAliasPrefix + QuoteName(SortFieldNames[i][0], sQuote) + " " + SortFieldNames[i][1];
		    if (i < MaxSortIndex)
			SortClause += ", ";
		} 
	    }
	    SelectString = SelectClause + FromClause + SortClause;
	    SelectString = SelectString.trim();
	    Command = SelectString;
	}
    }
    catch(Exception exception){
       exception.printStackTrace(System.out);  
    }}
 
    public void disposeDBMetaData(){
	if ((xComponent != null) && (!bConnectionOvergiven))
	    xComponent.dispose();
	if (xRowSetComponent != null)
	    xRowSetComponent.dispose();
    }

    
    public String getFieldTitle(String FieldName){
	int TitleIndex = Tools.FieldInList(FieldNames, FieldName);
	String FieldTitle = FieldTitles[TitleIndex];
	return FieldTitle;
    }
    
    public String getFieldName(String FieldTitle){
	int NameIndex = Tools.FieldInList(FieldTitles, FieldTitle);
	String FieldName = FieldNames[NameIndex];
	return FieldName;
    }

    
    public boolean executeCommand(String sMessage, boolean binitializeDBColumns) throws Tools.InvalidQueryException{
    try{
	Tools.setUNOPropertyValue(xRowSet, "DataSourceName", DataSourceName);
	Tools.setUNOPropertyValue(xRowSet, "ActiveConnection", DBConnection);
	Tools.setUNOPropertyValue(xRowSet, "Command", Command);
	Tools.setUNOPropertyValue(xRowSet, "CommandType", new Integer(com.sun.star.sdb.CommandType.COMMAND));    // CommandType
	xExecute.executeWithCompletion(xInteraction);
	// create the ResultSet to access the data
	XResultSetAccess xResultAccess = (XResultSetAccess) UnoRuntime.queryInterface(XResultSetAccess.class, xRowSet);
	ResultSet = xResultAccess.createResultSet();
	xResultSetRow = (com.sun.star.sdbc.XRow) UnoRuntime.queryInterface(com.sun.star.sdbc.XRow.class, ResultSet);
	XColumnsSupplier xDBCols = (XColumnsSupplier) UnoRuntime.queryInterface(XColumnsSupplier.class, ResultSet);
	xColumns = xDBCols.getColumns();
	String[] sElementNames = xColumns.getElementNames();
	CommandType = com.sun.star.sdb.CommandType.COMMAND;
	if (binitializeDBColumns == true){
	    initializeFields(FieldNames, false);
	}
	GroupColIndices = getSelectedQueryFields(GroupFieldNames);
	SelColIndices = getSelectedQueryFields(RecordFieldNames);
	
	// todo: the following Methods call directly from Dataimport object
        return true;
    }
    catch (Tools.InvalidQueryException queryexception){
	return false;
    }
    catch(com.sun.star.uno.Exception exception){
        exception.printStackTrace(System.out);  
	throw new Tools.InvalidQueryException(xMSF, Command);
    }}
    
    
    public class FieldColumn{
	public Object DefaultValue;
	public String FieldName;
	public String FieldTitle;
	public int FieldWidth;
	public int DBFormatKey;
	public int FieldType;
	public int StandardFormatKey;
	public boolean bIsNumberFormat;
	public Object oField;
	
	FieldColumn(String FieldName){
	try{
	    this.FieldName = FieldName;
	    oField = xColumns.getByName(FieldName);
	    FieldTitle = getFieldTitle(FieldName);
	    FieldType = AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Type"));
	    DBFormatKey = getFormatKey();
	    DefaultValue = getTyperelatedFieldData();
	}	
        catch(com.sun.star.uno.Exception exception){
	    exception.printStackTrace(System.out);  
	}}
	
	
	public int getFormatKey(){
	try{
	    int iKey;
	    Object oKey = Tools.getUNOPropertyValue(oField, "FormatKey");
	    if (AnyConverter.isVoid(oKey))
		DBFormatKey = -1;
	    else{
		DBFormatKey = AnyConverter.toInt(oKey);
	    }
	    return DBFormatKey;
	}
	catch(com.sun.star.uno.Exception exception ){
	    exception.printStackTrace(System.out);
	    return -1;
	}}
	
	
	private Object getTyperelatedFieldData(){
	try{    
	    switch (FieldType) {
		case com.sun.star.sdbc.DataType.BIT:				// ==  -7;
		    // Todo: Look if the defaultvalue has been set in the Datasource
		    StandardFormatKey = iLogicalFormatKey;
		    FieldWidth = 5;
		    bIsNumberFormat = true;
		    DefaultValue = (Object) Integer.valueOf("1");
		    break;
	    
		case com.sun.star.sdbc.DataType.TINYINT:			// ==  -6;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 5;
		    bIsNumberFormat = true;
		    DefaultValue = (Object) Integer.valueOf("98");
		    break;
		    
		case com.sun.star.sdbc.DataType.SMALLINT:			// ==   5;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 5;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Integer.valueOf("987");
		    break;
		    
		case com.sun.star.sdbc.DataType.INTEGER:			// ==   4;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 10;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Integer.valueOf("9876");
		    break;
		    
		case com.sun.star.sdbc.DataType.BIGINT:				// ==  -5;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 15;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Integer.valueOf("98765");
		    break;
		    
		case com.sun.star.sdbc.DataType.CHAR:				// ==   1;
		    StandardFormatKey = iTextFormatKey;
		    getTextFieldWidth(10);
		    bIsNumberFormat = false;		    
		    DefaultValue = (Object) String.valueOf('x');
		    break;
		    
		case com.sun.star.sdbc.DataType.VARCHAR:			// ==  12;
		    StandardFormatKey = iTextFormatKey;
		    getTextFieldWidth(30);
		    bIsNumberFormat = false;		    
		    DefaultValue = (Object) getBlindTextString(this, FieldWidth);
		    break;
		    
		case com.sun.star.sdbc.DataType.LONGVARCHAR:			// ==  -1;
		    StandardFormatKey = iTextFormatKey;
		    getTextFieldWidth(60);
		    bIsNumberFormat = false;		    
		    DefaultValue = (Object) getBlindTextString(this, FieldWidth);
		    break;
		    
		case com.sun.star.sdbc.DataType.NUMERIC:			// ==   2;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 20;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("9876.5");
		    break;
		    
		case com.sun.star.sdbc.DataType.DECIMAL:			// ==   3;  [mit Nachkommastellen]
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 10 + AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Scale")) + 1;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("9876.5");
		    break;
		    
		case com.sun.star.sdbc.DataType.FLOAT:				// ==   6;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 10 + AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Scale")) + 1;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("9876.5");
		    break;
		    
		case com.sun.star.sdbc.DataType.REAL:				// ==   7;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 10 + AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Scale")) + 1;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("9876.5");
		    break;
		    
		case com.sun.star.sdbc.DataType.DOUBLE:				// ==   8;
		    StandardFormatKey = iNumberFormatKey;
		    FieldWidth = 10 + AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Scale")) + 1;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("9876.54");
		    break;
		    
		case com.sun.star.sdbc.DataType.DATE:				// ==  91;
		    StandardFormatKey = iDateFormatKey;
		    FieldWidth = 10;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("42510");
		    break;
		    
		case com.sun.star.sdbc.DataType.TIME:				// ==  92;
		    StandardFormatKey = iTimeFormatKey;
		    FieldWidth = 10;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("10");
		    break;

		case com.sun.star.sdbc.DataType.TIMESTAMP:			// ==  93;
		    StandardFormatKey = iDateTimeFormatKey;
		    FieldWidth = 20;
		    bIsNumberFormat = true;		    
		    DefaultValue = (Object) Double.valueOf("5454110");
		    break;
	}
	if (DBFormatKey == -1)
	    DBFormatKey = StandardFormatKey;
	return DefaultValue;
	}
	catch(com.sun.star.lang.IllegalArgumentException exception ){
	    exception.printStackTrace(System.out);
	    return null;
	}
    }

    private void getTextFieldWidth(int iWidth){
    int iNewWidth = iWidth;
    try{
        FieldWidth = AnyConverter.toInt(Tools.getUNOPropertyValue(oField, "Precision"));
	if (FieldWidth > 0){
	    if (FieldWidth > (2*iWidth))
		FieldWidth = 2 * iWidth;
	    else if (FieldWidth == 0)
		FieldWidth = iWidth;
	}
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}
	
    
    }
    

    class ComposedName{
	public String CatalogName;
        public String SchemaName;
	public String TableName;
	public ComposedName(){
	}
    }
}

