 /*************************************************************************
 *
 *  $RCSfile: ReportDocument.java,v $
 *
 *  $Revision: 1.38 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/30 08:27:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 */

package com.sun.star.wizards.report;

import com.sun.star.wizards.common.TextDocument;
import com.sun.star.wizards.common.UNODialogs;
import com.sun.star.wizards.common.Tools;
import com.sun.star.wizards.report.DBMetaData;
import com.sun.star.wizards.report.Dataimport;


import java.util.*;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XElementAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XIndexContainer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.beans.XMultiPropertySet;

import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbc.*;
import com.sun.star.sdb.XColumn;
import com.sun.star.sdb.*;
import com.sun.star.sdbc.XColumnLocate;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Any;
import com.sun.star.uno.*;
import com.sun.star.sheet.*;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XEventsSupplier;
import com.sun.star.document.*;
import com.sun.star.table.*;
import com.sun.star.sdb.*;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XText;
import com.sun.star.table.XCellRange;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.util.XLinkUpdate;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XNumberFormatTypes;
import com.sun.star.util.NumberFormat;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.Date;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.Rectangle;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.lang.*;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.Locale;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.TableColumnSeparator;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.script.XInvocation;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.style.XStyleLoader;
import com.sun.star.style.TabStop;
import com.sun.star.style.BreakType;
import com.sun.star.frame.XFrame;
import com.sun.star.awt.Size;
import com.sun.star.awt.XTextComponent;
import com.sun.star.view.XSelectionSupplier;


    class ReportDocument extends com.sun.star.wizards.common.TextDocument{
	public XNumberFormats NumberFormats;
	private Object ReportPageStyle;
        private Object FirstPageStyle;
	private int PageWidth;
	private Rectangle PosSize;
	private String ReportFolderName;
	public java.util.Vector GroupFormatVector;
	private RecordTable CurRecordTable;
	public DBMetaData CurDBMetaData;
	private long lDateCorrection;
	private String sMsgTableNotExisting;
	private String sMsgCommonReportError;
	private String sMsgEndAutopilot;
	private String ContentTemplatePath;
	private String LayoutTemplatePath;
	private String sMsgInvalidTextField;
	public UNODialogs CurUNODialog;
	public boolean bIsCurLandscape;
	
	

	/** Creates new ReportDocument */
	public ReportDocument(XMultiServiceFactory xMSF, boolean bshowStatusIndicator, boolean bgetCurrentFrame, String[] ReportMessages) {
	super(xMSF, bshowStatusIndicator, bgetCurrentFrame);
	    Date dNullDate = (Date) Tools.getUNOStructValue(xNumberFormatsSupplier.getNumberFormatSettings(), "NullDate");
	    long lNullDate = Tools.convertUnoDatetoInteger(dNullDate);
	    lDateCorrection = Tools.getNullDateCorrection(lNullDate);
	    NumberFormats = xNumberFormatsSupplier.getNumberFormats();
	    GroupFormatVector = new java.util.Vector();
	    CurDBMetaData = new DBMetaData(xMSF, CharLocale, NumberFormats);
	    CurDBMetaData.lDateCorrection = lDateCorrection;
	    sMsgTableNotExisting = ReportMessages[0];
	    sMsgCommonReportError = ReportMessages[1];
	    sMsgEndAutopilot = ReportMessages[2];
	    sMsgInvalidTextField = ReportMessages[3];
	    sMsgTableNotExisting = sMsgTableNotExisting + (char) 13 + sMsgEndAutopilot;
	    bIsCurLandscape = true;
	    getReportPageStyles();
	}


    public boolean checkReportLayoutMode( String[] GroupFieldNames){
    try{
	XNameAccess xTextSections = xTextSectionsSupplier.getTextSections();
	Object oTextSection;
	if (GroupFieldNames.length > 0)
	    oTextSection = xTextSections.getByName("GroupField1");
	else
	    oTextSection = xTextSections.getByName("RecordSection");
	boolean bLayoutMode = AnyConverter.toBoolean(Tools.getUNOPropertyValue(oTextSection, "IsVisible"));
	return bLayoutMode;
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
	// In doubt we rather suggest this is LayoutMode...
	return true;
    }}


    public void swapContentTemplate(String ContentTemplatePath){
//	unlockallControllers();
	xProgressBar.start("", 10);
	this.ContentTemplatePath = ContentTemplatePath;
	loadSectionsfromTemplate(ContentTemplatePath);
	xProgressBar.setValue(40);
	loadStyleTemplates(ContentTemplatePath, "LoadTextStyles");
	xProgressBar.setValue(70);
	if (CurRecordTable != null)
	    CurRecordTable.adjustOptimalTableWidths();
	xProgressBar.setValue(100);
	selectFirstPage();
        CurUNODialog.assignPropertyToDialogControl("cmdGoOn", "Enabled", new Boolean(true));	
	xProgressBar.end();	
    }
    

    public void swapLayoutTemplate(String LayoutTemplatePath, String BitmapPath, UNODialogs CurUNODialog){
    try{
	xProgressBar.start("", 10);
	this.LayoutTemplatePath = LayoutTemplatePath;
	boolean bOldIsCurLandscape = AnyConverter.toBoolean(Tools.getUNOPropertyValue(ReportPageStyle, "IsLandscape"));
	loadStyleTemplates(LayoutTemplatePath, "LoadPageStyles");
	xProgressBar.setValue(60);
	changePageOrientation(BitmapPath, CurUNODialog, bOldIsCurLandscape);
	xProgressBar.setValue(100);
	selectFirstPage();
	xProgressBar.end();	
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}
    

    public void createReportForm(String SOREPORTFORMNAME){
	XNameContainer xNamedForm = insertFormbyName(SOREPORTFORMNAME);
        XNameAccess xNameAccess = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xNamedForm);
	insertHiddenControl(xNameAccess, xNamedForm, "DataSourceName", CurDBMetaData.DataSourceName);
	insertHiddenControl(xNameAccess, xNamedForm, "Command", CurDBMetaData.Command);
	insertHiddenControl(xNameAccess, xNamedForm, "CommandType", new String(Integer.toString(CurDBMetaData.CommandType)));
	insertHiddenControl(xNameAccess, xNamedForm, "GroupFieldNames", Tools.ArraytoString(CurDBMetaData.GroupFieldNames));
	insertHiddenControl(xNameAccess, xNamedForm, "FieldNames", Tools.ArraytoString(CurDBMetaData.FieldNames));
	insertHiddenControl(xNameAccess, xNamedForm, "RecordFieldNames", Tools.ArraytoString(CurDBMetaData.RecordFieldNames));
    }


    public void updateReportTitle(XTextComponent xTitleTextBox){
	String TitleName = xTitleTextBox.getText();
	Tools.setUNOPropertyValue(xDocInfo, "Title", TitleName);
    }
    

    public void getReportPageStyles(){
    try{
        Object oPageStyleFamily = xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
        ReportPageStyle  = Tools.getUNOObjectbyName(oPageStyleFamily, "Standard");
        FirstPageStyle = Tools.getUNOObjectbyName(oPageStyleFamily, "First Page");
    }
    catch(com.sun.star.uno.Exception exception){
        exception.printStackTrace(System.out);
    }}

    
    
    public void changePageOrientation(String BitmapPath, UNODialogs CurUNODialog,  boolean bNewLandscape){
    try{
	Size oNewSize;
	getReportPageStyles();
        Size oLocSize = (Size) Tools.getUNOStructValue(ReportPageStyle, "Size");
        bIsCurLandscape = AnyConverter.toBoolean(Tools.getUNOPropertyValue(ReportPageStyle, "IsLandscape"));
        if (bIsCurLandscape != bNewLandscape){
            oNewSize = new Size(oLocSize.Height, oLocSize.Width);
            Tools.setUNOPropertyValue(ReportPageStyle, "IsLandscape", new Boolean(bNewLandscape));
            Tools.setUNOPropertyValue(ReportPageStyle, "Size", oNewSize);
            Tools.setUNOPropertyValue(FirstPageStyle, "IsLandscape", new Boolean(bNewLandscape));
	    Tools.setUNOPropertyValue(FirstPageStyle, "Size", oNewSize);
	    int iLeftMargin = AnyConverter.toInt(Tools.getUNOPropertyValue(ReportPageStyle, "LeftMargin"));
	    int iRightMargin = AnyConverter.toInt(Tools.getUNOPropertyValue(ReportPageStyle, "RightMargin"));
	    PageWidth = oNewSize.Width - iLeftMargin - iRightMargin;
	    if (CurRecordTable != null)
		CurRecordTable.adjustOptimalTableWidths();
	}
	if (CurUNODialog != null){
	    if (bNewLandscape == true)
		CurUNODialog.assignPropertyToDialogControl("imgOrientation", "ImageURL", BitmapPath + "/landscape.gif");
	    else
		CurUNODialog.assignPropertyToDialogControl("imgOrientation", "ImageURL", BitmapPath + "/portrait.gif");
	}
    }
    catch(com.sun.star.uno.Exception exception){
        exception.printStackTrace(System.out);
    }}


    public boolean loadSectionsfromTemplate(String sTemplateUrl){
    try{
	int i;
	DBColumn CurDBColumn;
	String SectionName;
	Object oTextSection;
	int GroupCount = CurDBMetaData.GroupFieldNames.length;
	for (i = 0; i< GroupCount; i++){
	    SectionName = "GroupField" + Integer.toString(i + 1);
	    renameTextTable(xTextTablesSupplier.getTextTables(), "Tbl_" + SectionName, "MyTextTable");
	    oTextSection = xTextSectionsSupplier.getTextSections().getByName(SectionName);
	    linkSectiontoTemplate(oTextSection, sTemplateUrl, SectionName);
	    renameTextTable(xTextTablesSupplier.getTextTables(), "MyTextTable", "Tbl_" + SectionName);
	}
	if (xTextSectionsSupplier.getTextSections().getElementNames().length > CurDBMetaData.GroupFieldNames.length){
	    oTextSection = xTextSectionsSupplier.getTextSections().getByName("RecordSection");
	    linkSectiontoTemplate(oTextSection, sTemplateUrl, "RecordSection");
	    CurRecordTable = new RecordTable(xTextTablesSupplier);
	    insertColumnstoRecordTable();
	}
	else
	    CurRecordTable = null;
	for (i = 0; i < GroupCount; i++){
	    CurDBColumn = new DBColumn(CurDBMetaData.GroupFieldNames[i], i, "Tbl_GroupField" + (i + 1), true);
	    if (CurDBColumn == null)
		return false;
	    else{
		GroupFormatVector.set(i, CurDBColumn);
		replaceFieldValueInGroupTable(CurDBMetaData.GroupFieldNames[i], i);
	    }
	}
	return true;
    }
    catch( com.sun.star.uno.Exception exception ){
	exception.printStackTrace(System.out);
	return false;
    }}

    
    public void setupRecordSection(String TemplateName){
//    try{
	this.ContentTemplatePath = TemplateName;
	if (CurDBMetaData.RecordFieldNames.length > 0){
	    insertTextSection("RecordSection", TemplateName);
	    CurRecordTable = new RecordTable(xTextTablesSupplier);
	    insertColumnstoRecordTable();
	    if (CurRecordTable != null)
		CurRecordTable.adjustOptimalTableWidths();
	}
	else
	    CurRecordTable = null;
    }
//    catch( com.sun.star.uno.Exception exception ){
//	showCommonReportErrorBox(exception);
  //  }}

    
    public void replaceFieldValueInRecordSection(int RecordCount){
	ReportDocument.DBColumn CurDBColumn;
	int GroupCount = CurDBMetaData.GroupFieldNames.length;
	int FieldCount = CurDBMetaData.FieldNames.length;
	for (int i = GroupCount; i < FieldCount; i++){
	    CurDBColumn = (DBColumn) GroupFormatVector.elementAt(i);
	    insertUserField(CurDBColumn.xNameCell, CurDBMetaData.FieldNames[i]);
	    CurDBColumn.replaceValueCellofTable(false);
	}
    }


    public void updateTextSections(XListBox xSelGroupListBox) throws com.sun.star.uno.Exception{
	String CurFieldName;
	String ColumnTitle;
	String TableName;
	DBColumn OldDBColumn;
	DBColumn CurDBColumn;
	XNameAccess xTableNames = xTextTablesSupplier.getTextTables();
	short GroupFieldCount = xSelGroupListBox.getItemCount();
	for (int i = 0; i < GroupFieldCount; i++){
	    CurFieldName = xSelGroupListBox.getItem((short)i);
	    TableName = "Tbl_GroupField" + Integer.toString(i + 1);
	    OldDBColumn = (DBColumn) GroupFormatVector.get(i);
	    CurDBColumn = new DBColumn(CurFieldName, i, TableName, true, OldDBColumn);
	    GroupFormatVector.setElementAt(CurDBColumn, i);
	    insertUserField(CurDBColumn.xNameCell, CurFieldName);
	    CurDBColumn.replaceValueCellofTable(true);
	}
    }

    
    public void insertUserField(XCell xNameCell, String FieldName){
	String FieldTitle = CurDBMetaData.getFieldTitle(FieldName);
	XTextCursor xTextCursor = createTextCursor(xNameCell);
	xTextCursor.gotoStart(false);
	xTextCursor.gotoEnd(true);
	xTextCursor.setString("");	
	super.insertUserField(xTextCursor, FieldName, FieldTitle);
    }    
    
    
    public boolean isNameCell(XTextCursor xCellCursor, String CurFieldName, String CompString){
    try{
	xCellCursor.gotoStart(false);
	XTextRange xTextRange = xCellCursor.getEnd();
	Object oTextField = Tools.getUNOPropertyValue(xTextRange, "TextField");
	if (AnyConverter.isVoid(oTextField))
	    return false;
	else{
	    XDependentTextField xDependent = (XDependentTextField) UnoRuntime.queryInterface(XDependentTextField.class, oTextField);
	    XPropertySet xMaster = xDependent.getTextFieldMaster();
	    String UserFieldName = (String) xMaster.getPropertyValue("Name");
	    boolean bIsNameCell = ((UserFieldName.equals(CompString)) || (UserFieldName.equals(CurFieldName)));
	    return bIsNameCell;
	}
    }
    // Todo: Insert a  resource; Exception should be thrown to the calling routine
    catch( com.sun.star.uno.Exception exception){
	UNODialogs.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMsgInvalidTextField);
	exception.printStackTrace(System.out);
	return true;	//most probably this is really the Namecell!!!!
    }}
    

    public void replaceFieldValueInGroupTable(String CurFieldName, int TableIndex){
    try{
	String TableName = "";
	DBColumn CurDBColumn = (DBColumn) GroupFormatVector.elementAt(TableIndex);
	XIndexAccess xAllTextTables = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextTablesSupplier.getTextTables());
	Object oTextTable = xAllTextTables.getByIndex(TableIndex);
	TableName = "Tbl_GroupField" + (TableIndex + 1);
	// Note: for some reason the table might lose its name and has to be renamed therefor
	XNamed xTableName = (XNamed) UnoRuntime.queryInterface(XNamed.class, oTextTable);
	String OldTableName = xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0)
	    xTableName.setName(TableName);
	XCellRange xCellRange = (XCellRange) UnoRuntime.queryInterface(XCellRange.class, oTextTable);
	insertUserField(CurDBColumn.xNameCell, CurFieldName);
	CurDBColumn.replaceValueCellofTable(true);
	CurDBColumn.setCellFont();
    }
    catch( com.sun.star.uno.Exception exception){   //, com.sun.star.lang.WrappedTargetException exception
	exception.printStackTrace(System.out);
    }}
    

    public void replaceFieldValueInRecordTable(){
	DBColumn  CurDBColumn;
	String TableName = "Tbl_RecordSection";
	String OldTableName = CurRecordTable.xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0)
	    CurRecordTable.xTableName.setName(TableName);
	int GroupCount = CurDBMetaData.GroupFieldNames.length;
	int RecordCount = CurDBMetaData.RecordFieldNames.length;
	for (int i = GroupCount; i < RecordCount; i++){
	    CurDBColumn = (DBColumn) GroupFormatVector.elementAt(i);
    	    insertUserField(CurDBColumn.xNameCell, CurDBMetaData.RecordFieldNames[i]);
	    CurDBColumn.replaceValueCellofTable(false);
	}
    }


    public void insertColumnstoRecordTable(){
    try{
	int GroupCount = CurDBMetaData.GroupFieldNames.length;
	DBColumn  CurDBColumn;
	// Note for some reason the table might lose its name and has to be renamed therefor
	String OldTableName = CurRecordTable.xTableName.getName();
        if (OldTableName.compareTo("Tbl_RecordSection") != 0)
       	    CurRecordTable = new RecordTable(xTextTablesSupplier);
	XTableColumns xColumns = CurRecordTable.xTextTable.getColumns();
	int ColCount = xColumns.getCount();
	int RecordCount = CurDBMetaData.RecordFieldNames.length;
	if (ColCount > RecordCount){
	    int RemoveCount = ColCount - RecordCount;
	    xColumns.removeByIndex(0, RemoveCount);
	}
	else if (ColCount < RecordCount){
	    int AddCount = RecordCount - ColCount;
	    CurRecordTable.xTextTable.getColumns().insertByIndex(ColCount, AddCount);
	}
	for (int i = 0; i < RecordCount; i++){
	    CurDBColumn = new DBColumn(CurRecordTable, CurDBMetaData, i, true);
	    insertUserField(CurDBColumn.xNameCell, CurDBMetaData.RecordFieldNames[i]);
	    CurDBColumn.replaceValueCellofTable(false);
	    if (GroupFormatVector.size() <= (i + GroupCount))
		GroupFormatVector.add(CurDBColumn);
	    else
		GroupFormatVector.set(i+GroupCount,CurDBColumn);
	}
    }
    catch(com.sun.star.uno.Exception exception){
	showCommonReportErrorBox(exception);
    }}



    public boolean addGroupNametoDocument(XListBox xGroupListBox, XListBox xSelGroupListBox, Vector GroupFieldVector, String ReportPath){
    DBColumn CurDBColumn = null;
    try{
	int GroupCount = GroupFieldVector.size();
	if (GroupCount < 4){
	    removeGroupNamesofRecordTable(xSelGroupListBox.getItemCount());
	    String CurGroupTitle = xGroupListBox.getSelectedItem();
	    String CurGroupName = CurDBMetaData.getFieldName(CurGroupTitle);
	    short iSelPos = xGroupListBox.getSelectedItemPos();
	    CurUNODialog.removeSelectedItems(xGroupListBox);
	    GroupFieldVector.addElement(CurGroupName);
	    GroupCount += 1;
	    insertTextSection("GroupField" + GroupCount, ReportPath + "/cnt-default.stw");
	    CurDBColumn = new DBColumn(CurGroupName, GroupCount-1, "Tbl_GroupField" + (GroupCount), true);
	    if (CurDBColumn != null){
		GroupFormatVector.addElement(CurDBColumn);
		replaceFieldValueInGroupTable(CurGroupName, GroupCount-1);
		xSelGroupListBox.addItem(CurGroupTitle, xSelGroupListBox.getItemCount());
		CurUNODialog.selectListBoxItem(xGroupListBox, iSelPos);
		boolean bDoEnable = ((GroupCount < 4) && (xGroupListBox.getSelectedItems().length > 0));
		CurUNODialog.assignPropertyToDialogControl("cmdGroupOut", "Enabled", new Boolean(bDoEnable));
	    }
	    else{
		String sMessage = Tools.replaceSubString(sMsgTableNotExisting, "Tbl_GroupField" + (GroupCount), "<TABLENAME>");
		CurUNODialog.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMessage);
	    }
	    CurUNODialog.assignPropertyToDialogControl("lblBlindTextNote_1", "Enabled", new Boolean(true));
	}
    }
    catch(com.sun.star.uno.Exception exception){
	showCommonReportErrorBox(exception);
    }
    return (CurDBColumn != null);
    }

    
    public void removeGroupNamesofRecordTable(int GroupFieldCount){
	int CurFieldCount = GroupFormatVector.size();
	if (CurFieldCount > GroupFieldCount){
	    for (int i = CurFieldCount-1; i >= GroupFieldCount; i--){
		GroupFormatVector.removeElementAt(i);
	    }
	}
    }
    
    
    public void showCommonReportErrorBox(com.sun.star.uno.Exception exception){
	String SystemContentPath = Tools.convertfromURLNotation(ContentTemplatePath);
	String sMsgCurCommonReportError = Tools.replaceSubString(sMsgCommonReportError, SystemContentPath, "%PATH");
	UNODialogs.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMsgCurCommonReportError);
        CurUNODialog.assignPropertyToDialogControl("cmdGoOn", "Enabled", new Boolean(false));
	exception.printStackTrace(System.out);
    }
    
    
    public void removeGroupName(XListBox xGroupListBox, XListBox xSelGroupListBox, Vector GroupFieldVector){
    try{
	short iSelPos = xSelGroupListBox.getSelectedItemPos();
	if (iSelPos > -1){
	    removeGroupNamesofRecordTable(xSelGroupListBox.getItemCount());
	    String CurGroupTitle = xSelGroupListBox.getItem(iSelPos);
	    String CurGroupName = CurDBMetaData.getFieldName(CurGroupTitle); 
	    GroupFieldVector.removeElement(CurGroupName);
	    xGroupListBox.addItem(CurGroupTitle, (short) xGroupListBox.getItemCount());
	    CurUNODialog.assignPropertyToDialogControl("cmdGroupOut", "Enabled", new Boolean(xGroupListBox.getSelectedItems().length > 0));
	    CurUNODialog.assignPropertyToDialogControl("cmdGroupIn", "Enabled", new Boolean(GroupFieldVector.isEmpty() == false));
	    removeLastTextSection();
	    removeLastTextTable();
	    xSelGroupListBox.removeItems( iSelPos,(short)1);
	    if (iSelPos != xSelGroupListBox.getItemCount()){
		updateTextSections(xSelGroupListBox);
	    }
	    int iSelItemCount = (int) xSelGroupListBox.getItemCount();
	    GroupFormatVector.remove(iSelItemCount);
	    if (iSelItemCount > 0)
		CurUNODialog.selectListBoxItem(xSelGroupListBox, iSelPos);
	    else
		CurUNODialog.assignPropertyToDialogControl("lblBlindTextNote_1", "Enabled", new Boolean(false));

	}
    }
    catch(com.sun.star.uno.Exception exception){
	showCommonReportErrorBox(exception);
    }}

   
    public void getallDBColumns(){
    try{
	int GroupCount = CurDBMetaData.GroupFieldNames.length;
	int FieldCount = CurDBMetaData.FieldNames.length;
	DBColumn CurDBColumn;
	for (int i = 0; i < FieldCount; i++){
	    if (i < GroupCount)
	        CurDBColumn = new DBColumn(CurDBMetaData.GroupFieldNames[i], i, "Tbl_GroupField" + (i + 1), false);
	    else
		CurDBColumn = new DBColumn(CurRecordTable, CurDBMetaData, i-GroupCount, false);
	    if (CurDBColumn != null){
		GroupFormatVector.addElement(CurDBColumn);
	    }
	    else{
		String sMessage = Tools.replaceSubString(sMsgTableNotExisting, "Tbl_GroupField" + (GroupCount), "<TABLENAME>");
		UNODialogs.showMessageBox(xMSF, "ErrorBox", com.sun.star.awt.VclWindowPeerAttribute.OK, sMessage);
	    }
	}
    }
    catch(com.sun.star.uno.Exception exception){
	showCommonReportErrorBox(exception);
    }}

    
    public void selectFirstPage(){
    try{
	XTextRange xRange;
	Object oFirstTextTable;
	XTextContent xTextTable;
	BreakType BreakValue;
	xTextDocument = (XTextDocument) UnoRuntime.queryInterface(XTextDocument.class, xComponent);
	xViewCursorSupplier = (XTextViewCursorSupplier) UnoRuntime.queryInterface(XTextViewCursorSupplier.class, xTextDocument.getCurrentController());	
	XPageCursor xPageCursor = (XPageCursor) UnoRuntime.queryInterface(XPageCursor.class, xViewCursorSupplier.getViewCursor());
	XTextCursor xViewTextCursor = (XTextCursor) UnoRuntime.queryInterface(XTextCursor.class,  xPageCursor);
	xPageCursor.jumpToFirstPage();
	xPageCursor.jumpToStartOfPage();
	Tools.setUNOPropertyValue(xPageCursor, "PageDescName", "First Page");
	Object oPageStyles = xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
	XNameAccess xName = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, oPageStyles);
	Object oPageStyle = xName.getByName("First Page");
	if (xTextTablesSupplier.getTextTables().hasByName("Tbl_GroupField1"))
	    oFirstTextTable = xTextTablesSupplier.getTextTables().getByName("Tbl_GroupField1");
	else
	    oFirstTextTable = xTextTablesSupplier.getTextTables().getByName("Tbl_RecordSection");
	    
	Tools.setUNOPropertyValue(oFirstTextTable, "PageDescName", "First Page");
/*	XIndexAccess xAllTextTables = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xTextTablesSupplier.getTextTables());
	int TextTablesCount = xAllTextTables.getCount();
	for (int i = 0; i<TextTablesCount; i++){
	    xTextTable = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, xAllTextTables.getByIndex(i));
	    xRange = (XTextRange) UnoRuntime.queryInterface(XTextRange.class, xTextTable.getAnchor().getText());
	    xViewTextCursor.gotoRange(xRange, false);
	    if (xPageCursor.getPage() == (short)1){
		Tools.setUNOPropertyValue(xTextTable, "PageDescName", "First Page");
		resetBreakTypeofTextTable(xTextTable);
	    }
	}*/
	XTextRange xHeaderRange = (XTextRange) Tools.getUNOPropertyValue(oPageStyle, "HeaderText", XTextRange.class);
	if (com.sun.star.uno.AnyConverter.isVoid(xHeaderRange) == false){
	    xViewTextCursor.gotoRange(xHeaderRange, false);
	    xViewTextCursor.collapseToStart();
	}
	else
	    System.out.println("No Headertext available");
	unlockallControllers();		
    }
    catch( com.sun.star.uno.Exception exception ){
        exception.printStackTrace(System.out);
    }}
        
    
    class RecordTable{
	String CurFieldName;
	String LabelDescription;
	short ColumnIndex;
	long LabelWidth;		    //	(1/100 mm) 	-> the demanded labelwidth
	long Valuewidth;		    //	the demanded valuewidth
	long MinWidth;
	long MaxWidth;
	long DiffWidth;
	long CalcreducedWidth;
	long CalcincreasedWidth;
	boolean bIsunlimitedText;
	short bDecreaseWithPriority;	    //	set to 1 with bit TextFields and 2 with small textFields and BigIntegers
	double CharFactor;
	long ColumnMargin;
	public XNamed xTableName;
	public XCellRange xCellRange;
	public XTextTable xTextTable;	

	
	public RecordTable(XTextTablesSupplier TextTablesSupplier){
	try{
	    String[] TableNames = TextTablesSupplier.getTextTables().getElementNames();
	    XNameAccess xAllTextTables = TextTablesSupplier.getTextTables();
	    if (xAllTextTables.hasByName("Tbl_RecordSection") == false){
		XIndexAccess xTableIndex = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, xAllTextTables);
		xTextTable = (XTextTable) xTableIndex.getByIndex(xTableIndex.getCount()-1);		
		xTableName = (XNamed) UnoRuntime.queryInterface(XNamed.class, xTextTable);
		xTableName.setName("Tbl_RecordSection");
	    }
	    else{
		Object oTable = xAllTextTables.getByName("Tbl_RecordSection");
		xTextTable = (XTextTable) UnoRuntime.queryInterface(XTextTable.class, oTable);
		xTableName = (XNamed) UnoRuntime.queryInterface(XNamed.class, xTextTable);
	    }
	    xCellRange = (XCellRange) UnoRuntime.queryInterface(XCellRange.class, xTextTable);
	}
	catch(com.sun.star.container.NoSuchElementException exception){
	    exception.printStackTrace(System.out);
	}
	catch(com.sun.star.lang.IndexOutOfBoundsException secondexception){
	    secondexception.printStackTrace(System.out);
	}
	catch(com.sun.star.lang.WrappedTargetException thirdexception){
	    thirdexception.printStackTrace(System.out);
	}}

	
	public void adjustOptimalTableWidths(){	    // setTableColumnSeparators(){
	try{
	    int ColCount = xTextTable.getColumns().getCount();
	    XCellRange xCellRange = (XCellRange) UnoRuntime.queryInterface(XCellRange.class, xTextTable);
	    XCellRange xLocCellRange = xCellRange.getCellRangeByPosition(0, 0, ColCount-1, 1);
    	    short iHoriOrient =  AnyConverter.toShort(Tools.getUNOPropertyValue(xTextTable, "HoriOrient"));
	    XSelectionSupplier xSelection = (XSelectionSupplier) UnoRuntime.queryInterface(XSelectionSupplier.class, xTextDocument.getCurrentController());
	    xSelection.select(xLocCellRange);
	    Tools.dispatchURL(xMSF, ".uno:DistributeColumns", xFrame);
	    Tools.dispatchURL(xMSF, ".uno:SetOptimalColumnWidth", xFrame);
	    Tools.setUNOPropertyValue(xTextTable, "HoriOrient", new Short(iHoriOrient));
	    XTextViewCursorSupplier xViewCursor = (XTextViewCursorSupplier) UnoRuntime.queryInterface(XTextViewCursorSupplier.class, xTextDocument.getCurrentController());
	    XTextViewCursor xTextViewCursor = xViewCursor.getViewCursor();
	    xTextViewCursor.collapseToStart();
	}
	catch( com.sun.star.uno.Exception exception ){
	    exception.printStackTrace(System.out);
	}}
    }
    
    
    class DBColumn{
	public XCell xValCell;
	public XTextRange xValTextCell;
	public XTextCursor xValCellCursor;
	public XNumberFormats xValCellNumberFormats;
	public XCell xNameCell;
	public XTextRange xNameTextCell;
	public boolean bAlignLeft;
	public Object DefaultValue;
	public String CharFontName;
	public int FormatKey;
	public com.sun.star.beans.PropertyState PropertyState;
	public int ValColumn = 1;
	public int ValRow = 0;
	public DBMetaData.FieldColumn CurDBField;

	//Constructor called when the current DBColumn is part of the recordTable	
	public DBColumn(ReportDocument.RecordTable CurRecordTable, DBMetaData CurDBMetaData, int i, boolean binitialize)
	throws com.sun.star.uno.Exception{
	    if (CurRecordTable == null)
		CurRecordTable = new RecordTable(xTextTablesSupplier);
	    String CurFieldName = CurDBMetaData.RecordFieldNames[i];
	    CurDBField = CurDBMetaData.getFieldColumn(CurFieldName);
	    xNameCell = CurRecordTable.xCellRange.getCellByPosition(i,0);
	    String CellName = (String) Tools.getUNOPropertyValue(xNameCell, "CellName");
	    xNameTextCell = (XTextRange) UnoRuntime.queryInterface(XTextRange.class, xNameCell);
	    xValCell = CurRecordTable.xCellRange.getCellByPosition(i,1);
	    xValTextCell = (XTextRange) UnoRuntime.queryInterface(XTextRange.class, xValCell);
	    xValCellCursor = createTextCursor(xValCell);
	    if (binitialize){
		getNumberFormat();
		setCellFont();
	    }
	    else{
//	        int ValNumberFormat = AnyConverter.toInt(Tools.getUNOPropertyValue(xValCell, "NumberFormat"));
//		CurDBMetaData.getFieldColumn(CurFieldName).DBFormatKey = ValNumberFormat;
	    }
	}

	
	public DBColumn(String CurFieldName, int GroupIndex, String TableName, boolean binitialize, DBColumn OldDBColumn)
	throws com.sun.star.uno.Exception{
	    String CurFieldString = "G" + String.valueOf(GroupIndex+1) + "xxx";
	    XTextRange xTextCell;
	    XNameAccess xAllTextTables = xTextTablesSupplier.getTextTables();
	    if (xAllTextTables.hasByName(TableName) == true){
		CurDBField = CurDBMetaData.getFieldColumn(CurFieldName);		
		Object oTextTable = xAllTextTables.getByName(TableName);
		XTextTable xTextTable = (XTextTable) UnoRuntime.queryInterface(XTextTable.class, oTextTable);
		XTableColumns xTableColumns = xTextTable.getColumns();
		xNameCell = OldDBColumn.xNameCell;
		xNameTextCell = OldDBColumn.xNameTextCell;
		xValCell = OldDBColumn.xValCell;
		xValTextCell = OldDBColumn.xValTextCell;
		xValCellCursor = createTextCursor(xValCell);
		ValColumn = OldDBColumn.ValColumn;
		ValRow = OldDBColumn.ValRow;
		if (binitialize){
		    formatValueCell(xTableColumns);
		}}
	}

	
	public DBColumn(String CurFieldName, int GroupIndex, String TableName, boolean binitialize)
	throws com.sun.star.uno.Exception{
	    String CompString;
	    XTextRange xTextCell;
	    XCell xCell;
	    XTextCursor xCellCursor;
	    String CellString;
	    String CurFieldString = "G" + String.valueOf(GroupIndex + 1) + "xxx";
	    XNameAccess xAllTextTables = xTextTablesSupplier.getTextTables();
	    if (xAllTextTables.hasByName(TableName) == true){
		Object oTextTable = xAllTextTables.getByName(TableName);
		XTextTable xTextTable = (XTextTable) UnoRuntime.queryInterface(XTextTable.class, oTextTable);
		XCellRange xCellRange = (XCellRange) UnoRuntime.queryInterface(XCellRange.class, oTextTable);
		XTableColumns xTableColumns = xTextTable.getColumns();
		XTableRows xRows = xTextTable.getRows();
		for (int n = 0; n < xTableColumns.getCount(); n++){
		    for (int m = 0; m < xRows.getCount(); m++){
			xCell = xCellRange.getCellByPosition(n,m);
			xTextCell = (XTextRange) UnoRuntime.queryInterface(XTextRange.class, xCell);
			CellString = xTextCell.getString();
			CompString = TableName.substring(4);
			XTextCursor xLocCellCursor = createTextCursor(xCell);
			if (isNameCell(xLocCellCursor, CurFieldName, CompString)){
			    xNameCell = xCell;
			    xNameTextCell = xTextCell;
			}
			else if (CellString.equals(CurFieldString)){
			    xValCell = xCell;
			    xValTextCell = xTextCell;
			    xValCellCursor = xLocCellCursor;
			    ValColumn = n;
			    ValRow = m;
			}
		    }
		}
		if (binitialize){
	    	    CurDBField = CurDBMetaData.getFieldColumn(CurFieldName);
		    formatValueCell(xTableColumns);
		}
		else{
//		    int ValNumberFormat = AnyConverter.toInt(Tools.getUNOPropertyValue(xValCell, "NumberFormat"));
//		    CurDBMetaData.getFieldColumn(CurFieldName).DBFormatKey = ValNumberFormat;
		}
	    }
	}
	
	public void getNumberFormat(){
	try{
	    XPropertySet xNumberFormat = NumberFormats.getByKey(CurDBField.DBFormatKey);
	    String FormatString = AnyConverter.toString(Tools.getUNOPropertyValue(xNumberFormat, "FormatString"));
	    Locale oLocale = (Locale) Tools.getUNOPropertyValue(xNumberFormat, "Locale");
	    int FormatKey = NumberFormats.queryKey(FormatString, oLocale, true);
	    if (FormatKey == -1)
		FormatKey = NumberFormats.addNew(FormatString, oLocale);
	    Tools.setUNOPropertyValue(xValCell, "NumberFormat", new Integer(FormatKey));
	}
	catch(com.sun.star.uno.Exception exception ){
	    exception.printStackTrace(System.out);
	}}
	
	
	public void formatValueCell(XTableColumns xTableColumns){
	    getNumberFormat();
	    if ((CurDBField.bIsNumberFormat) && (ValColumn == xTableColumns.getCount()-1)){
		bAlignLeft = true;
		setCellFont();
	    }
	}	
	

	public void modifyCellContent(XCellRange xCellRange, Object CurGroupValue){ 
	try{
	    xValCell = xCellRange.getCellByPosition(ValColumn, ValRow);
	    xValTextCell = (XTextRange) UnoRuntime.queryInterface(XTextRange.class, xValCell);
	    modifyCellContent(CurGroupValue);
	    if (bAlignLeft){
		xValCellCursor = createTextCursor(xValCell);
		Tools.setUNOPropertyValue(xValCellCursor, "ParaAdjust", new Integer(com.sun.star.style.ParagraphAdjust.LEFT_value));
	    }
	}
	catch( com.sun.star.uno.Exception exception ){
	    exception.printStackTrace(System.out);
	}}
	    	
	
	public void modifyCellContent(Object CurGroupValue){
	double dblValue = 0;
	String sString;
	try{
	    if (xValCell != null){
		if (com.sun.star.uno.AnyConverter.isString(CurGroupValue)){
		    String sValue = (String) com.sun.star.uno.AnyConverter.toString(CurGroupValue);
		    xValTextCell.setString(sValue);
		}
		else{
		    boolean bbla = com.sun.star.uno.AnyConverter.isVoid(CurGroupValue);
		    if (com.sun.star.uno.AnyConverter.isBoolean(CurGroupValue))
			dblValue = (double) com.sun.star.uno.AnyConverter.toInt(CurGroupValue);
		    if (com.sun.star.uno.AnyConverter.isByte(CurGroupValue))
			dblValue = (double) com.sun.star.uno.AnyConverter.toByte(CurGroupValue);
		    else if (com.sun.star.uno.AnyConverter.isDouble(CurGroupValue))
			dblValue = com.sun.star.uno.AnyConverter.toDouble(CurGroupValue);
		    else if (com.sun.star.uno.AnyConverter.isFloat(CurGroupValue))
			dblValue = (double) com.sun.star.uno.AnyConverter.toFloat(CurGroupValue);
		    else if (com.sun.star.uno.AnyConverter.isInt(CurGroupValue))
			dblValue = (double) com.sun.star.uno.AnyConverter.toInt(CurGroupValue);
		    else if (com.sun.star.uno.AnyConverter.isLong(CurGroupValue))
			dblValue = (double) com.sun.star.uno.AnyConverter.toLong(CurGroupValue);
		    else if (com.sun.star.uno.AnyConverter.isShort(CurGroupValue))
			dblValue = (double) com.sun.star.uno.AnyConverter.toShort(CurGroupValue);
		    xValCell.setValue(dblValue);
		}
	    }
	}
	catch( com.sun.star.uno.Exception exception ){
	    System.err.println( exception);
	}}

	
	// If the parameter CurGroupValue is null the placeholders are inserted
	public void replaceValueCellofTable(boolean bIsGroupTable){
	try{
	    Object CurGroupValue;
	    if (bIsGroupTable == false && CurDBField.bIsNumberFormat == false)
		CurGroupValue = CurDBMetaData.adjustBlindTextlength(CurDBField, bIsCurLandscape);
	    else
		CurGroupValue = CurDBField.DefaultValue;
	    modifyCellContent(CurGroupValue);
	    xValCellCursor.gotoStart(false);
	    xValCellCursor.gotoEnd(true);
	    
	    if (bAlignLeft)
		Tools.setUNOPropertyValue(xValCellCursor, "ParaAdjust", new Integer(com.sun.star.style.ParagraphAdjust.LEFT_value));

	    if (CurDBField.FieldType == com.sun.star.sdbc.DataType.BIT){
		CharFontName = "StarSymbol";
		Tools.setUNOPropertyValue(xValCellCursor, "CharFontName", CharFontName);
		if (bIsGroupTable == false)
		    Tools.setUNOPropertyValue(xValCellCursor, "ParaAdjust", new Integer(com.sun.star.style.ParagraphAdjust.CENTER_value));
	    }
	    else{
		if (PropertyState == com.sun.star.beans.PropertyState.DEFAULT_VALUE){
		    XPropertyState xPropState = (XPropertyState) UnoRuntime.queryInterface(XPropertyState.class, xValCellCursor);
		    xPropState.setPropertyToDefault("CharFontName");
		}
		else{
		    if (PropertyState == com.sun.star.beans.PropertyState.DIRECT_VALUE)
			Tools.setUNOPropertyValue(xValCellCursor, "CharFontName", CharFontName);
		}
	    }
	}
	catch(com.sun.star.beans.UnknownPropertyException exception){
	    exception.printStackTrace(System.out);
	}}


	public void setCellFont(){
	try{
	    XPropertyState xPropertyState;
    	    int FieldType = CurDBField.FieldType;
	    if (FieldType == com.sun.star.sdbc.DataType.BIT){
		CharFontName = "StarSymbol";
		PropertyState = com.sun.star.beans.PropertyState.DIRECT_VALUE;
	    }
	    else{
		xPropertyState = (XPropertyState) UnoRuntime.queryInterface(XPropertyState.class, xValCellCursor);
		PropertyState = xPropertyState.getPropertyState("CharFontName");
		CharFontName = AnyConverter.toString(Tools.getUNOPropertyValue(xValCellCursor, "CharFontName"));
	    }
	}
	catch(com.sun.star.uno.Exception exception){
	    exception.printStackTrace(System.out);
	}}	
    }}