/**
 * Title:        <p>
 * Description:  <p>
 * Copyright:    Copyright (c) <p>
 * Company:      <p>
 * @author
 * @version 1.0
 */


package com.sun.star.help;

import java.net.*;
import com.sun.star.ucb.*;

public class HelpContentIdentifier implements XContentIdentifier
{
  	private URL m_xURLIdent;
	private HelpURLParameter m_xParameter = null;
	private String _defaultLanguage = null;
	
	
  	public HelpContentIdentifier( String strIdent ) throws IllegalIdentifierException
  	{
    	try
    	{
      		m_xURLIdent = new URL( strIdent );
			m_xParameter = new HelpURLParameter( m_xURLIdent,null );
    	}
    	catch( MalformedURLException e )
    	{
      		throw new IllegalIdentifierException();
    	}
  	}


	// Accepts the external form of an URL;
  	public HelpContentIdentifier( String strIdent,String defaultLanguage ) throws IllegalIdentifierException
  	{
    	try
    	{
      		m_xURLIdent = new URL( strIdent );
			m_xParameter = new HelpURLParameter( m_xURLIdent,defaultLanguage );
    	}
    	catch( MalformedURLException e )
    	{
      		throw new IllegalIdentifierException();
    	}
  	}

	
	public HelpContentIdentifier( URL URLIdent,String defaultLanguage ) throws IllegalIdentifierException
  	{
		m_xURLIdent = URLIdent;
		m_xParameter = new HelpURLParameter( m_xURLIdent,defaultLanguage );
  	}


  	public String getContentIdentifier() throws com.sun.star.uno.RuntimeException
  	{
    	return m_xURLIdent.toExternalForm();
  	}
	
	
  	public String getContentProviderScheme() throws com.sun.star.uno.RuntimeException
  	{
    	return m_xURLIdent.getProtocol();
  	}
	

  	public HelpURLParameter getParameter()
  	{
    	return m_xParameter;
  	}


  	public int isEqualTo( HelpContentIdentifier p0 )
  	{
  		return m_xParameter.isEqualTo( p0.getParameter() );
  	}

}
