/*************************************************************************
 *
 *  $RCSfile: xmlscripte.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dvo $ $Date: 2001/10/19 18:43:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/debug.hxx>
#include <tools/inetdef.hxx>
#include <tools/isolang.hxx>

#include "xmlscripte.hxx"
#include "xmlnmspe.hxx"
#include "xmltoken.hxx"
#include "xmlexp.hxx"
#include "attrlist.hxx"
#include "nmspmap.hxx"

#include <rtl/ustrbuf.hxx>
#include <tools/time.hxx>

#include <com/sun/star/document/XDocumentInfoSupplier.hpp>
#include <com/sun/star/container/XNameContainer.hpp>
#include <com/sun/star/script/XStarBasicAccess.hpp>
#include <com/sun/star/script/XStarBasicModuleInfo.hpp>
#include <com/sun/star/script/XStarBasicDialogInfo.hpp>
#include <com/sun/star/script/XStarBasicLibraryInfo.hpp>


using namespace com::sun::star::xml::sax;
using namespace com::sun::star::lang;
using namespace com::sun::star::uno;
using namespace com::sun::star::frame;
using namespace com::sun::star::script;
using namespace com::sun::star::container;
using namespace rtl;
using namespace ::xmloff::token;

//-------------------------------------------------------------------------

XMLBasicExport::XMLBasicExport( SvXMLExport& rExp )
	: mrExp( rExp )
{
}

XMLBasicExport::~XMLBasicExport()
{
}

void XMLBasicExport::implWriteModules( Reference< XStarBasicLibraryInfo > xLibInfo )
{
	// #85257 Basic libs now are exported outside content.xml
#if 0
    Reference< XNameContainer > xModuleContainer = xLibInfo->getModuleContainer();
    Sequence< OUString > aNames = xModuleContainer->getElementNames();
	const OUString* pNames = aNames.getConstArray();
	sal_Int32 nCount = aNames.getLength();

	OUString sElem, sSubElem, sAttrName, sValue;
	for( sal_Int32 i = 0 ; i < nCount ; i++ )
	{
		Any aElem = xModuleContainer->getByName( pNames[i] );
		Reference< XStarBasicModuleInfo > xModuleInfo;
		aElem >>= xModuleInfo;
		if( xModuleInfo.is() ) 
		{
            // Attributes
            OUString sName = xModuleInfo->getName();
            mrExp.AddAttribute( XML_NAMESPACE_SCRIPT, XML_NAME, sName );

            OUString sLanguage = xModuleInfo->getLanguage();
            if( sLanguage.len() )
            {
                mrExp.AddAttribute( XML_NAMESPACE_SCRIPT, XML_LANGUAGE, 
                                    sLanguage );
            }

            // Library
            SvXMLElementExport aElem( rExp, XML_NAMESPACE_SCRIPT, XML_MODULE, 
                                      sal_True, sal_False );
            rExport.Characters( xModuleInfo->getSource() );
		} // if xModuleInfo.is()
	}
#endif
}


void XMLBasicExport::Export()
{
	// #85257 Basic libs now are exported outside content.xml
#if 0

	// Get Basic data
	const Reference< XModel >& xModel = mrExp.GetModel();
	Reference< XStarBasicAccess > xBasic ( xModel, UNO_QUERY );
	if( !xBasic.is() )
		return;

    Reference< XNameContainer > xLibContainer = xBasic->getLibraryContainer();
    Sequence< OUString > aNames = xLibContainer->getElementNames();
	const OUString* pNames = aNames.getConstArray();
	sal_Int32 nCount = aNames.getLength();

	OUString sElem, sSubElem, sAttrName, sValue;
	for( sal_Int32 i = 0 ; i < nCount ; i++ )
	{
		Any aElem = xLibContainer->getByName( pNames[i] );
		Reference< XStarBasicLibraryInfo > xLibInfo;
		aElem >>= xLibInfo;
		if( xLibInfo.is() )
		{
		OUString LinkTargetURL = xLibInfo->getLinkTargetURL();
		if( LinkTargetURL.len() )
		{
			sElem = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                              GetXMLToken(XML_LIBRARY_LINKED);

			// Attributes
			mrAttrList.Clear();
			OUString sName = xLibInfo->getName();
			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                                      GetXMLToken(XML_NAME) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, sName );

			/* ??? Password for linked Libs? -> Should be in target
			OUString sPassword = xLibInfo->getPassword();
			if( sPassword.len() )
			{
				sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                GetXMLToken(XML_PASSWORD) );
				mrAttrList.AddAttribute( sAttrName, msCDATA, sPassword );
			}
			*/

			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_XLINK, 
                                                      GetXMLToken(XML_HREF) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, LinkTargetURL );

			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_XLINK, 
                                                      GetXMLToken(XML_TYPE) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, GetXMLToken(XML_SIMPLE) );

			// Library
			mxHandler->ignorableWhitespace( msWS );
			mxHandler->startElement( sElem, mxAttrList );
			mxHandler->endElement( sElem );
		}
		else
		{
			sElem = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                           GetXMLToken(XML_LIBRARY_EMBEDDED) );

			// Attributes
			mrAttrList.Clear();
			OUString sName = xLibInfo->getName();
			sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                                      GetXMLToken(XML_NAME) );
			mrAttrList.AddAttribute( sAttrName, msCDATA, sName );

			OUString sPassword = xLibInfo->getPassword();
			if( sPassword.len() )
			{
				sAttrName = mrNamespaceMap.GetQNameByKey( XML_NAMESPACE_SCRIPT, 
                                                   GetXMLToken(XML_PASSWORD) );
				mrAttrList.AddAttribute( sAttrName, msCDATA, sPassword );
			}

			// Library
			mxHandler->ignorableWhitespace( msWS );
			mxHandler->startElement( sElem, mxAttrList );

			// Modules
			implWriteModules( xLibInfo );

			// Dialogs
			//implWriteDialogs( xLibInfo );

			//mxHandler->characters( sValue );
			mxHandler->endElement( sElem );
		}
		} // if xLibInfo.is()
	}
	mrAttrList.Clear();
#endif
}

