/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIEditorShell.idl
 */

#ifndef __gen_nsIEditorShell_h__
#define __gen_nsIEditorShell_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFile; /* forward declaration */

class nsIDocumentStateListener; /* forward declaration */

class nsISelectionController; /* forward declaration */

class nsITransactionManager; /* forward declaration */

class nsIDOMWindowInternal; /* forward declaration */

class nsIDOMDocument; /* forward declaration */

class nsISelection; /* forward declaration */

class nsIDOMElement; /* forward declaration */

class nsIDOMNode; /* forward declaration */

class nsIEditor; /* forward declaration */

class nsISupportsArray; /* forward declaration */


/* starting interface:    nsIEditorShell */
#define NS_IEDITORSHELL_IID_STR "9afff72b-ca9a-11d2-96c9-0060b0fb9956"

#define NS_IEDITORSHELL_IID \
  {0x9afff72b, 0xca9a, 0x11d2, \
    { 0x96, 0xc9, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 }}

/**
 * nsIEditorShell is a DEPRECATED INTERFACE.
 * Please use the editor classes (nsIEditor, nsIHTMLEditor, etc.)
 * directly whenever possible.
 */
class nsIEditorShell : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IEDITORSHELL_IID)

  /* readonly attribute nsIDOMDocument editorDocument; */
  NS_IMETHOD GetEditorDocument(nsIDOMDocument * *aEditorDocument) = 0;

  /* readonly attribute nsISelection editorSelection; */
  NS_IMETHOD GetEditorSelection(nsISelection * *aEditorSelection) = 0;

  /* readonly attribute nsISelectionController selectionController; */
  NS_IMETHOD GetSelectionController(nsISelectionController * *aSelectionController) = 0;

  /* readonly attribute nsITransactionManager transactionManager; */
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager) = 0;

  /* attribute nsIDOMWindowInternal webShellWindow; */
  NS_IMETHOD GetWebShellWindow(nsIDOMWindowInternal * *aWebShellWindow) = 0;
  NS_IMETHOD SetWebShellWindow(nsIDOMWindowInternal * aWebShellWindow) = 0;

  /* attribute nsIDOMWindowInternal contentWindow; */
  NS_IMETHOD GetContentWindow(nsIDOMWindowInternal * *aContentWindow) = 0;
  NS_IMETHOD SetContentWindow(nsIDOMWindowInternal * aContentWindow) = 0;

  /* attribute wstring editorType; */
  NS_IMETHOD GetEditorType(PRUnichar * *aEditorType) = 0;
  NS_IMETHOD SetEditorType(const PRUnichar * aEditorType) = 0;

  /* attribute string contentsMIMEType; */
  NS_IMETHOD GetContentsMIMEType(char * *aContentsMIMEType) = 0;
  NS_IMETHOD SetContentsMIMEType(const char * aContentsMIMEType) = 0;

  /* readonly attribute nsIEditor editor; */
  NS_IMETHOD GetEditor(nsIEditor * *aEditor) = 0;

  enum {
    eDocumentStatusUnmodified,
    eDocumentStatusModified
  };
  enum {
    eDisplayModePreview,
    eDisplayModeNormal,
    eDisplayModeAllTags,
    eDisplayModeSource
  };
  /* readonly attribute boolean documentModified; */
  NS_IMETHOD GetDocumentModified(PRBool *aDocumentModified) = 0;

  /* readonly attribute boolean documentIsEmpty; */
  NS_IMETHOD GetDocumentIsEmpty(PRBool *aDocumentIsEmpty) = 0;

  /* readonly attribute boolean documentEditable; */
  NS_IMETHOD GetDocumentEditable(PRBool *aDocumentEditable) = 0;

  /* readonly attribute long documentLength; */
  NS_IMETHOD GetDocumentLength(PRInt32 *aDocumentLength) = 0;

  /* attribute long wrapColumn; */
  NS_IMETHOD GetWrapColumn(PRInt32 *aWrapColumn) = 0;
  NS_IMETHOD SetWrapColumn(PRInt32 aWrapColumn) = 0;

  /* void LoadUrl (in wstring url); */
  NS_IMETHOD LoadUrl(const PRUnichar *url) = 0;

  /* void SetDocumentTitle (in wstring title); */
  NS_IMETHOD SetDocumentTitle(const PRUnichar *title) = 0;

  /* wstring GetDocumentTitle (); */
  NS_IMETHOD GetDocumentTitle(PRUnichar **_retval) = 0;

  /** 
   * doAfterSave saves the new location on the web shell for subsequent
   *     webshell queries and any other necessary functions that can't be done via JS
   * @param aShouldUpdateURL   whether to update the url on the webshell
   * @param aURL               url string; ignored if aShouldUpdateURL is false
   */
  /* void doAfterSave (in boolean aShouldUpdateURL, in wstring aURL); */
  NS_IMETHOD DoAfterSave(PRBool aShouldUpdateURL, const PRUnichar *aURL) = 0;

  /** 
   * isSupportedTextType determines whether the mime type given is a type the editor
   *      supports (when editing as text)
   * @param aMIMEType    a mimetype string such as "text/plain"
   */
  /* boolean isSupportedTextType (in string aMIMEType); */
  NS_IMETHOD IsSupportedTextType(const char *aMIMEType, PRBool *_retval) = 0;

  /** Register a doc state listener. This gets added to a list of listeners
     which are registered with the editor when that gets instantiated.
     If the LoadUrl fails, this listener will not receive any notifcations.
     If you call this after the editor has been instantiated, it calls through
     to editor::AddDocumentStateListener().
  */
  /* void RegisterDocumentStateListener (in nsIDocumentStateListener docListener); */
  NS_IMETHOD RegisterDocumentStateListener(nsIDocumentStateListener *docListener) = 0;

  /** Unregister a listener.
     If you call this after the editor has been instantiated, it calls through
     to editor::RemoveDocumentStateListener().
  */
  /* void UnregisterDocumentStateListener (in nsIDocumentStateListener docListener); */
  NS_IMETHOD UnregisterDocumentStateListener(nsIDocumentStateListener *docListener) = 0;

  /* void Shutdown (); */
  NS_IMETHOD Shutdown(void) = 0;

  /* void Print (); */
  NS_IMETHOD Print(void) = 0;

  /* void Undo (); */
  NS_IMETHOD Undo(void) = 0;

  /* void Redo (); */
  NS_IMETHOD Redo(void) = 0;

  /* void Cut (); */
  NS_IMETHOD Cut(void) = 0;

  /* void Copy (); */
  NS_IMETHOD Copy(void) = 0;

  /* void Paste (in long selectionType); */
  NS_IMETHOD Paste(PRInt32 selectionType) = 0;

  /* void PasteAsQuotation (in long selectionType); */
  NS_IMETHOD PasteAsQuotation(PRInt32 selectionType) = 0;

  /* void PasteAsCitedQuotation (in wstring cite, in long selectionType); */
  NS_IMETHOD PasteAsCitedQuotation(const PRUnichar *cite, PRInt32 selectionType) = 0;

  /* void InsertAsQuotation (in wstring quotedText, out nsIDOMNode nodeInserted); */
  NS_IMETHOD InsertAsQuotation(const PRUnichar *quotedText, nsIDOMNode **nodeInserted) = 0;

  /* void InsertAsCitedQuotation (in wstring quotedText, in wstring cite, in boolean insertHTML, in wstring charset, out nsIDOMNode nodeInserted); */
  NS_IMETHOD InsertAsCitedQuotation(const PRUnichar *quotedText, const PRUnichar *cite, PRBool insertHTML, const PRUnichar *charset, nsIDOMNode **nodeInserted) = 0;

  /* void Rewrap (in boolean respectNewlines); */
  NS_IMETHOD Rewrap(PRBool respectNewlines) = 0;

  /* void StripCites (); */
  NS_IMETHOD StripCites(void) = 0;

  /* void SelectAll (); */
  NS_IMETHOD SelectAll(void) = 0;

  /* void DeleteSelection (in PRInt32 action); */
  NS_IMETHOD DeleteSelection(PRInt32 action) = 0;

  /* void Find (); */
  NS_IMETHOD Find(void) = 0;

  /* void FindNext (); */
  NS_IMETHOD FindNext(void) = 0;

  /* void Replace (); */
  NS_IMETHOD Replace(void) = 0;

  /* wstring GetString (in wstring name); */
  NS_IMETHOD GetString(const PRUnichar *name, PRUnichar **_retval) = 0;

  /* wstring GetDocumentCharacterSet (); */
  NS_IMETHOD GetDocumentCharacterSet(PRUnichar **_retval) = 0;

  /* void SetDocumentCharacterSet (in wstring characterSet); */
  NS_IMETHOD SetDocumentCharacterSet(const PRUnichar *characterSet) = 0;

  /* void InsertText (in wstring textToInsert); */
  NS_IMETHOD InsertText(const PRUnichar *textToInsert) = 0;

  /* void InsertSource (in wstring textToInsert); */
  NS_IMETHOD InsertSource(const PRUnichar *textToInsert) = 0;

  /* void InsertSourceWithCharset (in wstring textToInsert, in wstring charset); */
  NS_IMETHOD InsertSourceWithCharset(const PRUnichar *textToInsert, const PRUnichar *charset) = 0;

  /** Rebuild the entire document from source HTML
   *  Needed to be able to edit HEAD and other outside-of-BODY content
   *  @param source: HTML source string of the entire new document
   */
  /* void RebuildDocumentFromSource (in wstring source); */
  NS_IMETHOD RebuildDocumentFromSource(const PRUnichar *source) = 0;

  /* void InsertBreak (); */
  NS_IMETHOD InsertBreak(void) = 0;

  /* void MakeOrChangeList (in wstring listType, in PRBool entireList, in wstring bulletType); */
  NS_IMETHOD MakeOrChangeList(const PRUnichar *listType, PRBool entireList, const PRUnichar *bulletType) = 0;

  /* void RemoveList (in wstring listType); */
  NS_IMETHOD RemoveList(const PRUnichar *listType) = 0;

  /* void Indent (in wstring indent); */
  NS_IMETHOD Indent(const PRUnichar *indent) = 0;

  /* void Align (in wstring align); */
  NS_IMETHOD Align(const PRUnichar *align) = 0;

  /** Element insert and property editing */
/** Return an element only if it is the only node selected,
    *    such as an image, horizontal rule, etc.
    * The exception is a link, which is more like a text attribute:
    *    The Anchor tag is returned if the selection is within the textnode(s)
    *    that are children of the "A" node.
    *    This could be a collapsed selection, i.e., a caret within the link text.
    *
    * tagName:  The HTML tagname or and empty string 
    *       to get any element (but only if it is the only element selected)
    *    Special input values for Links and Named anchors:
    *    Use "href" to get a link node
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    */
  /* nsIDOMElement GetSelectedElement (in wstring tagName); */
  NS_IMETHOD GetSelectedElement(const PRUnichar *tagName, nsIDOMElement **_retval) = 0;

  /** Get first selected node from first selection range.
    * Assumes cell-selection model where each cell
    * is in a separate range (selection parent node is table row)
    * Returns null if ranges don't contain cell selections
    */
  /* nsIDOMElement GetFirstSelectedCell (); */
  NS_IMETHOD GetFirstSelectedCell(nsIDOMElement **_retval) = 0;

  /** Get first selected cell in table: the upper-left-most cell
    * Returns null if ranges don't contain cell selections
    * rowIndex and colIndex are those of the cell if found
    */
  /* nsIDOMElement GetFirstSelectedCellInTable (out PRInt32 rowIndex, out PRInt32 colIndex); */
  NS_IMETHOD GetFirstSelectedCellInTable(PRInt32 *rowIndex, PRInt32 *colIndex, nsIDOMElement **_retval) = 0;

  /** Get next selected cell element from first selection range.
    * Assumes cell-selection model where each cell
    * is in a separate range (selection parent node is table row)
    * Always call GetFirstSelectedCell() to initialize stored index of "next" cell
    * Returns null if after last cell or 
    *   ranges don't contain cell selections
    */
  /* nsIDOMElement GetNextSelectedCell (); */
  NS_IMETHOD GetNextSelectedCell(nsIDOMElement **_retval) = 0;

  /** Return the input node or a parent matching the given aTagName,
    *   starting the search at the supplied node.
    * An example of use is for testing if a node is in a table cell
    *   given a selection anchor node.
    *
    * tagName:  The HTML tagname
    *    Special input values:
    *    Use "href" to get a link node 
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    *    Use "list" to get an OL, UL, or DL list node
    *    Use "td" to get either a TD or TH cell node
    *
    * node:    The node in the document to start the search
    *     If it is null, the anchor node of the current selection is used
    */
  /* nsIDOMElement GetElementOrParentByTagName (in wstring tagName, in nsIDOMNode node); */
  NS_IMETHOD GetElementOrParentByTagName(const PRUnichar *tagName, nsIDOMNode *node, nsIDOMElement **_retval) = 0;

  /** Return a new element with default attribute values
    * 
    * This does not rely on the selection, and is not sensitive to context.
    * 
    * Used primarily to supply new element for various insert element dialogs
    *  (Image, Link, NamedAnchor, Table, and HorizontalRule 
    *   are the only returned elements as of 7/25/99)
    *
    * tagName:  The HTML tagname
    *    Special input values for Links and Named anchors:
    *    Use "href" to get a link node
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    */
  /* nsIDOMElement CreateElementWithDefaults (in wstring tagName); */
  NS_IMETHOD CreateElementWithDefaults(const PRUnichar *tagName, nsIDOMElement **_retval) = 0;

  /** Insert an element, which may have child nodes, at the selection
    * Used primarily to insert a new element for various insert element dialogs,
    *   but it enforces the HTML 4.0 DTD "CanContain" rules, so it should
    *   be useful for other elements.
    *
    * element:           The element to insert
    * deleteSelection:   Delete the selection before inserting
    *     If deleteSelection is PR_FALSE, then the element is inserted 
    *     after the end of the selection for all element except
    *     Named Anchors, which insert before the selection
    */
  /* void InsertElementAtSelection (in nsIDOMElement element, in boolean deleteSelection); */
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *element, PRBool deleteSelection) = 0;

  /** Insert an link element as the parent of the current selection
    *
    * element   An "A" element with a non-empty "href" attribute
    */
  /* void InsertLinkAroundSelection (in nsIDOMElement anchorElement); */
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *anchorElement) = 0;

  /** 
   * Insert an element under parent at position.
   * No checking is done to verify the legality of the insertion.
   *  That is the responsibility of the caller.
   * element:             The DOM element to insert.
   * parent:              The element to insert the new object under
   * position:            The place in parent to insert the new element
   *                        0=first child, 1=second child, etc.
   *                        any number > number of current children = last child
   * dontChangeSelection  If false, selection is set to just after new element
   *                      If true, preserve existing selection 
   *                        (use when inserting under <head> element)
   */
  /* void InsertElement (in nsIDOMElement element, in nsIDOMElement parent, in PRInt32 position, in PRBool dontChangeSelection); */
  NS_IMETHOD InsertElement(nsIDOMElement *element, nsIDOMElement *parent, PRInt32 position, PRBool dontChangeSelection) = 0;

  /** 
    * DeleteNode removes element from the document
    */
  /* void DeleteElement (in nsIDOMElement element); */
  NS_IMETHOD DeleteElement(nsIDOMElement *element) = 0;

  /** 
    * Deletion methods which need to be accessible to JS:
    */
  /* void DeleteCharForward (); */
  NS_IMETHOD DeleteCharForward(void) = 0;

  /* void DeleteCharBackward (); */
  NS_IMETHOD DeleteCharBackward(void) = 0;

  /* void DeleteWordForward (); */
  NS_IMETHOD DeleteWordForward(void) = 0;

  /* void DeleteWordBackward (); */
  NS_IMETHOD DeleteWordBackward(void) = 0;

  /* void DeleteToBeginningOfLine (); */
  NS_IMETHOD DeleteToBeginningOfLine(void) = 0;

  /* void DeleteToEndOfLine (); */
  NS_IMETHOD DeleteToEndOfLine(void) = 0;

  /* void SelectElement (in nsIDOMElement element); */
  NS_IMETHOD SelectElement(nsIDOMElement *element) = 0;

  /* void SetSelectionAfterElement (in nsIDOMElement element); */
  NS_IMETHOD SetSelectionAfterElement(nsIDOMElement *element) = 0;

  /** Table insert and delete methods.  Done relative to selected cell or
   * cell containing the selection anchor.
   */
  /* void InsertTableCell (in PRInt32 number, in boolean after); */
  NS_IMETHOD InsertTableCell(PRInt32 number, PRBool after) = 0;

  /* void InsertTableRow (in PRInt32 number, in boolean after); */
  NS_IMETHOD InsertTableRow(PRInt32 number, PRBool after) = 0;

  /* void InsertTableColumn (in PRInt32 number, in boolean after); */
  NS_IMETHOD InsertTableColumn(PRInt32 number, PRBool after) = 0;

  /* void DeleteTable (); */
  NS_IMETHOD DeleteTable(void) = 0;

  /* void DeleteTableCell (in PRInt32 number); */
  NS_IMETHOD DeleteTableCell(PRInt32 number) = 0;

  /* void DeleteTableCellContents (); */
  NS_IMETHOD DeleteTableCellContents(void) = 0;

  /* void DeleteTableRow (in PRInt32 number); */
  NS_IMETHOD DeleteTableRow(PRInt32 number) = 0;

  /* void DeleteTableColumn (in PRInt32 number); */
  NS_IMETHOD DeleteTableColumn(PRInt32 number) = 0;

  /** Create a new TD or TH element, the opposite type of the supplied aSourceCell
    *   1. Copy all attributes from sourceCell to the new cell
    *   2. Move all contents of sourceCell to the new cell
    *   3. Replace sourceCell in the table with the new cell
    *
    *  sourceCell   The cell to be replaced
    *  returns      The new cell that replaces sourceCell
    */
  /* nsIDOMElement SwitchTableCellHeaderType (in nsIDOMElement sourceCell); */
  NS_IMETHOD SwitchTableCellHeaderType(nsIDOMElement *sourceCell, nsIDOMElement **_retval) = 0;

  /** Merges contents of all selected cells
    * for selected cells that are adjacent,
    * this will result in a larger cell with appropriate 
    * rowspan and colspan, and original cells are deleted
    * The resulting cell is in the location of the 
    *   cell at the upper-left corner of the adjacent
    *   block of selected cells
    *
    * mergeNonContiguousContents:  
    *       If true: 
    *         Non-contiguous cells are not deleted,
    *         but their contents are still moved 
    *         to the upper-left cell
    *       If false: contiguous cells are ignored
    *
    * If there are no selected cells,
    *   and selection or caret is in a cell,
    *   that cell and the one to the right 
    *   are merged
    */
  /* void JoinTableCells (in boolean mergeNonContiguousContents); */
  NS_IMETHOD JoinTableCells(PRBool mergeNonContiguousContents) = 0;

  /** Split a cell that has rowspan and/or colspan > 0
    *   into cells such that all new cells have 
    *   rowspan = 1 and colspan = 1
    *  All of the contents are not touched --
    *   they will appear to be in the upper-left cell 
    */
  /* void SplitTableCell (); */
  NS_IMETHOD SplitTableCell(void) = 0;

  /** Table selection methods
    * Selecting a row or column actually
    * selects all cells (not TR in the case of rows)
    */
  /* void SelectTableCell (); */
  NS_IMETHOD SelectTableCell(void) = 0;

  /** Select a rectangular block of cells:
    *  all cells falling within the row/column index of startCell
    *  to through the row/column index of the endCell
    */
  /* void SelectBlockOfCells (in nsIDOMElement startCell, in nsIDOMElement endCell); */
  NS_IMETHOD SelectBlockOfCells(nsIDOMElement *startCell, nsIDOMElement *endCell) = 0;

  /* void SelectTableRow (); */
  NS_IMETHOD SelectTableRow(void) = 0;

  /* void SelectTableColumn (); */
  NS_IMETHOD SelectTableColumn(void) = 0;

  /* void SelectTable (); */
  NS_IMETHOD SelectTable(void) = 0;

  /* void SelectAllTableCells (); */
  NS_IMETHOD SelectAllTableCells(void) = 0;

  /** Scan through all rows and add cells as needed so 
    *   all locations in the cellmap are occupied.
    *   Used after inserting single cells or pasting
    *   a collection of cells that extend past the
    *   previous size of the table
    * If aTable is null, it uses table enclosing the selection anchor
    */
  /* void NormalizeTable (in nsIDOMElement tableElement); */
  NS_IMETHOD NormalizeTable(nsIDOMElement *tableElement) = 0;

  /** Get the indexes from layout's cellmap */
  /* PRInt32 GetRowIndex (in nsIDOMElement cellElement); */
  NS_IMETHOD GetRowIndex(nsIDOMElement *cellElement, PRInt32 *_retval) = 0;

  /* PRInt32 GetColumnIndex (in nsIDOMElement cellElement); */
  NS_IMETHOD GetColumnIndex(nsIDOMElement *cellElement, PRInt32 *_retval) = 0;

  /** Get the number of rows in a table from the layout's cellmap 
    * If tableElement is null, it will try to find enclosing table of selection anchor
    */
  /* PRInt32 GetTableRowCount (in nsIDOMElement tableElement); */
  NS_IMETHOD GetTableRowCount(nsIDOMElement *tableElement, PRInt32 *_retval) = 0;

  /** Get the number of columns in a table from the layout's cellmap
    * If tableElement is null, it will try to find enclosing table of selection anchor
    */
  /* PRInt32 GetTableColumnCount (in nsIDOMElement tableElement); */
  NS_IMETHOD GetTableColumnCount(nsIDOMElement *tableElement, PRInt32 *_retval) = 0;

  /** Get cell at a location in the layout's cellmap
    * returns null when past last cell in a row or column
    * If tableElement is null, it will try to find enclosing table of selection anchor
    */
  /* nsIDOMElement GetCellAt (in nsIDOMElement tableElement, in PRInt32 rowIndex, in PRInt32 colIndex); */
  NS_IMETHOD GetCellAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, nsIDOMElement **_retval) = 0;

  /** Get cell at a location in the layout's cellmap with associated data 
    * returns null when past last cell in a row or column 
    * Note that rowSpan and/or colSpan may be 0 (for extending across entire table),
    * so actualRowSpan and actualColSpan are the real number of cells spanned
    * If tableElement is null, it will try to find enclosing table of selection anchor
    */
  /* nsIDOMElement GetCellDataAt (in nsIDOMElement tableElement, in PRInt32 rowIndex, in PRInt32 colIndex, out PRInt32 startRowIndex, out PRInt32 startColIndex, out PRInt32 rowSpan, out PRInt32 colSpan, out PRInt32 actualRowSpan, out PRInt32 actualColSpan, out boolean isSelected); */
  NS_IMETHOD GetCellDataAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, PRInt32 *startRowIndex, PRInt32 *startColIndex, PRInt32 *rowSpan, PRInt32 *colSpan, PRInt32 *actualRowSpan, PRInt32 *actualColSpan, PRBool *isSelected, nsIDOMElement **_retval) = 0;

  /** Get the first row in a table 
    * tableElement may be a table or any child element a table
    */
  /* nsIDOMNode GetFirstRow (in nsIDOMElement tableElement); */
  NS_IMETHOD GetFirstRow(nsIDOMElement *tableElement, nsIDOMNode **_retval) = 0;

  /** Get the next row in a table after currentRow 
    */
  /* nsIDOMNode GetNextRow (in nsIDOMNode currentRow); */
  NS_IMETHOD GetNextRow(nsIDOMNode *currentRow, nsIDOMNode **_retval) = 0;

  /** Examine the current selection and find
    *   a selected TABLE, TD or TH, or TR element.
    *   or return the parent TD or TH if selection anchor is inside a table cell
    *   Returns null if no table element is found.
    *
    * Returns:
    *   The table element (table, row, or cell) found
    *     If multiple table cells are selected, this is the "focus" cell (last cell selected)
    *
    *   tagName           The tagname of returned element
    *                       Note that "td" will be returned if name is actually "th"
    *   selectedCount     How many table elements were selected
    *                       This tells us if we have multiple cells selected
    *                       (0 if element is a parent cell of selection)
    */
  /* nsIDOMElement GetSelectedOrParentTableElement (out wstring tagName, out PRInt32 selectedCount); */
  NS_IMETHOD GetSelectedOrParentTableElement(PRUnichar **tagName, PRInt32 *selectedCount, nsIDOMElement **_retval) = 0;

  /** Generally used after GetSelectedOrParentTableElement
    *   to test if selected cells are complete rows or columns
    * 
    * cellElement               Any table, cell, or element inside a table
    *                           Used to get enclosing table. 
    *                           If null, selection's focusNode is used
    * 
    * Returns: (defines are from nsIFrameSelection.h)
    *  0                         cellElement was not a cell
    *  1 (TABLESELECTION_CELL)   There are 1 or more cells selected
    *                              but complete rows or columns are not selected
    *  2 (TABLESELECTION_ROW)    All cells are in 1 or more rows
    *                              and in each row, all cells selected
    *                              Note: This is the value if all rows (thus all cells) are selected
    *  3 (TABLESELECTION_COLUMN) All cells are in 1 or more columns
    *                              and in each column, all cells are selected
    */
  /* PRUint32 GetSelectedCellsType (in nsIDOMElement element); */
  NS_IMETHOD GetSelectedCellsType(nsIDOMElement *element, PRUint32 *_retval) = 0;

  /**** end of table editing *****/
  /* nsISupportsArray GetEmbeddedObjects (); */
  NS_IMETHOD GetEmbeddedObjects(nsISupportsArray **_retval) = 0;

  /* nsISupportsArray GetLinkedObjects (); */
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval) = 0;

  /* void SetAttribute (in nsIDOMElement element, in wstring attr, in wstring value); */
  NS_IMETHOD SetAttribute(nsIDOMElement *element, const PRUnichar *attr, const PRUnichar *value) = 0;

  /* void RemoveAttribute (in nsIDOMElement element, in wstring attr); */
  NS_IMETHOD RemoveAttribute(nsIDOMElement *element, const PRUnichar *attr) = 0;

  /* void SetTextProperty (in wstring prop, in wstring attr, in wstring value); */
  NS_IMETHOD SetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value) = 0;

  /* void RemoveTextProperty (in wstring prop, in wstring attr); */
  NS_IMETHOD RemoveTextProperty(const PRUnichar *prop, const PRUnichar *attr) = 0;

  /* void GetTextProperty (in wstring prop, in wstring attr, in wstring value, out boolean firstHas, out boolean anyHas, out boolean allHas); */
  NS_IMETHOD GetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value, PRBool *firstHas, PRBool *anyHas, PRBool *allHas) = 0;

  /* void IncreaseFontSize (); */
  NS_IMETHOD IncreaseFontSize(void) = 0;

  /* void DecreaseFontSize (); */
  NS_IMETHOD DecreaseFontSize(void) = 0;

  /* void SetParagraphFormat (in wstring paragraphFormat); */
  NS_IMETHOD SetParagraphFormat(const PRUnichar *paragraphFormat) = 0;

  /* void SetBodyAttribute (in wstring attr, in wstring value); */
  NS_IMETHOD SetBodyAttribute(const PRUnichar *attr, const PRUnichar *value) = 0;

  /* void SetBackgroundColor (in wstring color); */
  NS_IMETHOD SetBackgroundColor(const PRUnichar *color) = 0;

  /** Get block state information:
    * Returns the tagname if part selection is within a 
    *   paragraph or list block tag,
    *   or empty string if none of selection isn't within the block
    *
    *   mixed    true if only part of selection has the state
    */
  /* wstring GetParagraphState (out boolean mixed); */
  NS_IMETHOD GetParagraphState(PRBool *mixed, PRUnichar **_retval) = 0;

  /* wstring GetListState (out boolean mixed); */
  NS_IMETHOD GetListState(PRBool *mixed, PRUnichar **_retval) = 0;

  /* wstring GetListItemState (out boolean mixed); */
  NS_IMETHOD GetListItemState(PRBool *mixed, PRUnichar **_retval) = 0;

  /* wstring GetAlignment (out boolean mixed); */
  NS_IMETHOD GetAlignment(PRBool *mixed, PRUnichar **_retval) = 0;

  /* void ApplyStyleSheet (in wstring url); */
  NS_IMETHOD ApplyStyleSheet(const PRUnichar *url) = 0;

  /** Set the display mode for editing
    * displayMode
    *       0 (eDisplayModeWYSIWIG) Preview mode
    *           that looks exactly like the browser display except
    *           for certain behaviors like cursor style over links, etc.
    *       1 (eDisplayModeNormal) Use minimal extra CSS style 
    *           (from override styles in EditorContent.css) 
    *           to show named anchors, table borders, etc for editing
    *       2 (eDisplayModeAllTags) Use maximum extra CSS style 
    *           (from override styles in EditorAllTags.css) 
    *           to show icon for every HTML tag
    */
  /* void SetDisplayMode (in PRInt32 displayMode); */
  NS_IMETHOD SetDisplayMode(PRInt32 displayMode) = 0;

  /** Get current mode for editing
    *  Returns:
    *  0 (eDisplayModePreview,)
    *  1 (eDisplayModeNormal)
    *  2 (eDisplayModeAllTags)
    *  3 (eDisplayModeSource)
    */
  /* PRInt32 GetEditMode (); */
  NS_IMETHOD GetEditMode(PRInt32 *_retval) = 0;

  /** For quicker test if we are in HTML Source mode
    */
  /* boolean IsHTMLSourceMode (); */
  NS_IMETHOD IsHTMLSourceMode(PRBool *_retval) = 0;

  /** Save the current HTML source edit session
    *  by inserting it into the document,
    *  replacing existing DOM
    */
  /* void FinishHTMLSource (); */
  NS_IMETHOD FinishHTMLSource(void) = 0;

  /** Add/remove an overridestyle sheet to show paragraph marks
    *
    */
  /* void DisplayParagraphMarks (in PRBool showMarks); */
  NS_IMETHOD DisplayParagraphMarks(PRBool showMarks) = 0;

  /* wstring GetContentsAs (in wstring format, in PRUint32 flags); */
  NS_IMETHOD GetContentsAs(const PRUnichar *format, PRUint32 flags, PRUnichar **_retval) = 0;

  /* wstring GetHeadContentsAsHTML (); */
  NS_IMETHOD GetHeadContentsAsHTML(PRUnichar **_retval) = 0;

  /* void ReplaceHeadContentsWithHTML (in wstring textToInsert); */
  NS_IMETHOD ReplaceHeadContentsWithHTML(const PRUnichar *textToInsert) = 0;

  /* void DumpContentTree (); */
  NS_IMETHOD DumpContentTree(void) = 0;

  /**
   * Tests if a node is a BLOCK element according the the HTML 4.0 DTD
   *   This does NOT consider CSS effect on display type
   */
  /* boolean NodeIsBlock (in nsIDOMNode node); */
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval) = 0;

  /**
   * This is similar to nsIDOMNode::cloneNode(),
   *   it assures the attribute nodes of the destination are identical with the source node
   *   by copying all existing attributes from the source and deleting those not in the source.
   *   This is used when the destination node (element) already exists
   *
   * The supplied nodes MUST BE ELEMENTS (most callers are working with nodes)
   * destNode     the destination element to operate on
   * sourceNode   the source element to copy attributes from
   */
  /* void CloneAttributes (in nsIDOMNode destNode, in nsIDOMNode sourceNode); */
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode) = 0;

  /* void BeginBatchChanges (); */
  NS_IMETHOD BeginBatchChanges(void) = 0;

  /* void EndBatchChanges (); */
  NS_IMETHOD EndBatchChanges(void) = 0;

  /* void RunUnitTests (); */
  NS_IMETHOD RunUnitTests(void) = 0;

  /* void StartLogging (in nsIFile logFile); */
  NS_IMETHOD StartLogging(nsIFile *logFile) = 0;

  /* void StopLogging (); */
  NS_IMETHOD StopLogging(void) = 0;

  /* void CloseWindowWithoutSaving (); */
  NS_IMETHOD CloseWindowWithoutSaving(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIEDITORSHELL \
  NS_IMETHOD GetEditorDocument(nsIDOMDocument * *aEditorDocument); \
  NS_IMETHOD GetEditorSelection(nsISelection * *aEditorSelection); \
  NS_IMETHOD GetSelectionController(nsISelectionController * *aSelectionController); \
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager); \
  NS_IMETHOD GetWebShellWindow(nsIDOMWindowInternal * *aWebShellWindow); \
  NS_IMETHOD SetWebShellWindow(nsIDOMWindowInternal * aWebShellWindow); \
  NS_IMETHOD GetContentWindow(nsIDOMWindowInternal * *aContentWindow); \
  NS_IMETHOD SetContentWindow(nsIDOMWindowInternal * aContentWindow); \
  NS_IMETHOD GetEditorType(PRUnichar * *aEditorType); \
  NS_IMETHOD SetEditorType(const PRUnichar * aEditorType); \
  NS_IMETHOD GetContentsMIMEType(char * *aContentsMIMEType); \
  NS_IMETHOD SetContentsMIMEType(const char * aContentsMIMEType); \
  NS_IMETHOD GetEditor(nsIEditor * *aEditor); \
  NS_IMETHOD GetDocumentModified(PRBool *aDocumentModified); \
  NS_IMETHOD GetDocumentIsEmpty(PRBool *aDocumentIsEmpty); \
  NS_IMETHOD GetDocumentEditable(PRBool *aDocumentEditable); \
  NS_IMETHOD GetDocumentLength(PRInt32 *aDocumentLength); \
  NS_IMETHOD GetWrapColumn(PRInt32 *aWrapColumn); \
  NS_IMETHOD SetWrapColumn(PRInt32 aWrapColumn); \
  NS_IMETHOD LoadUrl(const PRUnichar *url); \
  NS_IMETHOD SetDocumentTitle(const PRUnichar *title); \
  NS_IMETHOD GetDocumentTitle(PRUnichar **_retval); \
  NS_IMETHOD DoAfterSave(PRBool aShouldUpdateURL, const PRUnichar *aURL); \
  NS_IMETHOD IsSupportedTextType(const char *aMIMEType, PRBool *_retval); \
  NS_IMETHOD RegisterDocumentStateListener(nsIDocumentStateListener *docListener); \
  NS_IMETHOD UnregisterDocumentStateListener(nsIDocumentStateListener *docListener); \
  NS_IMETHOD Shutdown(void); \
  NS_IMETHOD Print(void); \
  NS_IMETHOD Undo(void); \
  NS_IMETHOD Redo(void); \
  NS_IMETHOD Cut(void); \
  NS_IMETHOD Copy(void); \
  NS_IMETHOD Paste(PRInt32 selectionType); \
  NS_IMETHOD PasteAsQuotation(PRInt32 selectionType); \
  NS_IMETHOD PasteAsCitedQuotation(const PRUnichar *cite, PRInt32 selectionType); \
  NS_IMETHOD InsertAsQuotation(const PRUnichar *quotedText, nsIDOMNode **nodeInserted); \
  NS_IMETHOD InsertAsCitedQuotation(const PRUnichar *quotedText, const PRUnichar *cite, PRBool insertHTML, const PRUnichar *charset, nsIDOMNode **nodeInserted); \
  NS_IMETHOD Rewrap(PRBool respectNewlines); \
  NS_IMETHOD StripCites(void); \
  NS_IMETHOD SelectAll(void); \
  NS_IMETHOD DeleteSelection(PRInt32 action); \
  NS_IMETHOD Find(void); \
  NS_IMETHOD FindNext(void); \
  NS_IMETHOD Replace(void); \
  NS_IMETHOD GetString(const PRUnichar *name, PRUnichar **_retval); \
  NS_IMETHOD GetDocumentCharacterSet(PRUnichar **_retval); \
  NS_IMETHOD SetDocumentCharacterSet(const PRUnichar *characterSet); \
  NS_IMETHOD InsertText(const PRUnichar *textToInsert); \
  NS_IMETHOD InsertSource(const PRUnichar *textToInsert); \
  NS_IMETHOD InsertSourceWithCharset(const PRUnichar *textToInsert, const PRUnichar *charset); \
  NS_IMETHOD RebuildDocumentFromSource(const PRUnichar *source); \
  NS_IMETHOD InsertBreak(void); \
  NS_IMETHOD MakeOrChangeList(const PRUnichar *listType, PRBool entireList, const PRUnichar *bulletType); \
  NS_IMETHOD RemoveList(const PRUnichar *listType); \
  NS_IMETHOD Indent(const PRUnichar *indent); \
  NS_IMETHOD Align(const PRUnichar *align); \
  NS_IMETHOD GetSelectedElement(const PRUnichar *tagName, nsIDOMElement **_retval); \
  NS_IMETHOD GetFirstSelectedCell(nsIDOMElement **_retval); \
  NS_IMETHOD GetFirstSelectedCellInTable(PRInt32 *rowIndex, PRInt32 *colIndex, nsIDOMElement **_retval); \
  NS_IMETHOD GetNextSelectedCell(nsIDOMElement **_retval); \
  NS_IMETHOD GetElementOrParentByTagName(const PRUnichar *tagName, nsIDOMNode *node, nsIDOMElement **_retval); \
  NS_IMETHOD CreateElementWithDefaults(const PRUnichar *tagName, nsIDOMElement **_retval); \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *element, PRBool deleteSelection); \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *anchorElement); \
  NS_IMETHOD InsertElement(nsIDOMElement *element, nsIDOMElement *parent, PRInt32 position, PRBool dontChangeSelection); \
  NS_IMETHOD DeleteElement(nsIDOMElement *element); \
  NS_IMETHOD DeleteCharForward(void); \
  NS_IMETHOD DeleteCharBackward(void); \
  NS_IMETHOD DeleteWordForward(void); \
  NS_IMETHOD DeleteWordBackward(void); \
  NS_IMETHOD DeleteToBeginningOfLine(void); \
  NS_IMETHOD DeleteToEndOfLine(void); \
  NS_IMETHOD SelectElement(nsIDOMElement *element); \
  NS_IMETHOD SetSelectionAfterElement(nsIDOMElement *element); \
  NS_IMETHOD InsertTableCell(PRInt32 number, PRBool after); \
  NS_IMETHOD InsertTableRow(PRInt32 number, PRBool after); \
  NS_IMETHOD InsertTableColumn(PRInt32 number, PRBool after); \
  NS_IMETHOD DeleteTable(void); \
  NS_IMETHOD DeleteTableCell(PRInt32 number); \
  NS_IMETHOD DeleteTableCellContents(void); \
  NS_IMETHOD DeleteTableRow(PRInt32 number); \
  NS_IMETHOD DeleteTableColumn(PRInt32 number); \
  NS_IMETHOD SwitchTableCellHeaderType(nsIDOMElement *sourceCell, nsIDOMElement **_retval); \
  NS_IMETHOD JoinTableCells(PRBool mergeNonContiguousContents); \
  NS_IMETHOD SplitTableCell(void); \
  NS_IMETHOD SelectTableCell(void); \
  NS_IMETHOD SelectBlockOfCells(nsIDOMElement *startCell, nsIDOMElement *endCell); \
  NS_IMETHOD SelectTableRow(void); \
  NS_IMETHOD SelectTableColumn(void); \
  NS_IMETHOD SelectTable(void); \
  NS_IMETHOD SelectAllTableCells(void); \
  NS_IMETHOD NormalizeTable(nsIDOMElement *tableElement); \
  NS_IMETHOD GetRowIndex(nsIDOMElement *cellElement, PRInt32 *_retval); \
  NS_IMETHOD GetColumnIndex(nsIDOMElement *cellElement, PRInt32 *_retval); \
  NS_IMETHOD GetTableRowCount(nsIDOMElement *tableElement, PRInt32 *_retval); \
  NS_IMETHOD GetTableColumnCount(nsIDOMElement *tableElement, PRInt32 *_retval); \
  NS_IMETHOD GetCellAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, nsIDOMElement **_retval); \
  NS_IMETHOD GetCellDataAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, PRInt32 *startRowIndex, PRInt32 *startColIndex, PRInt32 *rowSpan, PRInt32 *colSpan, PRInt32 *actualRowSpan, PRInt32 *actualColSpan, PRBool *isSelected, nsIDOMElement **_retval); \
  NS_IMETHOD GetFirstRow(nsIDOMElement *tableElement, nsIDOMNode **_retval); \
  NS_IMETHOD GetNextRow(nsIDOMNode *currentRow, nsIDOMNode **_retval); \
  NS_IMETHOD GetSelectedOrParentTableElement(PRUnichar **tagName, PRInt32 *selectedCount, nsIDOMElement **_retval); \
  NS_IMETHOD GetSelectedCellsType(nsIDOMElement *element, PRUint32 *_retval); \
  NS_IMETHOD GetEmbeddedObjects(nsISupportsArray **_retval); \
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval); \
  NS_IMETHOD SetAttribute(nsIDOMElement *element, const PRUnichar *attr, const PRUnichar *value); \
  NS_IMETHOD RemoveAttribute(nsIDOMElement *element, const PRUnichar *attr); \
  NS_IMETHOD SetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value); \
  NS_IMETHOD RemoveTextProperty(const PRUnichar *prop, const PRUnichar *attr); \
  NS_IMETHOD GetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value, PRBool *firstHas, PRBool *anyHas, PRBool *allHas); \
  NS_IMETHOD IncreaseFontSize(void); \
  NS_IMETHOD DecreaseFontSize(void); \
  NS_IMETHOD SetParagraphFormat(const PRUnichar *paragraphFormat); \
  NS_IMETHOD SetBodyAttribute(const PRUnichar *attr, const PRUnichar *value); \
  NS_IMETHOD SetBackgroundColor(const PRUnichar *color); \
  NS_IMETHOD GetParagraphState(PRBool *mixed, PRUnichar **_retval); \
  NS_IMETHOD GetListState(PRBool *mixed, PRUnichar **_retval); \
  NS_IMETHOD GetListItemState(PRBool *mixed, PRUnichar **_retval); \
  NS_IMETHOD GetAlignment(PRBool *mixed, PRUnichar **_retval); \
  NS_IMETHOD ApplyStyleSheet(const PRUnichar *url); \
  NS_IMETHOD SetDisplayMode(PRInt32 displayMode); \
  NS_IMETHOD GetEditMode(PRInt32 *_retval); \
  NS_IMETHOD IsHTMLSourceMode(PRBool *_retval); \
  NS_IMETHOD FinishHTMLSource(void); \
  NS_IMETHOD DisplayParagraphMarks(PRBool showMarks); \
  NS_IMETHOD GetContentsAs(const PRUnichar *format, PRUint32 flags, PRUnichar **_retval); \
  NS_IMETHOD GetHeadContentsAsHTML(PRUnichar **_retval); \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const PRUnichar *textToInsert); \
  NS_IMETHOD DumpContentTree(void); \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval); \
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode); \
  NS_IMETHOD BeginBatchChanges(void); \
  NS_IMETHOD EndBatchChanges(void); \
  NS_IMETHOD RunUnitTests(void); \
  NS_IMETHOD StartLogging(nsIFile *logFile); \
  NS_IMETHOD StopLogging(void); \
  NS_IMETHOD CloseWindowWithoutSaving(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIEDITORSHELL(_to) \
  NS_IMETHOD GetEditorDocument(nsIDOMDocument * *aEditorDocument) { return _to GetEditorDocument(aEditorDocument); } \
  NS_IMETHOD GetEditorSelection(nsISelection * *aEditorSelection) { return _to GetEditorSelection(aEditorSelection); } \
  NS_IMETHOD GetSelectionController(nsISelectionController * *aSelectionController) { return _to GetSelectionController(aSelectionController); } \
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager) { return _to GetTransactionManager(aTransactionManager); } \
  NS_IMETHOD GetWebShellWindow(nsIDOMWindowInternal * *aWebShellWindow) { return _to GetWebShellWindow(aWebShellWindow); } \
  NS_IMETHOD SetWebShellWindow(nsIDOMWindowInternal * aWebShellWindow) { return _to SetWebShellWindow(aWebShellWindow); } \
  NS_IMETHOD GetContentWindow(nsIDOMWindowInternal * *aContentWindow) { return _to GetContentWindow(aContentWindow); } \
  NS_IMETHOD SetContentWindow(nsIDOMWindowInternal * aContentWindow) { return _to SetContentWindow(aContentWindow); } \
  NS_IMETHOD GetEditorType(PRUnichar * *aEditorType) { return _to GetEditorType(aEditorType); } \
  NS_IMETHOD SetEditorType(const PRUnichar * aEditorType) { return _to SetEditorType(aEditorType); } \
  NS_IMETHOD GetContentsMIMEType(char * *aContentsMIMEType) { return _to GetContentsMIMEType(aContentsMIMEType); } \
  NS_IMETHOD SetContentsMIMEType(const char * aContentsMIMEType) { return _to SetContentsMIMEType(aContentsMIMEType); } \
  NS_IMETHOD GetEditor(nsIEditor * *aEditor) { return _to GetEditor(aEditor); } \
  NS_IMETHOD GetDocumentModified(PRBool *aDocumentModified) { return _to GetDocumentModified(aDocumentModified); } \
  NS_IMETHOD GetDocumentIsEmpty(PRBool *aDocumentIsEmpty) { return _to GetDocumentIsEmpty(aDocumentIsEmpty); } \
  NS_IMETHOD GetDocumentEditable(PRBool *aDocumentEditable) { return _to GetDocumentEditable(aDocumentEditable); } \
  NS_IMETHOD GetDocumentLength(PRInt32 *aDocumentLength) { return _to GetDocumentLength(aDocumentLength); } \
  NS_IMETHOD GetWrapColumn(PRInt32 *aWrapColumn) { return _to GetWrapColumn(aWrapColumn); } \
  NS_IMETHOD SetWrapColumn(PRInt32 aWrapColumn) { return _to SetWrapColumn(aWrapColumn); } \
  NS_IMETHOD LoadUrl(const PRUnichar *url) { return _to LoadUrl(url); } \
  NS_IMETHOD SetDocumentTitle(const PRUnichar *title) { return _to SetDocumentTitle(title); } \
  NS_IMETHOD GetDocumentTitle(PRUnichar **_retval) { return _to GetDocumentTitle(_retval); } \
  NS_IMETHOD DoAfterSave(PRBool aShouldUpdateURL, const PRUnichar *aURL) { return _to DoAfterSave(aShouldUpdateURL, aURL); } \
  NS_IMETHOD IsSupportedTextType(const char *aMIMEType, PRBool *_retval) { return _to IsSupportedTextType(aMIMEType, _retval); } \
  NS_IMETHOD RegisterDocumentStateListener(nsIDocumentStateListener *docListener) { return _to RegisterDocumentStateListener(docListener); } \
  NS_IMETHOD UnregisterDocumentStateListener(nsIDocumentStateListener *docListener) { return _to UnregisterDocumentStateListener(docListener); } \
  NS_IMETHOD Shutdown(void) { return _to Shutdown(); } \
  NS_IMETHOD Print(void) { return _to Print(); } \
  NS_IMETHOD Undo(void) { return _to Undo(); } \
  NS_IMETHOD Redo(void) { return _to Redo(); } \
  NS_IMETHOD Cut(void) { return _to Cut(); } \
  NS_IMETHOD Copy(void) { return _to Copy(); } \
  NS_IMETHOD Paste(PRInt32 selectionType) { return _to Paste(selectionType); } \
  NS_IMETHOD PasteAsQuotation(PRInt32 selectionType) { return _to PasteAsQuotation(selectionType); } \
  NS_IMETHOD PasteAsCitedQuotation(const PRUnichar *cite, PRInt32 selectionType) { return _to PasteAsCitedQuotation(cite, selectionType); } \
  NS_IMETHOD InsertAsQuotation(const PRUnichar *quotedText, nsIDOMNode **nodeInserted) { return _to InsertAsQuotation(quotedText, nodeInserted); } \
  NS_IMETHOD InsertAsCitedQuotation(const PRUnichar *quotedText, const PRUnichar *cite, PRBool insertHTML, const PRUnichar *charset, nsIDOMNode **nodeInserted) { return _to InsertAsCitedQuotation(quotedText, cite, insertHTML, charset, nodeInserted); } \
  NS_IMETHOD Rewrap(PRBool respectNewlines) { return _to Rewrap(respectNewlines); } \
  NS_IMETHOD StripCites(void) { return _to StripCites(); } \
  NS_IMETHOD SelectAll(void) { return _to SelectAll(); } \
  NS_IMETHOD DeleteSelection(PRInt32 action) { return _to DeleteSelection(action); } \
  NS_IMETHOD Find(void) { return _to Find(); } \
  NS_IMETHOD FindNext(void) { return _to FindNext(); } \
  NS_IMETHOD Replace(void) { return _to Replace(); } \
  NS_IMETHOD GetString(const PRUnichar *name, PRUnichar **_retval) { return _to GetString(name, _retval); } \
  NS_IMETHOD GetDocumentCharacterSet(PRUnichar **_retval) { return _to GetDocumentCharacterSet(_retval); } \
  NS_IMETHOD SetDocumentCharacterSet(const PRUnichar *characterSet) { return _to SetDocumentCharacterSet(characterSet); } \
  NS_IMETHOD InsertText(const PRUnichar *textToInsert) { return _to InsertText(textToInsert); } \
  NS_IMETHOD InsertSource(const PRUnichar *textToInsert) { return _to InsertSource(textToInsert); } \
  NS_IMETHOD InsertSourceWithCharset(const PRUnichar *textToInsert, const PRUnichar *charset) { return _to InsertSourceWithCharset(textToInsert, charset); } \
  NS_IMETHOD RebuildDocumentFromSource(const PRUnichar *source) { return _to RebuildDocumentFromSource(source); } \
  NS_IMETHOD InsertBreak(void) { return _to InsertBreak(); } \
  NS_IMETHOD MakeOrChangeList(const PRUnichar *listType, PRBool entireList, const PRUnichar *bulletType) { return _to MakeOrChangeList(listType, entireList, bulletType); } \
  NS_IMETHOD RemoveList(const PRUnichar *listType) { return _to RemoveList(listType); } \
  NS_IMETHOD Indent(const PRUnichar *indent) { return _to Indent(indent); } \
  NS_IMETHOD Align(const PRUnichar *align) { return _to Align(align); } \
  NS_IMETHOD GetSelectedElement(const PRUnichar *tagName, nsIDOMElement **_retval) { return _to GetSelectedElement(tagName, _retval); } \
  NS_IMETHOD GetFirstSelectedCell(nsIDOMElement **_retval) { return _to GetFirstSelectedCell(_retval); } \
  NS_IMETHOD GetFirstSelectedCellInTable(PRInt32 *rowIndex, PRInt32 *colIndex, nsIDOMElement **_retval) { return _to GetFirstSelectedCellInTable(rowIndex, colIndex, _retval); } \
  NS_IMETHOD GetNextSelectedCell(nsIDOMElement **_retval) { return _to GetNextSelectedCell(_retval); } \
  NS_IMETHOD GetElementOrParentByTagName(const PRUnichar *tagName, nsIDOMNode *node, nsIDOMElement **_retval) { return _to GetElementOrParentByTagName(tagName, node, _retval); } \
  NS_IMETHOD CreateElementWithDefaults(const PRUnichar *tagName, nsIDOMElement **_retval) { return _to CreateElementWithDefaults(tagName, _retval); } \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *element, PRBool deleteSelection) { return _to InsertElementAtSelection(element, deleteSelection); } \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *anchorElement) { return _to InsertLinkAroundSelection(anchorElement); } \
  NS_IMETHOD InsertElement(nsIDOMElement *element, nsIDOMElement *parent, PRInt32 position, PRBool dontChangeSelection) { return _to InsertElement(element, parent, position, dontChangeSelection); } \
  NS_IMETHOD DeleteElement(nsIDOMElement *element) { return _to DeleteElement(element); } \
  NS_IMETHOD DeleteCharForward(void) { return _to DeleteCharForward(); } \
  NS_IMETHOD DeleteCharBackward(void) { return _to DeleteCharBackward(); } \
  NS_IMETHOD DeleteWordForward(void) { return _to DeleteWordForward(); } \
  NS_IMETHOD DeleteWordBackward(void) { return _to DeleteWordBackward(); } \
  NS_IMETHOD DeleteToBeginningOfLine(void) { return _to DeleteToBeginningOfLine(); } \
  NS_IMETHOD DeleteToEndOfLine(void) { return _to DeleteToEndOfLine(); } \
  NS_IMETHOD SelectElement(nsIDOMElement *element) { return _to SelectElement(element); } \
  NS_IMETHOD SetSelectionAfterElement(nsIDOMElement *element) { return _to SetSelectionAfterElement(element); } \
  NS_IMETHOD InsertTableCell(PRInt32 number, PRBool after) { return _to InsertTableCell(number, after); } \
  NS_IMETHOD InsertTableRow(PRInt32 number, PRBool after) { return _to InsertTableRow(number, after); } \
  NS_IMETHOD InsertTableColumn(PRInt32 number, PRBool after) { return _to InsertTableColumn(number, after); } \
  NS_IMETHOD DeleteTable(void) { return _to DeleteTable(); } \
  NS_IMETHOD DeleteTableCell(PRInt32 number) { return _to DeleteTableCell(number); } \
  NS_IMETHOD DeleteTableCellContents(void) { return _to DeleteTableCellContents(); } \
  NS_IMETHOD DeleteTableRow(PRInt32 number) { return _to DeleteTableRow(number); } \
  NS_IMETHOD DeleteTableColumn(PRInt32 number) { return _to DeleteTableColumn(number); } \
  NS_IMETHOD SwitchTableCellHeaderType(nsIDOMElement *sourceCell, nsIDOMElement **_retval) { return _to SwitchTableCellHeaderType(sourceCell, _retval); } \
  NS_IMETHOD JoinTableCells(PRBool mergeNonContiguousContents) { return _to JoinTableCells(mergeNonContiguousContents); } \
  NS_IMETHOD SplitTableCell(void) { return _to SplitTableCell(); } \
  NS_IMETHOD SelectTableCell(void) { return _to SelectTableCell(); } \
  NS_IMETHOD SelectBlockOfCells(nsIDOMElement *startCell, nsIDOMElement *endCell) { return _to SelectBlockOfCells(startCell, endCell); } \
  NS_IMETHOD SelectTableRow(void) { return _to SelectTableRow(); } \
  NS_IMETHOD SelectTableColumn(void) { return _to SelectTableColumn(); } \
  NS_IMETHOD SelectTable(void) { return _to SelectTable(); } \
  NS_IMETHOD SelectAllTableCells(void) { return _to SelectAllTableCells(); } \
  NS_IMETHOD NormalizeTable(nsIDOMElement *tableElement) { return _to NormalizeTable(tableElement); } \
  NS_IMETHOD GetRowIndex(nsIDOMElement *cellElement, PRInt32 *_retval) { return _to GetRowIndex(cellElement, _retval); } \
  NS_IMETHOD GetColumnIndex(nsIDOMElement *cellElement, PRInt32 *_retval) { return _to GetColumnIndex(cellElement, _retval); } \
  NS_IMETHOD GetTableRowCount(nsIDOMElement *tableElement, PRInt32 *_retval) { return _to GetTableRowCount(tableElement, _retval); } \
  NS_IMETHOD GetTableColumnCount(nsIDOMElement *tableElement, PRInt32 *_retval) { return _to GetTableColumnCount(tableElement, _retval); } \
  NS_IMETHOD GetCellAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, nsIDOMElement **_retval) { return _to GetCellAt(tableElement, rowIndex, colIndex, _retval); } \
  NS_IMETHOD GetCellDataAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, PRInt32 *startRowIndex, PRInt32 *startColIndex, PRInt32 *rowSpan, PRInt32 *colSpan, PRInt32 *actualRowSpan, PRInt32 *actualColSpan, PRBool *isSelected, nsIDOMElement **_retval) { return _to GetCellDataAt(tableElement, rowIndex, colIndex, startRowIndex, startColIndex, rowSpan, colSpan, actualRowSpan, actualColSpan, isSelected, _retval); } \
  NS_IMETHOD GetFirstRow(nsIDOMElement *tableElement, nsIDOMNode **_retval) { return _to GetFirstRow(tableElement, _retval); } \
  NS_IMETHOD GetNextRow(nsIDOMNode *currentRow, nsIDOMNode **_retval) { return _to GetNextRow(currentRow, _retval); } \
  NS_IMETHOD GetSelectedOrParentTableElement(PRUnichar **tagName, PRInt32 *selectedCount, nsIDOMElement **_retval) { return _to GetSelectedOrParentTableElement(tagName, selectedCount, _retval); } \
  NS_IMETHOD GetSelectedCellsType(nsIDOMElement *element, PRUint32 *_retval) { return _to GetSelectedCellsType(element, _retval); } \
  NS_IMETHOD GetEmbeddedObjects(nsISupportsArray **_retval) { return _to GetEmbeddedObjects(_retval); } \
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval) { return _to GetLinkedObjects(_retval); } \
  NS_IMETHOD SetAttribute(nsIDOMElement *element, const PRUnichar *attr, const PRUnichar *value) { return _to SetAttribute(element, attr, value); } \
  NS_IMETHOD RemoveAttribute(nsIDOMElement *element, const PRUnichar *attr) { return _to RemoveAttribute(element, attr); } \
  NS_IMETHOD SetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value) { return _to SetTextProperty(prop, attr, value); } \
  NS_IMETHOD RemoveTextProperty(const PRUnichar *prop, const PRUnichar *attr) { return _to RemoveTextProperty(prop, attr); } \
  NS_IMETHOD GetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value, PRBool *firstHas, PRBool *anyHas, PRBool *allHas) { return _to GetTextProperty(prop, attr, value, firstHas, anyHas, allHas); } \
  NS_IMETHOD IncreaseFontSize(void) { return _to IncreaseFontSize(); } \
  NS_IMETHOD DecreaseFontSize(void) { return _to DecreaseFontSize(); } \
  NS_IMETHOD SetParagraphFormat(const PRUnichar *paragraphFormat) { return _to SetParagraphFormat(paragraphFormat); } \
  NS_IMETHOD SetBodyAttribute(const PRUnichar *attr, const PRUnichar *value) { return _to SetBodyAttribute(attr, value); } \
  NS_IMETHOD SetBackgroundColor(const PRUnichar *color) { return _to SetBackgroundColor(color); } \
  NS_IMETHOD GetParagraphState(PRBool *mixed, PRUnichar **_retval) { return _to GetParagraphState(mixed, _retval); } \
  NS_IMETHOD GetListState(PRBool *mixed, PRUnichar **_retval) { return _to GetListState(mixed, _retval); } \
  NS_IMETHOD GetListItemState(PRBool *mixed, PRUnichar **_retval) { return _to GetListItemState(mixed, _retval); } \
  NS_IMETHOD GetAlignment(PRBool *mixed, PRUnichar **_retval) { return _to GetAlignment(mixed, _retval); } \
  NS_IMETHOD ApplyStyleSheet(const PRUnichar *url) { return _to ApplyStyleSheet(url); } \
  NS_IMETHOD SetDisplayMode(PRInt32 displayMode) { return _to SetDisplayMode(displayMode); } \
  NS_IMETHOD GetEditMode(PRInt32 *_retval) { return _to GetEditMode(_retval); } \
  NS_IMETHOD IsHTMLSourceMode(PRBool *_retval) { return _to IsHTMLSourceMode(_retval); } \
  NS_IMETHOD FinishHTMLSource(void) { return _to FinishHTMLSource(); } \
  NS_IMETHOD DisplayParagraphMarks(PRBool showMarks) { return _to DisplayParagraphMarks(showMarks); } \
  NS_IMETHOD GetContentsAs(const PRUnichar *format, PRUint32 flags, PRUnichar **_retval) { return _to GetContentsAs(format, flags, _retval); } \
  NS_IMETHOD GetHeadContentsAsHTML(PRUnichar **_retval) { return _to GetHeadContentsAsHTML(_retval); } \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const PRUnichar *textToInsert) { return _to ReplaceHeadContentsWithHTML(textToInsert); } \
  NS_IMETHOD DumpContentTree(void) { return _to DumpContentTree(); } \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval) { return _to NodeIsBlock(node, _retval); } \
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode) { return _to CloneAttributes(destNode, sourceNode); } \
  NS_IMETHOD BeginBatchChanges(void) { return _to BeginBatchChanges(); } \
  NS_IMETHOD EndBatchChanges(void) { return _to EndBatchChanges(); } \
  NS_IMETHOD RunUnitTests(void) { return _to RunUnitTests(); } \
  NS_IMETHOD StartLogging(nsIFile *logFile) { return _to StartLogging(logFile); } \
  NS_IMETHOD StopLogging(void) { return _to StopLogging(); } \
  NS_IMETHOD CloseWindowWithoutSaving(void) { return _to CloseWindowWithoutSaving(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIEDITORSHELL(_to) \
  NS_IMETHOD GetEditorDocument(nsIDOMDocument * *aEditorDocument) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditorDocument(aEditorDocument); } \
  NS_IMETHOD GetEditorSelection(nsISelection * *aEditorSelection) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditorSelection(aEditorSelection); } \
  NS_IMETHOD GetSelectionController(nsISelectionController * *aSelectionController) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectionController(aSelectionController); } \
  NS_IMETHOD GetTransactionManager(nsITransactionManager * *aTransactionManager) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransactionManager(aTransactionManager); } \
  NS_IMETHOD GetWebShellWindow(nsIDOMWindowInternal * *aWebShellWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWebShellWindow(aWebShellWindow); } \
  NS_IMETHOD SetWebShellWindow(nsIDOMWindowInternal * aWebShellWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetWebShellWindow(aWebShellWindow); } \
  NS_IMETHOD GetContentWindow(nsIDOMWindowInternal * *aContentWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentWindow(aContentWindow); } \
  NS_IMETHOD SetContentWindow(nsIDOMWindowInternal * aContentWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetContentWindow(aContentWindow); } \
  NS_IMETHOD GetEditorType(PRUnichar * *aEditorType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditorType(aEditorType); } \
  NS_IMETHOD SetEditorType(const PRUnichar * aEditorType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEditorType(aEditorType); } \
  NS_IMETHOD GetContentsMIMEType(char * *aContentsMIMEType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentsMIMEType(aContentsMIMEType); } \
  NS_IMETHOD SetContentsMIMEType(const char * aContentsMIMEType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetContentsMIMEType(aContentsMIMEType); } \
  NS_IMETHOD GetEditor(nsIEditor * *aEditor) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditor(aEditor); } \
  NS_IMETHOD GetDocumentModified(PRBool *aDocumentModified) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentModified(aDocumentModified); } \
  NS_IMETHOD GetDocumentIsEmpty(PRBool *aDocumentIsEmpty) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentIsEmpty(aDocumentIsEmpty); } \
  NS_IMETHOD GetDocumentEditable(PRBool *aDocumentEditable) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentEditable(aDocumentEditable); } \
  NS_IMETHOD GetDocumentLength(PRInt32 *aDocumentLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentLength(aDocumentLength); } \
  NS_IMETHOD GetWrapColumn(PRInt32 *aWrapColumn) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetWrapColumn(aWrapColumn); } \
  NS_IMETHOD SetWrapColumn(PRInt32 aWrapColumn) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetWrapColumn(aWrapColumn); } \
  NS_IMETHOD LoadUrl(const PRUnichar *url) { return !_to ? NS_ERROR_NULL_POINTER : _to->LoadUrl(url); } \
  NS_IMETHOD SetDocumentTitle(const PRUnichar *title) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentTitle(title); } \
  NS_IMETHOD GetDocumentTitle(PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentTitle(_retval); } \
  NS_IMETHOD DoAfterSave(PRBool aShouldUpdateURL, const PRUnichar *aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoAfterSave(aShouldUpdateURL, aURL); } \
  NS_IMETHOD IsSupportedTextType(const char *aMIMEType, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsSupportedTextType(aMIMEType, _retval); } \
  NS_IMETHOD RegisterDocumentStateListener(nsIDocumentStateListener *docListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterDocumentStateListener(docListener); } \
  NS_IMETHOD UnregisterDocumentStateListener(nsIDocumentStateListener *docListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnregisterDocumentStateListener(docListener); } \
  NS_IMETHOD Shutdown(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Shutdown(); } \
  NS_IMETHOD Print(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Print(); } \
  NS_IMETHOD Undo(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Undo(); } \
  NS_IMETHOD Redo(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Redo(); } \
  NS_IMETHOD Cut(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Cut(); } \
  NS_IMETHOD Copy(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Copy(); } \
  NS_IMETHOD Paste(PRInt32 selectionType) { return !_to ? NS_ERROR_NULL_POINTER : _to->Paste(selectionType); } \
  NS_IMETHOD PasteAsQuotation(PRInt32 selectionType) { return !_to ? NS_ERROR_NULL_POINTER : _to->PasteAsQuotation(selectionType); } \
  NS_IMETHOD PasteAsCitedQuotation(const PRUnichar *cite, PRInt32 selectionType) { return !_to ? NS_ERROR_NULL_POINTER : _to->PasteAsCitedQuotation(cite, selectionType); } \
  NS_IMETHOD InsertAsQuotation(const PRUnichar *quotedText, nsIDOMNode **nodeInserted) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertAsQuotation(quotedText, nodeInserted); } \
  NS_IMETHOD InsertAsCitedQuotation(const PRUnichar *quotedText, const PRUnichar *cite, PRBool insertHTML, const PRUnichar *charset, nsIDOMNode **nodeInserted) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertAsCitedQuotation(quotedText, cite, insertHTML, charset, nodeInserted); } \
  NS_IMETHOD Rewrap(PRBool respectNewlines) { return !_to ? NS_ERROR_NULL_POINTER : _to->Rewrap(respectNewlines); } \
  NS_IMETHOD StripCites(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StripCites(); } \
  NS_IMETHOD SelectAll(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectAll(); } \
  NS_IMETHOD DeleteSelection(PRInt32 action) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteSelection(action); } \
  NS_IMETHOD Find(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Find(); } \
  NS_IMETHOD FindNext(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindNext(); } \
  NS_IMETHOD Replace(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Replace(); } \
  NS_IMETHOD GetString(const PRUnichar *name, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetString(name, _retval); } \
  NS_IMETHOD GetDocumentCharacterSet(PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentCharacterSet(_retval); } \
  NS_IMETHOD SetDocumentCharacterSet(const PRUnichar *characterSet) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentCharacterSet(characterSet); } \
  NS_IMETHOD InsertText(const PRUnichar *textToInsert) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertText(textToInsert); } \
  NS_IMETHOD InsertSource(const PRUnichar *textToInsert) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertSource(textToInsert); } \
  NS_IMETHOD InsertSourceWithCharset(const PRUnichar *textToInsert, const PRUnichar *charset) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertSourceWithCharset(textToInsert, charset); } \
  NS_IMETHOD RebuildDocumentFromSource(const PRUnichar *source) { return !_to ? NS_ERROR_NULL_POINTER : _to->RebuildDocumentFromSource(source); } \
  NS_IMETHOD InsertBreak(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertBreak(); } \
  NS_IMETHOD MakeOrChangeList(const PRUnichar *listType, PRBool entireList, const PRUnichar *bulletType) { return !_to ? NS_ERROR_NULL_POINTER : _to->MakeOrChangeList(listType, entireList, bulletType); } \
  NS_IMETHOD RemoveList(const PRUnichar *listType) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveList(listType); } \
  NS_IMETHOD Indent(const PRUnichar *indent) { return !_to ? NS_ERROR_NULL_POINTER : _to->Indent(indent); } \
  NS_IMETHOD Align(const PRUnichar *align) { return !_to ? NS_ERROR_NULL_POINTER : _to->Align(align); } \
  NS_IMETHOD GetSelectedElement(const PRUnichar *tagName, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedElement(tagName, _retval); } \
  NS_IMETHOD GetFirstSelectedCell(nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstSelectedCell(_retval); } \
  NS_IMETHOD GetFirstSelectedCellInTable(PRInt32 *rowIndex, PRInt32 *colIndex, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstSelectedCellInTable(rowIndex, colIndex, _retval); } \
  NS_IMETHOD GetNextSelectedCell(nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNextSelectedCell(_retval); } \
  NS_IMETHOD GetElementOrParentByTagName(const PRUnichar *tagName, nsIDOMNode *node, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementOrParentByTagName(tagName, node, _retval); } \
  NS_IMETHOD CreateElementWithDefaults(const PRUnichar *tagName, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateElementWithDefaults(tagName, _retval); } \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *element, PRBool deleteSelection) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertElementAtSelection(element, deleteSelection); } \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *anchorElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertLinkAroundSelection(anchorElement); } \
  NS_IMETHOD InsertElement(nsIDOMElement *element, nsIDOMElement *parent, PRInt32 position, PRBool dontChangeSelection) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertElement(element, parent, position, dontChangeSelection); } \
  NS_IMETHOD DeleteElement(nsIDOMElement *element) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteElement(element); } \
  NS_IMETHOD DeleteCharForward(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCharForward(); } \
  NS_IMETHOD DeleteCharBackward(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCharBackward(); } \
  NS_IMETHOD DeleteWordForward(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteWordForward(); } \
  NS_IMETHOD DeleteWordBackward(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteWordBackward(); } \
  NS_IMETHOD DeleteToBeginningOfLine(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteToBeginningOfLine(); } \
  NS_IMETHOD DeleteToEndOfLine(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteToEndOfLine(); } \
  NS_IMETHOD SelectElement(nsIDOMElement *element) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectElement(element); } \
  NS_IMETHOD SetSelectionAfterElement(nsIDOMElement *element) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSelectionAfterElement(element); } \
  NS_IMETHOD InsertTableCell(PRInt32 number, PRBool after) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertTableCell(number, after); } \
  NS_IMETHOD InsertTableRow(PRInt32 number, PRBool after) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertTableRow(number, after); } \
  NS_IMETHOD InsertTableColumn(PRInt32 number, PRBool after) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertTableColumn(number, after); } \
  NS_IMETHOD DeleteTable(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteTable(); } \
  NS_IMETHOD DeleteTableCell(PRInt32 number) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteTableCell(number); } \
  NS_IMETHOD DeleteTableCellContents(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteTableCellContents(); } \
  NS_IMETHOD DeleteTableRow(PRInt32 number) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteTableRow(number); } \
  NS_IMETHOD DeleteTableColumn(PRInt32 number) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteTableColumn(number); } \
  NS_IMETHOD SwitchTableCellHeaderType(nsIDOMElement *sourceCell, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->SwitchTableCellHeaderType(sourceCell, _retval); } \
  NS_IMETHOD JoinTableCells(PRBool mergeNonContiguousContents) { return !_to ? NS_ERROR_NULL_POINTER : _to->JoinTableCells(mergeNonContiguousContents); } \
  NS_IMETHOD SplitTableCell(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SplitTableCell(); } \
  NS_IMETHOD SelectTableCell(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectTableCell(); } \
  NS_IMETHOD SelectBlockOfCells(nsIDOMElement *startCell, nsIDOMElement *endCell) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectBlockOfCells(startCell, endCell); } \
  NS_IMETHOD SelectTableRow(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectTableRow(); } \
  NS_IMETHOD SelectTableColumn(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectTableColumn(); } \
  NS_IMETHOD SelectTable(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectTable(); } \
  NS_IMETHOD SelectAllTableCells(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectAllTableCells(); } \
  NS_IMETHOD NormalizeTable(nsIDOMElement *tableElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->NormalizeTable(tableElement); } \
  NS_IMETHOD GetRowIndex(nsIDOMElement *cellElement, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRowIndex(cellElement, _retval); } \
  NS_IMETHOD GetColumnIndex(nsIDOMElement *cellElement, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetColumnIndex(cellElement, _retval); } \
  NS_IMETHOD GetTableRowCount(nsIDOMElement *tableElement, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTableRowCount(tableElement, _retval); } \
  NS_IMETHOD GetTableColumnCount(nsIDOMElement *tableElement, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTableColumnCount(tableElement, _retval); } \
  NS_IMETHOD GetCellAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCellAt(tableElement, rowIndex, colIndex, _retval); } \
  NS_IMETHOD GetCellDataAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, PRInt32 *startRowIndex, PRInt32 *startColIndex, PRInt32 *rowSpan, PRInt32 *colSpan, PRInt32 *actualRowSpan, PRInt32 *actualColSpan, PRBool *isSelected, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCellDataAt(tableElement, rowIndex, colIndex, startRowIndex, startColIndex, rowSpan, colSpan, actualRowSpan, actualColSpan, isSelected, _retval); } \
  NS_IMETHOD GetFirstRow(nsIDOMElement *tableElement, nsIDOMNode **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstRow(tableElement, _retval); } \
  NS_IMETHOD GetNextRow(nsIDOMNode *currentRow, nsIDOMNode **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNextRow(currentRow, _retval); } \
  NS_IMETHOD GetSelectedOrParentTableElement(PRUnichar **tagName, PRInt32 *selectedCount, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedOrParentTableElement(tagName, selectedCount, _retval); } \
  NS_IMETHOD GetSelectedCellsType(nsIDOMElement *element, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedCellsType(element, _retval); } \
  NS_IMETHOD GetEmbeddedObjects(nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEmbeddedObjects(_retval); } \
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLinkedObjects(_retval); } \
  NS_IMETHOD SetAttribute(nsIDOMElement *element, const PRUnichar *attr, const PRUnichar *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAttribute(element, attr, value); } \
  NS_IMETHOD RemoveAttribute(nsIDOMElement *element, const PRUnichar *attr) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAttribute(element, attr); } \
  NS_IMETHOD SetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTextProperty(prop, attr, value); } \
  NS_IMETHOD RemoveTextProperty(const PRUnichar *prop, const PRUnichar *attr) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveTextProperty(prop, attr); } \
  NS_IMETHOD GetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value, PRBool *firstHas, PRBool *anyHas, PRBool *allHas) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTextProperty(prop, attr, value, firstHas, anyHas, allHas); } \
  NS_IMETHOD IncreaseFontSize(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->IncreaseFontSize(); } \
  NS_IMETHOD DecreaseFontSize(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DecreaseFontSize(); } \
  NS_IMETHOD SetParagraphFormat(const PRUnichar *paragraphFormat) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParagraphFormat(paragraphFormat); } \
  NS_IMETHOD SetBodyAttribute(const PRUnichar *attr, const PRUnichar *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBodyAttribute(attr, value); } \
  NS_IMETHOD SetBackgroundColor(const PRUnichar *color) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBackgroundColor(color); } \
  NS_IMETHOD GetParagraphState(PRBool *mixed, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParagraphState(mixed, _retval); } \
  NS_IMETHOD GetListState(PRBool *mixed, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListState(mixed, _retval); } \
  NS_IMETHOD GetListItemState(PRBool *mixed, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListItemState(mixed, _retval); } \
  NS_IMETHOD GetAlignment(PRBool *mixed, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAlignment(mixed, _retval); } \
  NS_IMETHOD ApplyStyleSheet(const PRUnichar *url) { return !_to ? NS_ERROR_NULL_POINTER : _to->ApplyStyleSheet(url); } \
  NS_IMETHOD SetDisplayMode(PRInt32 displayMode) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDisplayMode(displayMode); } \
  NS_IMETHOD GetEditMode(PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditMode(_retval); } \
  NS_IMETHOD IsHTMLSourceMode(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsHTMLSourceMode(_retval); } \
  NS_IMETHOD FinishHTMLSource(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->FinishHTMLSource(); } \
  NS_IMETHOD DisplayParagraphMarks(PRBool showMarks) { return !_to ? NS_ERROR_NULL_POINTER : _to->DisplayParagraphMarks(showMarks); } \
  NS_IMETHOD GetContentsAs(const PRUnichar *format, PRUint32 flags, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentsAs(format, flags, _retval); } \
  NS_IMETHOD GetHeadContentsAsHTML(PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeadContentsAsHTML(_retval); } \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const PRUnichar *textToInsert) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReplaceHeadContentsWithHTML(textToInsert); } \
  NS_IMETHOD DumpContentTree(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DumpContentTree(); } \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NodeIsBlock(node, _retval); } \
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloneAttributes(destNode, sourceNode); } \
  NS_IMETHOD BeginBatchChanges(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->BeginBatchChanges(); } \
  NS_IMETHOD EndBatchChanges(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->EndBatchChanges(); } \
  NS_IMETHOD RunUnitTests(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RunUnitTests(); } \
  NS_IMETHOD StartLogging(nsIFile *logFile) { return !_to ? NS_ERROR_NULL_POINTER : _to->StartLogging(logFile); } \
  NS_IMETHOD StopLogging(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->StopLogging(); } \
  NS_IMETHOD CloseWindowWithoutSaving(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseWindowWithoutSaving(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsEditorShell : public nsIEditorShell
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIEDITORSHELL

  nsEditorShell();
  virtual ~nsEditorShell();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsEditorShell, nsIEditorShell)

nsEditorShell::nsEditorShell()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsEditorShell::~nsEditorShell()
{
  /* destructor code */
}

/* readonly attribute nsIDOMDocument editorDocument; */
NS_IMETHODIMP nsEditorShell::GetEditorDocument(nsIDOMDocument * *aEditorDocument)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISelection editorSelection; */
NS_IMETHODIMP nsEditorShell::GetEditorSelection(nsISelection * *aEditorSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISelectionController selectionController; */
NS_IMETHODIMP nsEditorShell::GetSelectionController(nsISelectionController * *aSelectionController)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsITransactionManager transactionManager; */
NS_IMETHODIMP nsEditorShell::GetTransactionManager(nsITransactionManager * *aTransactionManager)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIDOMWindowInternal webShellWindow; */
NS_IMETHODIMP nsEditorShell::GetWebShellWindow(nsIDOMWindowInternal * *aWebShellWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsEditorShell::SetWebShellWindow(nsIDOMWindowInternal * aWebShellWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIDOMWindowInternal contentWindow; */
NS_IMETHODIMP nsEditorShell::GetContentWindow(nsIDOMWindowInternal * *aContentWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsEditorShell::SetContentWindow(nsIDOMWindowInternal * aContentWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute wstring editorType; */
NS_IMETHODIMP nsEditorShell::GetEditorType(PRUnichar * *aEditorType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsEditorShell::SetEditorType(const PRUnichar * aEditorType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string contentsMIMEType; */
NS_IMETHODIMP nsEditorShell::GetContentsMIMEType(char * *aContentsMIMEType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsEditorShell::SetContentsMIMEType(const char * aContentsMIMEType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIEditor editor; */
NS_IMETHODIMP nsEditorShell::GetEditor(nsIEditor * *aEditor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean documentModified; */
NS_IMETHODIMP nsEditorShell::GetDocumentModified(PRBool *aDocumentModified)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean documentIsEmpty; */
NS_IMETHODIMP nsEditorShell::GetDocumentIsEmpty(PRBool *aDocumentIsEmpty)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean documentEditable; */
NS_IMETHODIMP nsEditorShell::GetDocumentEditable(PRBool *aDocumentEditable)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long documentLength; */
NS_IMETHODIMP nsEditorShell::GetDocumentLength(PRInt32 *aDocumentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long wrapColumn; */
NS_IMETHODIMP nsEditorShell::GetWrapColumn(PRInt32 *aWrapColumn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsEditorShell::SetWrapColumn(PRInt32 aWrapColumn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void LoadUrl (in wstring url); */
NS_IMETHODIMP nsEditorShell::LoadUrl(const PRUnichar *url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDocumentTitle (in wstring title); */
NS_IMETHODIMP nsEditorShell::SetDocumentTitle(const PRUnichar *title)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetDocumentTitle (); */
NS_IMETHODIMP nsEditorShell::GetDocumentTitle(PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doAfterSave (in boolean aShouldUpdateURL, in wstring aURL); */
NS_IMETHODIMP nsEditorShell::DoAfterSave(PRBool aShouldUpdateURL, const PRUnichar *aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSupportedTextType (in string aMIMEType); */
NS_IMETHODIMP nsEditorShell::IsSupportedTextType(const char *aMIMEType, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RegisterDocumentStateListener (in nsIDocumentStateListener docListener); */
NS_IMETHODIMP nsEditorShell::RegisterDocumentStateListener(nsIDocumentStateListener *docListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void UnregisterDocumentStateListener (in nsIDocumentStateListener docListener); */
NS_IMETHODIMP nsEditorShell::UnregisterDocumentStateListener(nsIDocumentStateListener *docListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Shutdown (); */
NS_IMETHODIMP nsEditorShell::Shutdown()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Print (); */
NS_IMETHODIMP nsEditorShell::Print()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Undo (); */
NS_IMETHODIMP nsEditorShell::Undo()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Redo (); */
NS_IMETHODIMP nsEditorShell::Redo()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Cut (); */
NS_IMETHODIMP nsEditorShell::Cut()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Copy (); */
NS_IMETHODIMP nsEditorShell::Copy()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Paste (in long selectionType); */
NS_IMETHODIMP nsEditorShell::Paste(PRInt32 selectionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PasteAsQuotation (in long selectionType); */
NS_IMETHODIMP nsEditorShell::PasteAsQuotation(PRInt32 selectionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PasteAsCitedQuotation (in wstring cite, in long selectionType); */
NS_IMETHODIMP nsEditorShell::PasteAsCitedQuotation(const PRUnichar *cite, PRInt32 selectionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertAsQuotation (in wstring quotedText, out nsIDOMNode nodeInserted); */
NS_IMETHODIMP nsEditorShell::InsertAsQuotation(const PRUnichar *quotedText, nsIDOMNode **nodeInserted)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertAsCitedQuotation (in wstring quotedText, in wstring cite, in boolean insertHTML, in wstring charset, out nsIDOMNode nodeInserted); */
NS_IMETHODIMP nsEditorShell::InsertAsCitedQuotation(const PRUnichar *quotedText, const PRUnichar *cite, PRBool insertHTML, const PRUnichar *charset, nsIDOMNode **nodeInserted)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Rewrap (in boolean respectNewlines); */
NS_IMETHODIMP nsEditorShell::Rewrap(PRBool respectNewlines)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void StripCites (); */
NS_IMETHODIMP nsEditorShell::StripCites()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectAll (); */
NS_IMETHODIMP nsEditorShell::SelectAll()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteSelection (in PRInt32 action); */
NS_IMETHODIMP nsEditorShell::DeleteSelection(PRInt32 action)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Find (); */
NS_IMETHODIMP nsEditorShell::Find()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void FindNext (); */
NS_IMETHODIMP nsEditorShell::FindNext()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Replace (); */
NS_IMETHODIMP nsEditorShell::Replace()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetString (in wstring name); */
NS_IMETHODIMP nsEditorShell::GetString(const PRUnichar *name, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetDocumentCharacterSet (); */
NS_IMETHODIMP nsEditorShell::GetDocumentCharacterSet(PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDocumentCharacterSet (in wstring characterSet); */
NS_IMETHODIMP nsEditorShell::SetDocumentCharacterSet(const PRUnichar *characterSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertText (in wstring textToInsert); */
NS_IMETHODIMP nsEditorShell::InsertText(const PRUnichar *textToInsert)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertSource (in wstring textToInsert); */
NS_IMETHODIMP nsEditorShell::InsertSource(const PRUnichar *textToInsert)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertSourceWithCharset (in wstring textToInsert, in wstring charset); */
NS_IMETHODIMP nsEditorShell::InsertSourceWithCharset(const PRUnichar *textToInsert, const PRUnichar *charset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RebuildDocumentFromSource (in wstring source); */
NS_IMETHODIMP nsEditorShell::RebuildDocumentFromSource(const PRUnichar *source)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertBreak (); */
NS_IMETHODIMP nsEditorShell::InsertBreak()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void MakeOrChangeList (in wstring listType, in PRBool entireList, in wstring bulletType); */
NS_IMETHODIMP nsEditorShell::MakeOrChangeList(const PRUnichar *listType, PRBool entireList, const PRUnichar *bulletType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveList (in wstring listType); */
NS_IMETHODIMP nsEditorShell::RemoveList(const PRUnichar *listType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Indent (in wstring indent); */
NS_IMETHODIMP nsEditorShell::Indent(const PRUnichar *indent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Align (in wstring align); */
NS_IMETHODIMP nsEditorShell::Align(const PRUnichar *align)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetSelectedElement (in wstring tagName); */
NS_IMETHODIMP nsEditorShell::GetSelectedElement(const PRUnichar *tagName, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetFirstSelectedCell (); */
NS_IMETHODIMP nsEditorShell::GetFirstSelectedCell(nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetFirstSelectedCellInTable (out PRInt32 rowIndex, out PRInt32 colIndex); */
NS_IMETHODIMP nsEditorShell::GetFirstSelectedCellInTable(PRInt32 *rowIndex, PRInt32 *colIndex, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetNextSelectedCell (); */
NS_IMETHODIMP nsEditorShell::GetNextSelectedCell(nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetElementOrParentByTagName (in wstring tagName, in nsIDOMNode node); */
NS_IMETHODIMP nsEditorShell::GetElementOrParentByTagName(const PRUnichar *tagName, nsIDOMNode *node, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement CreateElementWithDefaults (in wstring tagName); */
NS_IMETHODIMP nsEditorShell::CreateElementWithDefaults(const PRUnichar *tagName, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertElementAtSelection (in nsIDOMElement element, in boolean deleteSelection); */
NS_IMETHODIMP nsEditorShell::InsertElementAtSelection(nsIDOMElement *element, PRBool deleteSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertLinkAroundSelection (in nsIDOMElement anchorElement); */
NS_IMETHODIMP nsEditorShell::InsertLinkAroundSelection(nsIDOMElement *anchorElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertElement (in nsIDOMElement element, in nsIDOMElement parent, in PRInt32 position, in PRBool dontChangeSelection); */
NS_IMETHODIMP nsEditorShell::InsertElement(nsIDOMElement *element, nsIDOMElement *parent, PRInt32 position, PRBool dontChangeSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteElement (in nsIDOMElement element); */
NS_IMETHODIMP nsEditorShell::DeleteElement(nsIDOMElement *element)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteCharForward (); */
NS_IMETHODIMP nsEditorShell::DeleteCharForward()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteCharBackward (); */
NS_IMETHODIMP nsEditorShell::DeleteCharBackward()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteWordForward (); */
NS_IMETHODIMP nsEditorShell::DeleteWordForward()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteWordBackward (); */
NS_IMETHODIMP nsEditorShell::DeleteWordBackward()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteToBeginningOfLine (); */
NS_IMETHODIMP nsEditorShell::DeleteToBeginningOfLine()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteToEndOfLine (); */
NS_IMETHODIMP nsEditorShell::DeleteToEndOfLine()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectElement (in nsIDOMElement element); */
NS_IMETHODIMP nsEditorShell::SelectElement(nsIDOMElement *element)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetSelectionAfterElement (in nsIDOMElement element); */
NS_IMETHODIMP nsEditorShell::SetSelectionAfterElement(nsIDOMElement *element)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertTableCell (in PRInt32 number, in boolean after); */
NS_IMETHODIMP nsEditorShell::InsertTableCell(PRInt32 number, PRBool after)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertTableRow (in PRInt32 number, in boolean after); */
NS_IMETHODIMP nsEditorShell::InsertTableRow(PRInt32 number, PRBool after)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertTableColumn (in PRInt32 number, in boolean after); */
NS_IMETHODIMP nsEditorShell::InsertTableColumn(PRInt32 number, PRBool after)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteTable (); */
NS_IMETHODIMP nsEditorShell::DeleteTable()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteTableCell (in PRInt32 number); */
NS_IMETHODIMP nsEditorShell::DeleteTableCell(PRInt32 number)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteTableCellContents (); */
NS_IMETHODIMP nsEditorShell::DeleteTableCellContents()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteTableRow (in PRInt32 number); */
NS_IMETHODIMP nsEditorShell::DeleteTableRow(PRInt32 number)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteTableColumn (in PRInt32 number); */
NS_IMETHODIMP nsEditorShell::DeleteTableColumn(PRInt32 number)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement SwitchTableCellHeaderType (in nsIDOMElement sourceCell); */
NS_IMETHODIMP nsEditorShell::SwitchTableCellHeaderType(nsIDOMElement *sourceCell, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void JoinTableCells (in boolean mergeNonContiguousContents); */
NS_IMETHODIMP nsEditorShell::JoinTableCells(PRBool mergeNonContiguousContents)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SplitTableCell (); */
NS_IMETHODIMP nsEditorShell::SplitTableCell()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectTableCell (); */
NS_IMETHODIMP nsEditorShell::SelectTableCell()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectBlockOfCells (in nsIDOMElement startCell, in nsIDOMElement endCell); */
NS_IMETHODIMP nsEditorShell::SelectBlockOfCells(nsIDOMElement *startCell, nsIDOMElement *endCell)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectTableRow (); */
NS_IMETHODIMP nsEditorShell::SelectTableRow()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectTableColumn (); */
NS_IMETHODIMP nsEditorShell::SelectTableColumn()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectTable (); */
NS_IMETHODIMP nsEditorShell::SelectTable()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectAllTableCells (); */
NS_IMETHODIMP nsEditorShell::SelectAllTableCells()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void NormalizeTable (in nsIDOMElement tableElement); */
NS_IMETHODIMP nsEditorShell::NormalizeTable(nsIDOMElement *tableElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 GetRowIndex (in nsIDOMElement cellElement); */
NS_IMETHODIMP nsEditorShell::GetRowIndex(nsIDOMElement *cellElement, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 GetColumnIndex (in nsIDOMElement cellElement); */
NS_IMETHODIMP nsEditorShell::GetColumnIndex(nsIDOMElement *cellElement, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 GetTableRowCount (in nsIDOMElement tableElement); */
NS_IMETHODIMP nsEditorShell::GetTableRowCount(nsIDOMElement *tableElement, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 GetTableColumnCount (in nsIDOMElement tableElement); */
NS_IMETHODIMP nsEditorShell::GetTableColumnCount(nsIDOMElement *tableElement, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetCellAt (in nsIDOMElement tableElement, in PRInt32 rowIndex, in PRInt32 colIndex); */
NS_IMETHODIMP nsEditorShell::GetCellAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetCellDataAt (in nsIDOMElement tableElement, in PRInt32 rowIndex, in PRInt32 colIndex, out PRInt32 startRowIndex, out PRInt32 startColIndex, out PRInt32 rowSpan, out PRInt32 colSpan, out PRInt32 actualRowSpan, out PRInt32 actualColSpan, out boolean isSelected); */
NS_IMETHODIMP nsEditorShell::GetCellDataAt(nsIDOMElement *tableElement, PRInt32 rowIndex, PRInt32 colIndex, PRInt32 *startRowIndex, PRInt32 *startColIndex, PRInt32 *rowSpan, PRInt32 *colSpan, PRInt32 *actualRowSpan, PRInt32 *actualColSpan, PRBool *isSelected, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode GetFirstRow (in nsIDOMElement tableElement); */
NS_IMETHODIMP nsEditorShell::GetFirstRow(nsIDOMElement *tableElement, nsIDOMNode **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMNode GetNextRow (in nsIDOMNode currentRow); */
NS_IMETHODIMP nsEditorShell::GetNextRow(nsIDOMNode *currentRow, nsIDOMNode **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement GetSelectedOrParentTableElement (out wstring tagName, out PRInt32 selectedCount); */
NS_IMETHODIMP nsEditorShell::GetSelectedOrParentTableElement(PRUnichar **tagName, PRInt32 *selectedCount, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRUint32 GetSelectedCellsType (in nsIDOMElement element); */
NS_IMETHODIMP nsEditorShell::GetSelectedCellsType(nsIDOMElement *element, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray GetEmbeddedObjects (); */
NS_IMETHODIMP nsEditorShell::GetEmbeddedObjects(nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray GetLinkedObjects (); */
NS_IMETHODIMP nsEditorShell::GetLinkedObjects(nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetAttribute (in nsIDOMElement element, in wstring attr, in wstring value); */
NS_IMETHODIMP nsEditorShell::SetAttribute(nsIDOMElement *element, const PRUnichar *attr, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveAttribute (in nsIDOMElement element, in wstring attr); */
NS_IMETHODIMP nsEditorShell::RemoveAttribute(nsIDOMElement *element, const PRUnichar *attr)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetTextProperty (in wstring prop, in wstring attr, in wstring value); */
NS_IMETHODIMP nsEditorShell::SetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveTextProperty (in wstring prop, in wstring attr); */
NS_IMETHODIMP nsEditorShell::RemoveTextProperty(const PRUnichar *prop, const PRUnichar *attr)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetTextProperty (in wstring prop, in wstring attr, in wstring value, out boolean firstHas, out boolean anyHas, out boolean allHas); */
NS_IMETHODIMP nsEditorShell::GetTextProperty(const PRUnichar *prop, const PRUnichar *attr, const PRUnichar *value, PRBool *firstHas, PRBool *anyHas, PRBool *allHas)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void IncreaseFontSize (); */
NS_IMETHODIMP nsEditorShell::IncreaseFontSize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DecreaseFontSize (); */
NS_IMETHODIMP nsEditorShell::DecreaseFontSize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetParagraphFormat (in wstring paragraphFormat); */
NS_IMETHODIMP nsEditorShell::SetParagraphFormat(const PRUnichar *paragraphFormat)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetBodyAttribute (in wstring attr, in wstring value); */
NS_IMETHODIMP nsEditorShell::SetBodyAttribute(const PRUnichar *attr, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetBackgroundColor (in wstring color); */
NS_IMETHODIMP nsEditorShell::SetBackgroundColor(const PRUnichar *color)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetParagraphState (out boolean mixed); */
NS_IMETHODIMP nsEditorShell::GetParagraphState(PRBool *mixed, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetListState (out boolean mixed); */
NS_IMETHODIMP nsEditorShell::GetListState(PRBool *mixed, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetListItemState (out boolean mixed); */
NS_IMETHODIMP nsEditorShell::GetListItemState(PRBool *mixed, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetAlignment (out boolean mixed); */
NS_IMETHODIMP nsEditorShell::GetAlignment(PRBool *mixed, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ApplyStyleSheet (in wstring url); */
NS_IMETHODIMP nsEditorShell::ApplyStyleSheet(const PRUnichar *url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDisplayMode (in PRInt32 displayMode); */
NS_IMETHODIMP nsEditorShell::SetDisplayMode(PRInt32 displayMode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 GetEditMode (); */
NS_IMETHODIMP nsEditorShell::GetEditMode(PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean IsHTMLSourceMode (); */
NS_IMETHODIMP nsEditorShell::IsHTMLSourceMode(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void FinishHTMLSource (); */
NS_IMETHODIMP nsEditorShell::FinishHTMLSource()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DisplayParagraphMarks (in PRBool showMarks); */
NS_IMETHODIMP nsEditorShell::DisplayParagraphMarks(PRBool showMarks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetContentsAs (in wstring format, in PRUint32 flags); */
NS_IMETHODIMP nsEditorShell::GetContentsAs(const PRUnichar *format, PRUint32 flags, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring GetHeadContentsAsHTML (); */
NS_IMETHODIMP nsEditorShell::GetHeadContentsAsHTML(PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ReplaceHeadContentsWithHTML (in wstring textToInsert); */
NS_IMETHODIMP nsEditorShell::ReplaceHeadContentsWithHTML(const PRUnichar *textToInsert)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DumpContentTree (); */
NS_IMETHODIMP nsEditorShell::DumpContentTree()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean NodeIsBlock (in nsIDOMNode node); */
NS_IMETHODIMP nsEditorShell::NodeIsBlock(nsIDOMNode *node, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CloneAttributes (in nsIDOMNode destNode, in nsIDOMNode sourceNode); */
NS_IMETHODIMP nsEditorShell::CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void BeginBatchChanges (); */
NS_IMETHODIMP nsEditorShell::BeginBatchChanges()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void EndBatchChanges (); */
NS_IMETHODIMP nsEditorShell::EndBatchChanges()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RunUnitTests (); */
NS_IMETHODIMP nsEditorShell::RunUnitTests()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void StartLogging (in nsIFile logFile); */
NS_IMETHODIMP nsEditorShell::StartLogging(nsIFile *logFile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void StopLogging (); */
NS_IMETHODIMP nsEditorShell::StopLogging()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CloseWindowWithoutSaving (); */
NS_IMETHODIMP nsEditorShell::CloseWindowWithoutSaving()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIEditorShell_h__ */
