/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsICategoryManager.idl
 */

#ifndef __gen_nsICategoryManager_h__
#define __gen_nsICategoryManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsISimpleEnumerator_h__
#include "nsISimpleEnumerator.h"
#endif

#ifndef __gen_nsICategoryHandler_h__
#include "nsICategoryHandler.h"
#endif

#ifndef __gen_nsIFactory_h__
#include "nsIFactory.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsICategoryManager */
#define NS_ICATEGORYMANAGER_IID_STR "5a1e1a2c-1dd2-11b2-a72f-967357e43a00"

#define NS_ICATEGORYMANAGER_IID \
  {0x5a1e1a2c, 0x1dd2, 0x11b2, \
    { 0xa7, 0x2f, 0x96, 0x73, 0x57, 0xe4, 0x3a, 0x00 }}

class NS_NO_VTABLE nsICategoryManager : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICATEGORYMANAGER_IID)

  /**
     * Get the value for the given category's entry.
     * @param aCategory The name of the category ("protocol")
     * @param aEntry The entry you're looking for ("http")
     * @return The value.
     */
  /* string getCategoryEntry (in string aCategory, in string aEntry); */
  NS_IMETHOD GetCategoryEntry(const char *aCategory, const char *aEntry, char **_retval) = 0;

  /**
     * As above, but do not permit overriding.  This is useful to allow
     * an override handler to get at the ``normal'' category contents.
     */
  /* string getCategoryEntryRaw (in string aCategory, in string aEntry); */
  NS_IMETHOD GetCategoryEntryRaw(const char *aCategory, const char *aEntry, char **_retval) = 0;

  /**
     * Add an entry to a category.
     * @param aCategory The name of the category ("protocol")
     * @param aEntry The entry to be added ("http")
     * @param aValue The value for the entry ("moz.httprulez.1")
     * @param aPersist Should we persist between invocations?
     * @param aReplace Should we replace an existing entry?
     * @return Previous entry, if any
     */
  /* string addCategoryEntry (in string aCategory, in string aEntry, in string aValue, in boolean aPersist, in boolean aReplace); */
  NS_IMETHOD AddCategoryEntry(const char *aCategory, const char *aEntry, const char *aValue, PRBool aPersist, PRBool aReplace, char **_retval) = 0;

  /**
     * Delete an entry from the category.
     * @param aCategory The name of the category ("protocol")
     * @param aEntry The entry to be added ("http")
     * @param aPersist Delete entry from registry, if present?
     */
  /* void deleteCategoryEntry (in string aCategory, in string aEntry, in boolean aPersist); */
  NS_IMETHOD DeleteCategoryEntry(const char *aCategory, const char *aEntry, PRBool aPersist) = 0;

  /**
     * Delete a category and all entries.
     * @param aCategory The category to be deleted.
     * @param aPersist Delete the category from the registry?
     */
  /* void deleteCategory (in string aCategory); */
  NS_IMETHOD DeleteCategory(const char *aCategory) = 0;

  /**
     * Enumerate the entries in a category.
     * @param aCategory The category to be enumerated.
     */
  /* nsISimpleEnumerator enumerateCategory (in string aCategory); */
  NS_IMETHOD EnumerateCategory(const char *aCategory, nsISimpleEnumerator **_retval) = 0;

  /**
     * Get all the category contents.
     */
  /* void getCategoryContents (in string category, [array, size_is (count)] out string entries, [array, size_is (count)] out string values, [retval] out unsigned long count); */
  NS_IMETHOD GetCategoryContents(const char *category, char ***entries, char ***values, PRUint32 *count) = 0;

  enum { OVERRIDE = 0 };

  enum { FALLBACK = 1 };

  /* nsICategoryHandler registerCategoryHandler (in string aCategory, in nsICategoryHandler aHandler, in long aMode); */
  NS_IMETHOD RegisterCategoryHandler(const char *aCategory, nsICategoryHandler *aHandler, PRInt32 aMode, nsICategoryHandler **_retval) = 0;

  /* void unregisterCategoryHandler (in string category, in nsICategoryHandler handler, in nsICategoryHandler previous); */
  NS_IMETHOD UnregisterCategoryHandler(const char *category, nsICategoryHandler *handler, nsICategoryHandler *previous) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICATEGORYMANAGER \
  NS_IMETHOD GetCategoryEntry(const char *aCategory, const char *aEntry, char **_retval); \
  NS_IMETHOD GetCategoryEntryRaw(const char *aCategory, const char *aEntry, char **_retval); \
  NS_IMETHOD AddCategoryEntry(const char *aCategory, const char *aEntry, const char *aValue, PRBool aPersist, PRBool aReplace, char **_retval); \
  NS_IMETHOD DeleteCategoryEntry(const char *aCategory, const char *aEntry, PRBool aPersist); \
  NS_IMETHOD DeleteCategory(const char *aCategory); \
  NS_IMETHOD EnumerateCategory(const char *aCategory, nsISimpleEnumerator **_retval); \
  NS_IMETHOD GetCategoryContents(const char *category, char ***entries, char ***values, PRUint32 *count); \
  NS_IMETHOD RegisterCategoryHandler(const char *aCategory, nsICategoryHandler *aHandler, PRInt32 aMode, nsICategoryHandler **_retval); \
  NS_IMETHOD UnregisterCategoryHandler(const char *category, nsICategoryHandler *handler, nsICategoryHandler *previous); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICATEGORYMANAGER(_to) \
  NS_IMETHOD GetCategoryEntry(const char *aCategory, const char *aEntry, char **_retval) { return _to GetCategoryEntry(aCategory, aEntry, _retval); } \
  NS_IMETHOD GetCategoryEntryRaw(const char *aCategory, const char *aEntry, char **_retval) { return _to GetCategoryEntryRaw(aCategory, aEntry, _retval); } \
  NS_IMETHOD AddCategoryEntry(const char *aCategory, const char *aEntry, const char *aValue, PRBool aPersist, PRBool aReplace, char **_retval) { return _to AddCategoryEntry(aCategory, aEntry, aValue, aPersist, aReplace, _retval); } \
  NS_IMETHOD DeleteCategoryEntry(const char *aCategory, const char *aEntry, PRBool aPersist) { return _to DeleteCategoryEntry(aCategory, aEntry, aPersist); } \
  NS_IMETHOD DeleteCategory(const char *aCategory) { return _to DeleteCategory(aCategory); } \
  NS_IMETHOD EnumerateCategory(const char *aCategory, nsISimpleEnumerator **_retval) { return _to EnumerateCategory(aCategory, _retval); } \
  NS_IMETHOD GetCategoryContents(const char *category, char ***entries, char ***values, PRUint32 *count) { return _to GetCategoryContents(category, entries, values, count); } \
  NS_IMETHOD RegisterCategoryHandler(const char *aCategory, nsICategoryHandler *aHandler, PRInt32 aMode, nsICategoryHandler **_retval) { return _to RegisterCategoryHandler(aCategory, aHandler, aMode, _retval); } \
  NS_IMETHOD UnregisterCategoryHandler(const char *category, nsICategoryHandler *handler, nsICategoryHandler *previous) { return _to UnregisterCategoryHandler(category, handler, previous); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICATEGORYMANAGER(_to) \
  NS_IMETHOD GetCategoryEntry(const char *aCategory, const char *aEntry, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCategoryEntry(aCategory, aEntry, _retval); } \
  NS_IMETHOD GetCategoryEntryRaw(const char *aCategory, const char *aEntry, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCategoryEntryRaw(aCategory, aEntry, _retval); } \
  NS_IMETHOD AddCategoryEntry(const char *aCategory, const char *aEntry, const char *aValue, PRBool aPersist, PRBool aReplace, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCategoryEntry(aCategory, aEntry, aValue, aPersist, aReplace, _retval); } \
  NS_IMETHOD DeleteCategoryEntry(const char *aCategory, const char *aEntry, PRBool aPersist) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCategoryEntry(aCategory, aEntry, aPersist); } \
  NS_IMETHOD DeleteCategory(const char *aCategory) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteCategory(aCategory); } \
  NS_IMETHOD EnumerateCategory(const char *aCategory, nsISimpleEnumerator **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnumerateCategory(aCategory, _retval); } \
  NS_IMETHOD GetCategoryContents(const char *category, char ***entries, char ***values, PRUint32 *count) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCategoryContents(category, entries, values, count); } \
  NS_IMETHOD RegisterCategoryHandler(const char *aCategory, nsICategoryHandler *aHandler, PRInt32 aMode, nsICategoryHandler **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterCategoryHandler(aCategory, aHandler, aMode, _retval); } \
  NS_IMETHOD UnregisterCategoryHandler(const char *category, nsICategoryHandler *handler, nsICategoryHandler *previous) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnregisterCategoryHandler(category, handler, previous); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsCategoryManager : public nsICategoryManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICATEGORYMANAGER

  nsCategoryManager();
  virtual ~nsCategoryManager();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsCategoryManager, nsICategoryManager)

nsCategoryManager::nsCategoryManager()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsCategoryManager::~nsCategoryManager()
{
  /* destructor code */
}

/* string getCategoryEntry (in string aCategory, in string aEntry); */
NS_IMETHODIMP nsCategoryManager::GetCategoryEntry(const char *aCategory, const char *aEntry, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getCategoryEntryRaw (in string aCategory, in string aEntry); */
NS_IMETHODIMP nsCategoryManager::GetCategoryEntryRaw(const char *aCategory, const char *aEntry, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string addCategoryEntry (in string aCategory, in string aEntry, in string aValue, in boolean aPersist, in boolean aReplace); */
NS_IMETHODIMP nsCategoryManager::AddCategoryEntry(const char *aCategory, const char *aEntry, const char *aValue, PRBool aPersist, PRBool aReplace, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteCategoryEntry (in string aCategory, in string aEntry, in boolean aPersist); */
NS_IMETHODIMP nsCategoryManager::DeleteCategoryEntry(const char *aCategory, const char *aEntry, PRBool aPersist)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteCategory (in string aCategory); */
NS_IMETHODIMP nsCategoryManager::DeleteCategory(const char *aCategory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISimpleEnumerator enumerateCategory (in string aCategory); */
NS_IMETHODIMP nsCategoryManager::EnumerateCategory(const char *aCategory, nsISimpleEnumerator **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCategoryContents (in string category, [array, size_is (count)] out string entries, [array, size_is (count)] out string values, [retval] out unsigned long count); */
NS_IMETHODIMP nsCategoryManager::GetCategoryContents(const char *category, char ***entries, char ***values, PRUint32 *count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsICategoryHandler registerCategoryHandler (in string aCategory, in nsICategoryHandler aHandler, in long aMode); */
NS_IMETHODIMP nsCategoryManager::RegisterCategoryHandler(const char *aCategory, nsICategoryHandler *aHandler, PRInt32 aMode, nsICategoryHandler **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void unregisterCategoryHandler (in string category, in nsICategoryHandler handler, in nsICategoryHandler previous); */
NS_IMETHODIMP nsCategoryManager::UnregisterCategoryHandler(const char *category, nsICategoryHandler *handler, nsICategoryHandler *previous)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_CATEGORYMANAGER_CONTRACTID     "@mozilla.org/categorymanager;1"
#define NS_CATEGORYMANAGER_CLASSNAME  "Category Manager"
/* 16d222a6-1dd2-11b2-b693-f38b02c021b2 */
#define NS_CATEGORYMANAGER_CID \
{ 0x16d222a6, 0x1dd2, 0x11b2, \
  {0xb6, 0x93, 0xf3, 0x8b, 0x02, 0xc0, 0x21, 0xb2} }
extern "C" NS_EXPORT nsresult NS_CategoryManagerGetFactory( nsIFactory** );
NS_COM nsresult
NS_CreateServicesFromCategory(const char *category,
                              nsISupports *origin,
                              const char *observerTopic);

#endif /* __gen_nsICategoryManager_h__ */
