/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /export/home/sean/sandbox/1.0/mozilla/content/html/content/public/nsISelectElement.idl
 */

#ifndef __gen_nsISelectElement_h__
#define __gen_nsISelectElement_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIContent; /* forward declaration */

class nsIDOMHTMLOptionElement; /* forward declaration */

class nsIPresContext; /* forward declaration */

class nsIPresState; /* forward declaration */


/* starting interface:    nsISelectElement */
#define NS_ISELECTELEMENT_IID_STR "a6cf90f6-15b3-11d2-932e-00805f8add32"

#define NS_ISELECTELEMENT_IID \
  {0xa6cf90f6, 0x15b3, 0x11d2, \
    { 0x93, 0x2e, 0x00, 0x80, 0x5f, 0x8a, 0xdd, 0x32 }}

/** 
 * This interface is used to notify a SELECT when OPTION
 * elements are added and removed from its subtree.
 * Note that the nsIDOMHTMLSelectElement and nsIContent 
 * interfaces are the ones to use to access and enumerate
 * OPTIONs within a SELECT element.
 */
class NS_NO_VTABLE nsISelectElement : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISELECTELEMENT_IID)

  /**
   * To be called when stuff is added under a child of
   * the select--but *before* they are actually added.
   */
  /* [noscript] void willAddOptions (in nsIContent aOptions, in nsIContent aParent, in long aContentIndex); */
  NS_IMETHOD WillAddOptions(nsIContent *aOptions, nsIContent *aParent, PRInt32 aContentIndex) = 0;

  /**
   * To be called when stuff is removed under a child of
   * the select--but *before* they are actually removed.
   */
  /* [noscript] void willRemoveOptions (in nsIContent aParent, in long aContentIndex); */
  NS_IMETHOD WillRemoveOptions(nsIContent *aParent, PRInt32 aContentIndex) = 0;

  /**
   * An OPTION element has been added to the SELECT's
   * subtree.
   */
  /* [noscript] void addOption (in nsIContent aContent); */
  NS_IMETHOD AddOption(nsIContent *aContent) = 0;

  /**
   * An OPTION element has been deleted from the SELECT's
   * subtree.
   */
  /* [noscript] void removeOption (in nsIContent aContent); */
  NS_IMETHOD RemoveOption(nsIContent *aContent) = 0;

  /**
   * Called when the parser is done adding child content
   * to the select during document loading.
   */
  /* void doneAddingChildren (); */
  NS_IMETHOD DoneAddingChildren(void) = 0;

  /**
   * Returns whether the parser is done adding child content
   * to the select during document loading.
   *
   * @return whether the parser is done adding children
   */
  /* boolean isDoneAddingChildren (); */
  NS_IMETHOD IsDoneAddingChildren(PRBool *_retval) = 0;

  /**
   * Returns whether we're the option is selected
   */
  /* boolean isOptionSelected (in nsIDOMHTMLOptionElement aOption); */
  NS_IMETHOD IsOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool *_retval) = 0;

  /**
   * Sets an option selected or delselected
   */
  /* void setOptionSelected (in nsIDOMHTMLOptionElement aOption, in boolean aIsSelected); */
  NS_IMETHOD SetOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool aIsSelected) = 0;

  /**
   * Checks whether an option is disabled (even if it's part of an optgroup)
   */
  /* boolean isOptionDisabled (in long aIndex); */
  NS_IMETHOD IsOptionDisabled(PRInt32 aIndex, PRBool *_retval) = 0;

  /**
   * Sets multiple options (or just sets startIndex if select is single)
   */
  /* boolean setOptionsSelectedByIndex (in long aStartIndex, in long aEndIndex, in boolean aIsSelected, in boolean aClearAll, in boolean aSetDisabled, in boolean aNotify); */
  NS_IMETHOD SetOptionsSelectedByIndex(PRInt32 aStartIndex, PRInt32 aEndIndex, PRBool aIsSelected, PRBool aClearAll, PRBool aSetDisabled, PRBool aNotify, PRBool *_retval) = 0;

  /**
   * Called when an option is disabled
   */
  /* void onOptionDisabled (in nsIDOMHTMLOptionElement aOption); */
  NS_IMETHOD OnOptionDisabled(nsIDOMHTMLOptionElement *aOption) = 0;

  /**
   * Called to save/restore to/from pres. state
   */
  /* [noscript] void saveState (); */
  NS_IMETHOD SaveState(void) = 0;

  /* [noscript] void restoreState (in nsIPresState aState); */
  NS_IMETHOD RestoreState(nsIPresState *aState) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISELECTELEMENT \
  NS_IMETHOD WillAddOptions(nsIContent *aOptions, nsIContent *aParent, PRInt32 aContentIndex); \
  NS_IMETHOD WillRemoveOptions(nsIContent *aParent, PRInt32 aContentIndex); \
  NS_IMETHOD AddOption(nsIContent *aContent); \
  NS_IMETHOD RemoveOption(nsIContent *aContent); \
  NS_IMETHOD DoneAddingChildren(void); \
  NS_IMETHOD IsDoneAddingChildren(PRBool *_retval); \
  NS_IMETHOD IsOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool *_retval); \
  NS_IMETHOD SetOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool aIsSelected); \
  NS_IMETHOD IsOptionDisabled(PRInt32 aIndex, PRBool *_retval); \
  NS_IMETHOD SetOptionsSelectedByIndex(PRInt32 aStartIndex, PRInt32 aEndIndex, PRBool aIsSelected, PRBool aClearAll, PRBool aSetDisabled, PRBool aNotify, PRBool *_retval); \
  NS_IMETHOD OnOptionDisabled(nsIDOMHTMLOptionElement *aOption); \
  NS_IMETHOD SaveState(void); \
  NS_IMETHOD RestoreState(nsIPresState *aState); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISELECTELEMENT(_to) \
  NS_IMETHOD WillAddOptions(nsIContent *aOptions, nsIContent *aParent, PRInt32 aContentIndex) { return _to WillAddOptions(aOptions, aParent, aContentIndex); } \
  NS_IMETHOD WillRemoveOptions(nsIContent *aParent, PRInt32 aContentIndex) { return _to WillRemoveOptions(aParent, aContentIndex); } \
  NS_IMETHOD AddOption(nsIContent *aContent) { return _to AddOption(aContent); } \
  NS_IMETHOD RemoveOption(nsIContent *aContent) { return _to RemoveOption(aContent); } \
  NS_IMETHOD DoneAddingChildren(void) { return _to DoneAddingChildren(); } \
  NS_IMETHOD IsDoneAddingChildren(PRBool *_retval) { return _to IsDoneAddingChildren(_retval); } \
  NS_IMETHOD IsOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool *_retval) { return _to IsOptionSelected(aOption, _retval); } \
  NS_IMETHOD SetOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool aIsSelected) { return _to SetOptionSelected(aOption, aIsSelected); } \
  NS_IMETHOD IsOptionDisabled(PRInt32 aIndex, PRBool *_retval) { return _to IsOptionDisabled(aIndex, _retval); } \
  NS_IMETHOD SetOptionsSelectedByIndex(PRInt32 aStartIndex, PRInt32 aEndIndex, PRBool aIsSelected, PRBool aClearAll, PRBool aSetDisabled, PRBool aNotify, PRBool *_retval) { return _to SetOptionsSelectedByIndex(aStartIndex, aEndIndex, aIsSelected, aClearAll, aSetDisabled, aNotify, _retval); } \
  NS_IMETHOD OnOptionDisabled(nsIDOMHTMLOptionElement *aOption) { return _to OnOptionDisabled(aOption); } \
  NS_IMETHOD SaveState(void) { return _to SaveState(); } \
  NS_IMETHOD RestoreState(nsIPresState *aState) { return _to RestoreState(aState); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISELECTELEMENT(_to) \
  NS_IMETHOD WillAddOptions(nsIContent *aOptions, nsIContent *aParent, PRInt32 aContentIndex) { return !_to ? NS_ERROR_NULL_POINTER : _to->WillAddOptions(aOptions, aParent, aContentIndex); } \
  NS_IMETHOD WillRemoveOptions(nsIContent *aParent, PRInt32 aContentIndex) { return !_to ? NS_ERROR_NULL_POINTER : _to->WillRemoveOptions(aParent, aContentIndex); } \
  NS_IMETHOD AddOption(nsIContent *aContent) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddOption(aContent); } \
  NS_IMETHOD RemoveOption(nsIContent *aContent) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveOption(aContent); } \
  NS_IMETHOD DoneAddingChildren(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoneAddingChildren(); } \
  NS_IMETHOD IsDoneAddingChildren(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsDoneAddingChildren(_retval); } \
  NS_IMETHOD IsOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsOptionSelected(aOption, _retval); } \
  NS_IMETHOD SetOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool aIsSelected) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOptionSelected(aOption, aIsSelected); } \
  NS_IMETHOD IsOptionDisabled(PRInt32 aIndex, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsOptionDisabled(aIndex, _retval); } \
  NS_IMETHOD SetOptionsSelectedByIndex(PRInt32 aStartIndex, PRInt32 aEndIndex, PRBool aIsSelected, PRBool aClearAll, PRBool aSetDisabled, PRBool aNotify, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOptionsSelectedByIndex(aStartIndex, aEndIndex, aIsSelected, aClearAll, aSetDisabled, aNotify, _retval); } \
  NS_IMETHOD OnOptionDisabled(nsIDOMHTMLOptionElement *aOption) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnOptionDisabled(aOption); } \
  NS_IMETHOD SaveState(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->SaveState(); } \
  NS_IMETHOD RestoreState(nsIPresState *aState) { return !_to ? NS_ERROR_NULL_POINTER : _to->RestoreState(aState); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSelectElement : public nsISelectElement
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISELECTELEMENT

  nsSelectElement();
  virtual ~nsSelectElement();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSelectElement, nsISelectElement)

nsSelectElement::nsSelectElement()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSelectElement::~nsSelectElement()
{
  /* destructor code */
}

/* [noscript] void willAddOptions (in nsIContent aOptions, in nsIContent aParent, in long aContentIndex); */
NS_IMETHODIMP nsSelectElement::WillAddOptions(nsIContent *aOptions, nsIContent *aParent, PRInt32 aContentIndex)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void willRemoveOptions (in nsIContent aParent, in long aContentIndex); */
NS_IMETHODIMP nsSelectElement::WillRemoveOptions(nsIContent *aParent, PRInt32 aContentIndex)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addOption (in nsIContent aContent); */
NS_IMETHODIMP nsSelectElement::AddOption(nsIContent *aContent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void removeOption (in nsIContent aContent); */
NS_IMETHODIMP nsSelectElement::RemoveOption(nsIContent *aContent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doneAddingChildren (); */
NS_IMETHODIMP nsSelectElement::DoneAddingChildren()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isDoneAddingChildren (); */
NS_IMETHODIMP nsSelectElement::IsDoneAddingChildren(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isOptionSelected (in nsIDOMHTMLOptionElement aOption); */
NS_IMETHODIMP nsSelectElement::IsOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setOptionSelected (in nsIDOMHTMLOptionElement aOption, in boolean aIsSelected); */
NS_IMETHODIMP nsSelectElement::SetOptionSelected(nsIDOMHTMLOptionElement *aOption, PRBool aIsSelected)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isOptionDisabled (in long aIndex); */
NS_IMETHODIMP nsSelectElement::IsOptionDisabled(PRInt32 aIndex, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean setOptionsSelectedByIndex (in long aStartIndex, in long aEndIndex, in boolean aIsSelected, in boolean aClearAll, in boolean aSetDisabled, in boolean aNotify); */
NS_IMETHODIMP nsSelectElement::SetOptionsSelectedByIndex(PRInt32 aStartIndex, PRInt32 aEndIndex, PRBool aIsSelected, PRBool aClearAll, PRBool aSetDisabled, PRBool aNotify, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onOptionDisabled (in nsIDOMHTMLOptionElement aOption); */
NS_IMETHODIMP nsSelectElement::OnOptionDisabled(nsIDOMHTMLOptionElement *aOption)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void saveState (); */
NS_IMETHODIMP nsSelectElement::SaveState()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void restoreState (in nsIPresState aState); */
NS_IMETHODIMP nsSelectElement::RestoreState(nsIPresState *aState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsISelectElement_h__ */
