#*************************************************************************
#
#   $RCSfile$
#
#   $Revision$
#
#   last change: $Author$ $Date$
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJ=.

PRJNAME=ooo_boost
TARGET=ooo_boost

# --- Settings -----------------------------------------------------

.INCLUDE :	settings.mk

# --- Files --------------------------------------------------------

TARFILE_NAME=boost_1_27_0
TARFILE_ROOTDIR=boost_1_27_0

PATCH_FILE_NAME=RE.boost_1_27_0.patch

# TODO: There is a bug in the solenv/inc/*.mk child dmake calls, which don't
# pass the original makefile name, a $(MAKEFILE) is missing there, a $(MFLAGS)
# is not sufficient. If that is fixed we should use ooo_makefile.mk instead,
# who knows if when and how the name makefile.mk might be used in future by the
# Boost library.
ADDITIONAL_FILES= \
	libs$/regex$/src$/makefile.mk \
	libs$/regex$/src$/ooo_bregex.dxp

CONFIGURE_DIR=
CONFIGURE_ACTION=

# Note that this simple dmake mechanism is only feasible because we build a
# single directory. If we wanted to use more of the Boost sublibraries we
# should use the Boost Jam build mechanism instead. However, building the Boost
# Jam doesn't work in our environment right away, because it wants to be built
# single threaded but STLport only knows multi threaded.
BUILD_DIR=libs$/regex$/src
BUILD_ACTION=$(MAKECMD)
BUILD_FLAGS= -f makefile.mk $(MFLAGS) $(CALLMACROS)

.IF "$(GUI)"=="UNX"

.IF "$(COMNAME)"=="sunpro5"
CC:=$(COMPATH)$/bin$/cc
CXX:=$(COMPATH)$/bin$/CC
.ENDIF          # "$(COMNAME)"=="sunpro5"

.IF "$(COMNAME)"=="gcc3"
CC:=$(COMPATH)$/bin$/gcc3
CXX:=$(COMPATH)$/bin$/g++3
.ENDIF          # "$(COMNAME)"=="gcc3"

.EXPORT : CC CXX

.ENDIF

# --- Targets ------------------------------------------------------

all: \
	$(MISC)$/remove_build.flag \
	ALLTAR
	
.INCLUDE : set_ext.mk
.INCLUDE : target.mk
.INCLUDE : tg_ext.mk

TG_DELIVER : $(PACKAGE_DIR)$/$(PREDELIVER_FLAG_FILE)
		$(DELIVER)

# Since you never know what will be in a patch (for example, it may already
# patch at configure level), we remove the entire package directory if a patch
# is newer.
# We build into our own output directories, remove those things too, but not
# recursively.
$(MISC)$/remove_build.flag : $(PATCH_FILE_NAME)
	$(REMOVE_PACKAGE_COMMAND)
	+-$(RM) $(SLO)$/* >& $(NULLDEV)
	+-$(RM) $(OBJ)$/* >& $(NULLDEV)
	+-$(RM) $(SLB)$/* >& $(NULLDEV)
	+-$(RM) $(LB)$/* >& $(NULLDEV)
	+-$(RM) $(BIN)$/* >& $(NULLDEV)
	+-$(RM) $(MISC)$/* >& $(NULLDEV)
	+$(TOUCH) $(MISC)$/remove_build.flag

.IF "$(BUILD_SOSL)"!=""
ALLTAR : TG_DELIVER
.ENDIF

