/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/mozilla/editor/idl/nsIEditorStyleSheets.idl
 */

#ifndef __gen_nsIEditorStyleSheets_h__
#define __gen_nsIEditorStyleSheets_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsICSSStyleSheet;

/* starting interface:    nsIEditorStyleSheets */
#define NS_IEDITORSTYLESHEETS_IID_STR "4805e682-49b9-11d3-9ce4-ed60bd6cb5bc"

#define NS_IEDITORSTYLESHEETS_IID \
  {0x4805e682, 0x49b9, 0x11d3, \
    { 0x9c, 0xe4, 0xed, 0x60, 0xbd, 0x6c, 0xb5, 0xbc }}

class NS_NO_VTABLE nsIEditorStyleSheets : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IEDITORSTYLESHEETS_IID)

  /** load and apply the style sheet, specified by aURL, to
    * the editor's document. This can involve asynchronous
    * network I/O
    * @param aURL         The style sheet to be loaded and applied.
    * @return             the style sheet created from aURL
    */
  /* [noscript] nsICSSStyleSheet applyStyleSheet (in AString aURL); */
  NS_IMETHOD ApplyStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval) = 0;

  /** load and apply an Override style sheet, specified by aURL, to
    * the editor's document. 
    * IMPORTANT: This is assumed to be synchronous:
    *            URL is a local file with no @import used
    * This action is not undoable.
    * It is not intended for use by "user", only editor developers
    *   to change display behavior for editing (like showing special cursors)
    *   that will not be affected by loading other "document" style sheets
    *   loaded using ApplyStyleSheet.
    *
    * @param aURL         The style sheet to be loaded and applied.
    * @return             the style sheet created from aURL
    */
  /* [noscript] nsICSSStyleSheet applyOverrideStyleSheet (in AString aURL); */
  NS_IMETHOD ApplyOverrideStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval) = 0;

  /** Add the given Style Sheet to the editor's document
    * This is always synchronous
    * @param aSheet  The style sheet to be  applied.
    */
  /* [noscript] void addStyleSheet (in nsICSSStyleSheet aSheet); */
  NS_IMETHOD AddStyleSheet(nsICSSStyleSheet * aSheet) = 0;

  /** Remove the given Style Sheet from the editor's document
    * This is always synchronous
    * @param aSheet  The style sheet to be removed
    */
  /* [noscript] void removeStyleSheet (in nsICSSStyleSheet aSheet); */
  NS_IMETHOD RemoveStyleSheet(nsICSSStyleSheet * aSheet) = 0;

  /** Remove the given Override Style Sheet from the editor's document
    * This is always synchronous
    * @param aSheet  The style sheet to be removed.
    */
  /* [noscript] void removeOverrideStyleSheet (in nsICSSStyleSheet aSheet); */
  NS_IMETHOD RemoveOverrideStyleSheet(nsICSSStyleSheet * aSheet) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIEDITORSTYLESHEETS \
  NS_IMETHOD ApplyStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval); \
  NS_IMETHOD ApplyOverrideStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval); \
  NS_IMETHOD AddStyleSheet(nsICSSStyleSheet * aSheet); \
  NS_IMETHOD RemoveStyleSheet(nsICSSStyleSheet * aSheet); \
  NS_IMETHOD RemoveOverrideStyleSheet(nsICSSStyleSheet * aSheet); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIEDITORSTYLESHEETS(_to) \
  NS_IMETHOD ApplyStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval) { return _to ApplyStyleSheet(aURL, _retval); } \
  NS_IMETHOD ApplyOverrideStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval) { return _to ApplyOverrideStyleSheet(aURL, _retval); } \
  NS_IMETHOD AddStyleSheet(nsICSSStyleSheet * aSheet) { return _to AddStyleSheet(aSheet); } \
  NS_IMETHOD RemoveStyleSheet(nsICSSStyleSheet * aSheet) { return _to RemoveStyleSheet(aSheet); } \
  NS_IMETHOD RemoveOverrideStyleSheet(nsICSSStyleSheet * aSheet) { return _to RemoveOverrideStyleSheet(aSheet); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIEDITORSTYLESHEETS(_to) \
  NS_IMETHOD ApplyStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ApplyStyleSheet(aURL, _retval); } \
  NS_IMETHOD ApplyOverrideStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ApplyOverrideStyleSheet(aURL, _retval); } \
  NS_IMETHOD AddStyleSheet(nsICSSStyleSheet * aSheet) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddStyleSheet(aSheet); } \
  NS_IMETHOD RemoveStyleSheet(nsICSSStyleSheet * aSheet) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveStyleSheet(aSheet); } \
  NS_IMETHOD RemoveOverrideStyleSheet(nsICSSStyleSheet * aSheet) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveOverrideStyleSheet(aSheet); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsEditorStyleSheets : public nsIEditorStyleSheets
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIEDITORSTYLESHEETS

  nsEditorStyleSheets();
  virtual ~nsEditorStyleSheets();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsEditorStyleSheets, nsIEditorStyleSheets)

nsEditorStyleSheets::nsEditorStyleSheets()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsEditorStyleSheets::~nsEditorStyleSheets()
{
  /* destructor code */
}

/* [noscript] nsICSSStyleSheet applyStyleSheet (in AString aURL); */
NS_IMETHODIMP nsEditorStyleSheets::ApplyStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] nsICSSStyleSheet applyOverrideStyleSheet (in AString aURL); */
NS_IMETHODIMP nsEditorStyleSheets::ApplyOverrideStyleSheet(const nsAString & aURL, nsICSSStyleSheet * *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void addStyleSheet (in nsICSSStyleSheet aSheet); */
NS_IMETHODIMP nsEditorStyleSheets::AddStyleSheet(nsICSSStyleSheet * aSheet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void removeStyleSheet (in nsICSSStyleSheet aSheet); */
NS_IMETHODIMP nsEditorStyleSheets::RemoveStyleSheet(nsICSSStyleSheet * aSheet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] void removeOverrideStyleSheet (in nsICSSStyleSheet aSheet); */
NS_IMETHODIMP nsEditorStyleSheets::RemoveOverrideStyleSheet(nsICSSStyleSheet * aSheet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIEditorStyleSheets_h__ */
