/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.DocumentDeserializerFactory;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.DocumentMergerFactory;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.DocumentSerializerFactory;
import org.openoffice.xmerge.PluginFactory;
import org.openoffice.xmerge.converter.dom.DOMDocument;
import org.openoffice.xmerge.converter.xml.xslt.ConverterCapabilitiesImpl;
import org.openoffice.xmerge.converter.xml.xslt.DocumentDeserializerImpl;
import org.openoffice.xmerge.converter.xml.xslt.DocumentMergerImpl;
import org.openoffice.xmerge.converter.xml.xslt.DocumentSerializerImpl;
import org.openoffice.xmerge.converter.xml.xslt.GenericOfficeDocument;
import org.openoffice.xmerge.util.registry.ConverterInfo;

public final class PluginFactoryImpl
extends PluginFactory
implements DocumentDeserializerFactory,
DocumentSerializerFactory,
DocumentMergerFactory {
    private static final ConverterCapabilities converterCap = new ConverterCapabilitiesImpl();

    public PluginFactoryImpl(ConverterInfo converterInfo) {
        super(converterInfo);
    }

    public Document createDeviceDocument(String string, InputStream inputStream) throws IOException {
        String string2 = this.getDeviceFileExtension();
        DOMDocument dOMDocument = new DOMDocument(string, string2);
        dOMDocument.read(inputStream);
        return dOMDocument;
    }

    public DocumentDeserializer createDocumentDeserializer(ConvertData convertData) {
        return new DocumentDeserializerImpl(this, convertData);
    }

    public DocumentMerger createDocumentMerger(Document document) {
        ConverterCapabilities converterCapabilities = converterCap;
        DocumentMergerImpl documentMergerImpl = new DocumentMergerImpl(document, converterCapabilities);
        return documentMergerImpl;
    }

    public DocumentSerializer createDocumentSerializer(Document document) {
        return new DocumentSerializerImpl(this, document);
    }

    public Document createOfficeDocument(String string, InputStream inputStream) throws IOException {
        GenericOfficeDocument genericOfficeDocument = new GenericOfficeDocument(string);
        genericOfficeDocument.read(inputStream);
        return genericOfficeDocument;
    }

    public Document createOfficeDocument(String string, InputStream inputStream, boolean bl) throws IOException {
        GenericOfficeDocument genericOfficeDocument = new GenericOfficeDocument(string);
        genericOfficeDocument.read(inputStream, bl);
        return genericOfficeDocument;
    }

    public String getDeviceFileExtension() {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("XsltPlugin.properties");
        Properties properties = new Properties();
        String string = ".txt";
        String string2 = null;
        ConverterInfo converterInfo = this.getConverterInfo();
        Enumeration enumeration = converterInfo.getDeviceMime();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
        }
        try {
            properties.load(inputStream);
            String string3 = properties.getProperty(string2);
            if (string3 != null) {
                string = string3;
            }
        }
        catch (Exception exception) {}
        return string;
    }
}

