/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.Vector;
import org.openoffice.xmerge.merger.DiffAlgorithm;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.util.Debug;

public class IteratorLCSAlgorithm
implements DiffAlgorithm {
    public Difference[] computeDiffs(Iterator iterator, Iterator iterator2) {
        int n = iterator.elementCount();
        int n2 = iterator2.elementCount();
        int[][] nArray = this.createDiffTable(iterator, iterator2);
        if (Debug.isFlagSet(1)) {
            this.printDiffTable(nArray);
        }
        Vector vector = new Vector();
        this.generateResult(nArray, n, n2, vector);
        Object[] objectArray = new Difference[]{};
        if (vector.size() > 0) {
            objectArray = new Difference[vector.size()];
            vector.copyInto(objectArray);
        }
        nArray = null;
        vector = null;
        return objectArray;
    }

    private int[][] createDiffTable(Iterator iterator, Iterator iterator2) {
        int n = iterator.elementCount() + 1;
        int n2 = iterator2.elementCount() + 1;
        int[][] nArray = new int[n][];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = new int[n2];
            ++n3;
        }
        Object object = iterator.start();
        int n4 = 1;
        while (object != null) {
            Object object2 = iterator2.start();
            int n5 = 1;
            while (object2 != null) {
                nArray[n4][n5] = iterator.equivalent(object, object2) ? nArray[n4 - 1][n5 - 1] + 1 : (nArray[n4 - 1][n5] >= nArray[n4][n5 - 1] ? nArray[n4 - 1][n5] : nArray[n4][n5 - 1]);
                object2 = iterator2.next();
                ++n5;
            }
            object = iterator.next();
            ++n4;
        }
        return nArray;
    }

    private void generateResult(int[][] nArray, int n, int n2, Vector vector) {
        if (n == 0 && n2 == 0) {
            return;
        }
        if (n2 == 0) {
            int n3 = 0;
            while (n3 < n) {
                Difference difference = new Difference(2, n3, n2);
                vector.add(difference);
                ++n3;
            }
            return;
        }
        if (n == 0) {
            int n4 = 0;
            while (n4 < n2) {
                Difference difference = new Difference(1, n, n4);
                vector.add(difference);
                ++n4;
            }
            return;
        }
        if (nArray[n - 1][n2 - 1] == nArray[n][n2] - 1 && nArray[n - 1][n2 - 1] == nArray[n - 1][n2] && nArray[n - 1][n2 - 1] == nArray[n][n2 - 1]) {
            this.generateResult(nArray, n - 1, n2 - 1, vector);
        } else if (nArray[n - 1][n2] > nArray[n][n2 - 1]) {
            this.generateResult(nArray, n - 1, n2, vector);
            Difference difference = new Difference(2, n - 1, n2);
            vector.add(difference);
        } else if (nArray[n - 1][n2] < nArray[n][n2 - 1]) {
            this.generateResult(nArray, n, n2 - 1, vector);
            Difference difference = new Difference(1, n, n2 - 1);
            vector.add(difference);
        } else {
            this.generateResult(nArray, n - 1, n2 - 1, vector);
            Difference difference = new Difference(3, n - 1, n2 - 1);
            vector.add(difference);
        }
    }

    private void printDiffTable(int[][] nArray) {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                string = String.valueOf(string) + " " + nArray[n][n2] + " ";
                ++n2;
            }
            Debug.log(1, string);
            string = "";
            ++n;
        }
    }
}

