/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.MergeException;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.merger.NodeMergeAlgorithm;
import org.openoffice.xmerge.merger.diff.IteratorLCSAlgorithm;
import org.openoffice.xmerge.merger.diff.ParaNodeIterator;
import org.openoffice.xmerge.merger.merge.CharacterBaseParagraphMerge;
import org.openoffice.xmerge.merger.merge.DocumentMerge;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Node;

public class DocumentMergerImpl
implements DocumentMerger {
    private ConverterCapabilities cc_;
    private Document orig = null;

    public DocumentMergerImpl(Document doc, ConverterCapabilities cc) {
        this.cc_ = cc;
        this.orig = doc;
    }

    public void merge(Document modifiedDoc) throws MergeException {
        SxwDocument wdoc1 = (SxwDocument)this.orig;
        SxwDocument wdoc2 = (SxwDocument)modifiedDoc;
        org.w3c.dom.Document doc1 = wdoc1.getContentDOM();
        org.w3c.dom.Document doc2 = wdoc2.getContentDOM();
        ParaNodeIterator i1 = new ParaNodeIterator(this.cc_, (Node)doc1.getDocumentElement());
        ParaNodeIterator i2 = new ParaNodeIterator(this.cc_, (Node)doc2.getDocumentElement());
        IteratorLCSAlgorithm diffAlgo = new IteratorLCSAlgorithm();
        Difference[] diffTable = diffAlgo.computeDiffs((Iterator)i1, (Iterator)i2);
        if (Debug.isFlagSet((int)1)) {
            Debug.log((int)1, (String)"Diff Result: ");
            int i = 0;
            while (i < diffTable.length) {
                Debug.log((int)1, (String)diffTable[i].debug());
                ++i;
            }
        }
        CharacterBaseParagraphMerge charMerge = new CharacterBaseParagraphMerge();
        DocumentMerge docMerge = new DocumentMerge(this.cc_, (NodeMergeAlgorithm)charMerge);
        Object result = null;
        docMerge.applyDifference((Iterator)i1, (Iterator)i2, diffTable);
    }
}

