/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.HighLowToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    private double candleWidth;
    private Paint upPaint;
    private Paint downPaint;
    private boolean drawVolume;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d) {
        this(d, true, new HighLowToolTipGenerator());
    }

    public CandlestickRenderer(double d, boolean bl, XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
        this.candleWidth = d;
        this.drawVolume = bl;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double d) {
        if (d != this.candleWidth) {
            Double d2 = new Double(this.candleWidth);
            this.candleWidth = d;
            this.firePropertyChanged("CandleStickRenderer.candleWidth", d2, new Double(d));
        }
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.upPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.upPaint", paint2, paint);
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.downPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.downPaint", paint2, paint);
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean bl) {
        if (this.drawVolume != bl) {
            this.drawVolume = bl;
            this.firePropertyChanged("CandlestickRenderer.drawVolume", null, new Boolean(bl));
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.getXValue(n, n2);
        Number number2 = highLowDataset.getHighValue(n, n2);
        Number number3 = highLowDataset.getLowValue(n, n2);
        Number number4 = highLowDataset.getOpenValue(n, n2);
        Number number5 = highLowDataset.getCloseValue(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
        double d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D);
        double d6 = this.candleWidth;
        double d7 = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int n3 = highLowDataset.getItemCount(n);
            d6 = (rectangle2D.getMaxX() - rectangle2D.getMinX()) / (double)n3 * 4.5 / 7.0;
            if (d6 < 1.0) {
                d6 = 1.0;
            }
            if ((d7 = d6) < 3.0) {
                d7 = 3.0;
            }
        }
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            int n4 = highLowDataset.getVolumeValue(n, n2).intValue();
            int n5 = 1;
            int n6 = highLowDataset.getItemCount(n);
            int n7 = 0;
            while (n7 < n6) {
                int n8 = highLowDataset.getVolumeValue(n, n7).intValue();
                if (n8 > n5) {
                    n5 = n8;
                }
                ++n7;
            }
            double d8 = (double)n4 / (double)n5;
            double d9 = rectangle2D.getMinY();
            double d10 = rectangle2D.getMaxY();
            double d11 = d8 * (d10 - d9);
            graphics2D.setPaint(Color.gray);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(new Rectangle2D.Double(d - d6 / 2.0, d10 - d11, d6, d11));
            graphics2D.setComposite(composite);
        }
        graphics2D.setPaint(paint);
        if (d2 < d4 && d2 < d5) {
            graphics2D.draw(new Line2D.Double(d, d2, d, Math.min(d4, d5)));
        }
        if (d3 > d4 && d3 > d5) {
            graphics2D.draw(new Line2D.Double(d, d3, d, Math.max(d4, d5)));
        }
        Rectangle2D.Double double_ = null;
        if (d4 > d5) {
            double_ = new Rectangle2D.Double(d - d7 / 2.0, d5, d7, d4 - d5);
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
                graphics2D.fill(double_);
            }
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        } else {
            double_ = new Rectangle2D.Double(d - d7 / 2.0, d4, d7, d5 - d4);
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            }
            graphics2D.fill(double_);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        if (entityCollection != null) {
            String string = "";
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, string, string2, n, n2);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

