/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/mozilla/content/base/public/nsIDragDropOverride.idl
 */

#ifndef __gen_nsIDragDropOverride_h__
#define __gen_nsIDragDropOverride_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMEventTarget; /* forward declaration */

class nsIWebNavigation; /* forward declaration */

class nsITransferable; /* forward declaration */

class nsIDragSession; /* forward declaration */

class nsIDOMEvent; /* forward declaration */


/* starting interface:    nsIOverrideDragSource */
#define NS_IOVERRIDEDRAGSOURCE_IID_STR "e03e6c5e-0d84-4c0b-8739-e6b8d51922de"

#define NS_IOVERRIDEDRAGSOURCE_IID \
  {0xe03e6c5e, 0x0d84, 0x4c0b, \
    { 0x87, 0x39, 0xe6, 0xb8, 0xd5, 0x19, 0x22, 0xde }}

/**
 * @status UNDER_REVIEW
 */
/**
 * Interfaces for overriding the built-in drag and drop
 * implementation in the content area. Use this to do things
 * such as prevent a drag from starting, adding or removing
 * data and flavors, or preventing the drop.
 */
/**
 * Overrides operations at the source of a drag. Can prevent
 * drag from starting and can modify what flavors/data are
 * presented to the OS.
 */
class NS_NO_VTABLE nsIOverrideDragSource : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IOVERRIDEDRAGSOURCE_IID)

  /**
   * Prevents the drag from starting
   *
   * @param event DOM event (drag gesture)
   *
   * @return TRUE  drag can proceed
   * @return FALSE drag is cancelled, does not go to OS
   */
  /* boolean allowStart (in nsIDOMEvent event); */
  NS_IMETHOD AllowStart(nsIDOMEvent *event, PRBool *_retval) = 0;

  /**
   * Alter the flavors or data presented to the OS
   *
   * @param trans the transferable holding the list of flavors
   *               and the data for each flavor
   */
  /* void modify (in nsITransferable trans); */
  NS_IMETHOD Modify(nsITransferable *trans) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIOVERRIDEDRAGSOURCE \
  NS_IMETHOD AllowStart(nsIDOMEvent *event, PRBool *_retval); \
  NS_IMETHOD Modify(nsITransferable *trans); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIOVERRIDEDRAGSOURCE(_to) \
  NS_IMETHOD AllowStart(nsIDOMEvent *event, PRBool *_retval) { return _to AllowStart(event, _retval); } \
  NS_IMETHOD Modify(nsITransferable *trans) { return _to Modify(trans); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIOVERRIDEDRAGSOURCE(_to) \
  NS_IMETHOD AllowStart(nsIDOMEvent *event, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AllowStart(event, _retval); } \
  NS_IMETHOD Modify(nsITransferable *trans) { return !_to ? NS_ERROR_NULL_POINTER : _to->Modify(trans); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsOverrideDragSource : public nsIOverrideDragSource
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIOVERRIDEDRAGSOURCE

  nsOverrideDragSource();
  virtual ~nsOverrideDragSource();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsOverrideDragSource, nsIOverrideDragSource)

nsOverrideDragSource::nsOverrideDragSource()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsOverrideDragSource::~nsOverrideDragSource()
{
  /* destructor code */
}

/* boolean allowStart (in nsIDOMEvent event); */
NS_IMETHODIMP nsOverrideDragSource::AllowStart(nsIDOMEvent *event, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void modify (in nsITransferable trans); */
NS_IMETHODIMP nsOverrideDragSource::Modify(nsITransferable *trans)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIOverrideDropSite */
#define NS_IOVERRIDEDROPSITE_IID_STR "a0ea9862-e2e6-4fd7-8cab-72afeb53c793"

#define NS_IOVERRIDEDROPSITE_IID \
  {0xa0ea9862, 0xe2e6, 0x4fd7, \
    { 0x8c, 0xab, 0x72, 0xaf, 0xeb, 0x53, 0xc7, 0x93 }}

/**
 * Overrides operations at the destination of a drag. Can prevent
 * drag from completing and provide an alternative action than
 * the built-in behavior for a drop.
 */
class NS_NO_VTABLE nsIOverrideDropSite : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IOVERRIDEDROPSITE_IID)

  /**
   * Tells the OS a drop is not allowed on this browser
   *
   * @param event   DOM event (drag over)
   * @param session the drag session from which client can get
   *                   the flavors present or the actual data
   *
   * @return TRUE  indicates to OS that if a drop does happen on this
   *                browser, it will be accepted.
   * @return FALSE indicates to OS drop is not allowed. On win32, this
   *                will change the cursor to "reject".
   */
  /* boolean allowDrop (in nsIDOMEvent event, in nsIDragSession session); */
  NS_IMETHOD AllowDrop(nsIDOMEvent *event, nsIDragSession *session, PRBool *_retval) = 0;

  /**
   * Provide an alternative action to the built-in behavior when
   * something is dropped on the browser
   *
   * @param event DOM event (drag drop)
   * @param trans the transferable holding the list of flavors
   *               and the data for each flavor
   *
   * @return TRUE  action was handled, do not perform built-in
   *                behavior
   * @return FALSE action was not overridden, do built-in behavior
   */
  /* boolean dropAction (in nsIDOMEvent event, in nsITransferable trans); */
  NS_IMETHOD DropAction(nsIDOMEvent *event, nsITransferable *trans, PRBool *_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIOVERRIDEDROPSITE \
  NS_IMETHOD AllowDrop(nsIDOMEvent *event, nsIDragSession *session, PRBool *_retval); \
  NS_IMETHOD DropAction(nsIDOMEvent *event, nsITransferable *trans, PRBool *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIOVERRIDEDROPSITE(_to) \
  NS_IMETHOD AllowDrop(nsIDOMEvent *event, nsIDragSession *session, PRBool *_retval) { return _to AllowDrop(event, session, _retval); } \
  NS_IMETHOD DropAction(nsIDOMEvent *event, nsITransferable *trans, PRBool *_retval) { return _to DropAction(event, trans, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIOVERRIDEDROPSITE(_to) \
  NS_IMETHOD AllowDrop(nsIDOMEvent *event, nsIDragSession *session, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AllowDrop(event, session, _retval); } \
  NS_IMETHOD DropAction(nsIDOMEvent *event, nsITransferable *trans, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->DropAction(event, trans, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsOverrideDropSite : public nsIOverrideDropSite
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIOVERRIDEDROPSITE

  nsOverrideDropSite();
  virtual ~nsOverrideDropSite();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsOverrideDropSite, nsIOverrideDropSite)

nsOverrideDropSite::nsOverrideDropSite()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsOverrideDropSite::~nsOverrideDropSite()
{
  /* destructor code */
}

/* boolean allowDrop (in nsIDOMEvent event, in nsIDragSession session); */
NS_IMETHODIMP nsOverrideDropSite::AllowDrop(nsIDOMEvent *event, nsIDragSession *session, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean dropAction (in nsIDOMEvent event, in nsITransferable trans); */
NS_IMETHODIMP nsOverrideDropSite::DropAction(nsIDOMEvent *event, nsITransferable *trans, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIDragDropOverride_h__ */
