/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIDownloadManager.idl
 */

#ifndef __gen_nsIDownloadManager_h__
#define __gen_nsIDownloadManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMWindow; /* forward declaration */

class nsIURI; /* forward declaration */

class nsILocalFile; /* forward declaration */

class nsIDownload; /* forward declaration */

class nsIWebBrowserPersist; /* forward declaration */


/* starting interface:    nsIDownloadManager */
#define NS_IDOWNLOADMANAGER_IID_STR "9be66cc0-1dd1-11b2-8617-e3a3ed26e3b0"

#define NS_IDOWNLOADMANAGER_IID \
  {0x9be66cc0, 0x1dd1, 0x11b2, \
    { 0x86, 0x17, 0xe3, 0xa3, 0xed, 0x26, 0xe3, 0xb0 }}

class NS_NO_VTABLE nsIDownloadManager : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IDOWNLOADMANAGER_IID)

  /**
  * Creates an nsIDownload and adds it to be managed by the download manager.
  *
  * @param aSource The source (nsIURI) of the download.
  *
  * @param aTarget The local file to which the download is being saved.
  *
  * @param aDisplayName The user-readable description of the download.
  *
  * @param aPersist The "persist" used to transfer the download.  If set,
  *                 the manager will set its listener to the download item
  *                 and use it for cancellation.  If not set, the client
  *                 is expected to set the download item as the listener on
  *                 whatever transfer component is being used, and to
  *                 set an observer on the download item that listens for
  *                 the "oncancel" topic and cancels the download.
  *
  * @return The newly created download item with the passed-in properties.
  */
  /* nsIDownload addDownload (in nsIURI aSource, in nsILocalFile aTarget, in wstring aDisplayName, in wstring openingWith, in long long startTime, in nsIWebBrowserPersist aPersist); */
  NS_IMETHOD AddDownload(nsIURI *aSource, nsILocalFile *aTarget, const PRUnichar *aDisplayName, const PRUnichar *openingWith, PRInt64 startTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval) = 0;

  /**
  *  Retrieves an in-progress download managed by the download manager.
  *
  *  @param aPersistentDescriptor The unique identifier used to describe a
  *                               a download, and an attribute of nsILocalFile.
  *                               On Windows and Linux, this is just the path
  *                               of the target, but on Mac this is guaranteed
  *                               to be unique.
  *
  *  @return The download with the specified persistent descriptor.
  */
  /* nsIDownload getDownload (in string aPersistentDescriptor); */
  NS_IMETHOD GetDownload(const char *aPersistentDescriptor, nsIDownload **_retval) = 0;

  /**
  * Cancels the download with the specified persistent descriptor if it's
  * currently in progress.  If a "persist" was specified for the download,
  * nsIWebBrowserPersist::CancelSave will be called.  If an observer was set
  * on the nsIDownload, it will be notified with the "oncancel" topic.  Clients
  * that don't provide a "persist" must listen for this topic and cancel the
  * download.
  *
  * @param aPersistentDescriptor The persistent descriptor of the download to
  *                              be cancelled.
  */
  /* void cancelDownload (in string aPersistentDescriptor); */
  NS_IMETHOD CancelDownload(const char *aPersistentDescriptor) = 0;

  /**
  * Removes the download with the specified persistent descriptor if it's not
  * currently in progress.  Whereas cancelDownload simply cancels the transfer
  * but retains information about it, removeDownload removes all knowledge of it.
  *
  * @param aPersistentDescriptor The persistent descriptor of the download to
  *                              be removed.
  */
  /* void removeDownload (in string aPersistentDescriptor); */
  NS_IMETHOD RemoveDownload(const char *aPersistentDescriptor) = 0;

  /**
  * Opens the Download Manager front end.
  *
  * @param aParent The parent, or opener, of the front end (optional).
  */
  /* void open (in nsIDOMWindow aParent); */
  NS_IMETHOD Open(nsIDOMWindow *aParent) = 0;

  /**
  * Opens an individual progress dialog displaying progress for the download.
  *
  * @param aPersistentDescriptor The persistent descriptor of the download to
  *                              display progress for.
  *
  * @param aParent The parent, or opener, of the front end (optional).
  */
  /* void openProgressDialogFor (in string aPersistentDescriptor, in nsIDOMWindow aParent); */
  NS_IMETHOD OpenProgressDialogFor(const char *aPersistentDescriptor, nsIDOMWindow *aParent) = 0;

  /**
  * Called when the download manager front end is closed.  Useful for
  * third party managers to let us know when they've closed.
  */
  /* void onClose (); */
  NS_IMETHOD OnClose(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOWNLOADMANAGER \
  NS_IMETHOD AddDownload(nsIURI *aSource, nsILocalFile *aTarget, const PRUnichar *aDisplayName, const PRUnichar *openingWith, PRInt64 startTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval); \
  NS_IMETHOD GetDownload(const char *aPersistentDescriptor, nsIDownload **_retval); \
  NS_IMETHOD CancelDownload(const char *aPersistentDescriptor); \
  NS_IMETHOD RemoveDownload(const char *aPersistentDescriptor); \
  NS_IMETHOD Open(nsIDOMWindow *aParent); \
  NS_IMETHOD OpenProgressDialogFor(const char *aPersistentDescriptor, nsIDOMWindow *aParent); \
  NS_IMETHOD OnClose(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOWNLOADMANAGER(_to) \
  NS_IMETHOD AddDownload(nsIURI *aSource, nsILocalFile *aTarget, const PRUnichar *aDisplayName, const PRUnichar *openingWith, PRInt64 startTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval) { return _to AddDownload(aSource, aTarget, aDisplayName, openingWith, startTime, aPersist, _retval); } \
  NS_IMETHOD GetDownload(const char *aPersistentDescriptor, nsIDownload **_retval) { return _to GetDownload(aPersistentDescriptor, _retval); } \
  NS_IMETHOD CancelDownload(const char *aPersistentDescriptor) { return _to CancelDownload(aPersistentDescriptor); } \
  NS_IMETHOD RemoveDownload(const char *aPersistentDescriptor) { return _to RemoveDownload(aPersistentDescriptor); } \
  NS_IMETHOD Open(nsIDOMWindow *aParent) { return _to Open(aParent); } \
  NS_IMETHOD OpenProgressDialogFor(const char *aPersistentDescriptor, nsIDOMWindow *aParent) { return _to OpenProgressDialogFor(aPersistentDescriptor, aParent); } \
  NS_IMETHOD OnClose(void) { return _to OnClose(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOWNLOADMANAGER(_to) \
  NS_IMETHOD AddDownload(nsIURI *aSource, nsILocalFile *aTarget, const PRUnichar *aDisplayName, const PRUnichar *openingWith, PRInt64 startTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddDownload(aSource, aTarget, aDisplayName, openingWith, startTime, aPersist, _retval); } \
  NS_IMETHOD GetDownload(const char *aPersistentDescriptor, nsIDownload **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownload(aPersistentDescriptor, _retval); } \
  NS_IMETHOD CancelDownload(const char *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelDownload(aPersistentDescriptor); } \
  NS_IMETHOD RemoveDownload(const char *aPersistentDescriptor) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveDownload(aPersistentDescriptor); } \
  NS_IMETHOD Open(nsIDOMWindow *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->Open(aParent); } \
  NS_IMETHOD OpenProgressDialogFor(const char *aPersistentDescriptor, nsIDOMWindow *aParent) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenProgressDialogFor(aPersistentDescriptor, aParent); } \
  NS_IMETHOD OnClose(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnClose(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDownloadManager : public nsIDownloadManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDOWNLOADMANAGER

  nsDownloadManager();
  virtual ~nsDownloadManager();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDownloadManager, nsIDownloadManager)

nsDownloadManager::nsDownloadManager()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsDownloadManager::~nsDownloadManager()
{
  /* destructor code */
}

/* nsIDownload addDownload (in nsIURI aSource, in nsILocalFile aTarget, in wstring aDisplayName, in wstring openingWith, in long long startTime, in nsIWebBrowserPersist aPersist); */
NS_IMETHODIMP nsDownloadManager::AddDownload(nsIURI *aSource, nsILocalFile *aTarget, const PRUnichar *aDisplayName, const PRUnichar *openingWith, PRInt64 startTime, nsIWebBrowserPersist *aPersist, nsIDownload **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDownload getDownload (in string aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::GetDownload(const char *aPersistentDescriptor, nsIDownload **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelDownload (in string aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::CancelDownload(const char *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeDownload (in string aPersistentDescriptor); */
NS_IMETHODIMP nsDownloadManager::RemoveDownload(const char *aPersistentDescriptor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void open (in nsIDOMWindow aParent); */
NS_IMETHODIMP nsDownloadManager::Open(nsIDOMWindow *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void openProgressDialogFor (in string aPersistentDescriptor, in nsIDOMWindow aParent); */
NS_IMETHODIMP nsDownloadManager::OpenProgressDialogFor(const char *aPersistentDescriptor, nsIDOMWindow *aParent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onClose (); */
NS_IMETHODIMP nsDownloadManager::OnClose()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_DOWNLOADMANAGER_CONTRACTID "@mozilla.org/download-manager;1"
#define NS_DOWNLOADMANAGER_CLASSNAME "Mozilla Download Manager"
// {EDB0490E-1DD1-11B2-83B8-DBF8D85906A6}
#define NS_DOWNLOADMANAGER_CID \
    { 0xedb0490e, 0x1dd1, 0x11b2, { 0x83, 0xb8, 0xdb, 0xf8, 0xd8, 0x59, 0x06, 0xa6 } }

#endif /* __gen_nsIDownloadManager_h__ */
