/*************************************************************************
 *
 *  $RCSfile: Cache.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.util.Hashtable;
import java.util.Enumeration;

public final class Cache {
  private static final int DefaultSleepTime = 10000;
  private final Hashtable _data = new Hashtable();
  private final int _sleepTime;
  private final int _maxAge;

  private final class TimeStamp {
    private final Object _object;
    private long  _lastAccess;

    public TimeStamp(Object object) {
      _object = object;
      _lastAccess = System.currentTimeMillis();
    }
    
    public Object access() {
      _lastAccess = System.currentTimeMillis();
      return _object;
    }

    public boolean expired(long oldest) {
      return _lastAccess < oldest;
    }
  } // end of TimeStamp
  
  public Cache(int maximalAge) {
    _maxAge = maximalAge;
    _sleepTime = Math.min(DefaultSleepTime, maximalAge);
    (new Thread() {
      public void run() {
	while (true) {
	  try {
	    Thread.sleep(_sleepTime);
	    checkExpiration();
	  }
	  catch (InterruptedException e) {}
	}}}).start();
  }

  private synchronized void checkExpiration() {
    final long oldest = System.currentTimeMillis() - _maxAge;
    final Enumeration keys = _data.keys();
    while (keys.hasMoreElements()) {
      final Object key = keys.nextElement();
      if (((TimeStamp)_data.get(key)).expired(oldest)) {
	System.out.println("removing " + key.toString() + " from cache");
	_data.remove(key);
      }
    }
  }

  public synchronized void clear() {
    _data.clear();
  }

  public synchronized void put(Object key, Object value) {
    _data.put(key, new TimeStamp(value));
  }

  public synchronized Object get(Object key) {
    Object timeStamp = _data.get(key);
    return timeStamp != null ? ((TimeStamp)timeStamp).access() : null;
  }
}

