/*************************************************************************
 *
 *  $RCSfile: XmlSearchClient.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;
import java.util.*;
import net.jini.core.lookup.ServiceItem;

import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.tree.*;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XmlSearchClient implements DocumentFragmentServer {
    private QueryProcessor         _queryProcessor;
    private DocumentFragmentServer _documentServer;
    private Vector                 _engines = new Vector();

    /** this is the main function of the module */
    public DocumentFragment getDocumentFragment(DocumentRequest request)
	throws Exception {
	return _documentServer.getDocumentFragment(request);
    }

    public CollectionModel getCollectionModel(String classification)
	throws Exception {
	return _documentServer.getCollectionModel(classification);
    }

    public void init(Element config) throws Exception {
	configureSearchServer(config);
    }

    public QueryResults runQuery(String terms, String scope) {
	try {
	    if (_queryProcessor != null) {
				// the following especially for cases where docs are readily available locally
		terms = terms.trim();
		if (terms.length() > 0) {
		    scope = scope.trim();
		    if (scope.length() == 0)
			scope = null;
		    return _queryProcessor.processQuery(new QueryStatement(terms,
									   scope,
									   30));
		}
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
	return null;
    }
  
    private void configureSearchServer(Element config) throws Exception {
	if (config.getTagName().equals("XmlQueryProcessors")) {
	    NodeList list = config.getElementsByTagName("XmlSearchEngine");
	    for (int i = 0; i < list.getLength(); i++) {
		Element seConfig = (Element)list.item(i);
		QueryProcessorImpl qp = new QueryProcessorImpl();
		if (qp.init(seConfig))
		    _engines.addElement(qp);
	    }
	    // process remote services
	    list = config.getElementsByTagName("XmlSearchService");
	    Vector searchServiceItems = new Vector();
	    if (list.getLength() > 0) {
		for (int i = 0; i < list.getLength(); i++) {
		    Element clientConfig = (Element)list.item(i);
		    System.out.println(clientConfig);
		    ServiceFinder finder = new ServiceFinder(searchServiceItems, "XmlSearchService");
		    new Thread(finder).start();
		    while (finder.getNumberOfServices() == 0)
			Thread.sleep(500);
		}
		for (int i = 0; i < searchServiceItems.size(); i++) {
		    ServiceItem item = (ServiceItem)searchServiceItems.elementAt(i);
		    for (int j = 0; j < item.attributeSets.length; j++)
			if (item.attributeSets[j] instanceof SearchEngineEntry) {
			    System.out.println("SearchEngineEntry found");
			    SearchEngineEntry sc = (SearchEngineEntry)item.attributeSets[j];
			    _engines.addElement(sc.getServer());
			}
		}
	    }
	    list = config.getElementsByTagName("XmlDocumentService");
	    Vector documentServiceItems = new Vector();
	    if (list.getLength() > 0) {
		for (int i = 0; i < list.getLength(); i++) {
		    Element clientConfig = (Element)list.item(i);
		    System.out.println(clientConfig);
		    ServiceFinder finder = new ServiceFinder(documentServiceItems,
							     "XmlDocumentService");
		    new Thread(finder).start();
		    while (finder.getNumberOfServices() == 0)
			Thread.sleep(500);
		}
	    }
	    else {
		list = config.getElementsByTagName("XmlDocumentServer");
		if (list.getLength() > 0) {
		    Element serverConfig = (Element)list.item(0);
		    _documentServer = new DocumentFragmentServerImpl(new String[] {
			serverConfig.getAttribute("Dir"),
			serverConfig.getAttribute("Http")});
		}
	    }
      
	    if (_documentServer == null && documentServiceItems.size() > 0) {
		ServiceItem item = (ServiceItem)documentServiceItems.elementAt(0);
		_documentServer = (DocumentFragmentServer)item.service;
	    }
	    /* !!! needs normal configuration
	       else
	       _documentServer = new DocumentFragmentServerImpl(); // local
	    */

	    setupQueryProcessor(_engines);
	}
	else
	    throw new Exception("inappropriate config element for GuiDemo");
    }
  
    public QueryProcessor[] getProcessors() {
	QueryProcessor[] result = new QueryProcessor[_engines.size()];
	if (_engines.size() > 0)
	result = (QueryProcessor[])_engines.toArray(result);
	return result;
    }

    public void setupQueryProcessor(Vector engines) throws Exception {
	switch (engines.size()) {
	case 0:
	    System.err.println("no QueryProcessors!");
	    break;
       
	case 1:
	    Object whatIsIt = engines.elementAt(0);

	    if (whatIsIt instanceof XmlSearchServer) // remote
		_queryProcessor = (XmlSearchServer)whatIsIt;
	    else if (whatIsIt instanceof QueryProcessor)
		_queryProcessor = (QueryProcessor)whatIsIt;
	    else
		throw new Exception("unknown service type");
	    break;

	default:
	    QueryHitMerger merger = new QueryHitMerger();
	    for (int i = 0; i < engines.size(); i++) {
		System.out.println(engines.elementAt(i));
      
		merger.addSearchServer((QueryProcessor)engines.elementAt(i));
	    }
	    _queryProcessor = merger;
	    break;
	}
    }

    public void close() {
	try {
	    if (_queryProcessor != null)
				// only close local processors
		if (_queryProcessor instanceof XmlSearchServer == false)
		    _queryProcessor.close();
	}
	catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
