/*************************************************************************
 *
 *  $RCSfile: loc_dir.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_LOC_LOC_DIR_HXX
#define ARY_LOC_LOC_DIR_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <ary/ids.hxx>
	// PARAMETERS


namespace ary
{
namespace loc
{


class Directory
{
  public:
    typedef std::map< udmstri, Lid >   Map_Children;

    // LIFECYCLE
    virtual             ~Directory() {}


    // OPERATIONS
    void                Add_ChildDir(
                            const udmstri &     i_sName,
                            Lid                 i_nId );
    void                Add_File(
                            const udmstri &     i_sName,
                            Lid                 i_nId );
    //INQUIRY
    Lid                 Id() const;
    const Map_Children &
                        ChildDirs() const;

    const Map_Children &
                        Files() const;
    // ACCESS
    Map_Children &      ChildDirs();
    Map_Children &      Files();

  protected:
                        Directory(
                            Lid                 i_nId );
  private:
    Map_Children        aChildDirs;
    Map_Children        aFiles;
    Lid                 nId;
};

class SubDirectory : public Directory
{
  public:
						SubDirectory(
							Lid                 i_nId,
							const udmstri &     i_sName,
							Lid                 i_nParentDirectory );
	//INQUIRY
	const udmstri &     Name() const;

  private:
	udmstri             sName;
	Lid                 nParentDirectory;
};


// IMPLEMENTATION

inline Lid
Directory::Id() const
	{ return nId; }
inline const Directory::Map_Children &
Directory::ChildDirs() const
    { return aChildDirs; }
inline const Directory::Map_Children &
Directory::Files() const
    { return aFiles; }
inline Directory::Map_Children &
Directory::ChildDirs()
    { return aChildDirs; }
inline Directory::Map_Children &
Directory::Files()
    { return aFiles; }
inline const udmstri &
SubDirectory::Name() const
    { return sName; }


} // namespace loc
} // namespace ary

#endif

