/*************************************************************************
 *
 *  $RCSfile: ifcc_ty.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_STORE_IFCC_TY_HXX
#define ARY_STORE_IFCC_TY_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>
#include <ary/cpp/c_etypes.hxx>


template <class XY> class Manipulator;


namespace ary
{
    namespace cpp
    {
		class TypeOwnerNode;
		class Type;
		class UsedType;
		class OperationSignature;

		class Namespace;
        class Class;
	}

    class IdGenerator;

namespace store
{
	class Cpp;

namespace cpp
{


class Type_Ifc
{
  public:
	// LIFECYCLE
						Type_Ifc(
							ary::store::Cpp & 	io_rStorageCpp,
                            Tid                 i_nFirstIdBuiltInTypes );
	void				Init_GlobalNamespaceNode(
							const ary::cpp::Namespace &
												i_rNamespace );
						~Type_Ifc();

	// OPERATIONS
	ary::cpp::TypeOwnerNode &
						Add_OwnerNode(
							const ary::cpp::Namespace &
												i_rNamespace,
							ary::cpp::TypeOwnerNode &
												i_rParent );
	ary::cpp::TypeOwnerNode &
						Add_OwnerNode(
							const ary::cpp::Class &
												i_rClass,
							ary::cpp::TypeOwnerNode &
												i_rParent );
	const ary::cpp::Type &
						Add_Type(
							DYN ary::cpp::UsedType &
												let_drUsedType );
	void                Add_OperationSignature(
							OSid                i_nId,
							DYN ary::cpp::OperationSignature &
												let_drOSigna );

    uintt                ForEachType(
                            const Manipulator< ary::cpp::UsedType > &
                                                i_rManip );

	// INQUIRY
	const ary::cpp::Type *
						Find_Type(
							Tid                 i_nType ) const;
	const ary::cpp::OperationSignature *
						Find_OperationSignature(
							OSid                i_nOSigna) const;

	const ary::cpp::Type *
						Search_BuiltInType(
							const udmstri &     i_sName,
							ary::cpp::E_TypeSpecialisation
												i_eTypeSpecialisation ) const;
	OSid                SearchId_OperationSignature(
							const ary::cpp::OperationSignature &
												i_rOSigna ) const;
	// ACCESS
	ary::cpp::TypeOwnerNode &
						GlobalNamespaceNode();
  private:
	struct CheshireCat;
	// DATA
    Dyn<CheshireCat>	pi;
};



// IMPLEMENTATION



}   // namespace cpp
}   // namespace store
}   // namespace ary



#endif

