/*************************************************************************
 *
 *  $RCSfile: cntsitem.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#include <cntsitem.hxx>

using namespace chaos;

//============================================================================
//
// CntSeenStatusItem Implementation.
//
//============================================================================

TYPEINIT1_AUTOFACTORY( CntSeenStatusItem, CntEnumItem );

//----------------------------------------------------------------------------
CntSeenStatusItem::CntSeenStatusItem( USHORT nWhich, CntSeenStatus eMode )
	: CntEnumItem( nWhich, eMode )
{
}

//----------------------------------------------------------------------------
SfxPoolItem* CntSeenStatusItem::Clone( SfxItemPool* ) const
{
	return new CntSeenStatusItem( *this );
}

//----------------------------------------------------------------------------
SfxPoolItem* CntSeenStatusItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntSeenStatusItem( Which(), (CntSeenStatus)eStyle );
}

//----------------------------------------------------------------------------
SvStream& CntSeenStatusItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

//----------------------------------------------------------------------------
SfxItemPresentation
CntSeenStatusItem::GetPresentation( SfxItemPresentation,
									SfxMapUnit,
									SfxMapUnit,
									XubString &rText,
                                    const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

//----------------------------------------------------------------------------
String CntSeenStatusItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos < CNT_SEENSTATUS_COUNT, "enum overflow!" );
	return String();
}

//----------------------------------------------------------------------------
USHORT CntSeenStatusItem::GetValueCount() const
{
	return CNT_SEENSTATUS_COUNT;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntSeenStatusItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		  BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntSeenStatusItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntSeenStatusItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	    BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

