/*************************************************************************
 *
 *  $RCSfile: rcpnitem.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:18:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _RCPNITEM_CXX "$Revision: 1.2 $"

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UCB_RECIPIENTINFO_HPP_
#include <com/sun/star/ucb/RecipientInfo.hpp>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _ADRPARSE_HXX
#include <svtools/adrparse.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _SVTOOLS_STRCRYPT_HXX_
#include <svtools/strcrypt.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif

#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif

#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif

using namespace chaos;

/*========================================================================
 *
 * CntRecipient... internals.
 *
 *======================================================================*/
SV_IMPL_PTRARR(CntRecipientInfoArr, CntRecipientInfo*);

/*
 * ItemVersion.
 * username + password added after version 1
 * serverbase added after version 2
 * UniStrings added after version 3
 * new string en-/decode added after version 4
 */
#define CNT_RECIPIENTLISTITEM_VERSION 	4

/*========================================================================
 *
 * CntRecipientInfo implementation.
 *
 *======================================================================*/
/*
 * CntRecipientInfo.
 */
CntRecipientInfo::CntRecipientInfo (
	const String&          aToRecipient,
	const String&          aCcRecipient,
	const String&          aBccRecipient,
	const String&          aNewsRecipient,
	const String&          aServer,
	const String&          sProtocoError,
	CntOutMsgProtocolType  eProtocol,
	CntOutMsgInternalState eState,
	USHORT                 nProtocolError,
	USHORT                 nSendRetries,
	const String&          aUsername,
	const String&          aPassword,
	const String&          aVIMPOPath)
	: _eProtocol      (eProtocol),
	  _eState         (eState),
	  _aToRecipient   (aToRecipient),
	  _aCcRecipient   (aCcRecipient),
	  _aBccRecipient  (aBccRecipient),
	  _aNewsRecipient (aNewsRecipient),
	  _aServer        (aServer),
	  _nSendTries     (nSendRetries),
	  _nProtocolError (nProtocolError),
	  _sProtocolError (sProtocoError),
	  _aUsername      (aUsername),
	  _aPassword      (aPassword),
	  _aVIMPOPath     (aVIMPOPath)
{
}

/*
 * operator==
 */
BOOL CntRecipientInfo::operator== (const CntRecipientInfo &rOther) const
{
	return    _eState == rOther._eState &&
		   _eProtocol == rOther._eProtocol &&
		_aToRecipient == rOther._aToRecipient &&
		_aCcRecipient == rOther._aCcRecipient &&
	   _aBccRecipient == rOther._aBccRecipient &&
	  _aNewsRecipient == rOther._aNewsRecipient &&
			 _aServer == rOther._aServer &&
		   _aUsername == rOther._aUsername &&
		   _aPassword == rOther._aPassword &&
		  _nSendTries == rOther._nSendTries &&
	  _nProtocolError == rOther._nProtocolError &&
	  _sProtocolError == rOther._sProtocolError &&
 	      _aVIMPOPath == rOther._aVIMPOPath;
}

/*
 * Load.
 */
void CntRecipientInfo::Load (SvStream& rStream, USHORT nVersion)
{
	USHORT nState = 0, nProtocol = 0;
	rStream >> nState
			>> nProtocol
			>> _nSendTries;
	SfxPoolItem::readUnicodeString(rStream, _aToRecipient, nVersion > 3);
	SfxPoolItem::readUnicodeString(rStream, _aCcRecipient, nVersion > 3);
	SfxPoolItem::readUnicodeString(rStream, _aBccRecipient, nVersion > 3);
	SfxPoolItem::readUnicodeString(rStream, _aNewsRecipient, nVersion > 3);
	SfxPoolItem::readUnicodeString(rStream, _aServer, nVersion > 3);
	rStream >> _nProtocolError;
	SfxPoolItem::readUnicodeString(rStream, _sProtocolError, nVersion > 3);
	if (nVersion > 1)
	{
		SfxPoolItem::readUnicodeString(rStream, _aUsername, nVersion > 3);

		// password is (of course) stored encoded...
		ByteString aPassword;
		rStream.ReadByteString(aPassword);
		_aPassword = UniString(CntStringDecode(nVersion >= 5, aPassword),
							   nVersion > 3 ? RTL_TEXTENCODING_UTF8 :
							                  rStream.GetStreamCharSet());
	}

	if (nVersion > 2)
		SfxPoolItem::readUnicodeString(rStream, _aVIMPOPath, nVersion > 3);

	_eState    = (CntOutMsgInternalState)nState;
	_eProtocol = (CntOutMsgProtocolType)nProtocol;
}

/*
 * Store.
 */
void CntRecipientInfo::Store (SvStream& rStream, USHORT nVersion) const
{
	rStream << (USHORT) _eState
	  	    << (USHORT) _eProtocol
			<< _nSendTries;
	SfxPoolItem::writeUnicodeString(rStream, _aToRecipient);
	SfxPoolItem::writeUnicodeString(rStream, _aCcRecipient);
	SfxPoolItem::writeUnicodeString(rStream, _aBccRecipient);
	SfxPoolItem::writeUnicodeString(rStream, _aNewsRecipient);
	SfxPoolItem::writeUnicodeString(rStream, _aServer);
	rStream << _nProtocolError;
	SfxPoolItem::writeUnicodeString(rStream, _sProtocolError);
	SfxPoolItem::writeUnicodeString(rStream, _aUsername);
	rStream.
		WriteByteString(SvStringEncode(ByteString(_aPassword,
												  RTL_TEXTENCODING_UTF8)));
		// Encode password before storing it !!!
	SfxPoolItem::writeUnicodeString(rStream, _aVIMPOPath);
}

/*
 * ToProtocolString.
 */
String CntRecipientInfo::ToProtocolString (
	const CntOutMsgProtocolType eType)
{
	switch ( eType )
	{
		case CNT_OUTMSG_PROTOCOL_SMTP:
			return
				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("SMTP"));

		case CNT_OUTMSG_PROTOCOL_VIM:
			return String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("VIM"));

		case CNT_OUTMSG_PROTOCOL_MAPI:
			return
				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("MAPI"));

 		case CNT_OUTMSG_PROTOCOL_MBOX:
			return
				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("MBOX"));

		case CNT_OUTMSG_PROTOCOL_NNTP:
			return
				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("NNTP"));

		case CNT_OUTMSG_PROTOCOL_COPY:
			return
				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("COPY"));

		default:
			break;
	}
	return String();
}

/*
 * ToProtocolType.
 */
CntOutMsgProtocolType CntRecipientInfo::ToProtocolType (
	const String& rType)
{
	return rType.EqualsIgnoreCaseAscii("smtp") ? CNT_OUTMSG_PROTOCOL_SMTP :
		   rType.EqualsIgnoreCaseAscii("vim") ? CNT_OUTMSG_PROTOCOL_VIM :
		   rType.EqualsIgnoreCaseAscii("mapi") ? CNT_OUTMSG_PROTOCOL_MAPI :
		   rType.EqualsIgnoreCaseAscii("mbox") ? CNT_OUTMSG_PROTOCOL_MBOX :
		   rType.EqualsIgnoreCaseAscii("nntp") ? CNT_OUTMSG_PROTOCOL_NNTP :
		   rType.EqualsIgnoreCaseAscii("copy") ? CNT_OUTMSG_PROTOCOL_COPY :
		                                         CNT_OUTMSG_PROTOCOL_END;
}

/*========================================================================
 *
 * CntRecipientInfoItem implementation.
 *
 *======================================================================*/
/*
 * CntRecipientInfoItem.
 */
TYPEINIT1_AUTOFACTORY (CntRecipientInfoItem, SfxPoolItem);

/*
 * ~CntRecipientInfoItem.
 */
CntRecipientInfoItem::~CntRecipientInfoItem (void)
{
}

/*
 * Clone.
 */
SfxPoolItem* CntRecipientInfoItem::Clone (SfxItemPool*) const
{
	return new CntRecipientInfoItem (*this);
}

/*
 * operator==
 */
int CntRecipientInfoItem::operator== (const SfxPoolItem &rItem) const
{
	const CntRecipientInfoItem &rOther =
		(const CntRecipientInfoItem&)rItem;
	if (m_pInfo && rOther.m_pInfo)
		return (m_pInfo->operator== (*(rOther.m_pInfo)));
	else
		return FALSE;
}

/*========================================================================
 *
 * CntRecipientListItem implementation.
 *
 *======================================================================*/
/*
 * CntRecipientListItem.
 */
TYPEINIT1_AUTOFACTORY (CntRecipientListItem, SfxPoolItem);

CntRecipientListItem::CntRecipientListItem (USHORT nWhich)
	: SfxPoolItem (nWhich)
{
}

CntRecipientListItem::CntRecipientListItem (
	USHORT nWhich, SvStream &rStream, USHORT nVersion)
	: SfxPoolItem (nWhich )
{
	USHORT nCount = 0;
	rStream >> nCount;
	for (USHORT n = 0; n < nCount; ++n)
	{
		CntRecipientInfo *pInfo = new CntRecipientInfo;
		pInfo->Load (rStream, nVersion);
		_aInfos.C40_INSERT (CntRecipientInfo, pInfo, n);
	}
}

CntRecipientListItem::CntRecipientListItem (const CntRecipientListItem &rOrig)
	: SfxPoolItem (rOrig.Which())
{
	// Cleanup.
	_aPresentation.Erase();
	_aInfos.DeleteAndDestroy (0, _aInfos.Count());

	// Copy.
	USHORT i, n = rOrig.Count();
	for (i = 0; i < n; ++i)
	{
		CntRecipientInfo *pInfo = new CntRecipientInfo (
			rOrig[i]->GetToRecipient(),
			rOrig[i]->GetCcRecipient(),
			rOrig[i]->GetBccRecipient(),
			rOrig[i]->GetNewsRecipient(),
			rOrig[i]->GetServer(),
			rOrig[i]->GetProtocolErrorStr(),
			rOrig[i]->GetProtocol(),
			rOrig[i]->GetState(),
			rOrig[i]->GetProtocolError(),
			rOrig[i]->GetSendTries(),
			rOrig[i]->GetUsername(),
			rOrig[i]->GetPassword(),
			rOrig[i]->GetVIMPOPath());
		_aInfos.C40_INSERT (CntRecipientInfo, pInfo, i);
	}
}

/*
 * ~CntRecipientListItem.
 */
CntRecipientListItem::~CntRecipientListItem()
{
}

/*
 * operator==
 */
int CntRecipientListItem::operator== (const SfxPoolItem &rItem) const
{
	const CntRecipientListItem& rOther = (const CntRecipientListItem&) rItem;
	if ( Count() != rOther.Count() )
		return FALSE;

	for ( USHORT n = 0; n < Count(); ++n )
		if (!(*operator[](n) == *rOther[n]))
			return FALSE;

	return TRUE;
}

/*
 * Compare.
 */
int CntRecipientListItem::Compare (const SfxPoolItem &rItem) const
{
	DBG_ASSERT(SfxPoolItem::operator ==(rItem), "unequal type");
	switch (GetRecipientString().
			    CompareIgnoreCaseToAscii(
					static_cast< CntRecipientListItem const * >(&rItem)->
					    GetRecipientString()))
	{
		case COMPARE_LESS:
			return -1;

		default: // COMPARE_EQUAL
			return  0;

		case COMPARE_GREATER:
			return  1;
	}
}

/*
 * Clone.
 */
SfxPoolItem* CntRecipientListItem::Clone (SfxItemPool*) const
{
	return new CntRecipientListItem (*this);
}

/*
 * Create.
 */
SfxPoolItem* CntRecipientListItem::Create (
	SvStream &rStream, USHORT nItemVersion) const
{
	return new CntRecipientListItem (Which(), rStream, nItemVersion);
}

/*
 * Store.
 */
SvStream& CntRecipientListItem::Store (
	SvStream &rStream, USHORT nItemVersion ) const
{
	rStream << Count();
	for ( USHORT n = 0; n < Count(); ++n )
		(*operator[](n)).Store (rStream, nItemVersion);
	return rStream;
}

/*
 * GetVersion.
 */
USHORT CntRecipientListItem::GetVersion (USHORT nFileFormatVersion) const
{
	return CNT_RECIPIENTLISTITEM_VERSION;
}

/*
 * IsCompletelySent.
 * (all stuff is successfully sent).
 */
BOOL CntRecipientListItem::IsCompletelySent (void) const
{
	for (USHORT nRecipient = 0; nRecipient < Count(); nRecipient++)
	{
		const CntRecipientInfo* pInfo = (*this)[nRecipient];

		if ((pInfo->GetState() != CNTOUT_ISTATE_PARTSENT ) &&
			(pInfo->GetState() != CNTOUT_ISTATE_SENT     ) &&
			(pInfo->GetState() != CNTOUT_ISTATE_CONFIRMED)    )
			return FALSE;
	};
	return TRUE;
}

/*
 * IsCompletelyProcessed.
 * (all stuff was tried to sent).
 */
BOOL CntRecipientListItem::IsCompletelyProcessed (void) const
{
	for (USHORT nRecipient = 0; nRecipient < Count(); nRecipient++)
	{
		const CntRecipientInfo* pInfo = (*this)[nRecipient];

		if (pInfo->GetState() == CNTOUT_ISTATE_WRITTEN)
			return FALSE;
	};
	return TRUE;
}

/*
 * IsPartiallySent.
 * (at least one msg was sent).
 */
BOOL CntRecipientListItem::IsPartiallySent (void) const
{
	for (USHORT nRecipient = 0; nRecipient < Count(); nRecipient++ )
	{
		const CntRecipientInfo* pInfo = (*this)[nRecipient];

		if ((pInfo->GetState() == CNTOUT_ISTATE_PARTSENT ) ||
			(pInfo->GetState() == CNTOUT_ISTATE_SENT     ) ||
			(pInfo->GetState() == CNTOUT_ISTATE_CONFIRMED)    )
			return TRUE;
	};
	return FALSE;
}

/*
 * ResetState.
 * (i.e., prepare for resend).
 */
void CntRecipientListItem::ResetState (void)
{
	for (USHORT i = 0; i < Count(); i++)
		_aInfos[i]->ResetState();
}

/*
 * Append.
 */
void CntRecipientListItem::Append (const CntRecipientInfo* pInfo)
{
	_aPresentation.Erase();
	_aInfos.C40_INSERT (CntRecipientInfo, pInfo, _aInfos.Count());
}

/*
 * Delete.
 */
void CntRecipientListItem::Delete (CntRecipientInfo* pInfo)
{
	_aPresentation.Erase();
	_aInfos.DeleteAndDestroy (_aInfos.C40_GETPOS(CntRecipientInfo, pInfo));
}

/*
 * Find.
 */
CntRecipientInfo * CntRecipientListItem::Find (
	CntOutMsgProtocolType eProtocol,
	const String & rUsername,
	const String & rPassword,
	const String & rServer,
	const String & rVIMPOPath)
{
	for (USHORT i = 0; i < Count(); ++i)
	{
		CntRecipientInfo * pInfo = (*this)[i];
		if ((pInfo->GetProtocol()  == eProtocol ) &&
			(pInfo->GetUsername()  == rUsername ) &&
			(pInfo->GetPassword()  == rPassword ) &&
			(pInfo->GetServer()    == rServer   ) &&
			(pInfo->GetVIMPOPath() == rVIMPOPath)    )
			return pInfo;
	}
	return NULL;
}

/*
 * GetPresentation.
 */
SfxItemPresentation CntRecipientListItem::GetPresentation (
	SfxItemPresentation, SfxMapUnit, SfxMapUnit, XubString& rText,
    const IntlWrapper *) const
{
	rText = GetRecipientString();
	return SFX_ITEM_PRESENTATION_NAMELESS;
}

/*
 * GetRecipientString.
 */
String CntRecipientListItem::GetRecipientString() const
{
	if (_aPresentation.Len() == 0)
	{
		CntRecipientListItem *pThis = (CntRecipientListItem *)this;
		for (USHORT i = 0; i < Count(); i++)
		{
			const CntRecipientInfo* pCurInfo = operator[](i);
			if (pCurInfo->GetToRecipient().Len()
				&& pCurInfo->GetProtocol() != CNT_OUTMSG_PROTOCOL_COPY)
			{
				SvAddressParser aParser (pCurInfo->GetToRecipient());
				for (USHORT k = 0; k < aParser.Count(); k++)
				{
					if (_aPresentation.Len())
						pThis->_aPresentation += ',';
					pThis->_aPresentation += aParser.GetRealName(k);
				}
			}
			if (pCurInfo->GetNewsRecipient().Len())
			{
				if (_aPresentation.Len())
					pThis->_aPresentation += ',';
				pThis->_aPresentation += pCurInfo->GetNewsRecipient();
			}
		}
	}
	return _aPresentation;
}

/*
 * GetToString.
 */
String CntRecipientListItem::GetToString() const
{
	String aResult;
	for (USHORT i = 0; i < Count(); i++)
	{
		String aTo (_aInfos[i]->GetToRecipient());
		if (aTo.Len()
			&& _aInfos[i]->GetProtocol() != CNT_OUTMSG_PROTOCOL_COPY)
		{
			if (aResult.Len())
				aResult += ',';
			aResult += aTo;
		}
	}
	return aResult;
}

/*
 * GetCcString.
 */
String CntRecipientListItem::GetCcString() const
{
	String aResult;
	for (USHORT i = 0; i < Count(); i++)
	{
		String aCc (_aInfos[i]->GetCcRecipient());
		if (aCc.Len())
		{
			if (aResult.Len())
				aResult += ',';
			aResult += aCc;
		}
	}
	return aResult;
}

/*
 * GetBccString.
 */
String CntRecipientListItem::GetBccString() const
{
	String aResult;
	for (USHORT i = 0; i < Count(); i++)
	{
		String aBcc (_aInfos[i]->GetBccRecipient());
		if (aBcc.Len())
		{
			if (aResult.Len())
				aResult += ',';
			aResult += aBcc;
		}
	}
	return aResult;
}

/*
 * GetNewsgroupString.
 */
String CntRecipientListItem::GetNewsgroupString() const
{
	String aResult;
	for (USHORT i = 0; i < Count(); i++)
	{
		String aNewsgroup (_aInfos[i]->GetNewsRecipient());
		if (aNewsgroup.Len())
		{
			if (aResult.Len())
				aResult += ',';
			aResult += aNewsgroup;
		}
	}
	return aResult;
}

/*
 * CleanupAndPromoteAddresses_Impl.
 */
void CntRecipientListItem::CleanUpAndPromoteAddresses_Impl (void)
{
	// suche nach RecipientInfos, die kein To-Feld haben
	for (USHORT nI = Count(); nI;)
	{
		const CntRecipientInfo* pCurInfo = operator[](--nI);
		if (pCurInfo->GetToRecipient().Len())
			// der hat einen -> OK
			continue;

		// kein To-Feld: nachgucken, ob wir CC promoten koennen
		if (pCurInfo->GetCcRecipient().Len())
		{
			// neue Info zusammen bauen, bei der das Cc-Feld zum To-Feld
			// verschoben ist, alte wegschmeissen
			Append (new CntRecipientInfo (
				pCurInfo->GetCcRecipient(),
				String(),
				pCurInfo->GetBccRecipient(),
				pCurInfo->GetNewsRecipient(),
				pCurInfo->GetServer(),
				pCurInfo->GetProtocolErrorStr(),
				pCurInfo->GetProtocol(),
				pCurInfo->GetState(), 0, 0,
				pCurInfo->GetUsername(),
				pCurInfo->GetPassword(),
				pCurInfo->GetVIMPOPath()));
			Delete ((CntRecipientInfo*)pCurInfo);
			continue;
		}

		// immer noch nichts: koennen wir noch mit Bcc herumtricksen?
		if (pCurInfo->GetBccRecipient().Len())
		{
			// lauter neue Infos zusammenbauen, bei der die Bcc-Felder
			// jeweils das einzige To-Feld bilden
			String aBcc (pCurInfo->GetBccRecipient());
			xub_StrLen nBcc = aBcc.GetTokenCount (',');

			for (xub_StrLen nJ = 0; nJ < nBcc; nJ++ )
			{
				Append (new CntRecipientInfo (
					aBcc.GetToken (nJ, ','),
					String(), // wir wissen schon, dass kein CC da ist
					String(), // die Bccs sind verbraucht
					pCurInfo->GetNewsRecipient(),
					pCurInfo->GetServer(),
					pCurInfo->GetProtocolErrorStr(),
					pCurInfo->GetProtocol(),
					pCurInfo->GetState(), 0, 0,
					pCurInfo->GetUsername(),
					pCurInfo->GetPassword(),
					pCurInfo->GetVIMPOPath()));
			}
			// alte Info wegschmeissen
			Delete ((CntRecipientInfo*)pCurInfo);
			continue;
		}

		// immer noch nichts? Dann kann ich auch nicht helfen.
		// FIXME: Hier sollte Meldung gemacht werden.
	}
}

//----------------------------------------------------------------------------
// virtual
BOOL CntRecipientListItem::PutValue( const com::sun::star::uno::Any& rVal,
						   			 BYTE nMemberId )
{
	com::sun::star::uno::Sequence<
							com::sun::star::ucb::RecipientInfo > aValue;
	if ( rVal >>= aValue )
	{
		// Destroy old array.
		while ( _aInfos.Count() )
			Delete( _aInfos[ 0 ] );

		const com::sun::star::ucb::RecipientInfo* pArray =
												aValue.getConstArray();

		// Assemble new array.
		sal_uInt32 nCount = aValue.getLength();
		for ( sal_uInt32 n = 0; n < nCount; ++n )
		{
			const com::sun::star::ucb::RecipientInfo& rInfo = pArray[ n ];
			const CntRecipientInfo* pInfo =	new CntRecipientInfo(
				rInfo.To,
				rInfo.CC,
				rInfo.BCC,
				rInfo.Newsgroups,
				rInfo.Server,
				rInfo.ProtocolErrorString,
				CntRecipientInfo::ToProtocolType(rInfo.ProtocolType),
				(CntOutMsgInternalState)rInfo.State,
				rInfo.ProtocolErrorNumber,
				rInfo.SendTries,
				rInfo.Username,
				rInfo.Password,
				rInfo.VIMPostOfficePath);
			Append( pInfo );
		}

		return TRUE;
	}

	DBG_ERROR( "CntRecipientListItem::PutValue - Wrong type!" );
	return FALSE;
}

//----------------------------------------------------------------------------
// virtual
BOOL CntRecipientListItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  	   BYTE nMemberId ) const
{
	sal_uInt32 nCount = _aInfos.Count();

	com::sun::star::uno::Sequence<
				com::sun::star::ucb::RecipientInfo > aValue( nCount );
	com::sun::star::ucb::RecipientInfo* pArray = aValue.getArray();

	for ( sal_uInt32 n = 0; n < nCount; ++n )
	{
		const CntRecipientInfo* pInfo = _aInfos[ n ];
		com::sun::star::ucb::RecipientInfo aInfo(
			CntRecipientInfo::ToProtocolString( pInfo->GetProtocol() ),
			com::sun::star::ucb::OutgoingMessageState( pInfo->GetState() ),
			pInfo->GetToRecipient(),
			pInfo->GetCcRecipient(),
			pInfo->GetBccRecipient(),
			pInfo->GetNewsRecipient(),
			pInfo->GetServer(),
			pInfo->GetUsername(),
			pInfo->GetPassword(),
			pInfo->GetVIMPOPath(),
			pInfo->GetProtocolErrorStr(),
			pInfo->GetProtocolError(),
			pInfo->GetSendTries() );
		pArray[ n ] = aInfo;
	}

	rVal <<= aValue;
	return TRUE;
}

