/*************************************************************************
 *
 *  $RCSfile: accessor.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:16:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "accessor.hxx"

#ifndef CONFIGMGR_SEGMENT_HXX
#include "segment.hxx"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

// -----------------------------------------------------------------------------	

namespace configmgr
{
// -----------------------------------------------------------------------------
    namespace memory
    {
    // -------------------------------------------------------------------------
        Accessor::Impl::Impl(Segment const * segment)
        : m_segment(segment)
        , m_refs(1)
        {
            void const * base = m_segment ? m_segment->acquireReadAccess() : NULL;
            m_base = static_cast<char const *>(base);
        }
    // -------------------------------------------------------------------------
        Accessor::Impl::Impl(Segment const * segment, void const * base)
        : m_segment(segment)
        , m_base(static_cast<char const *>(base))
        , m_refs(1)
        {
        }
    // -------------------------------------------------------------------------
        Accessor::Impl::~Impl()
        {
            if (m_segment) m_segment->releaseReadAccess(m_base);
        }
    // -------------------------------------------------------------------------
         /// Copies an Accessor
        Accessor::Accessor(Accessor const& _aOther) 
        : m_impl( _aOther.m_impl ) 
        { 
            acquireImpl(); 
        }

        Accessor& Accessor::operator=(Accessor const& _aOther)
        {
            _aOther.acquireImpl();
            this->releaseImpl();
            m_impl = _aOther.m_impl;
            return *this;
        }
    // -------------------------------------------------------------------------
        void Accessor::clear()
        {
            if (m_impl->is()) 
            {
                Impl * pNewImpl = new Impl(0,0);
                releaseImpl();
                m_impl = pNewImpl;
            }
            OSL_POSTCOND(!this->is(),"Accessor::clear: Could not clear");
        }

    // -------------------------------------------------------------------------
        void * Accessor::failNull()
        {
            char const * sMessage = "Unexpected NULL Address or Accessor";
            OSL_ENSURE(false,sMessage);
            return NULL;
        }
    // -------------------------------------------------------------------------

    #if OSL_DEBUG_LEVEL > 0
        void const * Accessor::resolve(AddressType _p) const 
        { 
            OSL_ENSURE( !_p.is() || segment_()->isValidAddress(_p.value()), "Address does not belong to this segment");
            return _p.is() ? base_() + _p.value() : NULL; 
        }

        Pointer  Accessor::reduce(void const * _p) const
        {
            if (_p)
            {
                Pointer::RawAddress addr = static_cast<char const *>(_p) - base_();
                OSL_ENSURE( segment_()->isValidAddress(addr), "Pointer does not belong to this segment");
                return Pointer(addr); 
            }
            else
                return Pointer();
        }
  #endif // OSL_DEBUG_LEVEL

    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------
} // namespace configmgr


