/*************************************************************************
 *
 *  $RCSfile: treetests.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:19:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <memory>
#include <vector>

#include <iostream>

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif
#include <cppuhelper/implbase1.hxx>

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#include <com/sun/star/xml/sax/InputSource.hpp>
#include <com/sun/star/xml/sax/XParser.hpp>
#include <com/sun/star/io/XActiveDataSource.hpp>

#ifndef _STREAM_HXX //autogen wg. SvStream
#include <tools/stream.hxx>
#endif

#include <rtl/ustring.hxx>

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif

#include <tools/urlobj.hxx>
#include <osl/diagnose.h>

// #include <icmp_oustring.hxx>

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_
#include <com/sun/star/uno/Sequence.h>
#endif
// How to create a name
// ConfigurationManagement
// c nf g r t  nm n g m nt
// c  f g       m n g    t
// c            m
#include "cmtree.hxx"
#include "xmltreebuilder.hxx"
#include "xmlformater.hxx"
#include "../source/inc/typeconverter.hxx"
#include "msc_msg.hxx"
#include "localsession.hxx"

// using namespace vos;
using namespace rtl;
using namespace std;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::xml::sax;
// using namespace com::sun::star::beans;
// using namespace com::sun::star::registry;
// using namespace com::sun::star::bridge;
// using namespace com::sun::star::ucb;
// using namespace com::sun::star::task;
using namespace com::sun::star::io;
// using namespace com::sun::star::sdbc;
// using namespace com::sun::star::container;
using namespace std;
namespace script = com::sun::star::script;
using namespace configmgr;

// --------------------------------- Prototypes ---------------------------------
void testString(const Any &aAny);
sal_Int16 testfunction();


Tree* filltest();
void writeTest(const Tree* aTree);

#define ASCII(x) OUString::createFromAscii(x)

sal_Int16 importViaXML(const Reference<XInputStream> &xStream,
					   const uno::Reference<lang::XMultiServiceFactory> &xServiceFactory);
sal_Int16 importViaXML2(const Reference<XInputStream> &xStream);
Any binaryTest();
void write_TreeChangeList();
OUString writeAny(const Any& rValue);

class CmXMLFormater_impl : public CmXMLFormater
{
public:
	CmXMLFormater_impl(const SubtreeChange* pSubtree, script::XTypeConverter *pConv)
			:CmXMLFormater(pSubtree, pConv){}

	static sal_Int32 Write( const Reference < XOutputStream> &xStream, const TreeChangeList &aTree);
};

/*========================================================================
 *
 * MyApp.
 *
 *=======================================================================*/

/*
class MyApp : public Application
{
public:
	virtual void Main();
};

MyApp aMyApp;
*/

//-------------------------------------------------------------------------
// virtual

auto_ptr<INode> fktTest()
{
	return auto_ptr<INode>(0);
}



#if (defined UNX) || (defined OS2)
void main( int argc, char * argv[] )
#else
void _cdecl main( int argc, char * argv[] )
#endif
{

#define WRITE_XML_TEST
#define READ_XML_TEST
/*
void MyApp::Main()
{
*/

	//////////////////////////////////////////////////////////////////////
	// Initialize local Service Manager and basic services.
	//////////////////////////////////////////////////////////////////////

	Reference< XMultiServiceFactory > xFac(
 					   cppu::createRegistryServiceFactory(OUString::createFromAscii("applicat.rdb")) );
 	comphelper::setProcessServiceFactory( xFac );
 
 	Reference< XComponent > xComponent(	xFac, UNO_QUERY );


/* #77115# value smaller 1 (eg. 0.1)
	double a;
	cout << "Blah" << endl;
	OUString aStr;
	OString aOStr;
	while (1) {
		
		cin >> a; 
		Any aAny;
		aAny <<= OUString::valueOf( a );
		if (aAny >>= aStr)
		{
			cout << "Eingabe: " << a << " valueOf(";
			aOStr = rtl::OUStringToOString(aStr,RTL_TEXTENCODING_ASCII_US);
			cout << aOStr.getStr();
			cout << ")" << endl;
		}
	}
*/
	

#ifdef READ_XML_TEST
 {
	 String aFilename = OUString::createFromAscii("e:/temp/org.openoffice.test.xml");
	 SvFileStream *pStream = new SvFileStream( aFilename, STREAM_READ );
	 Reference<XInputStream> xStream = new utl::OInputStreamWrapper(pStream, true);
	 if (xStream.is())
		 importViaXML(xStream, xFac);
 }
#endif



// 	   XMLFilter::Demo(ASCII("f:/local/SRC593/configmgr/workben/local_io"),
// 					   ASCII("com.sun.star.office.Setup"),
// 					   ASCII("com.sun.star.office.Setup"),
// 					   xFac);
	// compareTest();

	// NodeTest
// 	   Any anAny;
// 	   anAny = binaryTest();
// 	   writeAny(anAny);
// 
// 	   Tree *pTree = filltest();

	// ----------------- We start a write Test -----------------
	// DirEntry aEntry( "e:/temp/" );
	// aEntry += DirEntry( "configfile" );
	// aEntry.SetExtension( "xml" );
	
	// INetURLObject aObj;
	// aObj.SetSmartProtocol( INET_PROT_FILE );
	// aObj.SetSmartURL( "e:/temp/configfile.xml" );		// Name der Datei 

	// Tree *pTree2 = fill2test();
	// pTree->AddTree(pTree2);

	// delete pTree2;


//	write_TreeChangeList();
/*
#ifdef WRITE_XML_TEST
	write_TreeChangeList();
#endif
*/

	/*
	  {
	  String aFilename = OUString::createFromAscii("e:/temp/configfile_writeonly.xml");
	  SvFileStream aStream( aFilename, STREAM_TRUNC | STREAM_WRITE );
	  Reference<XOutputStream> xStream = new utl::OOutputStreamWrapper(aStream);
	  writeTest(pTree);
	  CmXMLFormater_impl::Write(xStream, pTree->getSubtree(ASCII("com")));
	  }
	*/ 
	
// ok.

	// String Compare
	// OUString aValue = ASCII("blah");
	// OUString aValue2 = ASCII("BLAH");
	// if (aValue.equalsIgnoreCase(aValue2))
	// {
	// 	   // Values sind gleich
	// 	   volatile int dummy=0;
	// }
	
	

/*
 {
	 String aFilename = OUString::createFromAscii("e:/temp/configupdate.xml");
	 SvFileStream *pStream = new SvFileStream( aFilename, STREAM_READ );
	 Reference<XInputStream> xStream = new utl::OInputStreamWrapper(pStream, true);
	 if (xStream.is())
		 importViaXML2(xStream);
 }
*/

//	delete pTree;
}

// -----------------------------------------------------------------------------
 

void test_TypeConversion() {
	
	OUString aStr;
	unsigned short n = 100;
	sal_uInt16 n2 = 100;
	sal_Int32 n3 = 100;
	aStr = OUString::valueOf(n3);

	Any anAny;
	TypeClass aType = anAny.getValueTypeClass();
	aStr = toTypeName(aType);

	anAny <<= double(3.14);

	aType = anAny.getValueTypeClass();
	aStr = toTypeName(aType);
}


// -----------------------------------------------------------------------------
void write_TreeChangeList() {
		
	TreeChangeList aList(ASCII("com.sun.star.egal"), ASCII("Layout"));
	
	auto_ptr<INode> pINode(new Subtree(ASCII("inode")));
	auto_ptr<Change> pNode(new AddNode(pINode, ASCII("Name_of_addnode")));

	// create a double any, insert it to the tree
	Any aDoubleAny2;
	double aValueDouble = 0.1;
	aDoubleAny2 <<= aValueDouble;
	auto_ptr<Change> pNode2(new ValueChange(
		ASCII("Version"), aDoubleAny2, ValueChange::changeValue));
	

	// create a binary any
	Sequence<sal_Int8> aBinarySeq(12);
	sal_Int8 *pByteArray = aBinarySeq.getArray();
	*pByteArray++ = 'H';
	*pByteArray++ = 'e';
	*pByteArray++ = 'l';
	*pByteArray++ = 'l';
	*pByteArray++ = 'o';
	*pByteArray++ = '\0';
	*pByteArray++ = 'W';
	*pByteArray++ = 'o';
	*pByteArray++ = 'r';
	*pByteArray++ = 'l';
	*pByteArray++ = 'd';
	*pByteArray++ = '.';
	Any aBinaryAny;
	aBinaryAny <<= aBinarySeq;
	auto_ptr<Change> pNode3(new ValueChange(
		ASCII("BinaryValue"), aBinaryAny, ValueChange::changeValue));

	// create a string list
	Sequence<OUString> aStringSeq(3);
	OUString *pStringArray = aStringSeq.getArray();
	*pStringArray++ = ASCII("This is the first element of a String list.");
	*pStringArray++ = ASCII("And this is the second line.");
	*pStringArray++ = ASCII("foo bar...");
	Any aStringAny;
	aStringAny <<= aStringSeq;
	auto_ptr<Change> pNode4(new ValueChange(
		ASCII("StringListValue"), aStringAny, ValueChange::changeValue));


	auto_ptr<Change> pNode5(new ValueChange(ASCII("AnAny"), Any(), ValueChange::typeIsAny));

	
	auto_ptr<SubtreeChange> pChange(new SubtreeChange(ASCII("Name_of_subtreechange")));
	pChange->addChange(pNode);
	pChange->addChange(pNode2);
	pChange->addChange(pNode3);
	pChange->addChange(pNode4);
	pChange->addChange(pNode5);

	aList.root.addChange(auto_ptr<Change>(pChange.release()));

	String aFilename = OUString::createFromAscii("e:/temp/configfile_writeonly.xml");
	SvFileStream aStream( aFilename, STREAM_TRUNC | STREAM_WRITE );
	Reference<XOutputStream> xStream = new utl::OOutputStreamWrapper(aStream);
 		
	CmXMLFormater_impl::Write(xStream, aList);
}

// -----------------------------------------------------------------------------

/*
Tree* filltest()
{
	// create a Tree
	Tree *pTree;
	pTree = new Tree();

	// fill the tree with sample data
	{
		pTree->addSubtree(ConfigurationName(), auto_ptr<Subtree> ( new Subtree(ASCII("com"))) , ITreeProvider::ALL_LEVELS);
	}
	ISubtree* pISubtree = pTree->requestSubtree(ASCII("com"));

	pISubtree = pISubtree->addChild(auto_ptr<INode> ( new Subtree(ASCII("sun"))))->asISubtree();
	pISubtree = pISubtree->addChild(auto_ptr<INode> ( new Subtree(ASCII("star"))))->asISubtree();

	// create a double any, insert it to the tree
	Any aDoubleAny2;
	aDoubleAny2 <<= 0.1;
	pISubtree->addChild(auto_ptr<INode>( new ValueNode(ASCII("Version"), aDoubleAny2)));

	Sequence<sal_Int8> aByteArray(12);
	sal_Int8 *pByteArray = aByteArray.getArray();
	*pByteArray++ = 'H';
	*pByteArray++ = 'e';
	*pByteArray++ = 'l';
	*pByteArray++ = 'l';
	*pByteArray++ = 'o';
	*pByteArray++ = '\0';
	*pByteArray++ = 'W';
	*pByteArray++ = 'o';
	*pByteArray++ = 'r';
	*pByteArray++ = 'l';
	*pByteArray++ = 'd';
	*pByteArray++ = '.';
	Any aBinaryAny;
	aBinaryAny <<= aBinaryAny;
	pISubtree->addChild(auto_ptr<INode>( new ValueNode(ASCII("BinarySample"), aBinaryAny)));

	return pTree;
}
*/
// -----------------------------------------------------------------------------
// sample to traverse through the hole tree with visitor construct
struct MyAction : public NodeAction
{
	vector< OUString > m_aNameList;

	virtual void handle(ValueNode const&);
	virtual void handle(ISubtree const&);
};

void MyAction::handle(ValueNode const& aValueNode)
{
	OUString aName;
	for (vector<OUString>::const_iterator it = m_aNameList.begin();
		 it != m_aNameList.end();
		 it++)
	{
		aName += *it;
		aName += OUString::createFromAscii("/");
	}

	Any anAny = aValueNode.getValue();
	double aDouble;
	anAny >>= aDouble;
	volatile int dummy = 0;
}

void MyAction::handle(ISubtree const& aSubtree)
{
	m_aNameList.push_back(aSubtree.getName());
	aSubtree.forEachChild(*this);
	m_aNameList.pop_back();
}

// -----------------------------------------------------------------------------
void writeTest(const Tree *pTree)
{
	// traverse to a fix Value
	ISubtree const* pISubtree = pTree->getSubtree(ASCII("com"));
	pISubtree = pISubtree->getChild(ASCII("sun"))->asISubtree();
	pISubtree = pISubtree->getChild(ASCII("star"))->asISubtree();

	ValueNode const* pValue = pISubtree->getChild(ASCII("Version"))->asValueNode();
	Any anAny = pValue->getValue();
	double aDouble;
	anAny >>= aDouble;

	// traverse through the hole tree
	MyAction aTest;
	aTest.handle(*pTree->getSubtree(ASCII("com")));

	volatile int dummy = 0;
}

// -----------------------------------------------------------------------------
#define ERR_SWG_WRITE_ERROR 1
sal_Int16 importViaXML(const Reference<XInputStream> &xStream,
					   const uno::Reference<lang::XMultiServiceFactory> &xServiceFactory)
{
	// get parser
	Reference <XInterface> xXMLParser =
		xServiceFactory->createInstance( L"com.sun.star.xml.sax.Parser" );
	OSL_ENSURE( xXMLParser.is(),
				 "XMLReader::Read: com.sun.star.xml.sax.Parser service missing" );
	if( !xXMLParser.is() )
		return ERR_SWG_WRITE_ERROR;
	
	// Create a TypeConverter
	uno::Reference<script::XTypeConverter>		m_aConverter;
	m_aConverter = m_aConverter.query(xServiceFactory->createInstance(ASCII( "com.sun.star.script.Converter" )) );

	// get filter
	XMLTreeBuilder *pImport = new XMLTreeBuilder(m_aConverter, ASCII(""), ASCII(""));
	Reference<XDocumentHandler> xFilter = pImport;
	
	// connect stream to input stream to the parser
	InputSource aParserInput;
	Reference<XInputStream> xPipeInput( xStream, UNO_QUERY );
	aParserInput.aInputStream = xPipeInput;
	
	// connect parser and filter
	Reference<XParser> xParser( xXMLParser, UNO_QUERY );
	xParser->setDocumentHandler( xFilter );
	
	// parse
	sal_Int16 nRet = 0;
	try
	{
		xParser->parseStream( aParserInput );
	}
	// catch( SAXParseException e )
	// {
	// 		  // Something goes wrong, perhaps the xml file is currupt
	// 		  nRet = 1;
	// }
	catch( SAXException e )
	{
		// UString sText = e.getName();
		OUString sError = e.Message;
		OSL_ENSURE(0, rtl::OUStringToOString(sError,RTL_TEXTENCODING_ASCII_US).getStr());
		nRet = 2;
	}
	catch( IOException e )
	{
		OUString sError = e.Message;
		OSL_ENSURE(0, rtl::OUStringToOString(sError,RTL_TEXTENCODING_ASCII_US).getStr());
		nRet = 3;
	}
	
	if (nRet != 0) return nRet;

	// ---------------- Test to Export the SubTree from XMLTreeBuilder ---------------
	// if next function blocks, no done() is send, to reset the internal condition
	pImport->setDone(); // only for DEBUG
	std::auto_ptr<ISubtree> pReturn = pImport->waitToResponse();

	TreeChangeList aList(ASCII("com.sun.star.egal"), ASCII("blah"));
	auto_ptr<INode> pINode(pReturn.release());

	auto_ptr<Change> pNode(new AddNode(pINode, ASCII("Name_of_addnode")));
	auto_ptr<SubtreeChange> pChange(new SubtreeChange(ASCII("Name_of_subtreechange")));
	aList.root.addChange(pNode);

	String aFilename = OUString::createFromAscii("e:/temp/configfile_write_a_tree.xml");
	SvFileStream aStream( aFilename, STREAM_TRUNC | STREAM_WRITE );
	Reference<XOutputStream> xOStream = new utl::OOutputStreamWrapper(aStream);
	// writeTest(pTree);
	CmXMLFormater_impl::Write(xOStream, aList);

	return nRet;
}

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------

sal_Int16 importViaXML2(const Reference<XInputStream> &xStream)
{
	Reference<XMultiServiceFactory> xServiceFactory = comphelper::getProcessServiceFactory();
	OSL_ENSURE( xServiceFactory.is(),
				 "XMLReader::Read: got no service manager" );
	if( !xServiceFactory.is() )
		return ERR_SWG_WRITE_ERROR;
	
	// get parser
	Reference <XInterface> xXMLParser =
		xServiceFactory->createInstance( L"com.sun.star.xml.sax.Parser" );
	OSL_ENSURE( xXMLParser.is(),
				 "XMLReader::Read: com.sun.star.xml.sax.Parser service missing" );
	if( !xXMLParser.is() )
		return ERR_SWG_WRITE_ERROR;
	
	// get filter
	TreeChangeList aTree;

	// Create a TypeConverter
	uno::Reference<script::XTypeConverter>		m_aConverter;
	m_aConverter = m_aConverter.query(xServiceFactory->createInstance(ASCII( "com.sun.star.script.Converter" )) );

	XMLTreeChangeListBuilder *pImport = new XMLTreeChangeListBuilder(m_aConverter, &aTree, ASCII(""));
	Reference<XDocumentHandler> xFilter = pImport;
	
	// connect stream to input stream to the parser
	InputSource aParserInput;
	Reference<XInputStream> xPipeInput( xStream, UNO_QUERY );
	aParserInput.aInputStream = xPipeInput;
	
	// connect parser and filter
	Reference<XParser> xParser( xXMLParser, UNO_QUERY );
	xParser->setDocumentHandler( xFilter );
	
	// parse
	sal_Int16 nRet = 0;
	try
	{
		xParser->parseStream( aParserInput );
	}
	// catch( SAXParseException e )
	// {
	// 		  // Something goes wrong, perhaps the xml file is currupt
	// 		  nRet = 1;
	// }
	catch( SAXException e )
	{
		// UString sText = e.getName();
		nRet = 2;
	}
	catch( IOException e )
	{
		nRet = 3;
	}
	
	if (nRet != 0) return nRet;
	// ---------------- Test to Export the SubTree from XMLTreeBuilder ---------------
	// if next function blocks, no done() is send, to reset the internal condition

	String aFilename = OUString::createFromAscii("e:/temp/configfile_xmltreechangelistbuilder_test.xml");
	SvFileStream aStream( aFilename, STREAM_TRUNC | STREAM_WRITE );
	Reference<XOutputStream> xOStream = new utl::OOutputStreamWrapper(aStream);
	// writeTest(pTree);
	CmXMLFormater_impl::Write(xOStream, aTree);

	return nRet;
}
#ifndef _COM_SUN_STAR_SCRIPT_XTYPECONVERTER_HPP_
#include <com/sun/star/script/XTypeConverter.hpp>
#endif

// -----------------------------------------------------------------------------
sal_Int32 CmXMLFormater_impl::Write( const Reference < XOutputStream> &xStream, const TreeChangeList &aTree )
{
	// PRE: an open stream, to write the data
	//      tree, where to get the data
	// POST: open SAX XML Writer

	sal_Int32 nRet = 0;
		Reference<XMultiServiceFactory> xServiceFactory = comphelper::getProcessServiceFactory();
	OSL_ENSURE( xServiceFactory.is(),
			"XMLReader::Read: got no service manager" );
	if( !xServiceFactory.is() )
		return ERR_SWG_WRITE_ERROR;

	// get writer
	
	Reference <XInterface> xXMLWriter =
		xServiceFactory->createInstance(
			OUString::createFromAscii("com.sun.star.extensions.xml.sax.Writer") );
	OSL_ENSURE( xXMLWriter.is(), "XMLWriter::Writer: com.sun.star.extensions.xml.sax.Writer service missing" );
	if( !xXMLWriter.is() )
		return ERR_SWG_WRITE_ERROR;

	Reference< XDocumentHandler > xHandler(xXMLWriter, UNO_QUERY);
	Reference< XActiveDataSource > xDataSource( xHandler , UNO_QUERY );
	OSL_ENSURE( xDataSource.is() , "no active data source" );

	xDataSource->setOutputStream(xStream);


	Reference< script::XTypeConverter > xTypeConv( xServiceFactory->createInstance(ASCII("com.sun.star.script.Converter") ) , UNO_QUERY);

	CmXMLFormater_impl *pExport = new CmXMLFormater_impl(&aTree.root, xTypeConv.get());
	if (pExport) 
	{
		pExport->SetHandler(xHandler);
		try
		{
			// implicit done be SetHandler()
			// pExport->WriteStart();
		}
		catch( SAXException e )
		{
			// Something goes wrong, perhaps the xml file is currupt
			nRet = 1;
		}
		delete pExport;
	}
	return 0;
}

// -----------------------------------------------------------------------------
Any binaryTest()
{
	Any anAny;

	rtl::OUString aStr;
	aStr = ASCII("414243444500FF");
	sal_Int16 nHex8;
	sal_Bool nHigh = true;
	Sequence<sal_Int8> aBinarySeq(aStr.getLength() / 2);
	sal_Int8 *pBinarySeq = aBinarySeq.getArray();
	sal_Int8 *pCheck = pBinarySeq;
	for(sal_Int32 nPos=0;nPos<aStr.getLength();nPos++)
	{
		sal_Char aHex = aStr[nPos];
		sal_Int8 nHex4 = 0;
		if (aHex >= '0' && aHex <= '9') nHex4 = aHex - '0';
		else if (aHex >= 'a' && aHex <= 'f') nHex4 = aHex - 'a' + 10;
		else if (aHex >= 'A' && aHex <= 'F') nHex4 = aHex - 'A' + 10;
		if (nHigh)
		{
			nHex8 = nHex4 << 4;
			nHigh = false;
		}
		else
		{
			nHex8 |= nHex4;
			nHigh = true;
			*pBinarySeq++ = nHex8;
		}
	}
	anAny <<= aBinarySeq;
	return anAny;
}

#pragma message(MSC_MSG("Hallo"))

OUString writeAny(const Any& rValue) 
{
	OUString aHexStr;
	if (rValue.getValueType() == getCppuType((Sequence<sal_Int8>*)(NULL)))
	{
		Sequence<sal_Int8> aBinarySeq;
		if (rValue >>= aBinarySeq)
		{
			sal_Int8 *pBinarySeq = aBinarySeq.getArray();
			sal_Int32 nLength = aBinarySeq.getLength();
			sal_Char *pHexField = new sal_Char[nLength * 2 + 1];
			sal_Char *pHex = pHexField;
			for (sal_Int32 nPos = 0;nPos < nLength;nPos++) {
			
				sal_Int8 n1 = (pBinarySeq[nPos] & 0xf0) >> 4;
				if (n1 >= 0 && n1 <= 9)
					n1 += '0';
				else
					n1 += 'a' - 10;
				
				*pHex++ = n1;

				sal_Int8 n2 = (pBinarySeq[nPos] & 0x0f);
				if (n2 >= 0 && n2 <= 9)
					n2 += '0';
				else
					n2 += 'a' - 10;

				*pHex++ = n2;
			}
			*pHex++ = 0;
			aHexStr = ASCII(pHexField);
			delete [] pHexField;
		}
	}
	return aHexStr;
}
