/*************************************************************************
 *
 *  $RCSfile: commandbase.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/30 07:54:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_COMMANDBASE_HXX_
#define _DBA_CORE_COMMANDBASE_HXX_

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_ 
#include <com/sun/star/uno/Sequence.hxx>
#endif

namespace utl
{
	class OConfigurationNode;
}

//........................................................................
namespace dbaccess
{
//........................................................................

//==========================================================================
//= OCommandBase - a base class (in fact just a container for some members)
//=					for classes implementing the sdb.CommandDefinition service
//==========================================================================
class OCommandBase
{
protected:
// <properties>
	::com::sun::star::uno::Sequence< sal_Int8>	m_aLayoutInformation;
	::rtl::OUString								m_sElementName;
	::rtl::OUString								m_sCommand;
	sal_Bool									m_bEscapeProcessing;		// no BitField ! so it can be used with a OPropertyContainer
	::rtl::OUString								m_sUpdateTableName;
	::rtl::OUString								m_sUpdateSchemaName;
	::rtl::OUString								m_sUpdateCatalogName;
// </properties>

protected:
	OCommandBase() : m_bEscapeProcessing(sal_True) { }

	/** store all configuration relevant informations under the given configuration node
		@param		_rConfigLocation		the configuration node. must not be readonly
	*/
	void	storeTo(const ::utl::OConfigurationNode& _rConfigLocation);

	/** initialize with the informations stored under the given configuration node
		@param		_rConfigLocation		the configuration node.
	*/
	void	loadFrom(const ::utl::OConfigurationNode& _rConfigLocation);
};

//........................................................................
}	// namespace dbaccess
//........................................................................

#endif // _DBA_CORE_COMMANDBASE_HXX_


