/*************************************************************************
 *
 *  $RCSfile: querydesignaccess.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/19 17:52:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_QUERYDESIGNACCESS_HXX_
#include "querydesignaccess.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_ 
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef DBAUI_COMPONENTCLIENTMONITOR_HXX
#include "componentclientmonitor.hxx"
#endif

// .........................................................................
namespace dbaui
{
// .........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::frame;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::util;

	//======================================================================
	//= ODesignAccess
	//======================================================================
	ODesignAccess::ODesignAccess(const Reference< XMultiServiceFactory >& _rxORB)
		:m_xORB(_rxORB)
	{
		OSL_ENSURE(m_xORB.is(), "ODesignAccess::ODesignAccess: invalid service factory!");
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::create(const ::rtl::OUString& _rDatasourceName, const Reference< XConnection >& _rxConnection)
	{
		Sequence< PropertyValue > aArguments;
		fill( aArguments, _rDatasourceName, _rxConnection,::rtl::OUString() );
		return doDispatch( aArguments );
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::create(const ::rtl::OUString& _rDatasourceName, const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor)
	{
		OSL_ENSURE( _rClientMonitor.isValid(), "ODesignAccess::create: invalid monitor!" );
		Reference< XComponent > xReturn;

		if ( _rClientMonitor.isValid() )
		{
			Reference< XConnection > xConn( _rClientMonitor->getComponent(), UNO_QUERY );
			OSL_ENSURE( xConn.is(), "ODesignAccess::create: invalid connection!" );

			xReturn = create( _rDatasourceName, xConn );
			if ( xReturn.is() )
				_rClientMonitor->registerClient( xReturn );
		}

		return xReturn;
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::doDispatch( const Sequence< PropertyValue >& _rArgs )
	{
		Reference< XComponent > xReturn;
		if (m_xORB.is())
		{
			try
			{
				// get the desktop object
				Reference< XInterface > xDesktop = m_xORB->createInstance(SERVICE_FRAME_DESKTOP);
				Reference< XComponentLoader > xLoader(xDesktop, UNO_QUERY);
				OSL_ENSURE(xLoader.is(), "ODesignAccess::doDispatch: invalid desktop object!");

				if ( xLoader.is() )
				{
					xReturn = xLoader->loadComponentFromURL(
						getDispatchURL(),
						::rtl::OUString::createFromAscii("_default"), // #104099# OJ
						FrameSearchFlag::TASKS | FrameSearchFlag::CREATE,
						_rArgs
					);
				}
			}
			catch(Exception&)
			{
				OSL_ENSURE(sal_False, "ODesignAccess::getDispatcher: caught an exception while loading the component!");
			}
		}
		return xReturn;
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::edit(const ::rtl::OUString& _rDatasourceName, const ::rtl::OUString& _rName, const Reference< XConnection >& _rxConnection)
	{
		Sequence< PropertyValue > aArguments;
		fill(aArguments, _rDatasourceName, _rxConnection, _rName);
		return doDispatch( aArguments );
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::edit(const ::rtl::OUString& _rDatasourceName, const ::rtl::OUString& _rName, const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor)
	{
		OSL_ENSURE( _rClientMonitor.isValid(), "ODesignAccess::edit: invalid monitor!" );
		Reference< XComponent > xReturn;

		if ( _rClientMonitor.isValid() )
		{
			Reference< XConnection > xConn( _rClientMonitor->getComponent(), UNO_QUERY );
			OSL_ENSURE( xConn.is(), "ODesignAccess::edit: invalid connection!" );

			xReturn = edit( _rDatasourceName, _rName, xConn );
			if ( xReturn.is() )
				_rClientMonitor->registerClient( xReturn );
		}

		return xReturn;
	}

	//======================================================================
	//= OQueryDesignAccess
	//======================================================================
	//----------------------------------------------------------------------
	OQueryDesignAccess::OQueryDesignAccess(const Reference< XMultiServiceFactory >& _rxORB, sal_Bool _bCreateView, sal_Bool _bPreferSQLView)
		:ODesignAccess(_rxORB)
		,m_bCreateView(_bCreateView)
		,m_bPreferSQLView(_bPreferSQLView)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString OQueryDesignAccess::getDispatchURL() const
	{
		return URL_COMPONENT_QUERYDESIGN;
	}

	//----------------------------------------------------------------------
	void OQueryDesignAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const ::rtl::OUString& _rDatasourceName,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rQueryName)
	{
		sal_Bool bIncludeQueryName = 0 != _rQueryName.getLength();

		_rDispatchArguments.realloc(3 + (bIncludeQueryName ? 1 : 0) + (_rxConnection.is() ? 1 : 0));
		sal_Int32 nPos = 0;
		_rDispatchArguments[nPos  ].Name = PROPERTY_DATASOURCENAME;
		_rDispatchArguments[nPos++].Value <<= _rDatasourceName;

		_rDispatchArguments[nPos  ].Name = PROPERTY_QUERYDESIGNVIEW;
		_rDispatchArguments[nPos++].Value <<= ::cppu::bool2any(!m_bPreferSQLView);

		_rDispatchArguments[nPos  ].Name = PROPERTY_CREATEVIEW;
		_rDispatchArguments[nPos++].Value <<= ::cppu::bool2any(m_bCreateView);

		if (_rxConnection.is())
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_ACTIVECONNECTION;
			_rDispatchArguments[nPos++].Value <<= _rxConnection;
		}

		if (bIncludeQueryName)
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_CURRENTQUERY;
			_rDispatchArguments[nPos++].Value <<= _rQueryName;
		}
	}

	//======================================================================
	//= OTableDesignAccess
	//======================================================================
	//----------------------------------------------------------------------
	OTableDesignAccess::OTableDesignAccess(const Reference< XMultiServiceFactory >& _rxORB)	: ODesignAccess(_rxORB)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString OTableDesignAccess::getDispatchURL() const
	{
		return URL_COMPONENT_TABLEDESIGN;
	}

	//----------------------------------------------------------------------
	void OTableDesignAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const ::rtl::OUString& _rDatasourceName,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rTableName)
	{
		sal_Bool bIncludeName = 0 != _rTableName.getLength();

		_rDispatchArguments.realloc(1 + (bIncludeName ? 1 : 0) + (_rxConnection.is() ? 1 : 0));

		sal_Int32 nPos = 0;
		_rDispatchArguments[nPos  ].Name = PROPERTY_DATASOURCENAME;
		_rDispatchArguments[nPos++].Value <<= _rDatasourceName;

		if (_rxConnection.is())
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_ACTIVECONNECTION;
			_rDispatchArguments[nPos++].Value <<= _rxConnection;
		}

		if (bIncludeName)
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_CURRENTTABLE;
			_rDispatchArguments[nPos++].Value <<= _rTableName;
		}
	}
	//======================================================================
	//= ORelationDesignAccess
	//======================================================================
	//----------------------------------------------------------------------
	ORelationDesignAccess::ORelationDesignAccess(const Reference< XMultiServiceFactory >& _rxORB)	: ODesignAccess(_rxORB)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString ORelationDesignAccess::getDispatchURL() const
	{
		return URL_COMPONENT_RELATIONDESIGN;
	}

	//----------------------------------------------------------------------
	void ORelationDesignAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const ::rtl::OUString& _rDatasourceName,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rTableName)
	{

		_rDispatchArguments.realloc(1 + (_rxConnection.is() ? 1 : 0));

		sal_Int32 nPos = 0;
		_rDispatchArguments[nPos  ].Name = PROPERTY_DATASOURCENAME;
		_rDispatchArguments[nPos++].Value <<= _rDatasourceName;

		if (_rxConnection.is())
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_ACTIVECONNECTION;
			_rDispatchArguments[nPos++].Value <<= _rxConnection;
		}
	}

// .........................................................................
}	// namespace dbaui
// .........................................................................

