/*************************************************************************
 *
 *  $RCSfile: content.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <content.hrc>
#include <content.hxx>

#ifndef _CNTCMPMN_HXX //autogen
#include <svtools/cntcmpmn.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANCELLEDEXCEPTION_HXX_
#include <smart/com/sun/star/address/CancelledException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKSOURCEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookSourceDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTYVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredPropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPROPERTYPARAMETERINFO_HXX_
#include <smart/com/sun/star/address/AddressBookPropertyParameterInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XSYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XSynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENTTYPE_HXX_
#include <smart/com/sun/star/address/JobEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYFUNCTION_HXX_
#include <smart/com/sun/star/address/AddressBookQueryFunction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKSCHEMATASUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookSchemataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOB_HXX_
#include <smart/com/sun/star/address/XJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYPARSER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASEFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKJOBFACTORYSUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookJobFactorySupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBLISTENER_HXX_
#include <smart/com/sun/star/address/XJobListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRECORDCONTAINER_HXX_
#include <smart/com/sun/star/address/XAddressBookRecordContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEFIELD_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYWRITER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryWriter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENT_HXX_
#include <smart/com/sun/star/address/JobEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XASYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XAsynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTY_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredProperty.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASESCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYTERM_HXX_
#include <smart/com/sun/star/address/AddressBookQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSORTINFO_HXX_
#include <smart/com/sun/star/address/AddressBookSortInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANTCONNECTEXCEPTION_HXX_
#include <smart/com/sun/star/address/CantConnectException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCOPE_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPScope.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRESULTSETDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/address/XAddressBookResultSetDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBFACTORY_HXX_
#include <smart/com/sun/star/address/XJobFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKXMLIMPORT_HXX_
#include <smart/com/sun/star/address/XAddressBookXMLImport.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XERRORHANDLER_HXX_
#include <smart/com/sun/star/xml/sax/XErrorHandler.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XENTITYRESOLVER_HXX_
#include <smart/com/sun/star/xml/sax/XEntityResolver.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_INPUTSOURCE_HXX_
#include <smart/com/sun/star/xml/sax/InputSource.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XDTDHANDLER_HXX_
#include <smart/com/sun/star/xml/sax/XDTDHandler.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_XML_SAX_XPARSER_HXX_
#include <smart/com/sun/star/xml/sax/XParser.hxx>
#endif


#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif

static ResMgr* pSsResMgr = 0;

OAdrResId::OAdrResId( USHORT nId ) 
	: ResId( nId, GetResManager() ) 
{
}

ResMgr* OAdrResId::GetResManager()
{
	if( !pSsResMgr )
	{
		String aPfx = "aco";
		aPfx += String(SUPD);
		if( GetpApp() )
			pSsResMgr = ResMgr::CreateResMgr( aPfx, LANGUAGE_DONTKNOW );
		else pSsResMgr = ResMgr::CreateResMgr( aPfx, LANGUAGE_DONTKNOW, 0,0 );
	}
	return pSsResMgr;
}

// implement isEqual for all properties used in propertysets

inline BOOL isEqual( const SortingInfo& r1, const SortingInfo& r2 )
{
	return r1.PropertyName == r2.PropertyName && 
		r1.Ascending == r2.Ascending;
}

DECLARE_SEQEQUAL( SortingInfo )

inline BOOL isEqual( const ContentType& r1, const ContentType& r2 )
{
	return r1.Type == r2.Type && r1.Presentation == r2.Presentation;
}

BOOL isEqual( 
	const MenuItemDescriptor& r1, const MenuItemDescriptor& r2 )
{
    return 
		r1.ItemText == r2.ItemText &&
		r1.Command == r2.Command &&
		r1.HelpUrl == r2.HelpUrl &&
		r1.ParentPos == r2.ParentPos &&
		r1.ItemFlags == r2.ItemFlags &&
		r1.InsertionPos == r2.InsertionPos;
}

DECLARE_SEQEQUAL( MenuItemDescriptor )

inline BOOL isEqual( const MenuDescriptor& r1, const MenuDescriptor& r2 )
{
	return isEqual( r1.Items, r2.Items );
}

void OContentData::fillClassInfo(
	OObjectClassBase*& rpParentClass, Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY(
			OContentData, IsFolder, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, HasFolder, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, MaskColor, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, OwnURL, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, Rename, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, Sorting, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, TargetFrames, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, Title, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, ContentType, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, DeleteMe, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, NewChild, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, MessageId, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, IconId, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, ViewDescription, PropertyAttribute_BOUND ),
			ADR_PROPERTY(
				OContentData, PopupMenu, PropertyAttribute_BOUND )
//  			,
//  			ADR_PROPERTY(
//  				OContentData, Commands, PropertyAttribute_BOUND )
			};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

XIdlClassRef OContent::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OContent", 
		OPropertySet::getStaticIdlClass(), 2,
		XURLContent_getReflection(), 
		XCommandExecutor_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OContent::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OContent::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XURLContent );
	QUERYIFACE( XChild );
	QUERYIFACE( XCommandExecutor );
	return OPropertySet::queryInterface( aUik, rOut );
}

BOOL OContent::initialize(
	const XURLContentRef& aParent, const UString& rURL )
{
	setParent( XChildRef( aParent, USR_QUERY ) );
	{
		OGuard aGuard( m_aMutex );
		m_OwnURL = rURL;
	}
	return TRUE;
}

void OContent::cancel(const XInterfaceRef& CommandId)
{
}

void OContent::importSource(
	const XPropertySetRef& xSource, const UString& rPath )
{
	
	UsrAny aFileNameAny( rPath );
	// fill source with standard data
	XAddressBookXMLImportRef xImport(
		m_xMgr->createInstance( 
			L"com.sun.star.address.XMLImport" ),
		USR_QUERY );
	xImport->setTarget( makeAny( xSource) );
	
	XParserRef xParser(
		m_xMgr->createInstance( 
			L"com.sun.star.xml.sax.Parser" ), USR_QUERY );
	xParser->setDocumentHandler(
		XDocumentHandlerRef( xImport, USR_QUERY ) );
	InputSource aSource;
	aSource.aInputStream = XInputStreamRef(
		m_xMgr->createInstanceWithArguments(
			L"com.sun.star.address.InputStream", 
			Sequence<UsrAny>( &aFileNameAny, 1 ) ), USR_QUERY );
	TRY
		{
			xParser->parseStream( aSource );
		}
	CATCH( SAXException, e )
		{
		}
	END_CATCH;
}

UString OContent::getDefaultXMLPath( 
	const XPropertySetRef& xFactProp )
{
	if( xFactProp->getPropertySetInfo()->hasPropertyByName( 
		L"DefaultXML" ) )
	{
		UString aDefaultXML;
		xFactProp->getPropertyValue( L"DefaultXML" ) >>= 
			aDefaultXML;
		XNameAccessRef xSettings( m_xMgr->createInstance(
			L"com.sun.star.frame.Settings" ), USR_QUERY );
		if( xSettings.is() )
		{
			XPropertySetRef xProps;
			extractInterface( 
				xSettings->getByName( L"PathSettings" ), xProps );
			UString aPath;
			if( xProps.is() && (
				xProps->getPropertyValue( L"Config" )  >>= aPath ) )
			{
				DirEntry aEntry( SHOULDTAKEUNICODE( aPath ));
				aEntry += DirEntry( SHOULDTAKEUNICODE( 
					aDefaultXML ) );
				return SHOULDBEUNICODE( aEntry.GetFull() );
			}
		}
	}
	return UString();
}


XDataEditorRef OContent::getDataEditor( 
	const UString& rSourceServiceName )
{
	XDataEditorRef xEdit;
	XPropertySetRef xProp( getFactory( rSourceServiceName ), USR_QUERY );
	if( xProp.is() )
	{
		if( xProp->getPropertySetInfo()->hasPropertyByName( 
			L"DialogService" ) )
		{
			UString aDialogServiceName;
			xProp->getPropertyValue( L"DialogService" ) >>= 
				aDialogServiceName;
			// construct matching dialog service
			xEdit = XDataEditorRef( 
				m_xMgr->createInstance( aDialogServiceName ), USR_QUERY );
		}
	}
	return xEdit;
}

XSingleServiceFactoryRef OContent::getFactory( 
	const UString& rSourceServiceName )
{
	// is the command a source service name?
	XEnumerationAccessRef xAccess( m_xMgr->createInstance( 
		L"com.sun.star.address.AddressBookServices" ), USR_QUERY );
	XEnumerationRef xEnum = xAccess->createEnumeration();
	XSingleServiceFactoryRef xFact;
	XPropertySetRef xFactProp;
	while( !xFact.is() && xEnum->hasMoreElements() )
	{
		if( extractInterface( xEnum->nextElement(), xFactProp ) )
		{
			Sequence<UString> aSupportedServices;
			xFactProp->getPropertyValue( L"SupportedServiceNames" ) >>= 
				aSupportedServices;
			const UString* pFirst = aSupportedServices.getConstArray();
			const UString* pLast = pFirst + aSupportedServices.getLen();
			for(; pFirst != pLast; pFirst++ )
				if( *pFirst == rSourceServiceName ) 
				{
					xFact = XSingleServiceFactoryRef( xFactProp, USR_QUERY );
					break;
				}
		}
	}
	return xFact;
}
////////////////////////////////////////////////////////////////////////////

OContentRoot::OContentRoot( const XMultiServiceFactoryRef& xMgr )
	: OContent( xMgr )
{
	{
		BOOL bHasTypeSources = FALSE;
		XEnumerationAccessRef xAccess( m_xMgr->createInstance(
			L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
		XEnumerationRef xEnum( xAccess->createEnumeration() );
		Sequence<UString> aTypes;
		while( !bHasTypeSources && xEnum->hasMoreElements() )
		{
			XPropertySetRef xProp;
			extractInterface( xEnum->nextElement(), xProp );
			xProp->getPropertyValue( L"Types" ) >>= aTypes;
			if( containsValue( aTypes, L"typeSource" ) )
			{
				bHasTypeSources = TRUE;
				break;
			}
		}
		if( !bHasTypeSources ) createDefaultSources();
	}

	m_ContentType.Type = L"application/x-addressbook";
	m_TargetFrames = ( L";_document;_blank" );
	m_Title = L"Adressbuch";

	vector<MenuItemDescriptor> aItems;
	MenuItemDescriptor aDescr;
	aDescr.ParentPos = 0;
	aDescr.InsertionPos = 0;
	aDescr.ItemFlags = CNT_COMPMENU_SEPARATOR;
	aItems.push_back( aDescr );
	
	aDescr.ItemText = L"New";
	aDescr.HelpUrl = L"";
	aDescr.ItemFlags = 0;
	aItems.push_back( aDescr );
	
	XEnumerationAccessRef xAccess( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookServices" ), USR_QUERY );
	XEnumerationRef xEnumeration( xAccess->createEnumeration() );
	aDescr.ParentPos = 2;
	while( xEnumeration->hasMoreElements() )
	{
		XPropertySetRef xProp;
		extractInterface( xEnumeration->nextElement(), xProp );
		aDescr.ItemText = L"Unknown";
		aDescr.Command = L"";
		XPropertySetInfoRef xInfo = xProp->getPropertySetInfo();
		if( xInfo->hasPropertyByName( L"SupportedServiceNames" ) &&
			xInfo->hasPropertyByName( L"UIName" ) )
		{
			Sequence<UString> aServices;
			xProp->getPropertyValue( L"SupportedServiceNames" ) >>= aServices;
			const UString* pFirst = aServices.getConstArray();
			const UString* pLast = pFirst + aServices.getLen();
			xProp->getPropertyValue( L"UIName" ) >>= aDescr.ItemText;
			for( ;pFirst != pLast; pFirst++ )
				if( pFirst->len() &&
					*pFirst != L"com.sun.star.address.AddressBookSourceSchedule"  &&
					*pFirst != L"com.sun.star.address.AddressBookSource" )
				{
					aDescr.Command = *pFirst;
					aItems.push_back( aDescr );
					break;
				}
		}
	}
	
	aDescr.ParentPos = 0;
	aDescr.ItemFlags = CNT_COMPMENU_SEPARATOR;
	aItems.push_back( aDescr );
	copyContainerToSequence( aItems, m_PopupMenu.Items );
}

void OContentRoot::createDefaultSources()
{
	UString aDefaultSDBName;
	UString aDefaultSDBDBName;
	UString aDefaultSDBTable;
	UString aAutocompleteName;
	UString aAutobrowseName;
	UString aAutomailName;
	{
		// The resource system is not thread enabled
		OGuard aGuard( Application::GetSolarMutex() );
		aDefaultSDBName = SHOULDBEUNICODE(
			String( OAdrResId( RID_STR_CONTENT_DEFAULTSDB_NAME ) ) );

		XNameAccessRef xSettings( m_xMgr->createInstance(
			L"com.sun.star.frame.Settings" ), USR_QUERY );
		if( xSettings.is() )
		{
			XPropertySetRef xProps;
			extractInterface( xSettings->getByName( L"PathSettings" ), xProps );
			UString aPath;
			if( xProps.is() &&
				(xProps->getPropertyValue( L"Storage" )  >>= aPath ) )
			{
				DirEntry aEntry( SHOULDTAKEUNICODE( aPath ) );
				aEntry += DirEntry( "adrdbf" );
				aDefaultSDBDBName = SHOULDBEUNICODE( aEntry.GetFull() );
			}
		}
		
		aDefaultSDBTable = L"address";
		aAutocompleteName = SHOULDBEUNICODE(
			String( OAdrResId( RID_STR_TYPE_AUTOCOMPLETE ) ) );
		aAutobrowseName = SHOULDBEUNICODE(
			String( OAdrResId( RID_STR_TYPE_AUTOBROWSE ) ) );
		aAutomailName = SHOULDBEUNICODE(
			String( OAdrResId( RID_STR_TYPE_AUTOMAIL ) ) );
	}
		
	XSetRef xSources( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookSources" ), USR_QUERY );

	// create sdb source for table adresses
	XPropertySetRef xFact( getFactory(
		L"com.sun.star.address.AddressBookSourceSimpleDatabase" ), USR_QUERY );
	XPropertySetRef xSource(
		m_xMgr->createInstance( L"com.sun.star.address.AddressBookSourceSimpleDatabase" ), 
		USR_QUERY );
	UString aXML = getDefaultXMLPath( XPropertySetRef( xFact, USR_QUERY ) );
	if( aXML.len() ) importSource( xSource, aXML );
	xSource->setPropertyValue( 	L"Name", UsrAny( aDefaultSDBName ) );
	
	Sequence<PropertyValue> aArgs( 3 );
	PropertyValue* pArgs = aArgs.getArray();
	pArgs[ 0 ].Name = L"DSN";
	pArgs[ 0 ].Value <<= aDefaultSDBDBName;
	pArgs[ 1 ].Name = L"CHARSET";
	pArgs[ 1 ].Value <<= UString( L"IBMPC" );
	pArgs[ 2 ].Name = L"TYPE";
	pArgs[ 2 ].Value <<= UString( L"DBF" );
	xSource->setPropertyValue( L"ConnectionParameters", makeAny( aArgs ) );

	Sequence<AddressBookSourceSimpleDatabaseSchemaDefinition> aSchemata;
	xSource->getPropertyValue( L"Schemata" ) >>= aSchemata;
	if( aSchemata.getLen() ) 
		aSchemata.getArray()->Table = aDefaultSDBTable;
	xSource->setPropertyValue( L"Schemata", makeAny( aSchemata ) );
	UString aType( L"userSource" );
	Sequence<UString> aTypes( &aType, 1 );
	xSource->setPropertyValue( L"Types", makeAny( aTypes ) );
	xSources->insert( makeAny( xSource ) );
	UString aDefaultUid;
	xSource->getPropertyValue( L"Uid" ) >>= aDefaultUid;
	
	aType = L"typeSource";
	aTypes = Sequence<UString>( &aType, 1 );
	
	Sequence<UString> aSources( &aDefaultUid, 1 );
	
	xSource = XPropertySetRef(
		m_xMgr->createInstance( 
			L"com.sun.star.address.AddressBookSourceMerging" ), USR_QUERY );
	xSource->setPropertyValue( L"Types", makeAny( aTypes ));
	xSource->setPropertyValue( L"Sources", makeAny( aSources ) );
	xSource->setPropertyValue( L"Name", makeAny( aAutocompleteName ) );
	xSource->setPropertyValue( L"Uid", makeAny( UString( L"autocomplete") ) );
	xSources->insert( makeAny( xSource ) );
	
	xSource = XPropertySetRef(
		m_xMgr->createInstance( 
			L"com.sun.star.address.AddressBookSourceMerging" ), USR_QUERY );
	xSource->setPropertyValue( L"Types", makeAny( aTypes ));
	xSource->setPropertyValue( L"Sources", makeAny( aSources ) );
	xSource->setPropertyValue( L"Name", aAutomailName );
	xSource->setPropertyValue( L"Uid", makeAny( UString( L"automail") ) );
	xSources->insert( makeAny( xSource ) );
	
	xSource = XPropertySetRef(
		m_xMgr->createInstance( 
			L"com.sun.star.address.AddressBookSourceMerging" ), USR_QUERY );
	xSource->setPropertyValue( L"Types", makeAny( aTypes ));
	xSource->setPropertyValue( L"Sources", makeAny( aSources ) );
	xSource->setPropertyValue( L"Name", aAutobrowseName );
	xSource->setPropertyValue( L"Uid", makeAny( UString( L"autobrowse") ) );
	xSources->insert( makeAny( xSource ) );

	xSource = XPropertySetRef(
		m_xMgr->createInstance( 
			L"com.sun.star.address.AddressBookSourceMerging" ), USR_QUERY );
	xSource->setPropertyValue( L"Types", makeAny( aTypes ));
	xSource->setPropertyValue( L"Sources", makeAny( aSources ) );
	xSource->setPropertyValue( L"Name", aAutobrowseName );
	xSource->setPropertyValue( L"Uid", makeAny( UString( L"pilotsync") ) );
	xSources->insert( makeAny( xSource ) );
}


Sequence< UString > OContentRoot::queryCommands() const 
{
	vector<UString> aCommands;

	XEnumerationAccessRef xAccess( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookServices" ), USR_QUERY );
	XEnumerationRef xEnumeration( xAccess->createEnumeration() );
	while( xEnumeration->hasMoreElements() )
	{
		UString aCommand;
		XPropertySetRef xProp;
		extractInterface( xEnumeration->nextElement(), xProp );
		if( xProp->getPropertySetInfo()->hasPropertyByName(
			L"SupportedServiceNames" ) )
		{
			Sequence<UString> aServices;
			xProp->getPropertyValue( L"SupportedServiceNames" ) >>= aServices;
			const UString* pFirst = aServices.getConstArray();
			const UString* pLast = pFirst + aServices.getLen();
			for( ;pFirst != pLast; pFirst++ )
				if( *pFirst != L"com.sun.star.address.AddressBookSource" )
				{
					aCommands.push_back( *pFirst );
					break;
				}
		}
	}
	aCommands.push_back( L"open" );
	aCommands.push_back( L"showPropertyDialog" );
	
	Sequence<UString> aSeq;
	copyContainerToSequence( aCommands, aSeq );
	return aSeq;
}

void OContentRoot::execute(
	const UString& Command, const UsrAny& Args, 
	const XStatusCallbackRef& Callback)
{
	StatusCallbackEvent aEvent(
		*this, XInterfaceRef(), Command, Args );
	if( Command == L"open" )
	{
		XNameAccessRef xNames( m_xMgr->createInstance(
			L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
		Sequence<UString> aNames( xNames->getElementNames() );
		const UString* pFirstNames = aNames.getConstArray();
		const UString* pLastNames = pFirstNames + aNames.getLen();
		UString aType( L"userSource" );
		for(; pFirstNames != pLastNames; pFirstNames++ )
		{
			UString aName;
			{
				OGuard aGuard( m_aMutex );
				aName = m_OwnURL;
			}
			XPropertySetRef xProp;
			extractInterface( xNames->getByName( *pFirstNames ), xProp );
			if( xProp.is() )
			{
				Sequence<UString> aTypes;
				if( (xProp->getPropertyValue( L"Types" ) >>= aTypes ) &&
					containsValue( aTypes, aType ) )
				{
					UString aUid;
					xProp->getPropertyValue( L"Uid" ) >>= aUid;
					Callback->result( aEvent, 1, aUid );
				}
			}
		}
		XContainerRef xContainer( xNames, USR_QUERY );
		xContainer->addContainerListener( this );
	}
	else if( Command == L"showPropertyDialog" )
	{
		XNameAccessRef xNames( m_xMgr->createInstance(
			L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
		XDataEditorRef xEdit( m_xMgr->createInstance(
			L"com.sun.star.address.DialogGeneral" ), USR_QUERY );
		xEdit->setModel( xEdit );
		xEdit->show();
	}
	else if( Command == L"createDefaultSources" )
	{
		createDefaultSources();
	}
	else 
	{
		// is the command a source service name?
		XEnumerationAccessRef xAccess( m_xMgr->createInstance( 
			L"com.sun.star.address.AddressBookServices" ), USR_QUERY );
		XEnumerationRef xEnum = xAccess->createEnumeration();
		XSingleServiceFactoryRef xFact( getFactory( Command ) );
		if( xFact.is() )
		{
			XPropertySetRef xFactProp( xFact, USR_QUERY );
			XDataEditorRef xEdit = getDataEditor( Command );
			if( xEdit.is() )
			{
				XPropertySetRef xSource( 
					xFact->createInstance(), USR_QUERY );
				
				UString aPath = getDefaultXMLPath( xFactProp );
				if( aPath.len() )
					importSource( xSource, aPath );
				
				xEdit->setModel( xSource );
				xEdit->addDataEditorListener( 
					new OSourceEditorListener( xEdit, m_xMgr, TRUE ) );
				xEdit->show();
			}
		}
	}
	if( Callback.is() ) Callback->done( aEvent );
}

void OContentRoot::elementInserted(const ContainerEvent& Event) 
	THROWS( (UsrSystemException) )
{
	XPropertySetRef xProp;
	extractInterface( Event.Element, xProp );
	UString aCmd( L"NewChild" );
	setPropertyValue( 
		aCmd, xProp->getPropertyValue( L"Uid" ) );
	setPropertyValue( aCmd, UsrAny( UString() ) );
}

void OContentRoot::elementRemoved(const ContainerEvent& Event) 
	THROWS( (UsrSystemException) )
{
	XPropertySetRef xProp;
	extractInterface( Event.Element, xProp );
	UString aCmd( L"DeleteMe" );
	setPropertyValue( aCmd, xProp->getPropertyValue( L"Uid" ) );
	setPropertyValue( aCmd, UsrAny( UString() ) );
}

void OContentRoot::elementReplaced(const ContainerEvent& Event) 
	THROWS( (UsrSystemException) )
{
	ContainerEvent aEvent( Event );
	aEvent.Element = aEvent.ReplacedElement;
	aEvent.ReplacedElement = UsrAny();
	elementRemoved( aEvent );
	elementInserted( Event );
}

void OContentRoot::disposing()
{
	XContainerRef xContainer( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
	xContainer->removeContainerListener( this );
}

XIdlClassRef OContentRoot::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OContentRoot", 
		OContent::getStaticIdlClass(), 1,
		XContainerListener_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OContentRoot::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OContentRoot::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XContainerListener );
	return OContent::queryInterface( aUik, rOut );
}

////////////////////////////////////////////////////////////////////////////

OContentSource::OContentSource( const XMultiServiceFactoryRef& xMgr )
	: OContent( xMgr )
{
	m_ContentType.Type = L"application/x-addressbooksource";
	m_IsFolder = FALSE;
	m_HasFolder = FALSE;
}

XIdlClassRef OContentSource::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OContentRoot", 
		OContent::getStaticIdlClass(), 1,
		XPropertyChangeListener_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OContentSource::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OContentSource::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XPropertyChangeListener );
	return OContent::queryInterface( aUik, rOut );
}

Sequence< UString > OContentSource::queryCommands() const
{
	static const UString aCommandList[] =
	{
		L"rename",
		L"open",
		L"delete",
		L"undelete",
		L"prepareMenu",
		L"showPropertyDialog"
	};
	static const UString aReadOnlyCommandList[] =
	{
		L"open",
		L"prepareMenu",
		L"showPropertyDialog"
	};

	BOOL bReadOnly;
	if( !( m_xSource->getPropertyValue( L"ReadOnly" ) >>= bReadOnly ) )
		THROW( IllegalArgumentException() );
	
	if( bReadOnly ) return Sequence< UString >(
		aReadOnlyCommandList,
		sizeof( aReadOnlyCommandList ) / sizeof( UString ));
	else return Sequence< UString >(
		aCommandList, sizeof( aCommandList ) / sizeof( UString ));
}

void OContentSource::execute(
	const UString& Command, const UsrAny& Args, 
	const XStatusCallbackRef& Callback)
{
	StatusCallbackEvent aEvent(
		*this, XInterfaceRef(), Command, Args );
	if( Command == L"delete" )
	{
		XUniqueIDAccessRef xSources( m_xMgr->createInstance(
			L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
		xSources->removeByUniqueID(
			m_xSource->getPropertyValue( L"Uid" ).getString() );
	}
	else if( Command == L"showPropertyDialog" )
	{
		UString aServiceName;
		if( m_xSource->getPropertyValue( L"ServiceName" ) >>= aServiceName )
		{
			XDataEditorRef xEdit = getDataEditor( aServiceName );
			if( xEdit.is() )
			{
				xEdit->setModel( m_xSource );
				xEdit->show();
			}
		}
	}
	Callback->done( aEvent );
}

void OContentSource::disposing()
{
	m_xSource->removePropertyChangeListener( L"", this );
}

void OContentSource::update()
{
	setPropertyValue( 
		L"Title", m_xSource->getPropertyValue( L"Name" ) );
}

BOOL OContentSource::initialize( 
	const XURLContentRef& aParent, const UString& aURL )
{
	UString aUid = aURL.getToken( aURL.getTokenCount( L'/' ) - 1, L'/' );
	XUniqueIDAccessRef xSources( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
	XPropertySetRef xProp;
	TRY
	{
		extractInterface( xSources->getByUniqueID( aUid ),  xProp );
	}
	CATCH( NoSuchElementException, e )
	{
	}
	END_CATCH;
	if( xProp.is() )
	{
		m_xSource = xProp;
		xProp->addPropertyChangeListener( L"", this );
		update();
		return OContent::initialize( aParent, aURL );
	}
	return FALSE;
}

void OSourceEditorListener::updateDataEditorState(
	const DataEditorEvent& rEvent )
{
	if( rEvent.Type == DataEditorEventType_DONE && m_bNew )
	{
		XSetRef m_xCont( 
			m_xMgr->createInstance( L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
		XDataEditorRef xSource( rEvent.Source, USR_QUERY );
		XPropertySetRef xModel( xSource->getModel(), USR_QUERY );
		m_xCont->insert( makeAny( xModel) );
	}
	switch( rEvent.Type )
	{
		default:
		{
			m_xEditor->removeDataEditorListener( this );
			m_xEditor = (XDataEditor*)0;
		}
	}
}

XIdlClassRef OSourceEditorListener::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OSourceEditorListener", 
		UsrObject::getUsrObjectIdlClass(), 1,
		XDataEditorListener_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OSourceEditorListener::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OSourceEditorListener::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XDataEditorListener );
	QUERYIFACE( XEventListener );
	return UsrObject::queryInterface( aUik, rOut );
}


XIdlClassRef OIdentityInternationalizer::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OIdentityInternationalizer", 
		UsrObject::getUsrObjectIdlClass(), 1,
		XNameTranslator_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OIdentityInternationalizer::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OIdentityInternationalizer::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XNameTranslator );
	return UsrObject::queryInterface( aUik, rOut );
}

///////////////////////////////////////////////////////////////////////////

UString OResourceInternationalizer::getTranslatedName( const UString& rName )
{
	if( rName.getTokenCount( ':' ) != 2 ) THROW( IllegalArgumentException() );
	String aPfx = SHOULDTAKEUNICODE( rName.getToken( 0, ':' ) );
	aPfx += String(SUPD);
	OGuard aGuard( Application::GetSolarMutex() );
	ResMgr* pResMgr = ResMgr::CreateResMgr( aPfx, LANGUAGE_DONTKNOW );
	USHORT nId = (long)SHOULDTAKEUNICODE( rName.getToken( 1, ':' ) );
	String aStr( ResId( nId, pResMgr ) );
	delete pResMgr;
	return SHOULDBEUNICODE( aStr );
}

XIdlClassRef OResourceInternationalizer::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OResourceInternationalizer", 
		UsrObject::getUsrObjectIdlClass(), 1,
		XNameTranslator_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OResourceInternationalizer::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OResourceInternationalizer::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XNameTranslator );
	return UsrObject::queryInterface( aUik, rOut );
}



