/*************************************************************************
 *
 *  $RCSfile: services.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_SERVICES_HXX
#define _ADR_SERVICES_HXX


#include <propset.hxx>
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANCELLEDEXCEPTION_HXX_
#include <smart/com/sun/star/address/CancelledException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKSOURCEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookSourceDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTYVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredPropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPROPERTYPARAMETERINFO_HXX_
#include <smart/com/sun/star/address/AddressBookPropertyParameterInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XSYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XSynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENTTYPE_HXX_
#include <smart/com/sun/star/address/JobEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYFUNCTION_HXX_
#include <smart/com/sun/star/address/AddressBookQueryFunction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKSCHEMATASUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookSchemataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOB_HXX_
#include <smart/com/sun/star/address/XJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYPARSER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASEFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKJOBFACTORYSUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookJobFactorySupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBLISTENER_HXX_
#include <smart/com/sun/star/address/XJobListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRECORDCONTAINER_HXX_
#include <smart/com/sun/star/address/XAddressBookRecordContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEFIELD_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYWRITER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryWriter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENT_HXX_
#include <smart/com/sun/star/address/JobEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XASYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XAsynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTY_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredProperty.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASESCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYTERM_HXX_
#include <smart/com/sun/star/address/AddressBookQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSORTINFO_HXX_
#include <smart/com/sun/star/address/AddressBookSortInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANTCONNECTEXCEPTION_HXX_
#include <smart/com/sun/star/address/CantConnectException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCOPE_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPScope.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRESULTSETDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/address/XAddressBookResultSetDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBFACTORY_HXX_
#include <smart/com/sun/star/address/XJobFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XASSIGNABLE_HXX_
#include <smart/com/sun/star/schedule/XAssignable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULEQUERYTERM_HXX_
#include <smart/com/sun/star/schedule/ScheduleQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEBUSYTIME_HXX_
#include <smart/com/sun/star/schedule/XScheduleBusyTime.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULERESULTSETCHANGEDBROADCASTER_HXX_
#include <smart/com/sun/star/schedule/XScheduleResultSetChangedBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULERESULTSETCHANGEDEVENT_HXX_
#include <smart/com/sun/star/schedule/ScheduleResultSetChangedEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEPRINTCONTEXTSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XSchedulePrintContextSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULECURSORTYPE_HXX_
#include <smart/com/sun/star/schedule/ScheduleCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECONFIGURATIONSSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleConfigurationsSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSTRINGPROPERTYACCESS_HXX_
#include <smart/com/sun/star/schedule/XStringPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XINDEXFACTORYCONTAINER_HXX_
#include <smart/com/sun/star/schedule/XIndexFactoryContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEPROTOCOLPROVIDER_HXX_
#include <smart/com/sun/star/schedule/XScheduleProtocolProvider.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULERESULTSETCHANGEDLISTENER_HXX_
#include <smart/com/sun/star/schedule/XScheduleResultSetChangedListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECURSORFACTORY_HXX_
#include <smart/com/sun/star/schedule/XScheduleCursorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEWRITECONTAINER_HXX_
#include <smart/com/sun/star/schedule/XScheduleWriteContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEGROUPING_HXX_
#include <smart/com/sun/star/schedule/XScheduleGrouping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEDEFAULTCONFIGURATIONUIDSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleDefaultConfigurationUidSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULEUIDACCESS_HXX_
#include <smart/com/sun/star/schedule/XScheduleUidAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSION_HXX_
#include <smart/com/sun/star/schedule/XScheduleSession.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSIONMANAGER_HXX_
#include <smart/com/sun/star/schedule/XScheduleSessionManager.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_DURATION_HXX_
#include <smart/com/sun/star/schedule/Duration.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_SCHEDULERESULTSETCHANGEDEVENTTYPE_HXX_
#include <smart/com/sun/star/schedule/ScheduleResultSetChangedEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XNAMETRANSLATOR_HXX_
#include <smart/com/sun/star/schedule/XNameTranslator.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESERVERSSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleServersSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECONFIGURATIONSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleConfigurationSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSIONFACTORY_HXX_
#include <smart/com/sun/star/schedule/XScheduleSessionFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULECURSORDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/schedule/XScheduleCursorDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_SCHEDULE_XSCHEDULESESSIONSUPPLIER_HXX_
#include <smart/com/sun/star/schedule/XScheduleSessionSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XINITIALIZATION_HXX_
#include <smart/com/sun/star/lang/XInitialization.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HXX_
#include <smart/com/sun/star/container/XContentEnumerationAccess.hxx>
#endif


class OPropertySetPersistance
{
public:
	static void savePropertySet( 
		const XPropertySetRef& xProp, const XRegistryKeyRef& xKey );
	static void loadPropertySet( 
		const XPropertySetRef& xProp, const XRegistryKeyRef& xKey );
};

class OProxyFactory : 
	public OPropertySet, 
	public XSingleServiceFactory
{
public:
	SMART_UNO_DECLARATION( OProxyFactory, OPropertySet );
	OProxyFactory( 
		const XMultiServiceFactoryRef& xMgr, 
		const XSingleServiceFactoryRef& xFact );
	
	static void fillClassInfo(
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

    virtual XInterfaceRef createInstance(void) {
		return m_xFactory->createInstance(); }
    virtual XInterfaceRef createInstanceWithArguments(
		const Sequence< UsrAny >& aArguments) {
		return m_xFactory->createInstanceWithArguments( aArguments ); }
	
private:
	NAMESPACE_VOS( OMutex )       m_aMutex;
	XSingleServiceFactoryRef      m_xFactory;
};

class OServiceEnumeration : 
	public OEnumerationHelper< vector< XSingleServiceFactoryRef >::iterator >,
	public UsrObject
{
public:
	SMART_UNO_DECLARATION( OServiceEnumeration, UsrObject );
	OServiceEnumeration( const XMultiServiceFactoryRef& xSrv, const UString& rName );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
private:
	NAMESPACE_VOS( OMutex ) m_aMutex;
	vector< XSingleServiceFactoryRef > m_xServices;
};

class OMultiServiceFactory : 
	public XMultiServiceFactory, public XEnumerationAccess, 
	public XInitialization,	public UsrObject
{
public:
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ){
		return *new OMultiServiceFactory( xMgr ); }
	
	OMultiServiceFactory( const XMultiServiceFactoryRef& xMgr )
		: m_xMgr( xMgr ) {}
	SMART_UNO_DECLARATION( OMultiServiceFactory, UsrObject );
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void initialize( const Sequence<UsrAny>& rSeq ) THROWS( (IllegalArgumentException ) );

    virtual XInterfaceRef createInstance(
		const UString& aServiceSpecifier);
    virtual XInterfaceRef createInstanceWithArguments(
		const UString& ServiceSpecifier, const Sequence< UsrAny >& Arguments);
    virtual Sequence< UString > getAvailableServiceNames(void);


	virtual XEnumerationRef createEnumeration(void);

    virtual XIdlClassRef getElementType(void) const;
    virtual BOOL hasElements(void) const;
private:
	UString                 m_aServiceName;
	XMultiServiceFactoryRef m_xMgr;
};


#endif

