/*************************************************************************
 *
 *  $RCSfile: datman.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>

/*
<<<<<<< datman.cxx
#include <stardiv/uno/repos/regkey.hxx>
#include <stardiv/uno/repos/simplreg.hxx>
#include <stardiv/uno/repos/serinfo.hxx>
#include <stardiv/uno/beans/propset.hxx>
#include <stardiv/uno/lang/factory.hxx>
#include <stardiv/uno/lang/serviceinfo.hxx>
#include <stardiv/uno/util/containr.hxx>
#include <stardiv/one/frame/xloader.hxx>
#include <stardiv/one/frame/xframe.hxx>
#include <stardiv/one/frame/xctrller.hxx>
#include <stardiv/one/form/grid.hxx>
#include <stardiv/one/data/dbcursor.hxx>
#include <stardiv/one/util/clone.hxx>

=======
*/
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEKEYRULE_HXX_
#include <smart/com/sun/star/data/DatabaseKeyRule.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEVIEWDEFINITION_HXX_
#include <smart/com/sun/star/data/DatabaseViewDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEINFO_HXX_
#include <smart/com/sun/star/data/DatabaseInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASENULLSSORT_HXX_
#include <smart/com/sun/star/data/DatabaseNullsSort.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASESQL92_HXX_
#include <smart/com/sun/star/data/DatabaseSQL92.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEIDENTIFIERCASE_HXX_
#include <smart/com/sun/star/data/DatabaseIdentifierCase.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDESCRIPTOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASETABLEDEFINITION_HXX_
#include <smart/com/sun/star/data/DatabaseTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEOUTERJOINSUPPORT_HXX_
#include <smart/com/sun/star/data/DatabaseOuterJoinSupport.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASESUBQUERY_HXX_
#include <smart/com/sun/star/data/DatabaseSubquery.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEQUALIFIER_HXX_
#include <smart/com/sun/star/data/DatabaseQualifier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEINDEXDEFINITION_HXX_
#include <smart/com/sun/star/data/DatabaseIndexDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEISOLATIONLEVEL_HXX_
#include <smart/com/sun/star/data/DatabaseIsolationLevel.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASESQLCONFORMANCE_HXX_
#include <smart/com/sun/star/data/DatabaseSQLConformance.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASELIMIT_HXX_
#include <smart/com/sun/star/data/DatabaseLimit.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECAPABILITY_HXX_
#include <smart/com/sun/star/data/DatabaseCapability.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDSTATUS_HXX_
#include <smart/com/sun/star/data/DatabaseRecordStatus.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSOROPTION_HXX_
#include <smart/com/sun/star/data/DatabaseCursorOption.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSORSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseCursorSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XPREPAREDDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XPreparedDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEUPDATECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDIRECTCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDirectCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSORTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDMODE_HXX_
#include <smart/com/sun/star/data/DatabaseRecordMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRID_HXX_
#include <smart/com/sun/star/form/XGrid.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDCOLUMNFACTORY_HXX_
#include <smart/com/sun/star/form/XGridColumnFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDPEER_HXX_
#include <smart/com/sun/star/form/XGridPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDFIELDDATASUPPLIER_HXX_
#include <smart/com/sun/star/form/XGridFieldDataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFILTERDETECT_HXX_
#include <smart/com/sun/star/frame/XFilterDetect.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XCONNECTABLE_HXX_
#include <smart/com/sun/star/io/XConnectable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATACONTROL_HXX_
#include <smart/com/sun/star/io/XActiveDataControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XMARKABLESTREAM_HXX_
#include <smart/com/sun/star/io/XMarkableStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XSTREAMLISTENER_HXX_
#include <smart/com/sun/star/io/XStreamListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASINK_HXX_
#include <smart/com/sun/star/io/XActiveDataSink.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASOURCE_HXX_
#include <smart/com/sun/star/io/XActiveDataSource.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINER_HXX_
#include <smart/com/sun/star/container/XContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HXX_
#include <smart/com/sun/star/container/XIndexContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HXX_
#include <smart/com/sun/star/container/XNameReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HXX_
#include <smart/com/sun/star/container/XContainerListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XSET_HXX_
#include <smart/com/sun/star/container/XSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HXX_
#include <smart/com/sun/star/container/ContainerEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HXX_
#include <smart/com/sun/star/container/XIndexReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HXX_
#include <smart/com/sun/star/container/XNameContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidValueException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HXX_
#include <smart/com/sun/star/registry/RegistryKeyType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HXX_
#include <smart/com/sun/star/registry/RegistryValueType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidRegistryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XREFRESHABLE_HXX_
#include <smart/com/sun/star/util/XRefreshable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDESCRIPTOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEFIELDTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseFieldType.hxx>
#endif


>>>>>>> 1.7
#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>

#ifndef _SV_LSTBOX_HXX //autogen wg. ListBox
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen wg. Edit
#include <vcl/edit.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#ifndef _FSYS_HXX //autogen wg. DirEntry
#include <tools/fsys.hxx>
#endif



#include "datman.hxx"
#include "adrmod.hxx"
#include "registry.hxx"
#include "adrprop.hrc"
#include "framectr.hxx"

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif


#define STR_UID "id"
UString gGridName(L"theGrid");
UString gViewName(L"theView");
UString gGlobalName(L"theGlobals");
UString gBeamerSize(L"theBeamerSize");
UString gViewSize(L"theViewSize");

SMART_UNO_IMPLEMENTATION( AdrDataManager, UsrObject );
AdrDataManager::AdrDataManager(const XSimpleRegistryRef& xReg):
	bRecordIsInsertable(FALSE),
	bRecordIsRemovable(FALSE),
	bRecordIsModified(FALSE),
	pFrameController(NULL),
	nTmState(0),
	nEditMode(DatabaseRecordMode_STANDARD)
{
	xRegistry = xReg;
	xGlobalProps=createGlobalProperties();
	aUID.setString(UString());
	
	aUpdateTimer.SetTimeoutHdl(LINK( this, AdrDataManager, UpdateHdl));
	aUpdateTimer.SetTimeout(300);
	
}

AdrDataManager::~AdrDataManager()
{
}

//------------------------------------------------------------------------
void AdrDataManager::InsertFields(const XFormComponentRef& xGrid)
{
TRY
{
	XDatabaseCursorRef xCursor(xForm, USR_QUERY);
	if( !xCursor.is() || !xGrid.is() ) return;

	XGridColumnFactoryRef xColFactory(xGrid, USR_QUERY);
	XNameContainerRef xColContainer(xGrid, USR_QUERY);

	XNameAccessRef xFields(xCursor->getRecord(), USR_QUERY);
	XPropertySetRef xField;
	
	Sequence<UString> aFields(xFields->getElementNames());
	const UString* pFields = aFields.getConstArray();
	INT32 nCount=aFields.getLen();
	UsrAny aElement;
	for( INT32 i=0; i<nCount; i++ )
	{
		UString aCurrentColName= pFields[i];
		
		if(!xColContainer->hasByName(aCurrentColName))
		{
			aElement = xFields->getByName(aCurrentColName);
			xField = *(XPropertySetRef*)aElement.get();

			INT32 nFormatKey = xField->getPropertyValue(FM_PROP_FORMATKEY).getINT32();

			XPropertySetRef xCurrentCol = xColFactory->createColumn(getControlName(nFormatKey));
			xCurrentCol->setPropertyValue(FM_PROP_CONTROLSOURCE,UsrAny(aCurrentColName));
			xCurrentCol->setPropertyValue(FM_PROP_LABEL, UsrAny(aCurrentColName));
			
			xColContainer->insertByName(aCurrentColName, UsrAny(&xCurrentCol, XPropertySet_getReflection()));
		}
	}
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::InsertFields")
}
END_CATCH

}

XControlModelRef AdrDataManager::createGridModel()
{
	return createGridModel(xForm);
}

XControlModelRef AdrDataManager::createGridModel(const XDatabaseFormRef& xDbForm)
{
	TRY
	{
		XPropertySetRef aFormPropSet( xDbForm, USR_QUERY );
		UsrAny aDbSource=aFormPropSet->getPropertyValue(L"DataSelection");
		UString aName=aDbSource.getString();

		//xGridModel=loadGridModel(aName);
		  xGridModel=loadGridModel(gGridName);

		XNameContainerRef xNameCont(xDbForm, USR_QUERY);
					
		if(xNameCont->hasByName(aName))
		{
			xNameCont->removeByName(aName);
		}

		xNameCont->insertByName(aName, UsrAny(&xGridModel, XFormComponent_getReflection()));

	}
	CATCH_ALL()
	{
		DBG_ERROR("::createGridModel: something went wrong !");
	}
	END_CATCH

	return xGridModel;
}

XDatabaseFormRef AdrDataManager::getDatabaseForm()
{
	return xForm;
}

XDatabaseFormRef AdrDataManager::createDatabaseForm(const UString& rURL)
{
	XDatabaseFormRef xResult;
	TRY
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		xForm=XDatabaseFormRef(xMgr->createInstance(
			L"com.sun.star.form.component.Form"), USR_QUERY );

		XPropertySetRef aPropertySet(xForm, USR_QUERY );

		if(aPropertySet.is())
		{
			aPropertySet->setPropertyValue(L"DataSource",rURL);
			
			INT16 nCacheSize=0;
			UsrAny aCacheSize(nCacheSize);

			aPropertySet->setPropertyValue(L"CacheSize",aCacheSize);//Caching for Performance
			
			XDatabaseFormRef xDBForm(xForm, USR_QUERY);

			xDBForm->addPositioningListener(this);
			xDBForm->addLoadListener(this);

			//L"DataSource"
			XDatabaseConnectionRef xConnection = xDBForm->getConnection();
			XNameAccessRef xAccess(xConnection->getTables(), USR_QUERY);
			Sequence<UString> aTableNameSeq = getDataSources();
			UINT32 nCount = aTableNameSeq.getLen();
			if(nCount > 0)
			{
				const UString* pTableNames = aTableNameSeq.getConstArray();
				aActivDataSource= pTableNames[0];
				UString aFormDataSource=aActivDataSource + L".Person";
				aPropertySet->setPropertyValue(L"DataSelection",UsrAny(aFormDataSource));
			
				DataSelectionType eType=DataSelectionType_TABLE;
				aPropertySet->setPropertyValue(L"DataSelectionType",
					UsrAny(&eType,DataSelectionType_getReflection()));

				XRegistryKeyRef xRoot = xRegistry->getRootKey();
				XRegistryKeyRef xKey = xRoot->openKey(aActivDataSource);
				if(!xKey.is())
					xKey = xRoot->createKey(aActivDataSource);

				xSourceProps=XPropertySetRef(xKey, USR_QUERY);

				XDatabaseDescriptorRef xMetaData= xConnection->getMetaData();
				UsrAny aMetaInfo=xMetaData->getInfo(DatabaseInfo_IDENTIFIER_QUOTE_CHAR);
				aQuoteChar=aMetaInfo.getString();
				XDatabaseQueryComposerFactoryRef xFactory(xConnection, USR_QUERY);
				xParser = xFactory->createDatabaseQueryComposer();

				UString aString(L"SELECT * FROM ");
				aString+=aQuoteChar;
				aString+=aFormDataSource;
				aString+=aQuoteChar;
				xParser->setQuery(aString);
				setQueryField(getQueryField());
				startQueryWith(getQueryString());
				xResult=xForm;
				
				//UpdateAddressbookCursor(xDBForm);
				UpdateAddressbookCursor(aActivDataSource);
			}
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::createDatabaseForm: something went wrong !");
	}
	END_CATCH

	return xResult;
}

Sequence<UString> AdrDataManager::getDataSources()
{
	Sequence<UString> aTableNameSeq;

	TRY
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		XNameAccessRef xAccess=XNameAccessRef(xMgr->createInstance(L"com.sun.star.address.AddressBookSources"), USR_QUERY );

		aTableNameSeq = xAccess->getElementNames();
	}
	CATCH_ALL()
	{
		DBG_ERROR("::getDataSources: something went wrong !");
	}
	END_CATCH

	return aTableNameSeq;
}

UString AdrDataManager::getActivDataSource()
{
	return aActivDataSource;
}

XDatabaseQueryComposerRef AdrDataManager::getParser()
{
	return xParser;
}

void AdrDataManager::setFilter(const UString& rQuery)
{		
	TRY
	{
		xParser->setFilter(rQuery);
		UString aQuery=xParser->getFilter(); 
		XPropertySetRef aPropertySet(xForm, USR_QUERY );
		aPropertySet->setPropertyValue(L"Filter",UsrAny(aQuery));
		XRefreshableRef aRefreshRef(xForm, USR_QUERY );
		aRefreshRef->refresh();
		

	}
	CATCH_ALL()
	{
		DBG_ERROR("::setFilterOnActivDataSource: something went wrong !");
	}
	END_CATCH

}

UString AdrDataManager::getFilter()
{		

	UString aQueryString;
	TRY
	{
		XPropertySetRef aPropertySet(xForm, USR_QUERY );
		UsrAny aQuery=aPropertySet->getPropertyValue(L"Filter");

		if(!aQuery.getReflection()->equals(*Void_getReflection()))
		{
			aQueryString=aQuery.getString();
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::getFilterOnActivDataSource: something went wrong !");
	}
	END_CATCH

	return aQueryString;

}

Sequence<UString> AdrDataManager::getQueryFields()
{
	Sequence<UString> aFieldSeq;
TRY
{
	XDatabaseCursorRef xCursor(xForm, USR_QUERY);
	XNameAccessRef xFields(xCursor->getRecord(), USR_QUERY);
	aFieldSeq=xFields->getElementNames();
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::InsertFields")
}
END_CATCH
	
	return aFieldSeq;
}

void AdrDataManager::setQueryField(const UString& rQuery)
{
	TRY
	{
		UsrAny aQuery(rQuery);
		xSourceProps->setPropertyValue(L"QueryField",aQuery);		
		
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrDataManager::setQueryField")
	}
	END_CATCH
}

UString AdrDataManager::getQueryField()
{
	UString aFieldString;
	TRY
	{
		UsrAny aField=xSourceProps->getPropertyValue(L"QueryField");

		if(aField.getReflection()->equals(*Void_getReflection()))
		{
			Sequence<UString> aSeq=getQueryFields();
			const UString* pFields = aSeq.getConstArray();
			if(aSeq.getLen()>0)
			{
				aFieldString=pFields[0];
			}
		}
		else
		{
			aFieldString=aField.getString();
		}
		
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrDataManager::getQueryField")
	}
	END_CATCH

	return aFieldString;
}

void AdrDataManager::startQueryWith(const UString& rQuery)
{
	TRY
	{
		UsrAny aQuery(rQuery);
		xSourceProps->setPropertyValue(L"QueryText",rQuery);

		UString aQueryString;
		if(rQuery.len()>0)
		{
			aQueryString=aQuoteChar;
			aQueryString+=getQueryField();
			aQueryString+=aQuoteChar;
			aQueryString+=L" like '";
			aQueryString+=rQuery;
			aQueryString+=L"%'";
		}
		setFilter(aQueryString);

	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrDataManager::StartQueryWith")
	}
	END_CATCH
}
UString AdrDataManager::getQueryString()
{
	UString aQueryString;
	TRY
	{
		UsrAny aQuery=xSourceProps->getPropertyValue(L"QueryText");
		if(!aQuery.getReflection()->equals(*Void_getReflection()))
		{
			aQueryString=aQuery.getString();
		}		
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrDataManager::getQueryString")
	}
	END_CATCH

	return aQueryString;
}



void AdrDataManager::setActivDataSource(const UString& rURL)
{
	TRY
	{
		BOOL bFlag=FALSE;
		XPropertySetRef aPropertySet(xForm, USR_QUERY );

		if(aPropertySet.is())
		{
			XDatabaseFormRef xDBForm(xForm, USR_QUERY);

			XDatabaseConnectionRef xConnection = xDBForm->getConnection();
			XNameAccessRef xAccess(xConnection->getTables(), USR_QUERY);
			Sequence<UString> aTableNameSeq = getDataSources();
			UINT32 nCount = aTableNameSeq.getLen();
			const UString* pTableNames = aTableNameSeq.getConstArray();

			UString aFormDataSource;
			for(INT32 i=0;i<nCount;i++)
			{
				if(pTableNames[i] == rURL)
				{
					aActivDataSource=rURL;
					aFormDataSource =aActivDataSource + L".Person";
					aPropertySet->setPropertyValue(L"DataSelection",UsrAny(aFormDataSource));
					bFlag=TRUE;
					break;
				}
			}

			if(xGridModel.is())
			{
				saveGridModel(xGridModel);
			}
			
			aAdrSourceChangedHdl.Call(this);

			if(bFlag)
			{
				XRegistryKeyRef xRoot = xRegistry->getRootKey();
				XRegistryKeyRef xKey = xRoot->openKey(aActivDataSource);
				
				if(!xKey.is())
					xKey = xRoot->createKey(aActivDataSource);

				xSourceProps=XPropertySetRef(xKey, USR_QUERY);
	
				XDatabaseDescriptorRef xMetaData= xConnection->getMetaData();
				UsrAny aMetaInfo=xMetaData->getInfo(DatabaseInfo_IDENTIFIER_QUOTE_CHAR);
				aQuoteChar=aMetaInfo.getString();
				
				XDatabaseQueryComposerFactoryRef xFactory(xConnection, USR_QUERY);
				xParser = xFactory->createDatabaseQueryComposer();
				
				UString aString(L"SELECT * FROM ");
				aString+=aQuoteChar;
				aString+=aFormDataSource;
				aString+=aQuoteChar;
				xParser->setQuery(aString);
				
				setQueryField(getQueryField());
				startQueryWith(getQueryString());

				//UpdateAddressbookCursor(xDBForm);
				UpdateAddressbookCursor(aActivDataSource);

				aAdrSourceRefreshHdl.Call(this);
				
			}
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::createDatabaseForm: something went wrong !");
	}
	END_CATCH
}

void AdrDataManager::loadDatabase()
{
TRY
{	
	if(xForm.is()) 
	{
		xForm->load();
		XRefreshableRef aRefreshRef(xForm, USR_QUERY );
		if(aRefreshRef.is())
			aRefreshRef->refresh();

		XDatabaseCursorRef xCursor(xForm, USR_QUERY);
		XPropertySetRef xCursorSet(xCursor, USR_QUERY);
		UsrAny aCursorAny= xCursorSet->getPropertyValue(L"DataSource");

		SetMeAsUidListener();
	}
}

CATCH_ALL()
{
	DBG_ERROR("::loadDatabase: something went wrong !");
}
END_CATCH

}
void AdrDataManager::unloadDatabase()
{
TRY
{	
	if(xForm.is())
	{
		RemoveMeAsUidListener();
		xForm->unload();
	}
}
CATCH_ALL()
{
	DBG_ERROR("::unloadDatabase: something went wrong !");
}
END_CATCH
}

XControlModelRef AdrDataManager::loadGridModel(const UString& rName)
{
	XControlModelRef xModel;

	TRY
	{
		XPersistObjectRef aObject;
		UsrAny aGridModel=xSourceProps->getPropertyValue(rName);
		if(aGridModel.getReflection()->equals(*XPersistObject_getReflection()))
		{
			aObject=*(XPersistObjectRef*)aGridModel.get();
		}
		
		if(!aObject.is() )
		{
			XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
			XInterfaceRef xObject = xMgr->createInstance(
				L"com.sun.star.form.component.GridControl");
			xModel=XControlModelRef( xObject, USR_QUERY );
			XPropertySetRef xPropSet( xModel, USR_QUERY );
			UsrAny aDbSource(rName);
			xPropSet->setPropertyValue( L"Name",aDbSource);
			UString aControlName(L"com.sun.star.form.control.ExtendedGridControl");
			UsrAny aAny(aControlName);
			xPropSet->setPropertyValue( L"DefaultControl",aAny );

			XFormComponentRef aFormComp(xModel,USR_QUERY );
			InsertFields(aFormComp);
		}
		else
		{
			xModel=XControlModelRef(aObject,USR_QUERY );
			XFormComponentRef aFormComp(xModel,USR_QUERY );
			InsertFields(aFormComp);
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::loadGridModel: something went wrong !");
	}
	END_CATCH

	return xModel;
}

void AdrDataManager::saveGridModel(const XControlModelRef& rGridModel)
{
	TRY
	{	
		XPersistObjectRef aPersistObject(rGridModel, USR_QUERY );

		UsrAny aGridModel(&aPersistObject, XPersistObject_getReflection());
			
		xSourceProps->setPropertyValue(gGridName,aGridModel);
	}
	CATCH_ALL()
	{
		DBG_ERROR("::saveGridModelData: something went wrong !");
	}
	END_CATCH
}

XPropertySetRef	AdrDataManager::createGlobalProperties()
{	
	TRY
	{	
		XRegistryKeyRef xRoot = xRegistry->getRootKey();
		XRegistryKeyRef xKey = xRoot->openKey(gGlobalName);
		if(!xKey.is())
			xKey = xRoot->createKey(gGlobalName);

		return XPropertySetRef(xKey, USR_QUERY);
	}

	CATCH_ALL()
	{
		DBG_ERROR("::getViewProperties: something went wrong !");
	}
	END_CATCH
}


void AdrDataManager::setViewSize(long nSize)
{
	TRY
	{	
		UsrAny aViewSize((INT32) nSize);
			
		xGlobalProps->setPropertyValue(gViewSize,aViewSize);
	}
	CATCH_ALL()
	{
		DBG_ERROR("::setViewSize: something went wrong !");
	}
	END_CATCH
}

long AdrDataManager::getViewSize()
{
	long nSize=0;
	TRY
	{	
		UsrAny aViewSize=xGlobalProps->getPropertyValue(gViewSize);

		if(!aViewSize.getReflection()->equals(*Void_getReflection()))
		{
			nSize=aViewSize.getINT32();
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::getViewSize: something went wrong !");
	}
	END_CATCH

	return nSize;
}

void AdrDataManager::setBeamerSize(long nSize)
{
	TRY
	{	
		UsrAny aBeamerSize((INT32) nSize);
			
		xGlobalProps->setPropertyValue(gBeamerSize,aBeamerSize);
	}
	CATCH_ALL()
	{
		DBG_ERROR("::setBeamerSize: something went wrong !");
	}
	END_CATCH
}

long AdrDataManager::getBeamerSize()
{
	long nSize=0;
	TRY
	{	
		UsrAny aBeamerSize=xGlobalProps->getPropertyValue(gBeamerSize);

		if(!aBeamerSize.getReflection()->equals(*Void_getReflection()))
		{
			nSize=aBeamerSize.getINT32();
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::getBeamerSize: something went wrong !");
	}
	END_CATCH

	return nSize;
}

XPropertySetRef	AdrDataManager::getViewProperties()
{
	TRY
	{	
		XRegistryKeyRef xKey = XRegistryKeyRef(xSourceProps, USR_QUERY);
		
		XRegistryKeyRef xViewKey=xKey->openKey(gViewName);

		if(!xViewKey.is())
		{
			xViewKey=xKey->createKey(gViewName);
		}

		return XPropertySetRef(xViewKey, USR_QUERY);
	}

	CATCH_ALL()
	{
		DBG_ERROR("::getViewProperties: something went wrong !");
	}
	END_CATCH
}

UString AdrDataManager::getControlName(INT32 nFormatKey )
{
	UString aResStr;
	switch (nFormatKey)
	{
		case DatabaseFieldType_BOOL:
			aResStr=L"CheckBox";
			break;
		case DatabaseFieldType_TINYINT:
		case DatabaseFieldType_SMALLINT:
		case DatabaseFieldType_INTEGER:
			aResStr=L"NumericField";   ;
			break;
		case DatabaseFieldType_REAL:
		case DatabaseFieldType_DOUBLE:
		case DatabaseFieldType_NUMERIC:
		case DatabaseFieldType_DECIMAL:
			aResStr=L"FormattedField"; 			
			break;
		case DatabaseFieldType_CURRENCY:
			aResStr=L"CurrencyField";
			break;
		case DatabaseFieldType_DATETIME:
			aResStr=L"FormattedField"; 
			break;
		case DatabaseFieldType_DATE:
			aResStr=L"DateField";
			break;
		case DatabaseFieldType_TIME:
			aResStr=L"TimeField";      
			break;
		case DatabaseFieldType_CHAR:
		case DatabaseFieldType_VARCHAR:
		case DatabaseFieldType_LONGVARCHAR:
		default:
			aResStr=L"TextField";
			break;
	}
	return aResStr;
}

XControlModelRef AdrDataManager::loadControlModel(const UString& rName)
{
	XControlModelRef xModel;

	UString aName(L"View_");
	aName+=rName;

	TRY
	{
		XPersistObjectRef aObject;
		UsrAny aControlModel=xSourceProps->getPropertyValue(aName);
		if(aControlModel.getReflection()->equals(*XPersistObject_getReflection()))
		{
			aObject=*(XPersistObjectRef*)aControlModel.get();
		}
		
		if(!aObject.is() )
		{
			XDatabaseCursorRef xCursor(xForm, USR_QUERY);

			if( !xCursor.is()) return xModel;

			XNameAccessRef xFields(xCursor->getRecord(), USR_QUERY);
			XPropertySetRef xField;
		
			UsrAny aElement;

			aElement = xFields->getByName(rName);
			xField = *(XPropertySetRef*)aElement.get();
			INT32 nFormatKey = xField->getPropertyValue(FM_PROP_FORMATKEY).getINT32();

			UString aInstanceName(L"com.sun.star.form.component.");

			aInstanceName += getControlName(nFormatKey );

			XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
			XInterfaceRef xObject = xMgr->createInstance(aInstanceName);
			xModel=XControlModelRef( xObject, USR_QUERY );
			XPropertySetRef xPropSet( xModel, USR_QUERY );
			UsrAny aFieldName(aName);
			xPropSet->setPropertyValue( FM_PROP_NAME,aFieldName);
			
			UsrAny aDbSource(rName);
			xPropSet->setPropertyValue( FM_PROP_CONTROLSOURCE,aDbSource);

			XFormComponentRef aFormComp(xModel,USR_QUERY );
//Hack			
			XDatabaseFormRef xDBForm(xForm, USR_QUERY);
			XNameContainerRef xNameCont(xDBForm, USR_QUERY);
			xNameCont->insertByName(aName, UsrAny(&xModel, XFormComponent_getReflection()));
		}
		else
		{
			xModel=XControlModelRef(aObject,USR_QUERY );
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::loadControlModel: something went wrong !");
	}
	END_CATCH

	return xModel;
}
void AdrDataManager::saveCtrModel(const UString& rName,const XControlModelRef& rCtrModel)
{
	TRY
	{	
		UString aName(L"View_");
		aName+=rName;

		XPersistObjectRef aPersistObject(rCtrModel, USR_QUERY );

		UsrAny aModel(&aPersistObject, XPersistObject_getReflection());
			
		xSourceProps->setPropertyValue(aName,aModel);
	}
	CATCH_ALL()
	{
		DBG_ERROR("::saveCtrModel: something went wrong !");
	}
	END_CATCH
}

void AdrDataManager::EnableLayoutMode(BOOL bFlag)
{
}

BOOL AdrDataManager::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
	if( aUIK == XPropertyChangeListener::getSmartUik() )
		xRet = (XPropertyChangeListener*) this;
	else if( aUIK == XPositioningListener::getSmartUik() )
		xRet = (XPositioningListener*) this;
	else if( aUIK == XLoadListener::getSmartUik() )
		xRet = (XLoadListener*) this;	
	else return UsrObject::queryInterface( aUIK, xRet );
	return xRet.is();
}

void AdrDataManager::disposing( const EventObject& Source )
{
	TRY
	{	
		if ( xForm.is())
		{
			XDatabaseFormRef xDBForm(xForm, USR_QUERY);

			xDBForm->removePositioningListener(this);

			RemoveMeAsUidListener();
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::propertyChange: something went wrong !");
	}
	END_CATCH
}

void AdrDataManager::loaded(const EventObject& aEvent)
{
	TRY
	{	
		XDatabaseFormRef xDBForm(xForm, USR_QUERY);

		UpdateAddressbookCursor(xDBForm);

	}
	CATCH_ALL()
	{
		DBG_ERROR("::loaded: something went wrong !");
	}
	END_CATCH
}

void AdrDataManager::unloaded(const EventObject& aEvent)
{
	TRY
	{	
		aUID.setString(UString());
		aNewUID.setString(UString());
		xAdrCursor=XDatabaseBookmarkCursorRef();
	}
	CATCH_ALL()
	{
		DBG_ERROR("::unloaded: something went wrong !");
	}
	END_CATCH
}

void AdrDataManager::positioned(const EventObject& aEvent)
{
	if(	(!aNewUID.getReflection()->equals(*Void_getReflection())) &&
		(!aUID.getReflection()->equals(*Void_getReflection())) &&
		(aNewUID.getString() != aUID.getString()))
	{
		TRY
		{	
			saveRecord();
			if(nTmState==0)
			{
				XDatabaseBookmarkCursorRef xBookmarkCursor(xForm, USR_QUERY );
				aBookmark=xBookmarkCursor->getBookmark();
				
				aUID=aNewUID;

				BOOL bFlag=xAdrCursor->moveToBookmark(aUID);
				
				XDatabaseCursorRef xCursor(xAdrCursor, USR_QUERY );

				XPropertySetRef xSet=xCursor->getRecord();

				UsrAny aUsrAnyValues = xSet->getPropertyValue(L"Values");
				UsrAny aSchemataName = xSet->getPropertyValue(L"SchemaName");
				UsrAny aRemovable=xSet->getPropertyValue(L"IsRemovable");

				aValueSeq = *(Sequence<AddressBookParameteredPropertyValue> *)aUsrAnyValues.get();

				UsrAny aElement = xAdrSourceSchemata->getByName(aSchemataName.getString());

				XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();

				UsrAny theFields=xFields->getPropertyValue(L"Properties");
				aRecordSchemataSeq = *(Sequence<AddressBookParameteredProperty> *)theFields.get();

				bRecordIsRemovable = aRemovable.getBOOL();

				aUpdateLink.Call(this);

				if(pFrameController)
					pFrameController->RecordChanged();
			}
		}
		CATCH_ALL()
		{
			DBG_ERROR("::positioned: something went wrong !");
		}
		END_CATCH
	}
}


void AdrDataManager::propertyChange(const PropertyChangeEvent& evt) THROWS( (UsrSystemException) )
{
	TRY
	{	
		BOOL bFlag=FALSE;
		if(evt.PropertyName == FM_PROP_VALUE)
		{
			if( evt.NewValue.getReflection() == XInputStream_getReflection() )
			{
				XDataInputStreamRef xStream( 
					*(const XInputStreamRef*)evt.NewValue.get(), USR_QUERY );
				aNewUID.setString(  xStream->readUTF() );
			}
			else
				aNewUID = evt.NewValue;

		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::propertyChange: something went wrong !");
	}
	END_CATCH

}

void AdrDataManager::saveRecord()
{
	TRY
	{	
		if(bRecordIsModified)
		{
			bRecordIsModified = FALSE;
			Sequence<AddressBookParameteredPropertyValue> aSeq;
			aValueSeq= aSeq;
			aAdrSourceSaveHdl.Call(this);

			INT32 nCount = aValueSeq.getLen();

			if(nCount >0)
			{
				aTimerBookmark = aBookmark;
				nTmState = 1;
				xAdrCursor->moveToBookmark(aUID);
				
				AddressBookParameteredPropertyValue* pVal=aValueSeq.getArray();

				UsrAny aUsrAnyValues(&aValueSeq,Sequence<AddressBookParameteredPropertyValue>::getReflection());
					
				XDatabaseUpdateCursorRef xCursor(xAdrCursor, USR_QUERY );

				XPropertySetRef xSet=xCursor->getRecord();

				xSet->setPropertyValue(L"Values",aUsrAnyValues);

				xCursor->updateRecord();				
				aUpdateTimer.Start();
			}
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::saveRecord: something went wrong !");
		nTmState = 0;
	}
	END_CATCH

}

void AdrDataManager::removeRecord()
{
	TRY
	{	
		XDatabaseUpdateCursorRef xCursor(xForm, USR_QUERY );
		xCursor->deleteRecord();

		XDatabaseUpdateCursorRef xCursor2(xAdrCursor, USR_QUERY );
		xCursor2->moveRelative(0);
		
	}
	CATCH_ALL()
	{
		DBG_ERROR("::removeRecord: something went wrong !");
	}
	END_CATCH

}

void AdrDataManager::insertRecord()
{
	TRY
	{	
		Sequence<AddressBookParameteredPropertyValue> aSeq;
		
		aValueSeq = aSeq;

		UString aSchemaName;

		if(IsRecordInsertable(&aSchemaName))
		{	
			XDatabaseUpdateCursorRef xCursor(xForm, USR_QUERY );
			xCursor->addRecord();

			XDatabaseUpdateCursorRef xCursor2(xAdrCursor, USR_QUERY );
			xCursor2->moveRelative(0);
			
		}

	}
	CATCH_ALL()
	{
		DBG_ERROR("::insertRecord: something went wrong !");
	}
	END_CATCH
}

BOOL AdrDataManager::IsRecordInsertable(UString* pSchemataName)
{
	BOOL bRes=FALSE;

	TRY
	{	
		XAddressBookResultSetDescriptorFactoryRef xDescriptorFactory(xRecordContainer, USR_QUERY );

		XAddressBookSchemataSupplierRef xSchemataSupplier(xRecordContainer, USR_QUERY );

		XNameAccessRef xSchemata = xSchemataSupplier->getSchemata();
		
		UString aSchemaName;

		Sequence<UString> aSchemataList(xSchemata->getElementNames());

		INT32 nCount=aSchemataList.getLen();
		
		const UString* pSchemata = aSchemataList.getConstArray();

		INT32 nPos=0;
		INT32 nFieldCount = 0;
		INT32 nMaxCount = 0;
		for(nPos=0;nPos<nCount;nPos++)
		{
			UsrAny aElement = xSchemata->getByName(pSchemata[nPos]);

			XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();
			UsrAny aInsertable=xFields->getPropertyValue(L"IsInsertable");
			
			if(aInsertable.getBOOL())
			{
				if(pSchemataName!=NULL)
					*pSchemataName=pSchemata[nPos];
				bRes=TRUE;
				break;
			}
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::IsRecordInsertable: something went wrong !");
	}
	END_CATCH

	return bRes;
}

void AdrDataManager::editRecord()
{
	TRY
	{	
		/*
		if ( xForm.is() && nEditMode==DatabaseRecordMode_STANDARD)
		{
			XDatabaseUpdateCursorRef xCursor(xForm, USR_QUERY);
			if (xCursor.is())
					xCursor->editRecord();
		}
		*/
	}
	CATCH_ALL()
	{
		DBG_ERROR("::editRecord: something went wrong !");
	}
	END_CATCH
}

//------------------------------------------------------------------------
void AdrDataManager::SetMeAsUidListener()
{
TRY
{
	XDatabaseCursorRef xCursor(xForm, USR_QUERY);
	if( !xCursor.is()) return;

	XNameAccessRef xFields(xCursor->getRecord(), USR_QUERY);
	
	Sequence<UString> aFields(xFields->getElementNames());
	const UString* pFields = aFields.getConstArray();
	INT32 nCount=aFields.getLen();
	String StrUID(STR_UID);
	UString theFieldName;
	for( INT32 i=0; i<nCount; i++ )
	{
		String aName= U2S(pFields[i]);
		
		if(aName.Lower() == StrUID)
		{
			theFieldName=pFields[i];
			break;
		}
	}
		
	if(theFieldName.len()>0)
	{
		XPropertySetRef xPropSet;
		UsrAny aElement;
		
		aElement = xFields->getByName(theFieldName);
		xPropSet = *(XPropertySetRef*)aElement.get();

		xPropSet->addPropertyChangeListener(FM_PROP_VALUE, this);
	}				

}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::SetMeAsUidListener")
}
END_CATCH

}

void AdrDataManager::RemoveMeAsUidListener()
{
TRY
{
	XDatabaseCursorRef xCursor(xForm, USR_QUERY);
	if( !xCursor.is()) return;

	XNameAccessRef xFields(xCursor->getRecord(), USR_QUERY);
	
	Sequence<UString> aFields(xFields->getElementNames());
	const UString* pFields = aFields.getConstArray();
	INT32 nCount=aFields.getLen();
	String StrUID(STR_UID);
	UString theFieldName;
	for( INT32 i=0; i<nCount; i++ )
	{
		String aName= U2S(pFields[i]);
		
		if(aName.Lower() == StrUID)
		{
			theFieldName=pFields[i];
			break;
		}
	}
		
	if(theFieldName.len()>0)
	{
		XPropertySetRef xPropSet;
		UsrAny aElement;
		
		aElement = xFields->getByName(theFieldName);
		xPropSet = *(XPropertySetRef*)aElement.get();

		xPropSet->removePropertyChangeListener(FM_PROP_VALUE, this);
	}				

}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::RemoveMeAsUidListener")
}
END_CATCH

}

Sequence<UString> AdrDataManager::MakeMaxFieldList(const XNameAccessRef& xSchemata)
{
	Sequence<UString> aNameSeq;
TRY
{
	Sequence<UString> aSchemataList(xSchemata->getElementNames());
	
	INT32 nCount=aSchemataList.getLen();
	
	const UString* pSchemata = aSchemataList.getConstArray();

	INT32 nPos=0;
	INT32 nFieldCount = 0;
	INT32 nMaxCount = 0;
	for(nPos=0;nPos<nCount;nPos++)
	{
		UsrAny aElement = xSchemata->getByName(pSchemata[nPos]);

		XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();

		UsrAny theFields=xFields->getPropertyValue(L"Properties");
		Sequence<AddressBookParameteredProperty>* pParaSeq;
		pParaSeq = (Sequence<AddressBookParameteredProperty> *)theFields.get();

		nFieldCount += pParaSeq->getLen();
	}
	
		
	aNameSeq.realloc(nFieldCount);

	for(nPos=0;nPos<nCount;nPos++)
	{
		UsrAny aElement = xSchemata->getByName(pSchemata[nPos]);

		XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();

		UsrAny theFields=xFields->getPropertyValue(L"Properties");
		Sequence<AddressBookParameteredProperty>* pParaSeq;
		pParaSeq = (Sequence<AddressBookParameteredProperty> *)theFields.get();

		INT32 nFieldCount1 = pParaSeq->getLen();

		const AddressBookParameteredProperty* pProp= pParaSeq->getConstArray();

		BOOL bFlag = TRUE;
		for(INT32 i=0; i<nFieldCount1; i++)
		{
			UString* pStr = aNameSeq.getArray();
			
			for(INT32 j=0; j<nMaxCount; j++)
			{
				if(*pStr == pProp->Name)
				{
					bFlag=FALSE;
					break;
				}
				pStr++;
			}
			if(bFlag)
			{
				nMaxCount++;
				*pStr = pProp->Name;
			}
			pProp++;
		}
	}
	aNameSeq.realloc(nMaxCount);

}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::MakeMaxFieldList")
}
END_CATCH

	return aNameSeq;
}


void AdrDataManager::UpdateAddressbookCursor(UString aSourceName)
{
TRY
{

	XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
	XInterfaceRef xObject = xMgr->createInstance(L"com.sun.star.address.AddressBookSources");
			
	XNameAccessRef xSources=XNameAccessRef(xObject, USR_QUERY );

	XJobFactoryRef xSource(*(XInterfaceRef*)xSources->getByName(aSourceName).get(),USR_QUERY);
	UsrAny aSource( &xSource, getReflection( &xSource ) );

	xRecordContainer= XAddressBookRecordContainerRef(xMgr->createInstanceWithArguments(
				L"com.sun.star.address.AddressBookSourceAccess", Sequence<UsrAny>( &aSource, 1 )), USR_QUERY );

	XAddressBookResultSetDescriptorFactoryRef xDescriptorFactory(xRecordContainer, USR_QUERY );

	XAddressBookSchemataSupplierRef xSchemataSupplier(xRecordContainer, USR_QUERY );

	XNameAccessRef xSchemata = xSchemataSupplier->getSchemata();

	xAdrSourceSchemata = xSchemata;

	Sequence<UString> aSchemataList(xSchemata->getElementNames());
	
	INT32 nCount=aSchemataList.getLen();
	
	if(nCount>0)
	{
		Sequence<UString> aNameSeq=MakeMaxFieldList(xSchemata);

		UsrAny aFieldList(&aNameSeq, Sequence<UString>::getReflection());
		UsrAny aSchemataAny(&aSchemataList, Sequence<UString>::getReflection());
		
		XPropertySetRef xDescriptor = XPropertySetRef(xDescriptorFactory->createResultSetDescriptor(), USR_QUERY);

		xDescriptor->setPropertyValue(L"RequestedProperties",aFieldList);
		xDescriptor->setPropertyValue(L"Query",UString());
		xDescriptor->setPropertyValue(L"Schemata",aSchemataAny);

		UsrAny aRecordContainer(&xRecordContainer,XAddressBookRecordContainer_getReflection());
		UsrAny aDescriptor(&xDescriptor,XPropertySet_getReflection());
		
		Sequence<UsrAny> aSeq(2);
		
		UsrAny* pPara = aSeq.getArray();
		pPara[0] = aRecordContainer;
		pPara[1] = aDescriptor;

		/*
		xAdrCursor= XDatabaseBookmarkCursorRef(xMgr->createInstanceWithArguments(
									L"com.sun.star.address.AddressBookCursor",aSeq )
									, USR_QUERY );
		*/
	}
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::UpdateAddressbookCursor")
}
END_CATCH

}

void AdrDataManager::UpdateAddressbookCursor(const XDatabaseFormRef& xDbForm)
{
	TRY
	{
		XPropertySetRef aFormPropSet( xDbForm, USR_QUERY );
		UsrAny aUsrAny=aFormPropSet->getPropertyValue(L"Source");

		XInterfaceRef xObject=*(XInterfaceRef*)aUsrAny.get();

		XDatabaseBookmarkCursorRef xtest(xObject, USR_QUERY);
		XCloneableRef xClone(xtest, USR_QUERY);

		XCloneableRef xCursor=xClone->createClone();
		//xAdrCursor = XDatabaseBookmarkCursorRef(xCursor, USR_QUERY);
		xAdrCursor = xtest;
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrDataManager::UpdateAddressbookCursor")
	}
	END_CATCH
}

void AdrDataManager::RemoveAvailableField(const UString& aClassName,const Sequence<UString>& seqParas)
{
TRY
{
	AddressBookParameteredProperty* pValue = aRecordSchemataSeq.getArray();
	AddressBookParameteredProperty* pResPtr= NULL; 
	
	UINT32 nCount = aValueSeq.getLen();


	for(UINT32 i=0; i < nCount; i++)
	{
		if(pValue->Name == aClassName)
		{
			pResPtr = pValue;
			break;
		}
		pValue++;
	}
			
	if(pResPtr !=NULL && pResPtr->MaxCount > 0)
	{
		Sequence< AddressBookPropertyParameterInfo >* pInfoSeq = &pResPtr->AllowedParameterCombinations;

		/*
		if(pReadOnly!=NULL)
			*pReadOnly = !pResPtr->IsWritable;
		*/
		AddressBookPropertyParameterInfo* pInfo = pInfoSeq->getArray();
		nCount = pInfoSeq->getLen();
		
		for(UINT32 j=0; j < nCount; j++)
		{
			if(	HasEqualParas(pInfo->Parameters, seqParas,TRUE))
			{	
				pInfo->MaxCount--;
				pResPtr->MaxCount--;
				break;
			}
		}
	}
}
CATCH_ALL()
{
	//Do nothing
}
END_CATCH

}

UsrAny AdrDataManager::getAvailableField(const UString& aClassName,const Sequence<UString>& aSubSet, BOOL* pReadOnly)
{
	UsrAny aResult;
TRY
{
	AddressBookParameteredProperty* pValue = aRecordSchemataSeq.getArray();
	AddressBookParameteredProperty* pResPtr= NULL; 
	
	UINT32 nCount = aValueSeq.getLen();


	for(UINT32 i=0; i < nCount; i++)
	{
		if(pValue->Name == aClassName)
		{
			pResPtr = pValue;
			break;
		}
		pValue++;
	}
			
	if(pResPtr !=NULL && pResPtr->MaxCount > 0)
	{
		Sequence< AddressBookPropertyParameterInfo >* pInfoSeq = &pResPtr->AllowedParameterCombinations;

		AddressBookPropertyParameterInfo* pInfo = pInfoSeq->getArray();
		nCount = pInfoSeq->getLen();
		
		for(UINT32 j=0; j < nCount; j++)
		{
			if(	HasEqualParas(pInfo->Parameters, aSubSet))
			{	
				AddressBookParameteredValue aValue;
				aValue.Parameters = pInfo->Parameters;
				aResult.set(&aValue,AddressBookParameteredValue_getReflection());
				if(pReadOnly!=NULL)
					*pReadOnly = !pResPtr->IsWritable;
		
				pInfo->MaxCount--;
				pResPtr->MaxCount--;
				break;
			}
		}
	}
}
CATCH_ALL()
{
	//Do nothing
}
END_CATCH

	return aResult;
}

void AdrDataManager::saveFieldValue(const UString& aClassName,AddressBookParameteredValue aValue)
{
TRY
{
	AddressBookParameteredPropertyValue* pValue = aValueSeq.getArray();
	AddressBookParameteredPropertyValue* pResPtr= NULL; 
	
	UINT32 nCount = aValueSeq.getLen();


	for(UINT32 i=0; i < nCount; i++)
	{
		if(pValue->Name == aClassName)
		{
			pResPtr = pValue;
			break;
		}
		pValue++;
	}
	
	if(pResPtr ==NULL )
	{
		aValueSeq.realloc(nCount+1);
		pValue = aValueSeq.getArray();
		pResPtr = &pValue[nCount];
		pResPtr->Name = aClassName;
		pResPtr->Type = aValue.Value.getReflection()->getIdlClass();
		pResPtr->IsWritable = TRUE;
	}

	if(pResPtr !=NULL )
	{
		Sequence<AddressBookParameteredValue>* pValues = &pResPtr->Values;

		nCount = pValues->getLen();
		pValues->realloc(nCount+1);
		AddressBookParameteredValue* pVal = pValues->getArray();
		pVal[nCount]=aValue;
		pResPtr->MinCount=nCount+1;
		pResPtr->MaxCount=nCount+1;
	}
}
CATCH_ALL()
{
	//Do nothing
}
END_CATCH
}

UsrAny AdrDataManager::getFieldValue(const UString& aClassName,const Sequence<UString>& seqParas, BOOL* pReadOnly)
{
	UsrAny aResult;
TRY
{
	AddressBookParameteredPropertyValue* pValue = aValueSeq.getArray();
	AddressBookParameteredPropertyValue* pResPtr= NULL; 
	
	UINT32 nCount = aValueSeq.getLen();


	for(UINT32 i=0; i < nCount; i++)
	{
		if(pValue->Name == aClassName)
		{
			pResPtr = pValue;
			break;
		}
		pValue++;
	}
			
	AddressBookParameteredProperty* pProp = aRecordSchemataSeq.getArray();
	
	UINT32 nCountProp = aRecordSchemataSeq.getLen();


	for(UINT32 ii=0; ii < nCountProp; i++)
	{
		if(pProp->Name == aClassName) break;
		pProp++;
	}

	if( pResPtr !=NULL && ii != nCountProp )
	{
		Sequence<AddressBookParameteredValue> aValues = pResPtr->Values;
		
		if(pReadOnly!=NULL)	*pReadOnly = !pProp->IsWritable;
		AddressBookParameteredValue* pVal = aValues.getArray();
		nCount = aValues.getLen();
		
		for(UINT32 j=0; j < nCount; j++)
		{
			if(	HasEqualParas(pVal->Parameters, seqParas))
			{	
				aResult.set(pVal,AddressBookParameteredValue_getReflection());
				break;
			}
		}
	}
}
CATCH_ALL()
{
	//Do nothing
}
END_CATCH

	return aResult;
}

BOOL AdrDataManager::HasEqualParas(const Sequence<UString>& seqParas,const Sequence<UString>& aSubSet, 
								   BOOL bEqualLength)
{
	UINT32 nCount1 = seqParas.getLen();
	UINT32 nCount2 = aSubSet.getLen();

	if(bEqualLength && nCount1!=nCount2)
		return FALSE;

	const UString* pStr2 = aSubSet.getConstArray();

	UINT32 nCounter = 0;

	for(UINT32 i=0; i < nCount2; i++)
	{
		const UString* pStr1 = seqParas.getConstArray();
		
		for(UINT32 j=0; j < nCount1; j++)
		{
			if(	*pStr1 == *pStr2)
			{	
				nCounter++;
				break;
			}

			pStr1++;
		}

		pStr2++;
	}

	if(nCounter == nCount2)
		return TRUE;

	return FALSE;
}
	
INT32 AdrDataManager::GetMaxFieldCount(const UString& aClassName,const Sequence<UString>& seqParas)
{
	INT32 nMax=0;
TRY
{
	Sequence<UString> aSchemataList(xAdrSourceSchemata->getElementNames());
	
	INT32 nCount=aSchemataList.getLen();
	
	for(INT32 nPos=0; nPos<nCount; nPos++)	
	{
		const UString* pSchemata = aSchemataList.getConstArray();

		UString aSchemataName = pSchemata[nPos];

		UsrAny aElement = xAdrSourceSchemata->getByName(aSchemataName);

		XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();

		UsrAny theFields=xFields->getPropertyValue(L"Properties");
		Sequence<AddressBookParameteredProperty> aParaSeq;
		aParaSeq = *(Sequence<AddressBookParameteredProperty> *)theFields.get();

		INT32 nFieldCount =aParaSeq.getLen();
		
		const AddressBookParameteredProperty* pProp= aParaSeq.getConstArray();
		const AddressBookParameteredProperty* pResProp= NULL;

		for(INT32 i=0;i < nFieldCount; i++)
		{
			if(pProp->Name == aClassName)
			{
				pResProp = pProp;
				break;
			}
			pProp++;
		}

		if(pResProp != NULL)
		{ 
			Sequence<AddressBookPropertyParameterInfo> aValues = pResProp->AllowedParameterCombinations;

			const AddressBookPropertyParameterInfo* pVal = aValues.getConstArray();
			INT32 nCount = aValues.getLen();
			
			if(nCount >0)
			{
				for(INT32 j=0; j < nCount; j++)
				{
					if(	HasEqualParas(pVal->Parameters, seqParas, TRUE))
					{	
						nMax = pVal->MaxCount;
						break;
					}
					pVal++;
				}
			}
			else
			{
				if(HasEqualParas(pResProp->Parameters, seqParas))
				{
					nMax = pResProp->MaxCount;
				}
			}
		}
	}
	
	return nMax;
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::GetMaxFieldCount")
}
END_CATCH

}

INT32 AdrDataManager::GetMaxFieldCount()
{
	INT32 nMax=0;
TRY
{
	Sequence<UString> aSchemataList(xAdrSourceSchemata->getElementNames());
	
	INT32 nCount=aSchemataList.getLen();
	
	for(INT32 nPos=0; nPos<nCount; nPos++)	
	{
		const UString* pSchemata = aSchemataList.getConstArray();

		UString aSchemataName = pSchemata[nPos];

		UsrAny aElement = xAdrSourceSchemata->getByName(aSchemataName);

		XPropertySetRef xFields = *(XPropertySetRef*)aElement.get();

		UsrAny theFields=xFields->getPropertyValue(L"Properties");
		Sequence<AddressBookParameteredProperty> aParaSeq;
		aParaSeq = *(Sequence<AddressBookParameteredProperty> *)theFields.get();

		INT32 nFieldCount =aParaSeq.getLen();
		
		const AddressBookParameteredProperty* pProp= aParaSeq.getConstArray();
		const AddressBookParameteredProperty* pResProp= NULL;

		for(INT32 i=0;i < nFieldCount; i++)
		{
			nMax += pResProp->MaxCount;
		}
	}
	
	return nMax;
}
CATCH_ALL()
{
	DBG_ERROR("Exception in AdrDataManager::GetMaxFieldCount(void)")
}
END_CATCH

}

XNameAccessRef AdrDataManager::GetSourceSchemata()
{
	return xAdrSourceSchemata;
}
		
void AdrDataManager::CreateFields()
{
	INT32 nMax = GetMaxFieldCount();


}


IMPL_LINK( AdrDataManager, UpdateHdl, Timer*,pT)
{
	if(nTmState ==1)
	{
		nTmState++;
		XDatabaseBookmarkCursorRef xBookmarkCursor(xForm, USR_QUERY );
		UsrAny aTmpBookmark=xBookmarkCursor->getBookmark();
		xBookmarkCursor->moveToBookmark(aTimerBookmark);
		//XDatabaseCursorRef aOldCursor(xForm, USR_QUERY );
		XDatabaseUpdateCursorRef aOldCursor(xForm, USR_QUERY );
		//aOldCursor->moveRelative(0);
		aOldCursor->restoreRecord();
		aTimerBookmark=aTmpBookmark;
		aUpdateTimer.Start();
	}
	else
	{	
		nTmState = 0;
		XDatabaseBookmarkCursorRef aFormCursor(xForm, USR_QUERY );
		aFormCursor->moveToBookmark(aTimerBookmark);
		aBookmark=aTimerBookmark;		
	}
	return 0;
}

/*	

	struct AddressBookParameteredPropertyValue : AddressBookParameteredProperty
	{
		Sequence<AddressBookParameteredValue> Values;
	};
	
	struct AddressBookParameteredProperty
	{
		string           Name;
		short            MinCount;
		short            MaxCount;
		
		// must be lexicografically sorted.
		Sequence<string> Parameters;
		Sequence<AddressBookPropertyParameterInfo> 
						 AllowedParameterCombinations;

		boolean          IsWritable;
	};
	
	struct AddressBookParameteredValue
	{
		// must be lexicografically sorted.
		Sequence<string> Parameters;
		any              Value;
	};

	[property] Sequence<AddressBookParameteredPropertyValue> Values;
	[property] string                                        Uid;
	[property] string                                        SchemaName;
	[property] boolean                                       IsRemovable;

*/

