/*************************************************************************
 *
 *  $RCSfile: services.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <services.hxx>

#if STLPORT_VERSION < 321
#include <rope.h>
#else
#include <rope>
#endif

#ifndef __STARDIV_UNO_LANG_SERVICEINFO_HXX__ //autogen wg. XServiceInfo
#include <stardiv/uno/lang/serviceinfo.hxx>
#endif


#ifndef __STARDIV_UNO_REPOS_SIMPLREG_HXX__ //autogen wg. XSimpleRegistry
#include <stardiv/uno/repos/simplreg.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif

XIdlClassRef OProxyFactory::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OProxyFactory", 
		OPropertySet::getStaticIdlClass(), 1,
		XSingleServiceFactory_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OProxyFactory::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OProxyFactory::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XSingleServiceFactory );
	return OPropertySet::queryInterface( aUik, rOut );
}

OProxyFactory::OProxyFactory(
	const XMultiServiceFactoryRef& xMgr, 
	const XSingleServiceFactoryRef& xFact ) : 
	m_xFactory( xFact ),
	OPropertySet( m_aMutex )
{
	XServiceInfoRef xInfo( xFact, USR_QUERY );
	XPropertySetRef xProp( xMgr, USR_QUERY );
	UsrAny aRegistry = xProp->getPropertyValue( L"Registry" );
	XSimpleRegistryRef xRegistry( 
		*(XInterfaceRef*)aRegistry.get(), USR_QUERY );
	NAMESPACE_STD(wrope) aRoot = L"/IMPLEMENTATIONS/";
	aRoot += NAMESPACE_STD(wrope)( xInfo->getImplementationName() );
	aRoot += NAMESPACE_STD(wrope)( L"/Properties" );
	sal_Unicode* pKey = new sal_Unicode[ aRoot.size() + 1];
	NAMESPACE_STD(copy)( aRoot.begin(), aRoot.end(), pKey );
	pKey[ aRoot.size() ] = 0;
	XRegistryKeyRef xKey = xRegistry->getRootKey()->openKey( pKey );
	delete[] pKey;
	Sequence<XRegistryKeyRef> aKeys = xKey->openKeys();
	ORef<OGenericObjectClass> xClass = new OGenericObjectClass;
	const XRegistryKeyRef* pKeys = aKeys.getConstArray();
	INT32 nPos;
	NAMESPACE_STD(vector)< UsrAny> aValues;
	NAMESPACE_STD(vector)< UString> aNames;
	for( nPos = aKeys.getLen(); nPos--; )
	{
		const XRegistryKeyRef& xKey = pKeys[ nPos ];
		const IPropertyType* pType = 0;
		
		switch( xKey->getValueType() )
		{
			case RegistryValueType_STRING:
				pType = OPropertyType<UString>::getInstance();
				aValues.push_back( UsrAny( xKey->getStringValue() ) );
				break;
			case RegistryValueType_LONG:
				pType = OPropertyType<INT32>::getInstance();
				aValues.push_back( UsrAny( xKey->getLongValue() ) );
				break;
			case RegistryValueType_STRINGLIST:
				pType = OPropertyType<Sequence<UString> >::getInstance();
				UsrAny aAny;
				aAny <<= xKey->getStringListValue();
				aValues.push_back( aAny );
				break;
		}
		if( pType ) 
		{
			UString aName( xKey->getKeyName() );
			INT32 nPos = aName.len( ) - 1;
			while( nPos && aName[ nPos ] != L'/' ) nPos--;
			if( nPos ) aName = aName.copy( nPos + 1 );
			xClass->addProperty( pType, aName, 0 );
			aNames.push_back( aName );
		}
	}
	xClass->addProperty( OPropertyType<Sequence<UString> >::getInstance(),
						 L"SupportedServiceNames", 0 );
	xClass->init();
	OPropertyObject* pNew = xClass->createInstance();
	
	Sequence<PropertyValue> aSeq( aValues.size() + 1);
	PropertyValue* pSeq = aSeq.getArray();
	for( nPos = aValues.size(); nPos--; )
	{
		const OPropertyAccessor* pAcc = xClass->getAccessor( nPos );
		pSeq[ nPos ].Name = aNames[ nPos ];
		pSeq[ nPos ].Handle = -1;
		pSeq[ nPos ].Value = aValues[ nPos ];
	}
	pSeq[ aValues.size() ].Name = L"SupportedServiceNames";
	pSeq[ aValues.size() ].Handle = -1;
	pSeq[ aValues.size() ].Value <<= xInfo->getSupportedServiceNames();

	xClass->setPropertyValues( pNew, aSeq );

	m_pObject = pNew;
	m_bOwner = true;
	m_pClass = xClass.getBodyPtr();
}

OServiceEnumeration::OServiceEnumeration(
	const XMultiServiceFactoryRef& xSrv, const UString& rName ) :
	OEnumerationHelper<NAMESPACE_STD(vector)< XSingleServiceFactoryRef >::iterator >( 
		m_aMutex )
{
	XContentEnumerationAccessRef xEnumAccess( xSrv, USR_QUERY );
	XEnumerationRef xEnum = xEnumAccess->createContentEnumeration(
		rName );
	if( xEnum.is() ) while( xEnum->hasMoreElements() )
	{
		XSingleServiceFactoryRef xFact( 
			*(XInterfaceRef*)xEnum->nextElement().get(), USR_QUERY );
		m_xServices.insert( 
			m_xServices.end(), XSingleServiceFactoryRef( 
				new OProxyFactory( xSrv, xFact ) ) );
	}
	setIterators( m_xServices.begin(), m_xServices.end() );
}

XIdlClassRef OServiceEnumeration::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OServiceEnumeration", 
		UsrObject::getUsrObjectIdlClass(), 1,
		XEnumeration_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef> OServiceEnumeration::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OServiceEnumeration::queryInterface( 
	Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XEnumeration );
	return UsrObject::queryInterface( aUik, rOut );
}


XIdlClassRef OMultiServiceFactory::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OMultiServiceFactory", 
		UsrObject::getUsrObjectIdlClass(), 3,
		XMultiServiceFactory_getReflection(),
		XEnumerationAccess_getReflection(),
		XInitialization_getReflection());
	return xClass;
}

Sequence<XIdlClassRef>	OMultiServiceFactory::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );

}

BOOL OMultiServiceFactory::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XMultiServiceFactory );
	QUERYIFACE( XEnumerationAccess );
	QUERYIFACE( XElementAccess );
	QUERYIFACE( XInitialization );
	return UsrObject::queryInterface( aUik, rOut );
}
	
XInterfaceRef OMultiServiceFactory::createInstance(
	const UString& aServiceSpecifier )
{
	return m_xMgr->createInstance( aServiceSpecifier );
}

XInterfaceRef OMultiServiceFactory::createInstanceWithArguments(
	const UString& ServiceSpecifier, const Sequence< UsrAny >& Arguments)
{
	return m_xMgr->createInstanceWithArguments(
		ServiceSpecifier, Arguments );
}

void OMultiServiceFactory::initialize( const Sequence<UsrAny>& rSeq )
THROWS( (IllegalArgumentException ) )
{
	if( rSeq.getLen() != 1 || !(
		rSeq.getConstArray()[ 0 ] >>= m_aServiceName ) )
		THROW( IllegalArgumentException() );
}

XIdlClassRef OMultiServiceFactory::getElementType(void) const
{
	return XMultiServiceFactory_getReflection()->getIdlClass();
}

BOOL OMultiServiceFactory::hasElements(void) const
{
	return ((OMultiServiceFactory*)this)->
		createEnumeration()->hasMoreElements();
}

inline BOOL isLess( const UString& r1, const UString& r2 ) 
{
	return r1 < r2;
}

Sequence< UString > OMultiServiceFactory::getAvailableServiceNames(void)
{
	XEnumerationRef xEnum = createEnumeration();
	NAMESPACE_STD(vector)<UString> aServices;
	Sequence<UString> aServiceNames;
	while( xEnum->hasMoreElements() )
	{
		XPropertySetRef xProp( 
			*(XInterfaceRef*)xEnum->nextElement().get(), USR_QUERY );
		if( xProp->getPropertyValue( L"ServiceName" ) >>= aServiceNames )
		{
			const UString* pCur = aServiceNames.getConstArray();
			for( INT32 nPos = aServiceNames.getLen(); nPos--; )
				if( pCur[ nPos ] != m_aServiceName )
					aServices.push_back( pCur[ nPos ] );
		}
	}
  	NAMESPACE_STD(sort)( aServices.begin(), aServices.end(), isLess );
  	aServices.erase( 
		NAMESPACE_STD(unique)( aServices.begin(), aServices.end() ), aServices.end() );
	
	Sequence<UString> aRet( aServices.size() );
	NAMESPACE_STD(copy)( aServices.begin(), aServices.end(), aRet.getArray() );
	return aRet;
}

XEnumerationRef OMultiServiceFactory::createEnumeration(void)
{
	return new OServiceEnumeration( m_xMgr, m_aServiceName );
}





