/*************************************************************************
 *
 *  $RCSfile: importdialog.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:03:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_IMPORTDIALOG_HXX_
#include "importdialog.hxx"
#endif
#ifndef _EXTENSIONS_COMPONENT_MODULE_HXX_
#include "componentmodule.hxx"
#endif
#ifndef _EXTENSIONS_DBIRESID_HRC_
#include "dbiresid.hrc"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _EHDL_HXX 
#include <svtools/ehdl.hxx>
#endif
#ifndef _EXTENSIONS_DBI_SDBIMPORTER_HXX_
#include "sdbimporter.hxx"
#endif
#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif
#ifndef _EXTENSIONS_DBI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif
#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif
#ifndef __SGI_STL_ALGORITHM
#include <algorithm>
#endif
#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef _SV_WAITOBJ_HXX 
#include <vcl/waitobj.hxx>
#endif
#ifndef __EXTENSIONS_INC_EXTENSIO_HRC__
#include "extensio.hrc"
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XEXECUTABLEDIALOG_HPP_
#include <com/sun/star/ui/dialogs/XExecutableDialog.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif
//.........................................................................
namespace dbi
{
//.........................................................................

#define STATE_SELECTSDB			0
#define STATE_SELECTCONTENT		1
#define STATE_ADJUST_DSN		2
#define STATE_FORMSELECTION		3
#define STATE_QUERYSELECTION	4
#define STATE_FINALIZATION		5

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::container;
	using namespace ::svt;
	using namespace ::com::sun::star::ui::dialogs;
	using namespace ::com::sun::star::beans;

	//=====================================================================
	//= OImportSdbDialog
	//=====================================================================
	//---------------------------------------------------------------------
	OImportSdbDialog::OImportSdbDialog(Window* _pParent, const Reference< XMultiServiceFactory >& _rxORB)
		:OImportSdbDialog_Base(_pParent, ModuleRes(RID_DLG_IMPORTWIZARD), WZB_HELP | WZB_FINISH | WZB_CANCEL | WZB_NEXT | WZB_PREVIOUS)
		,m_xORB(_rxORB)
		,m_pDatabaseFile(new OSdbFileAccess)
	{
		SetPageSizePixel(LogicToPixel(Size(WINDOW_SIZE_X, WINDOW_SIZE_Y), MAP_APPFONT));

		ShowButtonFixedLine(sal_True);

		m_pPrevPage->SetHelpId(HID_DBIWIZARD_PREVIOUS);
		m_pNextPage->SetHelpId(HID_DBIWIZARD_NEXT);
		m_pCancel->SetHelpId(HID_DBIWIZARD_CANCEL);
		m_pFinish->SetHelpId(HID_DBIWIZARD_FINISH);
		m_pHelp->SetUniqueId(UID_DBIWIZARD_HELP);

		defaultButton(WZB_NEXT);
		enableButtons(WZB_FINISH, sal_False);
		ActivatePage();

		implCollectDatasources();
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::implCollectDatasources()
	{
		try
		{
			DBG_ASSERT(m_xORB.is(), "OImportSdbDialog::implCollectDatasources: invalid service factory!");

			Reference< XInterface > xContext;
			if (m_xORB.is())
				xContext = m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.sdb.DatabaseContext"));
			DBG_ASSERT(xContext.is(), "OImportSdbDialog::implCollectDatasources: invalid database context!");

			m_xDatasources = Reference< XNameAccess >(xContext, UNO_QUERY);
			DBG_ASSERT(m_xDatasources.is() || !xContext.is(), "OImportSdbDialog::implCollectDatasources: invalid database context (missing the XNameAccess)!");
			if (m_xDatasources.is())
			{
				Sequence< ::rtl::OUString > aNames = m_xDatasources->getElementNames();
				const ::rtl::OUString* pLoop = aNames.getConstArray();
				const ::rtl::OUString* pEnd = pLoop + aNames.getLength();
				for (; pLoop != pEnd; ++pLoop)
					m_aDatasources.insert(String(*pLoop));
			}
		}
		catch (Exception&)
		{
			DBG_ERROR("OImportSdbDialog::implCollectDatasources: could not collect the data source names!");
		}
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::doOpen()
	{
		if (m_pDatabaseFile->getFileName() != m_aSettings.sImportFile)
			implOpen();
	}

	//---------------------------------------------------------------------
	sal_Bool OImportSdbDialog::onFinish(sal_Int32 _nResult)
	{
		if (RET_OK != _nResult)
			return OImportSdbDialog_Base::onFinish(_nResult);
		
		// open the file (if necessary)
		sal_Bool bOpendFile = m_pDatabaseFile->isOpen();
		if (m_pDatabaseFile->getFileName() != m_aSettings.sImportFile)
			bOpendFile = implOpen();
		if (!bOpendFile)
			return sal_False;

		// do the import
		{
			WaitObject aWaitCursor(this);
			OSdbImporter aImporter(m_xORB, m_aSettings, m_pDatabaseFile, this);
			aImporter.import();
		}

		// collect some data from out members
		// we may be dead after returning from onFinish
		sal_Bool bResult = OImportSdbDialog_Base::onFinish(_nResult);

		return bResult;
	}

	//---------------------------------------------------------------------
	sal_Bool OImportSdbDialog::implOpen()
	{
		// the sdb file has changed. open it
		m_pDatabaseFile->open(m_aSettings.sImportFile);
		if (!m_pDatabaseFile->isOpen())
		{
			SfxErrorContext aContext(ERR_COULDNOTOPEN, NULL, RID_RSC_OPENSDB_ERROR, OModule::getResManager());
			ErrorHandler::HandleError(m_pDatabaseFile->getError());
			
			return sal_False;
		}

		// some defaults
		// assume that all forms/queries should be imported
		m_pDatabaseFile->getFormNames(m_aSettings.aImportForms);
		m_pDatabaseFile->getQueryNames(m_aSettings.aImportQueries);

		// import objects only if it makes sense ...
		m_aSettings.bImportForms = (0 != m_aSettings.aImportForms.size());
		m_aSettings.bImportQueries = (0 != m_aSettings.aImportQueries.size());

		// a new (unique) title for the new data source
		if (m_xDatasources.is())
		{
			try
			{
				::rtl::OUString sTitle = m_pDatabaseFile->getTitle();
				if (m_xDatasources->hasByName(sTitle))
				{
					::rtl::OUString sBase(sTitle);
					sBase += ::rtl::OUString::createFromAscii(" ");

					sal_Bool bTestedAll = sal_False;
					for (sal_Int32 i=2; !bTestedAll; bTestedAll = (0x7FFFFFFF == i), ++i)
					{
						sTitle = sBase;
						sTitle += ::rtl::OUString::valueOf((sal_Int32)i);

						if (!m_xDatasources->hasByName(sTitle))
							break;
					}

					if (bTestedAll)
						// can't do anything ...
						sTitle = m_pDatabaseFile->getTitle();
				}
				m_aSettings.sDatasourceName = sTitle;
			}
			catch(Exception&)
			{
				DBG_ERROR("OImportSdbDialog::implOpen: could not retrieve a title!");
			}
		}

		// a default for the for export directory
		INetURLObject aURL(m_pDatabaseFile->getFileURL(), INET_PROT_FILE);
		aURL.removeSegment();
		aURL.removeFinalSlash();
		OFileNotation aTransformer(aURL.GetMainURL(INetURLObject::NO_DECODE), OFileNotation::N_URL);
		m_aSettings.sFormImportPath = aTransformer.get(OFileNotation::N_SYSTEM);
		

		// check if we can import the type described in the file
		ODSNTypeInfo aTypeInfo(m_pDatabaseFile->getTypeLogical());
		if ( !aTypeInfo.isAvailableOnPlatform() )
		{
			sal_uInt16 nErrorBoxId = aTypeInfo.isAvailable() ? RID_ERROR_NOPLATFORM_SUPPORT : RID_ERROR_TYPE_NO_AVAILABLE;
			ErrorBox aError( this, ModuleRes( nErrorBoxId ) );

			String sMessage = aError.GetMessText();
			sMessage.SearchAndReplaceAscii("$type$", aTypeInfo.getDisplayName());
			aError.SetMessText(sMessage);

			if (RET_YES != aError.Execute())
			{
				m_pDatabaseFile->close();
				return sal_False;
			}
		}

		// now that we've defaulted all settings to valid values, enable the finish button
		m_aInvalidPages.clear();
		implCheckFinishButton();

		return sal_True;
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::currentModified()
	{
		// commit the page, so it will copy it's current data into our settings
		if (getCurrentPage()->commitPage(OWizardPage::CR_VALIDATE_NOUI))
			setValid(getCurrentState());
		else
			setInvalid(getCurrentState());

		checkPageDependencies(getCurrentState(), getCurrentPage());
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::checkPageDependencies(sal_uInt16 _nModifiedPage, OWizardPage* _pModifiedPage)
	{
		switch (_nModifiedPage)
		{
			case STATE_SELECTCONTENT:
				// changes made on this page may affect the "valid" flag of the queries page.
				if (!m_aSettings.bImportQueries || OQueryImportPage::isValid(m_aSettings, NULL))
					setValid(STATE_QUERYSELECTION);
				else
					setInvalid(STATE_QUERYSELECTION);

				// of the forms page, too
				if (!m_aSettings.bImportForms || OFormImportPage::isValid(m_aSettings, NULL))
					setValid(STATE_FORMSELECTION);
				else
					setInvalid(STATE_FORMSELECTION);

				// and of the finalization page, too
				if (!m_aSettings.bCreateDatasource || OFinalizationPage::isValid(m_aSettings, m_aDatasources))
					setValid(STATE_FINALIZATION);
				else
					setInvalid(STATE_FINALIZATION);
		}
		implCheckFinishButton();
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::enterState(sal_uInt16 _nState)
	{
		OImportSdbDialog_Base::enterState(_nState);

		if (STATE_FINALIZATION == _nState)
			defaultButton(WZB_FINISH);

		implCheckFinishButton();
	}

	//---------------------------------------------------------------------
	sal_Bool OImportSdbDialog::isValid(sal_uInt16 _nState)
	{
		UInt16ArrayIterator aInvalidBefore = ::std::find(m_aInvalidPages.begin(), m_aInvalidPages.end(), _nState);
		return (m_aInvalidPages.end() == aInvalidBefore);
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::setValid(sal_uInt16 _nState)
	{
		UInt16ArrayIterator aInvalidBefore = ::std::find(m_aInvalidPages.begin(), m_aInvalidPages.end(), _nState);
		if (m_aInvalidPages.end() != aInvalidBefore)
			m_aInvalidPages.erase(aInvalidBefore);
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::setInvalid(sal_uInt16 _nState)
	{
		if (isValid(_nState))
			m_aInvalidPages.push_back(_nState);
	}

	//---------------------------------------------------------------------
	sal_Bool OImportSdbDialog::leaveState(sal_uInt16 _nState)
	{
		if (!OImportSdbDialog_Base::leaveState(_nState))
			return sal_False;

		sal_Bool bAllow = sal_True;
		switch (_nState)
		{
			case STATE_FINALIZATION:
				defaultButton(WZB_NEXT);
				break;

			case STATE_SELECTSDB:
				if (m_pDatabaseFile->getFileName() != m_aSettings.sImportFile)
				{
					bAllow = implOpen();
				}
				else
					bAllow = m_pDatabaseFile->isOpen();
				break;
		}
		if (!bAllow)
			return sal_False;

		// ask the current page if it's data is valid
		OWizardPage* pCurrentPage = getPage(_nState);
		if (pCurrentPage)
		{
			// (assume "yes" first")
			setValid(_nState);
			// then check again
			if (!pCurrentPage->commitPage(OWizardPage::CR_VALIDATE_NOUI))
				// it's invalid ...
				setInvalid(_nState);
		}
		implCheckFinishButton();

		return sal_True;
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::implCheckFinishButton()
	{
		sal_uInt16 nCurrentState = getCurrentState();
		// if the page we're entering is the only invalid page at the moment, 
		// enable the Finish button. Upon pressing it, the page data is checked anyway ...
		// Without this, the Finish button would be checked upon leaving this (one and only invalid)
		// page, and this means theat the user would have to input valid data, leave the page and
		// _then_ press finish, which sounds quite laborious
		if ((1 == m_aInvalidPages.size()) && (m_aInvalidPages[0] == nCurrentState))
			// but this does not hold for the ContentSelection-/Finalization ... here we need valid data
			if ((STATE_SELECTCONTENT == nCurrentState) || (STATE_FINALIZATION == nCurrentState))
				m_pFinish->Disable();
			else
				m_pFinish->Enable();
		else
			m_pFinish->Enable(0 == m_aInvalidPages.size());
	}

	//---------------------------------------------------------------------
	OWizardPage* OImportSdbDialog::createPage(sal_uInt16 _nState)
	{
		switch (_nState)
		{
			case STATE_SELECTSDB:
				return new OSdbSelectionPage(this);
			case STATE_SELECTCONTENT:
				return new OContentSelectionPage(this);
			case STATE_ADJUST_DSN:
				return new ODsnAdjustmentPage(this);
			case STATE_FORMSELECTION:
				return new OFormImportPage(this);
			case STATE_QUERYSELECTION:
				return new OQueryImportPage(this);
			case STATE_FINALIZATION:
				return new OFinalizationPage(this);
			default:
				DBG_ERROR("OImportSdbDialog::createPage: invalid state!");
				return NULL;
		}
	}

	//---------------------------------------------------------------------
	sal_uInt16 OImportSdbDialog::determineNextState(sal_uInt16 _nCurrentState)
	{
		switch (_nCurrentState)
		{
			case STATE_SELECTSDB:
				return STATE_SELECTCONTENT;

			case STATE_SELECTCONTENT:
				if (m_aSettings.bCreateDatasource)
					if ((TYPE_TEXT == m_pDatabaseFile->getTypeLogical()) || (TYPE_DBASE == m_pDatabaseFile->getTypeLogical()))
					{
						String sOriginalPath = m_pDatabaseFile->getDSNStringToken( "DSN" );

						if	(	(STRING_NOTFOUND != sOriginalPath.SearchAscii("$(USER)"))
							||	(STRING_NOTFOUND != sOriginalPath.SearchAscii("$(INST)"))
							||	(STRING_NOTFOUND != sOriginalPath.SearchAscii("$(USERURL)"))
							||	(STRING_NOTFOUND != sOriginalPath.SearchAscii("$(INSTURL)"))
							)
							return STATE_ADJUST_DSN;
					}
				// NO BREAK !!!

			case STATE_ADJUST_DSN:
				if (m_aSettings.bImportForms)
					return STATE_FORMSELECTION;
				// NO BREAK !!!

			case STATE_FORMSELECTION:
				if (m_aSettings.bImportQueries)
					return STATE_QUERYSELECTION;
				else
					return STATE_FINALIZATION;

			case STATE_QUERYSELECTION:
				return STATE_FINALIZATION;

			case STATE_FINALIZATION:
				break;

			default:
				DBG_ERROR("OImportSdbDialog::determineNextState: invalid current state!");
		}

		DBG_ERROR("OImportSdbDialog::determineNextState: no next state available!");
		return WZS_INVALID_STATE;
	}

	//---------------------------------------------------------------------
	void OImportSdbDialog::adjustDsnPath( const String& _rNewPath, const PathWriteAccess& )
	{
		DBG_ASSERT(m_pDatabaseFile.isValid(), "OImportSdbDialog::adjustDsnPath: no database file!");
		String sAsURL = OFileNotation(_rNewPath, OFileNotation::N_SYSTEM).get(OFileNotation::N_URL);
		if (sAsURL.Len())
			m_pDatabaseFile->overwriteStringToken("DSN", sAsURL);
		else
			// the user input could not be interpreted
			m_pDatabaseFile->overwriteStringToken("DSN", _rNewPath);
	}
	//---------------------------------------------------------------------
	// Add by BerryJia for fixing Bug95795. Time:2002-8-22 15:35
	short OImportSdbDialog::Execute()
	{
		short nRet = Dialog::Execute();

		if(RET_OK != nRet)
			return nRet;
		sal_Bool bAdministration = m_aSettings.bCreateDatasource && m_aSettings.bAdministrateNewDS;
		if (!bAdministration)
			return nRet;

		try
		{
			::rtl::OUString sServiceName = ::rtl::OUString::createFromAscii("com.sun.star.sdb.DatasourceAdministrationDialog");
			::rtl::OUString sNewDSName = m_aSettings.sDatasourceName;

			// build the arguments sequence, if we have an initial selection
			Sequence< Any > aArgs;
			if (sNewDSName.getLength())
			{
				aArgs.realloc(1);
				aArgs[0] <<= PropertyValue(
					::rtl::OUString::createFromAscii("InitialSelection"), 0,
					makeAny(sNewDSName),
					PropertyState_DIRECT_VALUE);
			}

			// create
			Reference< XInterface > xAdminDialog;
			if (aArgs.getLength())
				xAdminDialog = m_xORB->createInstanceWithArguments(sServiceName, aArgs);
			else
				xAdminDialog = m_xORB->createInstance(sServiceName);

			// available?
			if (!xAdminDialog.is())
			{
				ShowServiceNotAvailableError(NULL, sServiceName, sal_True);
				return 0L;
			}

			// execute
			Reference< XExecutableDialog > xExecutable(xAdminDialog, UNO_QUERY);
			if (xExecutable.is())
			{
				xExecutable->execute();
			}
			else
			{
				DBG_ERROR("OAsyncAdminDialog, OnAsyncExecute: missing the XExecutableDialog interface of the component!!");
			}
		}
		catch(Exception&)
		{
			DBG_ERROR("OAsyncAdminDialog, OnAsyncExecute: could not create/execute the dialog component!");
		}

		return nRet;

	}
	
//.........................................................................
}	// namespace dbi
//.........................................................................

