<?xml version="1.0" encoding="UTF-8"?>
<!--
   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:aml="http://schemas.microsoft.com/aml/2001/core" xmlns:svg="http://www.w3.org/2000/svg" xmlns:draw="http://openoffice.org/2000/drawing" xmlns:office="http://openoffice.org/2000/office" xmlns:style="http://openoffice.org/2000/style" xmlns:text="http://openoffice.org/2000/text" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="http://openoffice.org/2000/meta" xmlns:config="http://openoffice.org/2001/config" xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882" xmlns:table="http://openoffice.org/2000/table" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:number="http://openoffice.org/2000/datastyle" exclude-result-prefixes="w wx aml o dt fo v">
	<xsl:output method="xml" indent="no" encoding="UTF-8" version="1.0"/>
	<!--xsl:include href="../../common/measure_conversion.xsl"/>
    <xsl:include href="../common/ms2ooo_docpr.xsl"/>
    <xsl:include href="wordml2ooo_text.xsl"/>
    <xsl:include href="wordml2ooo_settings.xsl"/>
    <xsl:include href="wordml2ooo_table.xsl"/>
    <xsl:include href="wordml2ooo_page.xsl"/>
    <xsl:include href="wordml2ooo_list.xsl"/>
    <xsl:include href="wordml2ooo_draw.xsl"/>
    <xsl:include href="wordml2ooo_field.xsl"/ -->
	<xsl:key name="paragraph-style" match="w:style[@w:type = 'paragraph']" use="@w:styleId"/>
	<xsl:key name="heading-style" match="w:style[@w:type = 'paragraph' and w:pPr/w:outlineLvl]" use="@w:styleId"/>
	<!-- start measure_conversions.xsl ===================== -->
	<!-- DPI (dots per inch) the standard resolution of given pictures (necessary for the conversion of 'cm' into 'pixel')
         Although many pictures have a 96 dpi resolution, a higher resoltion give better results for common browsers -->
	<xsl:param name="dpi" select="111"/>
	<xsl:param name="centimeter-in-mm" select="10"/>
	<xsl:param name="inch-in-mm" select="25.4"/>
	<xsl:param name="didot-point-in-mm" select="0.376065"/>
	<xsl:param name="pica-in-mm" select="4.2333333"/>
	<xsl:param name="point-in-mm" select="0.3527778"/>
	<xsl:param name="twip-in-mm" select="0.017636684"/>
	<xsl:param name="pixel-in-mm" select="$inch-in-mm div $dpi"/>
	<!-- ***** MEASUREMENT CONVERSIONS *****
      PARAM 'value'
        The measure to be converted.
        The current measure is judged by a substring (e.g. 'mm', 'cm', 'in', 'pica'...)
        directly added to the number.

      PARAM 'rounding-factor'
        Is used for the rounding of decimal places.
        The parameter number is the product of 1 and some '10', where
        every zero represents a decimal place.

        For example, providing as parameter:
            <xsl:param name="rounding-factor" select="10000" />
        Gives by default four decimal places.

        To round two decimal places, basically the following is done:
            <xsl:value-of select="round(100 * value) div 100"/>

      RETURN    The converted number, by default rounded to four decimal places.
                In case the input measure could not be matched the same value is
                returned and a warning message is written out.



     MEASURE LIST:
     * 1 milimeter (mm), the basic measure

     * 1 centimeter (cm) = 10 mm

     * 1 inch (in) = 25.4 mm
        While the English have already seen the light (read: the metric system), the US
        remains loyal to this medieval system.

     * 1 point (pt) = 0.35277777.. mm
        Sometimes called PostScript point (ppt), as when Adobe created PostScript, they added their own system of points.
        There are exactly 72 PostScript points in 1 inch.

     * 1 twip = twentieth of a (PostScript) point
        A twip (twentieth of a point) is a 1/20th of a PostScript point, a traditional measure in printing.

     * 1 didot point (dpt) = 0.376065 mm
        Didot point after the French typographer Firmin Didot (1764-1836).

        More details under
        http://www.unc.edu/~rowlett/units/dictP.html:
        "A unit of length used by typographers and printers. When printing was done
        from hand-set metal type, one point represented the smallest element of type
        that could be handled, roughly 1/64 inch. Eventually, the point was standardized
        in Britain and America as exactly 1/72.27 = 0.013 837 inch, which is
        about 0.35 mm (351.46 micrometers). In continental Europe, typographers
        traditionally used a slightly larger point of 0.014 83 inch (about
        1/72 pouce, 0.377 mm, or roughly 1/67 English inch), called a Didot point
        after the French typographer Firmin Didot (1764-1836). In the U.S.,
        Adobe software defines the point to be exactly 1/72 inch (0.013 888 9 inch
        or 0.352 777 8 millimeters) and TeX software uses a slightly smaller point
        of 0.351 459 8035 mm. The German standards agency DIN has proposed that
        all these units be replaced by multiples of 0.25 millimeters (1/101.6 inch).

     * 1 pica = 4.233333 mm
        1/6 inch or 12 points

     * 1 pixel (px) = 0.26458333.. mm   (relative to 'DPI', here: 96 dpi)
        Most pictures have the 96 dpi resolution, but the dpi variable may vary by stylesheet parameter


    -->
	<!-- changing measure to mm -->
	<xsl:template name="convert2mm">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="substring-before($value, 'mm')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm' ) * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in' ) * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dxa') * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'mm'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to cm -->
	<xsl:template name="convert2cm">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="substring-before($value, 'cm')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $centimeter-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $centimeter-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $centimeter-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $centimeter-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $centimeter-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dxa') div $centimeter-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $centimeter-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'cm'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to inch (cp. section comment) -->
	<xsl:template name="convert2in">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $inch-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="substring-before($value, 'in')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $inch-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $inch-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $inch-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $inch-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dxa') div $inch-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $inch-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'in'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to dpt (cp. section comment) -->
	<xsl:template name="convert2dpt">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $didot-point-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $didot-point-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $didot-point-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="substring-before($value, 'dpt')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $didot-point-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $didot-point-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dxa') div $didot-point-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $didot-point-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'dpt'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pica (cp. section comment) -->
	<xsl:template name="convert2pica">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $pica-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $pica-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $pica-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $pica-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="substring-before($value, 'pica')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $pica-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dxa') div $pica-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $pica-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'pica'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pt (cp. section comment) -->
	<xsl:template name="convert2pt">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $point-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $point-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="substring-before($value, 'pt')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $point-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $point-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'twip') div $point-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dxa') div $point-in-mm * $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $point-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'pt'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pt (cp. section comment) -->
	<xsl:template name="convert2twip">
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $twip-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $twip-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $twip-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $twip-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $twip-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="substring-before($value, 'twip')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="substring-before($value, 'dxa')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $twip-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'twip'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- changing measure to pixel by via parameter provided dpi (dots per inch) standard factor (cp. section comment) -->
	<xsl:template name="convert2px">
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round(number(substring-before($value, 'mm')) div $pixel-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round(number(substring-before($value, 'cm')) div $pixel-in-mm * $centimeter-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round(number(substring-before($value, 'in')) div $pixel-in-mm * $inch-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round(number(substring-before($value, 'pt')) div $pixel-in-mm * $point-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round(number(substring-before($value, 'dpt')) div $pixel-in-mm * $didot-point-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round(number(substring-before($value, 'pica')) div $pixel-in-mm * $pica-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="round(number(substring-before($value, 'twip')) div $pixel-in-mm * $twip-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="round(number(substring-before($value, 'dxa')) div $pixel-in-mm * $twip-in-mm)"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="$value"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'px'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="convert2dxa">
		<!-- this template is the same as the template of convert2twip because M$ word uses the dxa to represent twip-->
		<xsl:param name="value"/>
		<xsl:param name="rounding-factor" select="10000"/>
		<xsl:choose>
			<xsl:when test="contains($value, 'mm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'mm') div $twip-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'cm')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'cm') div $twip-in-mm * $centimeter-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'in')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'in') div $twip-in-mm * $inch-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pt') div $twip-in-mm * $point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dpt')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'dpt') div $twip-in-mm * $didot-point-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'pica')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'pica') div $twip-in-mm * $pica-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:when test="contains($value, 'twip')">
				<xsl:value-of select="substring-before($value, 'twip')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'dxa')">
				<xsl:value-of select="substring-before($value, 'dxa')"/>
			</xsl:when>
			<xsl:when test="contains($value, 'px')">
				<xsl:value-of select="round($rounding-factor * number(substring-before($value, 'px') div $twip-in-mm * $pixel-in-mm)) div $rounding-factor"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>measure_conversion.xsl: Find no conversion for <xsl:value-of select="$value"/> to 'twip'!</xsl:message>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- end of measure_conversions.xsl ========== -->
	<!-- star math.xsl =================== -->
	<xsl:variable name="pi" select="3.1416"/>
	<xsl:template name="math-test">
        sin(34.8)
        <xsl:call-template name="sin">
			<xsl:with-param name="x" select="34.8"/>
			<xsl:with-param name="rounding-factor" select="100000"/>
		</xsl:call-template>
        cos(34.8)
        <xsl:call-template name="cos">
			<xsl:with-param name="x" select="34.8"/>
			<xsl:with-param name="rounding-factor" select="100000"/>
		</xsl:call-template>
        arctan(2.74)
        <xsl:call-template name="arctan">
			<xsl:with-param name="x" select="2.74"/>
			<xsl:with-param name="rounding-factor" select="100000"/>
		</xsl:call-template>
        sqrt(1328.3414)
        <xsl:call-template name="sqrt">
			<xsl:with-param name="x" select="1328.3414"/>
			<xsl:with-param name="rounding-factor" select="100000"/>
		</xsl:call-template>
	</xsl:template>
	<!-- public functions start -->
	<xsl:template name="sin">
		<xsl:param name="x" select="0"/>
		<xsl:param name="rounding-factor" select="100"/>
		<xsl:variable name="angle" select="$x * 180 div $pi "/>
		<xsl:variable name="mod-angle" select="$angle mod 360"/>
		<xsl:variable name="sinx">
			<xsl:call-template name="sin-private">
				<xsl:with-param name="x" select="  ( $angle mod 360 )  * $pi div 180 "/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select=" round ( number($sinx) * $rounding-factor ) div $rounding-factor"/>
	</xsl:template>
	<xsl:template name="cos">
		<xsl:param name="x" select="0"/>
		<xsl:param name="rounding-factor" select="100"/>
		<xsl:variable name="angle" select="$x * 180 div $pi "/>
		<xsl:variable name="mod-angle" select="$angle mod 360"/>
		<xsl:variable name="cosx">
			<xsl:call-template name="cos-private">
				<xsl:with-param name="x" select="  ( $angle mod 360 )  * $pi div 180 "/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select=" round ( number($cosx) * $rounding-factor ) div $rounding-factor"/>
	</xsl:template>
	<xsl:template name="arctan">
		<xsl:param name="x" select="0"/>
		<xsl:param name="rounding-factor" select="100"/>
		<xsl:choose>
			<xsl:when test="$x = 0">
				<xsl:value-of select="0"/>
			</xsl:when>
			<xsl:when test="$x &lt; 0">
				<xsl:variable name="arctan-x">
					<xsl:call-template name="arctan">
						<xsl:with-param name="x" select=" -1 * $x"/>
						<xsl:with-param name="rounding-factor" select="$rounding-factor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="-1 * $arctan-x"/>
			</xsl:when>
			<xsl:when test="$x &gt; 1">
				<xsl:variable name="arctan-div-x">
					<xsl:call-template name="arctan">
						<xsl:with-param name="x" select="1 div $x "/>
						<xsl:with-param name="rounding-factor" select="$rounding-factor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select=" 90 * $pi div 180 - $arctan-div-x"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="arctanx">
					<xsl:call-template name="arctan-private">
						<xsl:with-param name="x" select="  $x "/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select=" round ( number($arctanx) * $rounding-factor ) div $rounding-factor"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="abs">
		<xsl:param name="x"/>
		<xsl:choose>
			<xsl:when test="$x &gt; 0">
				<xsl:value-of select="$x"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$x * -1"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="max">
		<xsl:param name="x1"/>
		<xsl:param name="x2"/>
		<xsl:choose>
			<xsl:when test="$x1 &gt;  $x2">
				<xsl:value-of select="$x1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$x2"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="min">
		<xsl:param name="x1"/>
		<xsl:param name="x2"/>
		<xsl:choose>
			<xsl:when test="$x1 &lt;  $x2">
				<xsl:value-of select="$x1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$x2"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="power">
		<xsl:param name="x"/>
		<xsl:param name="y" select="1"/>
		<xsl:param name="rounding-factor" select="100"/>
		<!--  z is a private param -->
		<xsl:param name="z" select="1"/>
		<xsl:choose>
			<xsl:when test="$y &gt; 0">
				<xsl:call-template name="power">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="y" select="$y - 1"/>
					<xsl:with-param name="z" select="$z * $x"/>
					<xsl:with-param name="rounding-factor" select="$rounding-factor"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select=" round( $z * $rounding-factor) div $rounding-factor"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="sqrt">
		<xsl:param name="x"/>
		<xsl:param name="rounding-factor" select="100"/>
		<xsl:choose>
			<xsl:when test="$x = 0">0</xsl:when>
			<xsl:when test="$x &lt; 0">
				<xsl:message>sqrt error : <xsl:value-of select="$x"/>  less then 0!</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="sqrt-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="rounding-factor" select="$rounding-factor"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- public functions end -->
	<!--
Private functions:
sin-private
cos-private
arctan-private
sqrt-private
integer-sqrt
Sqrt-GetOneDigit
-->
	<xsl:template name="sin-private">
		<xsl:param name="x" select="0"/>
		<xsl:param name="n" select="0"/>
		<xsl:param name="nx" select="1"/>
		<xsl:param name="sign" select="1"/>
		<xsl:param name="max-n" select="20"/>
		<xsl:param name="sinx" select="0"/>
		<xsl:choose>
			<xsl:when test="not ($max-n &gt;  $n) or $nx = 0 ">
				<xsl:value-of select="$sinx"/>
			</xsl:when>
			<xsl:when test="$n = 0">
				<xsl:call-template name="sin-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="sign" select="$sign *  -1"/>
					<xsl:with-param name="max-n" select="$max-n"/>
					<xsl:with-param name="nx" select="$x "/>
					<xsl:with-param name="sinx" select="$sinx + $x"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="new-nx" select="($nx * $x * $x)  div ( 2  *  $n )  div ( 2  *  $n  + 1)  "/>
				<xsl:call-template name="sin-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="sign" select="$sign *  -1"/>
					<xsl:with-param name="max-n" select="$max-n"/>
					<xsl:with-param name="nx" select=" $new-nx "/>
					<xsl:with-param name="sinx" select="$sinx + $new-nx  * $sign"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="cos-private">
		<xsl:param name="x" select="0"/>
		<xsl:param name="n" select="0"/>
		<xsl:param name="nx" select="1"/>
		<xsl:param name="sign" select="1"/>
		<xsl:param name="max-n" select="20"/>
		<xsl:param name="cosx" select="0"/>
		<xsl:choose>
			<xsl:when test="not ($max-n &gt;  $n)  or $nx = 0  ">
				<xsl:value-of select="$cosx"/>
			</xsl:when>
			<xsl:when test="$n = 0">
				<xsl:call-template name="cos-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="sign" select="$sign *  -1"/>
					<xsl:with-param name="max-n" select="$max-n"/>
					<xsl:with-param name="nx" select=" 1 "/>
					<xsl:with-param name="cosx" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="new-nx" select="($nx * $x * $x)  div ( 2  *  $n  -1 )  div ( 2  *  $n )  "/>
				<xsl:call-template name="cos-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="sign" select="$sign *  -1"/>
					<xsl:with-param name="max-n" select="$max-n"/>
					<xsl:with-param name="nx" select=" $new-nx "/>
					<xsl:with-param name="cosx" select="$cosx + $new-nx  * $sign"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="arctan-private">
		<xsl:param name="x" select="0"/>
		<xsl:param name="n" select="0"/>
		<xsl:param name="nx" select="1"/>
		<xsl:param name="sign" select="1"/>
		<xsl:param name="max-n" select="40"/>
		<xsl:param name="arctanx" select="0"/>
		<xsl:choose>
			<xsl:when test="not ($max-n &gt;  $n) or $nx = 0 ">
				<xsl:value-of select="$arctanx"/>
			</xsl:when>
			<xsl:when test="$n = 0">
				<xsl:call-template name="arctan-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="sign" select="$sign *  -1"/>
					<xsl:with-param name="max-n" select="$max-n"/>
					<xsl:with-param name="nx" select="$x "/>
					<xsl:with-param name="arctanx" select="$arctanx + $x"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="new-nx" select=" $nx * $x * $x "/>
				<xsl:call-template name="arctan-private">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="sign" select="$sign *  -1"/>
					<xsl:with-param name="max-n" select="$max-n"/>
					<xsl:with-param name="nx" select=" $new-nx "/>
					<xsl:with-param name="arctanx" select="$arctanx + $new-nx div (2 * $n +1)  * $sign"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="sqrt-private">
		<xsl:param name="x"/>
		<xsl:param name="rounding-factor" select="100"/>
		<xsl:variable name="shift" select="string-length( $rounding-factor)"/>
		<xsl:variable name="power">
			<xsl:call-template name="power">
				<xsl:with-param name="x" select="100"/>
				<xsl:with-param name="y" select="$shift"/>
				<xsl:with-param name="rounding-factor" select="1"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="integer-x" select=" round( $power * $x )"/>
		<xsl:variable name="integer-quotient">
			<xsl:call-template name="integer-sqrt">
				<xsl:with-param name="x" select="$integer-x"/>
				<xsl:with-param name="length" select=" string-length( $integer-x ) "/>
				<xsl:with-param name="curr-pos" select=" 2 -  (round (string-length( $integer-x ) div 2 )  * 2 - string-length( $integer-x ) ) "/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="power-10">
			<xsl:call-template name="power">
				<xsl:with-param name="x" select="10"/>
				<xsl:with-param name="y" select="$shift - 1"/>
				<xsl:with-param name="rounding-factor" select="1"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="  round( $integer-quotient div 10) div $power-10 "/>
	</xsl:template>
	<xsl:template name="integer-sqrt">
		<xsl:param name="x"/>
		<xsl:param name="length"/>
		<xsl:param name="curr-pos"/>
		<xsl:param name="last-quotient" select="0"/>
		<xsl:choose>
			<xsl:when test="$curr-pos &gt; $length">
				<xsl:value-of select="$last-quotient"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="curr-x" select="substring( $x, 1,  $curr-pos )"/>
				<xsl:variable name="new-quotient">
					<xsl:call-template name="get-one-sqrt-digit">
						<xsl:with-param name="x" select="$curr-x"/>
						<xsl:with-param name="last-quotient" select="$last-quotient"/>
						<xsl:with-param name="n" select="5"/>
						<xsl:with-param name="direct" select="0"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="integer-sqrt">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="length" select="$length"/>
					<xsl:with-param name="curr-pos" select="$curr-pos + 2"/>
					<xsl:with-param name="last-quotient" select="number($new-quotient)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="get-one-sqrt-digit">
		<xsl:param name="x"/>
		<xsl:param name="last-quotient"/>
		<xsl:param name="n"/>
		<xsl:param name="direct" select="1"/>
		<xsl:variable name="quotient" select=" concat( $last-quotient, $n) "/>
		<xsl:variable name="accumulate" select="$quotient * $quotient "/>
		<xsl:choose>
			<xsl:when test="$accumulate  =  $x">
				<xsl:value-of select="concat($last-quotient , $n  )"/>
			</xsl:when>
			<xsl:when test="$direct = 0 and $accumulate  &lt;  $x">
				<xsl:call-template name="get-one-sqrt-digit">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="last-quotient" select="$last-quotient"/>
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="direct" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$direct = 0 and $accumulate  &gt;  $x">
				<xsl:call-template name="get-one-sqrt-digit">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="last-quotient" select="$last-quotient"/>
					<xsl:with-param name="n" select="$n - 1"/>
					<xsl:with-param name="direct" select="-1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=" $accumulate * $direct  &lt;  $x * $direct  ">
				<xsl:call-template name="get-one-sqrt-digit">
					<xsl:with-param name="x" select="$x"/>
					<xsl:with-param name="last-quotient" select="$last-quotient"/>
					<xsl:with-param name="n" select="$n+ $direct"/>
					<xsl:with-param name="direct" select="$direct"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="not($n &lt; 9)  or $n = -1">
				<xsl:value-of select="concat($last-quotient , $n - $direct) "/>
			</xsl:when>
			<xsl:when test="$direct = 1">
				<xsl:value-of select="concat($last-quotient , $n - 1) "/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($last-quotient , $n) "/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--end of math.xsl ============== -->
	<xsl:template match="/">
		<xsl:apply-templates select="w:wordDocument"/>
	</xsl:template>
	<xsl:template match="w:wordDocument">
		<office:document office:class="text" office:version="1.0">
			<xsl:apply-templates select="o:DocumentProperties"/>
			<xsl:apply-templates select="w:docPr"/>
			<xsl:apply-templates select="w:fonts"/>
			<xsl:apply-templates select="w:styles"/>
			<xsl:apply-templates select="w:body"/>
		</office:document>
	</xsl:template>
	<xsl:template match="w:fonts">
		<xsl:element name="office:font-decls">
			<!-- MS Word's default font declaration, added for Writer automatically. glu -->
			<style:font-decl style:name="Arial" fo:font-family="Arial" style:font-family-generic="roman" style:font-pitch="variable"/>
			<style:font-decl style:name="Times New Roman" fo:font-family="'Times New Roman'" style:font-family-generic="roman" style:font-pitch="variable"/>
			<style:font-decl style:name="Symbol" fo:font-family="Symbol" style:font-family-generic="roman" style:font-pitch="variable" style:font-charset="x-symbol"/>
			<style:font-decl style:name="Courier New" fo:font-family="'Courier New'" style:font-family-generic="modern" style:font-pitch="fixed"/>
			<xsl:if test="not(w:font[@w:name='StarSymbol'])">
				<style:font-decl style:name="StarSymbol" fo:font-family="StarSymbol" style:font-charset="x-symbol"/>
			</xsl:if>
			<xsl:for-each select="w:font">
				<xsl:element name="style:font-decl">
					<xsl:attribute name="style:name"><xsl:value-of select="@w:name"/></xsl:attribute>
					<xsl:attribute name="fo:font-family"><xsl:value-of select="@w:name"/></xsl:attribute>
					<!-- added by glu, for process special fonts e.g. Marlett, -->
					<xsl:if test="w:charset/@w:val = '02'">
						<xsl:attribute name="style:font-charset">x-symbol</xsl:attribute>
					</xsl:if>
					<xsl:if test="w:family">
						<xsl:choose>
							<xsl:when test="w:family/@w:val = 'Swiss'">
								<xsl:attribute name="style:font-family-generic">swiss</xsl:attribute>
							</xsl:when>
							<xsl:when test="w:family/@w:val='Modern'">
								<xsl:attribute name="style:font-family-generic">modern</xsl:attribute>
							</xsl:when>
							<xsl:when test="w:family/@w:val='Roman'">
								<xsl:attribute name="style:font-family-generic">roman</xsl:attribute>
							</xsl:when>
							<xsl:when test="w:family/@w:val='Script'">
								<xsl:attribute name="style:font-family-generic">script</xsl:attribute>
							</xsl:when>
							<xsl:when test="w:family/@w:val='Decorative'">
								<xsl:attribute name="style:font-family-generic">decorative</xsl:attribute>
							</xsl:when>
							<xsl:when test="w:family/@w:val='System'">
								<xsl:attribute name="style:font-family-generic">system</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style:font-family-generic">system</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<xsl:if test="w:pitch">
						<xsl:attribute name="style:font-pitch"><xsl:value-of select="w:pitch/@w:val"/></xsl:attribute>
					</xsl:if>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:styles">
		<office:styles>
			<xsl:call-template name="create-default-paragraph-styles"/>
			<xsl:call-template name="create-default-text-styles"/>
			<xsl:call-template name="create-default-frame-style"/>
			<!-- StarWriter has no default style family 'list'. glu -->
			<xsl:if test="w:style[@w:type = 'paragraph' and w:pPr/w:outlineLvl and w:pPr/w:listPr]">
				<xsl:call-template name="create-outline-style"/>
			</xsl:if>
			<xsl:apply-templates select="w:style[@w:type='list']" mode="list"/>
			<xsl:apply-templates select="w:style[@w:type!='list']"/>
			<xsl:apply-templates select="/w:wordDocument/w:docPr/w:footnotePr" mode="config"/>
			<xsl:apply-templates select="/w:wordDocument/w:docPr/w:endnotePr" mode="config"/>
		</office:styles>
		<office:automatic-styles>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:p" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:rPr[not(parent::w:pPr)]" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:tblPr" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:gridCol" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:trHeight" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:tcPr" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:listPr" mode="style"/>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:sectPr" mode="page-master"/>
			<xsl:call-template name="default_date_style"/>
			<!--add for generate the date , time style for date , time field  G.Y.-->
			<xsl:apply-templates select="/w:wordDocument/w:body//w:instrText | /w:wordDocument/w:body//w:fldSimple " mode="style"/>
		</office:automatic-styles>
		<office:master-styles>
			<xsl:apply-templates select="/w:wordDocument/w:body//w:sectPr" mode="master-page"/>
		</office:master-styles>
	</xsl:template>
	<xsl:template match="w:style">
		<style:style>
			<xsl:attribute name="style:name"><xsl:value-of select="@w:styleId"/></xsl:attribute>
			<xsl:if test="w:basedOn">
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select="w:basedOn/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="w:next">
				<xsl:attribute name="style:next-style-name"><xsl:value-of select="w:next/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="@w:type = 'character'">
					<xsl:attribute name="style:family">text</xsl:attribute>
				</xsl:when>
				<!-- table, paragraph are the same as in Writer . glu -->
				<xsl:when test="@w:type">
					<xsl:attribute name="style:family"><xsl:value-of select="@w:type"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style:family">text</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:element name="style:properties">
                <xsl:apply-templates select="w:rPr"  />

				<xsl:apply-templates select="w:pPr"/>
				
			</xsl:element>
		</style:style>
	</xsl:template>
	<xsl:template match="w:body">
		<xsl:element name="office:body">
			<!-- to add the sequece variable declaration at the begining of the office:body  G.Y.-->
			<text:sequence-decls>
				<xsl:call-template name="default_seqence_declaration"/>
				<xsl:apply-templates select="/w:wordDocument/w:body//w:instrText[substring(normalize-space(text()),1,3) = 'SEQ' ] | /w:wordDocument/w:body//w:fldSimple[substring(normalize-space(@w:instr),1,3) = 'SEQ' ]  " mode="sequence_declare"/>
			</text:sequence-decls>
			<!--  add the user field variables declare for Docpropety fields importing G.Y.-->
			<text:user-field-decls>
				<xsl:call-template name="user_fields_declare_docproperty"/>
			</text:user-field-decls>
			<xsl:apply-templates select="wx:sect | w:p | w:tbl | w:sectPr"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="wx:sect">
		<xsl:apply-templates select="wx:sub-section | w:p | w:tbl | w:sectPr"/>
	</xsl:template>
	<xsl:template match="wx:sub-section">
		<xsl:apply-templates select="wx:sub-section | w:p | w:tbl | w:sectPr"/>
	</xsl:template>
	<xsl:template name="create-default-frame-style">
		<!--add for default frame style -->
		<style:style style:name="Frame" style:family="graphics">
			<style:properties text:anchor-type="paragraph" svg:x="0inch" svg:y="0inch" style:wrap="parallel" style:number-wrapped-paragraphs="no-limit" style:wrap-contour="false" style:vertical-pos="top" style:vertical-rel="paragraph-content" style:horizontal-pos="center" style:horizontal-rel="paragraph-content"/>
		</style:style>
	</xsl:template>
	<!-- End of the wordml2ooo.xsl  ==========================   -->
	<!--Start common/m2ooo_docpr.xsl =======================  -->
	<xsl:template match="o:DocumentProperties">
		<office:meta>
			<meta:generator>Microsoft Word 2003</meta:generator>
			<dc:title>
				<xsl:value-of select="o:Title"/>
			</dc:title>
			<dc:description>
				<xsl:value-of select="o:Description"/>
			</dc:description>
			<dc:subject>
				<xsl:value-of select="o:Subject"/>
			</dc:subject>
			<meta:initial-creator>
				<xsl:value-of select="o:Author"/>
			</meta:initial-creator>
			<meta:creation-date>
				<xsl:value-of select="substring-before( o:Created, 'Z')"/>
			</meta:creation-date>
			<dc:creator>
				<xsl:value-of select="o:LastAuthor"/>
			</dc:creator>
			<dc:date>
				<xsl:value-of select="substring-before( o:LastSaved, 'Z')"/>
			</dc:date>
			<meta:printed-by/>
			<meta:print-date>
				<xsl:value-of select="substring-before( o:LastPrinted, 'Z')"/>
			</meta:print-date>
			<meta:keywords>
				<meta:keyword>
					<xsl:value-of select="o:Keywords"/>
				</meta:keyword>
			</meta:keywords>
			<dc:language/>
			<meta:editing-cycles>
				<xsl:value-of select="o:Revision"/>
			</meta:editing-cycles>
			<meta:editing-duration>
				<xsl:if test="o:TotalTime">
					<xsl:value-of select="concat('PT', floor(o:TotalTime div 60), 'H', o:TotalTime mod 60, 'M0S')"/>
				</xsl:if>
			</meta:editing-duration>
			<meta:user-defined meta:name="Category">
				<xsl:value-of select="o:Category"/>
			</meta:user-defined>
			<meta:user-defined meta:name="Manager">
				<xsl:value-of select="o:Manager"/>
			</meta:user-defined>
			<meta:user-defined meta:name="Company">
				<xsl:value-of select="o:Company"/>
			</meta:user-defined>
			<meta:user-defined meta:name="Version">
				<xsl:value-of select="o:Version"/>
			</meta:user-defined>
			<meta:user-defined meta:name="HyperlinkBase">
				<xsl:value-of select="o:HyperlinkBase"/>
			</meta:user-defined>
			<xsl:apply-templates select="../o:CustomDocumentProperties"/>
			<meta:document-statistic meta:page-count="{o:Pages}" meta:paragraph-count="{o:Paragraphs}" meta:word-count="{o:Words}" meta:character-count="{o:Characters}"/>
		</office:meta>
	</xsl:template>
	<xsl:template match="o:CustomDocumentProperties">
		<xsl:for-each select="node()[@dt:dt]">
			<meta:user-defined meta:name="{local-name()}">
				<xsl:value-of select="."/>
			</meta:user-defined>
		</xsl:for-each>
	</xsl:template>
	<!--End wordml/common/m2ooo_docpr.xsl =======================  -->
	<!--start  wordml2ooo_draw.xsl =======================  -->
	<xsl:template match="w:pict">
		<xsl:choose>
			<xsl:when test="descendant::w:binData">
				<!-- Cannot load zipped Wmf file. glu <xsl:if test="not(contains(w:binData/@w:name,'.wmz'))"> -->
				<xsl:element name="draw:image">
					<xsl:if test="v:shape/@style">
						<xsl:if test="contains( v:shape/@style, 'margin-left:')">
							<xsl:variable name="x-pos">
								<xsl:call-template name="get-middle-substring">
									<xsl:with-param name="string" select="v:shape/@style"/>
									<xsl:with-param name="prefix" select="'margin-left:'"/>
									<xsl:with-param name="suffix" select="';'"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:attribute name="svg:x"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="$x-pos"/></xsl:call-template>cm</xsl:attribute>
						</xsl:if>
						<xsl:if test="contains( v:shape/@style, 'margin-top:')">
							<xsl:variable name="y-pos">
								<xsl:call-template name="get-middle-substring">
									<xsl:with-param name="string" select="v:shape/@style"/>
									<xsl:with-param name="prefix" select="'margin-top:'"/>
									<xsl:with-param name="suffix" select="';'"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:attribute name="svg:y"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="$y-pos"/></xsl:call-template>cm</xsl:attribute>
						</xsl:if>
						<xsl:variable name="width">
							<xsl:call-template name="get-middle-substring">
								<xsl:with-param name="string" select="v:shape/@style"/>
								<xsl:with-param name="prefix" select="'width:'"/>
								<xsl:with-param name="suffix" select="';'"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="svg:width"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="$width"/></xsl:call-template>cm</xsl:attribute>
						<xsl:variable name="height">
							<xsl:call-template name="get-middle-substring">
								<xsl:with-param name="string" select="v:shape/@style"/>
								<xsl:with-param name="prefix" select="'height:'"/>
								<xsl:with-param name="suffix" select="';'"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="svg:height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="$height"/></xsl:call-template>cm</xsl:attribute>
						<xsl:variable name="anchor-type">
							<xsl:if test="contains( v:shape/@style, 'mso-position-horizontal-relative')">
								<xsl:value-of select="substring-before( substring-after( v:shape/@style, 'mso-position-horizontal-relative:'), ';')"/>
							</xsl:if>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$anchor-type = 'margin'">
								<xsl:attribute name="text:anchor-type">frame</xsl:attribute>
							</xsl:when>
							<xsl:when test="$anchor-type = 'page'">
								<xsl:attribute name="text:anchor-type">page</xsl:attribute>
							</xsl:when>
							<xsl:when test="$anchor-type = 'char'">
								<xsl:attribute name="text:anchor-type">as-char</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="text:anchor-type">paragraph</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="v:shape/v:imagedata/@o:title">
							<xsl:attribute name="draw:name"><xsl:value-of select="v:shape/v:imagedata/@o:title"/></xsl:attribute>
						</xsl:if>
						<xsl:element name="office:binary-data">
							<xsl:value-of select="w:binData"/>
						</xsl:element>
					</xsl:if>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="get-middle-substring">
		<xsl:param name="string"/>
		<xsl:param name="prefix"/>
		<xsl:param name="suffix"/>
		<xsl:if test="contains($string, $prefix)">
			<xsl:choose>
				<xsl:when test="contains(substring-after( $string, $prefix), $suffix)">
					<xsl:value-of select="substring-before(substring-after( $string, $prefix), $suffix)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring-after( $string, $prefix)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:binData">
		<xsl:element name="office:binary-data">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="v:group">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="v:oval">
		<xsl:element name="draw:ellipse">
			<xsl:variable name="style" select="@style"/>
			<xsl:variable name="position" select="substring-after($style,'position:')"/>
			<xsl:variable name="positionval" select="substring-before($position,';')"/>
			<xsl:variable name="left" select="substring-after($style,'left:')"/>
			<xsl:variable name="leftval" select="substring-before($left,';')"/>
			<xsl:variable name="top" select="substring-after($style,'top:')"/>
			<xsl:variable name="topval" select="substring-before($top,';')"/>
			<xsl:variable name="width" select="substring-after($style,'width:')"/>
			<xsl:variable name="widthval" select="substring-before($width,';')"/>
			<xsl:variable name="height" select="substring-after($style,'height:')"/>
			<xsl:variable name="heightval" select="$height"/>
			<xsl:if test="$positionval = 'absolute'">
				<xsl:variable name="parentgroup" select="parent::v:group"/>
				<xsl:variable name="origin" select="$parentgroup/@coordorigin"/>
				<xsl:variable name="groupleft" select="substring-before($origin,',')"/>
				<xsl:variable name="grouptop" select="substring-after($origin,',')"/>
				<xsl:variable name="currsect" select="ancestor::wx:sect"/>
				<xsl:variable name="currsectPr" select="$currsect/descendant::w:sectPr/w:pgMar"/>
				<xsl:variable name="leftmar" select="$currsectPr/@w:left"/>
				<xsl:variable name="topmar" select="$currsectPr/@w:top"/>
				<xsl:attribute name="text:anchor-type">page</xsl:attribute>
				<xsl:attribute name="svg:width"><xsl:value-of select="(number($widthval) div 1440) * 2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:height"><xsl:value-of select="(number($heightval) div 1440) * 2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:x"><xsl:value-of select="(number($topval + $topmar) div 1440) * 2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:y"><xsl:value-of select="(number($leftval + $leftmar) div 1440) * 2.54"/>cm</xsl:attribute>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template match="v:rect">
		<xsl:element name="draw:rect">
			<xsl:variable name="style" select="@style"/>
			<xsl:variable name="position" select="substring-after($style,'position:')"/>
			<xsl:variable name="positionval" select="substring-before($position,';')"/>
			<xsl:variable name="left" select="substring-after($style,'left:')"/>
			<xsl:variable name="leftval" select="substring-before($left,';')"/>
			<xsl:variable name="top" select="substring-after($style,'top:')"/>
			<xsl:variable name="topval" select="substring-before($top,';')"/>
			<xsl:variable name="width" select="substring-after($style,'width:')"/>
			<xsl:variable name="widthval" select="substring-before($width,';')"/>
			<xsl:variable name="height" select="substring-after($style,'height:')"/>
			<xsl:variable name="heightval" select="$height"/>
			<xsl:if test="$positionval = 'absolute'">
				<xsl:variable name="parentgroup" select="parent::v:group"/>
				<xsl:variable name="origin" select="$parentgroup/@coordorigin"/>
				<xsl:variable name="groupleft" select="substring-before($origin,',')"/>
				<xsl:variable name="grouptop" select="substring-after($origin,',')"/>
				<xsl:variable name="currsect" select="ancestor::wx:sect"/>
				<xsl:variable name="currsectPr" select="$currsect/descendant::w:sectPr/w:pgMar"/>
				<xsl:variable name="leftmar" select="$currsectPr/@w:left"/>
				<xsl:variable name="topmar" select="$currsectPr/@w:top"/>
				<xsl:attribute name="text:anchor-type">page</xsl:attribute>
				<xsl:attribute name="svg:width"><xsl:value-of select="(number($widthval) div 1440) * 2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:height"><xsl:value-of select="(number($heightval) div 1440) * 2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:x"><xsl:value-of select="(number($topval + $topmar) div 1440) * 2.54"/>cm</xsl:attribute>
				<xsl:attribute name="svg:y"><xsl:value-of select="(number($leftval + $leftmar) div 1440) * 2.54"/>cm</xsl:attribute>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<!--end  wordml2ooo_draw.xsl =======================  -->
	<!-- start wordml2ooo_field.xsl ======================= -->
	<!--Generally, The MS fields can be represented in two forms, simple field w:fldsimple or complicated field
 w:fldChar, so when importing we have to take care of two possible forms of  the same type field -->
	<xsl:template match="w:instrText">
		<!-- ===this template is to process the w:fldChar fields ======  -->
		<xsl:choose>
			<xsl:when test="contains(. , 'HYPERLINK')">
				<xsl:variable name="hyper-str" select="normalize-space(.)"/>
				<xsl:variable name="hyper-dest" select="substring-before( substring($hyper-str, 12), '&quot;')"/>
				<xsl:variable name="hyper-bookmark">
					<xsl:if test="contains( $hyper-str, ' \l ')">
						<xsl:value-of select="concat( '#', substring-before( substring-after( substring-after( $hyper-str, ' \l '), '&quot;'), '&quot;') )"/>
					</xsl:if>
				</xsl:variable>
				<text:a xlink:type="simple" xlink:href="{concat( $hyper-dest, $hyper-bookmark)}"/>
			</xsl:when>
			<xsl:when test="substring( normalize-space(.),1,3) = 'REF' ">
				<text:bookmark-ref text:reference-format="text" text:ref-name="{normalize-space( substring-before (substring-after(text(), 'REF') , '\') )}">

            </text:bookmark-ref>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,4) = 'DATE'  or substring(normalize-space(.),1,4) = 'TIME' ">
				<text:date>
					<xsl:choose>
						<xsl:when test="contains(text(), '\@')">
							<xsl:attribute name="style:data-style-name">ND<xsl:number count="w:instrText | w:fldSimple" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</text:date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,9) = 'PRINTDATE' ">
				<text:print-date>
					<xsl:choose>
						<xsl:when test="contains(text(), '\@')">
							<xsl:attribute name="style:data-style-name">ND<xsl:number count="w:instrText | w:fldSimple" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</text:print-date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,10) = 'CREATEDATE' ">
				<text:creation-date>
					<xsl:choose>
						<xsl:when test="contains(text(), '\@')">
							<xsl:attribute name="style:data-style-name">ND<xsl:number count="w:instrText | w:fldSimple" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</text:creation-date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,8) = 'SAVEDATE' ">
				<text:modification-date>
					<xsl:choose>
						<xsl:when test="contains(text(), '\@')">
							<xsl:attribute name="style:data-style-name">ND<xsl:number count="w:instrText | w:fldSimple" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</text:modification-date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,4) = 'PAGE' ">
				<text:page-number text:select-page="current">
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(text(), '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:page-number>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,8) = 'NUMPAGES' ">
				<text:page-count>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(text(), '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:page-count>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,8) = 'NUMWORDS' ">
				<text:word-count>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(text(), '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:word-count>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,8) = 'NUMCHARS' ">
				<text:character-count>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(text(), '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:character-count>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,6) = 'REVNUM' ">
				<text:editing-cycles>
					<xsl:value-of select="w:r"/>
				</text:editing-cycles>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,7) = 'AUTONUM'  or  substring(normalize-space(.),1,10) = 'AUTONUMLGL' or substring(normalize-space(.),1,10) = 'AUTONUMOUT' ">
				<text:sequence>
					<xsl:attribute name="text:ref-name">RefAutoNum<xsl:number count="w:instrText[contains(text(), 'AUTONUM') or contains(text(), 'AUTONUMLGL') or contains( text(), 'AUTONUMOUT') ] | w:fldSimple[contains(@w:instr,'AUTONUM') or contains(@w:instr, 'AUTONUMLGL') or contains(@w:instr, 'AUTONUMOUT') ] " from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
					<xsl:attribute name="text:name"><xsl:value-of select=" 'AutoNr' "/></xsl:attribute>
					<xsl:attribute name="text:formula"><xsl:value-of select=" 'AutoNr + 1' "/></xsl:attribute>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(text(), '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:sequence>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,3) = 'SEQ' ">
				<text:sequence>
					<xsl:attribute name="text:ref-name">Ref<xsl:number count="w:instrText[contains(text(), 'SEQ') ] | w:fldSimple[contains(@w:instr,'SEQ') ] " from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
					<xsl:variable name="seq_text_name">
						<xsl:call-template name="get_seq_name">
							<xsl:with-param name="input_seq_string" select="normalize-space(substring-after(text(), 'SEQ'))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="text:name"><xsl:value-of select="$seq_text_name"/></xsl:attribute>
					<xsl:attribute name="text:formula"><xsl:value-of select="concat ($seq_text_name, ' + 1' )"/></xsl:attribute>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(text(), '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:sequence>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,6) = 'AUTHOR' ">
				<text:initial-creator>
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:initial-creator>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,5) = 'TITLE' ">
				<text:title>
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:title>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,7) = 'SUBJECT' ">
				<text:subject>
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:subject>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,8) = 'KEYWORDS' ">
				<text:keywords>
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:keywords>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,6) = 'FILLIN' ">
				<text:text-input>
					<xsl:attribute name="text:description"><xsl:value-of select="substring-before(substring-after(text(), 'FILLIN'), '\*')"/></xsl:attribute>
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:text-input>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,11) = 'DOCPROPERTY' ">
				<xsl:variable name="instr_command">
					<xsl:value-of select="normalize-space (substring-after(text(), 'DOCPROPERTY' ))"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="contains($instr_command, 'Author' ) ">
						<text:user-field-get text:name="Author">
			             </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Bytes' ) ">
						<text:user-field-get text:name="Bytes">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'CharactersWithSpaces' ) ">
						<text:user-field-get text:name="CharactersWithSpaces">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Category' ) ">
						<text:user-field-get text:name="Category">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Characters' ) ">
						<text:user-field-get text:name="Characters">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Comments' ) ">
						<text:user-field-get text:name="Comments">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Company' ) ">
						<text:user-field-get text:name="Company">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'CreateTime' ) ">
						<text:user-field-get text:name="CreateTime">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'HyperlinkBase' ) ">
						<text:user-field-get text:name="HyperlinkBase">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Keywords' ) ">
						<text:user-field-get text:name="Keywords">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'LastPrinted' ) ">
						<text:user-field-get text:name="LastPrinted">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'LastSavedBy' ) ">
						<text:user-field-get text:name="LastSavedBy">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'LastSavedTime' ) ">
						<text:user-field-get text:name="LastSavedTime">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Lines' ) ">
						<text:user-field-get text:name="Lines">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Manager' ) ">
						<text:user-field-get text:name="Manager">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'NameofApplication' ) ">
						<text:user-field-get text:name="NameofApplication">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'ODMADocId' ) ">
						<text:user-field-get text:name="ODMADocId">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Pages' ) ">
						<text:user-field-get text:name="Pages">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Paragraphs' ) ">
						<text:user-field-get text:name="Paragraphs">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'RevisionNumber' ) ">
						<text:user-field-get text:name="RevisionNumber">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Security' ) ">
						<text:user-field-get text:name="Security">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Subject' ) ">
						<text:user-field-get text:name="Subject">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Template' ) ">
						<text:user-field-get text:name="Template">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Title' ) ">
						<text:user-field-get text:name="Title">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'TotalEditingTime' ) ">
						<text:user-field-get text:name="TotalEditingTime">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Words' ) ">
						<text:user-field-get text:name="Words">
			            </text:user-field-get>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,10) = 'MERGEFIELD' ">
				<text:database-display text:database-name="" text:table-name="" text:table-type="table">
					<xsl:attribute name="text:column-name"><xsl:value-of select="substring-before(substring-after(normalize-space(.), 'MERGEFIELD' ), ' ' ) "/></xsl:attribute>
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:database-display>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,8) = 'MERGEREC' ">
				<text:database-row-number text:database-name="" text:table-name="" text:table-type="table" style:num-format="A" text:value="0">
					<xsl:call-template name="get-fldchar-content">
						<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
						<xsl:with-param name="sibling_number" select=" 1"/>
					</xsl:call-template>
				</text:database-row-number>
			</xsl:when>
			<xsl:when test="substring(normalize-space(.),1,4) = 'NEXT' ">
				<text:database-next text:database-name="" text:table-name="" text:table-type="table" text:condition="">
                </text:database-next>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:fldChar">
		<!-- for complicated field w:fldChar, we only process the w:instrText, please see the template processing w:instrText  -->
	</xsl:template>
	<xsl:template name="get-fldchar-content">
		<!-- this template is to get the content of fldchar in-between w:instrText and w:fldChar/@w:fldCharType ='end'  -->
		<xsl:param name="next_node"/>
		<xsl:param name="sibling_number"/>
		<xsl:if test="not ($next_node/w:fldChar/@w:fldCharType ='end' ) and $next_node ">
			<xsl:if test="$next_node/w:br">
				<xsl:text>&#x0A;</xsl:text>
			</xsl:if>
			<xsl:value-of select="$next_node//w:t"/>
			<xsl:call-template name="get-fldchar-content">
				<xsl:with-param name="next_node" select="../following-sibling::w:r[$sibling_number + 1]"/>
				<xsl:with-param name="sibling_number" select="$sibling_number + 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- ====== this  template is to process the w:fldsimple fields ======= -->
	<xsl:template match="w:fldSimple">
		<xsl:choose>
			<xsl:when test="substring( normalize-space(@w:instr),1,3) = 'REF' ">
				<text:bookmark-ref text:reference-format="text" text:ref-name="{normalize-space( substring-before (substring-after(@w:instr, 'REF') , '\') )}">

            </text:bookmark-ref>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,4) = 'DATE'  or substring(normalize-space(@w:instr),1,4) = 'TIME'  ">
				<text:date>
					<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
					<xsl:value-of select=".//w:t"/>
				</text:date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,9) = 'PRINTDATE' ">
				<text:print-date>
					<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
					<xsl:value-of select=".//w:t"/>
				</text:print-date>
			</xsl:when>
			<xsl:when test=" substring(normalize-space(@w:instr),1,10) = 'CREATEDATE' ">
				<text:creation-date>
					<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
					<xsl:value-of select=".//w:t"/>
				</text:creation-date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,8) = 'SAVEDATE' ">
				<text:modification-date>
					<xsl:attribute name="style:data-style-name"><xsl:value-of select=" 'NDF1' "/></xsl:attribute>
					<xsl:value-of select=".//w:t"/>
				</text:modification-date>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,4) = 'PAGE' ">
				<text:page-number text:select-page="current">
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(@w:instr, '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:page-number>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,8) = 'NUMPAGES' ">
				<text:page-count>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(@w:instr, '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:page-count>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,8) = 'NUMWORDS' ">
				<text:word-count>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(@w:instr, '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:word-count>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,8) = 'NUMCHARS' ">
				<text:character-count>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(@w:instr, '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:character-count>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,6) = 'REVNUM' ">
				<text:editing-cycles>
					<xsl:value-of select="w:r"/>
				</text:editing-cycles>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,7) = 'AUTONUM'  or  substring(normalize-space(@w:instr),1,10) = 'AUTONUMLGL' or substring(normalize-space(@w:instr),1,10) = 'AUTONUMOUT' ">
				<text:sequence>
					<xsl:attribute name="text:ref-name">RefAutoNum<xsl:number count="w:instrText[contains(text(), 'AUTONUM') or contains(text(), 'AUTONUMLGL') or contains( text(), 'AUTONUMOUT') ] | w:fldSimple[contains(@w:instr,'AUTONUM') or contains(@w:instr, 'AUTONUMLGL') or contains(@w:instr, 'AUTONUMOUT') ] " from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
					<xsl:attribute name="text:name"><xsl:value-of select=" 'AutoNr' "/></xsl:attribute>
					<xsl:attribute name="text:formula"><xsl:value-of select=" 'AutoNr + 1' "/></xsl:attribute>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(@w:instr, '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:sequence>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,3) = 'SEQ' ">
				<text:sequence>
					<xsl:attribute name="text:ref-name">Ref<xsl:number count="w:instrText[contains(text(), 'SEQ') ] | w:fldSimple[contains(@w:instr,'SEQ') ] " from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
					<xsl:variable name="seq_text_name">
						<xsl:call-template name="get_seq_name">
							<xsl:with-param name="input_seq_string" select="normalize-space(substring-after(@w:instr, 'SEQ'))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="text:name"><xsl:value-of select="$seq_text_name"/></xsl:attribute>
					<xsl:attribute name="text:formula"><xsl:value-of select="concat ($seq_text_name, ' + 1' )"/></xsl:attribute>
					<xsl:variable name="num-format">
						<xsl:call-template name="get_field_num_format">
							<xsl:with-param name="input_MS_num_format" select="normalize-space(substring-after(@w:instr, '\*' ))"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:attribute name="style:num-format"><xsl:value-of select="$num-format"/></xsl:attribute>
				</text:sequence>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,6) = 'AUTHOR' ">
				<text:initial-creator>
					<xsl:value-of select=" .//w:t"/>
				</text:initial-creator>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,5) = 'TITLE' ">
				<text:title>
					<xsl:value-of select=" .//w:t"/>
				</text:title>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,7) = 'SUBJECT' ">
				<text:subject>
					<xsl:value-of select=" .//w:t"/>
				</text:subject>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,8) = 'KEYWORDS' ">
				<text:keywords>
					<xsl:value-of select=" .//w:t"/>
				</text:keywords>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,6) = 'FILLIN' ">
				<text:text-input>
					<xsl:attribute name="text:description"><xsl:value-of select="substring-before(substring-after(@w:instr, '&quot;'), '&quot;')"/></xsl:attribute>
					<xsl:value-of select=" .//w:t"/>
				</text:text-input>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,11) = 'DOCPROPERTY' ">
				<xsl:variable name="instr_command">
					<xsl:value-of select="normalize-space (substring-after(@w:instr, 'DOCPROPERTY' ))"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="contains($instr_command, 'Author' ) ">
						<text:user-field-get text:name="Author">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Bytes' ) ">
						<text:user-field-get text:name="Bytes">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Category' ) ">
						<text:user-field-get text:name="Category">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'CharactersWithSpaces' ) ">
						<text:user-field-get text:name="CharactersWithSpaces">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Characters' ) ">
						<text:user-field-get text:name="Characters">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Comments' ) ">
						<text:user-field-get text:name="Comments">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Company' ) ">
						<text:user-field-get text:name="Company">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'CreateTime' ) ">
						<text:user-field-get text:name="CreateTime">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'HyperlinkBase' ) ">
						<text:user-field-get text:name="HyperlinkBase">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Keywords' ) ">
						<text:user-field-get text:name="Keywords">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'LastPrinted' ) ">
						<text:user-field-get text:name="LastPrinted">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'LastSavedBy' ) ">
						<text:user-field-get text:name="LastSavedBy">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'LastSavedTime' ) ">
						<text:user-field-get text:name="LastSavedTime">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Lines' ) ">
						<text:user-field-get text:name="Lines">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Manager' ) ">
						<text:user-field-get text:name="Manager">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'NameofApplication' ) ">
						<text:user-field-get text:name="NameofApplication">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'ODMADocId' ) ">
						<text:user-field-get text:name="ODMADocId">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Pages' ) ">
						<text:user-field-get text:name="Pages">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Paragraphs' ) ">
						<text:user-field-get text:name="Paragraphs">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'RevisionNumber' ) ">
						<text:user-field-get text:name="RevisionNumber">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Security' ) ">
						<text:user-field-get text:name="Security">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Subject' ) ">
						<text:user-field-get text:name="Subject">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Template' ) ">
						<text:user-field-get text:name="Template">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Title' ) ">
						<text:user-field-get text:name="Title">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'TotalEditingTime' ) ">
						<text:user-field-get text:name="TotalEditingTime">
			            </text:user-field-get>
					</xsl:when>
					<xsl:when test="contains($instr_command, 'Words' ) ">
						<text:user-field-get text:name="Words">
			            </text:user-field-get>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,10) = 'MERGEFIELD' ">
				<text:database-display text:database-name="" text:table-name="" text:table-type="table">
					<xsl:attribute name="text:column-name"><xsl:value-of select="substring-before(substring-after(normalize-space(.), 'MERGEFIELD' ), ' ' ) "/></xsl:attribute>
					<xsl:value-of select=" .//w:t"/>
				</text:database-display>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,8) = 'MERGEREC' ">
				<text:database-row-number text:database-name="" text:table-name="" text:table-type="table" style:num-format="A" text:value="0">
					<xsl:value-of select=" .//w:t"/>
				</text:database-row-number>
			</xsl:when>
			<xsl:when test="substring(normalize-space(@w:instr),1,4) = 'NEXT' ">
				<text:database-next text:database-name="" text:table-name="" text:table-type="table" text:condition="">
					<xsl:value-of select=" .//w:t"/>
				</text:database-next>
			</xsl:when>
			<xsl:otherwise>
				<!--  for  MS simple fields that can not map to  OOo writer fields, we just import the content of these fields -->
				<xsl:value-of select="w:r"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="get_seq_name">
		<!-- this template is to get the identifier from the input MS seq string -->
		<xsl:param name="input_seq_string"/>
		<xsl:choose>
			<xsl:when test="contains( $input_seq_string, ' ' )">
				<xsl:value-of select="substring-before($input_seq_string, ' ' )"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$input_seq_string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="default_seqence_declaration">
		<text:sequence-decl text:display-outline-level="0" text:name="Illustration">
			</text:sequence-decl>
		<text:sequence-decl text:display-outline-level="0" text:name="Table">
			</text:sequence-decl>
		<text:sequence-decl text:display-outline-level="0" text:name="Text">
			</text:sequence-decl>
		<text:sequence-decl text:display-outline-level="0" text:name="Drawing">
			</text:sequence-decl>
		<text:sequence-decl text:display-outline-level="0" text:name="AutoNr">
			</text:sequence-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="sequence_declare">
		<text:sequence-decl text:display-outline-level="0">
			<xsl:variable name="seq_variable_name">
				<xsl:choose>
					<xsl:when test=" name() = 'w:instrText' ">
						<xsl:if test="substring(normalize-space(text()),1,3) = 'SEQ' ">
							<xsl:call-template name="get_seq_name">
								<xsl:with-param name="input_seq_string" select="normalize-space( substring-after(text(), 'SEQ' ))"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
					<xsl:when test=" name() = 'w:fldSimple' ">
						<xsl:if test="substring(normalize-space(@w:instr),1,3) = 'SEQ' ">
							<xsl:call-template name="get_seq_name">
								<xsl:with-param name="input_seq_string" select="normalize-space( substring-after(@w:instr, 'SEQ' ))"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:name"><xsl:value-of select="$seq_variable_name"/></xsl:attribute>
		</text:sequence-decl>
	</xsl:template>
	<!-- ===== the following templates are to generate the user fields declarations for MS word DocProperty field importing == -->
	<xsl:template name="user_fields_declare_docproperty">
		<xsl:variable name="document-field-root" select="/w:wordDocument/w:body//w:instrText[substring(normalize-space(text()),1,11) = 'DOCPROPERTY' ]  | /w:wordDocument/w:body//w:fldSimple[substring(normalize-space(@w:instr),1,11) = 'DOCPROPERTY' ] "/>
		<xsl:variable name="field_Author_nodeset" select="$document-field-root[contains(text(), 'Author')] | $document-field-root[contains(@w:instr, 'Author')]"/>
		<xsl:variable name="field_Bytes_nodeset" select="$document-field-root[contains(text(), 'Bytes')] | $document-field-root[contains(@w:instr, 'Bytes')]"/>
		<xsl:variable name="field_Category_nodeset" select="$document-field-root[contains(text(), 'Category')] | $document-field-root[contains(@w:instr, 'Category')]"/>
		<xsl:variable name="field_Characters_nodeset" select="$document-field-root[contains(text(), 'Characters')] | $document-field-root[contains(@w:instr, 'Characters')]"/>
		<xsl:variable name="field_CharactersWithSpaces_nodeset" select="$document-field-root[contains(text(), 'CharactersWithSpaces')] | $document-field-root[contains(@w:instr, 'CharactersWithSpaces')]"/>
		<xsl:variable name="field_Comments_nodeset" select="$document-field-root[contains(text(), 'Comments')] | $document-field-root[contains(@w:instr, 'Comments')]"/>
		<xsl:variable name="field_Company_nodeset" select="$document-field-root[contains(text(), 'Company')] | $document-field-root[contains(@w:instr, 'Company')]"/>
		<xsl:variable name="field_CreateTime_nodeset" select="$document-field-root[contains(text(), 'CreateTime')] | $document-field-root[contains(@w:instr, 'CreateTime')]"/>
		<xsl:variable name="field_HyperlinkBase_nodeset" select="$document-field-root[contains(text(), 'HyperlinkBase')] | $document-field-root[contains(@w:instr, 'HyperlinkBase')]"/>
		<xsl:variable name="field_Keywords_nodeset" select="$document-field-root[contains(text(), 'Keywords')] | $document-field-root[contains(@w:instr, 'Keywords')]"/>
		<xsl:variable name="field_LastPrinted_nodeset" select="$document-field-root[contains(text(), 'LastPrinted')] | $document-field-root[contains(@w:instr, 'LastPrinted')]"/>
		<xsl:variable name="field_LastSavedBy_nodeset" select="$document-field-root[contains(text(), 'LastSavedBy')] | $document-field-root[contains(@w:instr, 'LastSavedBy')]"/>
		<xsl:variable name="field_LastSavedTime_nodeset" select="$document-field-root[contains(text(), 'LastSavedTime')] | $document-field-root[contains(@w:instr, 'LastSavedTime')]"/>
		<xsl:variable name="field_Lines_nodeset" select="$document-field-root[contains(text(), 'Lines')] | $document-field-root[contains(@w:instr, 'Lines')]"/>
		<xsl:variable name="field_Manager_nodeset" select="$document-field-root[contains(text(), 'Manager')] | $document-field-root[contains(@w:instr, 'Manager')]"/>
		<xsl:variable name="field_NameofApplication_nodeset" select="$document-field-root[contains(text(), 'NameofApplication')] | $document-field-root[contains(@w:instr, 'NameofApplication')]"/>
		<xsl:variable name="field_ODMADocId_nodeset" select="$document-field-root[contains(text(), 'ODMADocId')] | $document-field-root[contains(@w:instr, 'ODMADocId')]"/>
		<xsl:variable name="field_Pages_nodeset" select="$document-field-root[contains(text(), 'Pages')] | $document-field-root[contains(@w:instr, 'Pages')]"/>
		<xsl:variable name="field_Paragraphs_nodeset" select="$document-field-root[contains(text(), 'Paragraphs')] | $document-field-root[contains(@w:instr, 'Paragraphs')]"/>
		<xsl:variable name="field_RevisionNumber_nodeset" select="$document-field-root[contains(text(), 'RevisionNumber')] | $document-field-root[contains(@w:instr, 'RevisionNumber')]"/>
		<xsl:variable name="field_Security_nodeset" select="$document-field-root[contains(text(), 'Security')] | $document-field-root[contains(@w:instr, 'Security')]"/>
		<xsl:variable name="field_Subject_nodeset" select="$document-field-root[contains(text(), 'Subject')] | $document-field-root[contains(@w:instr, 'Subject')]"/>
		<xsl:variable name="field_Template_nodeset" select="$document-field-root[contains(text(), 'Template')] | $document-field-root[contains(@w:instr, 'Template')]"/>
		<xsl:variable name="field_Title_nodeset" select="$document-field-root[contains(text(), 'Title')] | $document-field-root[contains(@w:instr, 'Title')]"/>
		<xsl:variable name="field_TotalEditingTime_nodeset" select="$document-field-root[contains(text(), 'TotalEditingTime')] | $document-field-root[contains(@w:instr, 'TotalEditingTime')]"/>
		<xsl:variable name="field_Words_nodeset" select="$document-field-root[contains(text(), 'Words')] | $document-field-root[contains(@w:instr, 'Words')]"/>
		<xsl:apply-templates select="$field_Author_nodeset[1]" mode="user_field_Author_declare"/>
		<xsl:apply-templates select="$field_Bytes_nodeset[1]" mode="user_field_Bytes_declare"/>
		<xsl:apply-templates select="$field_Category_nodeset[1]" mode="user_field_Category_declare"/>
		<xsl:apply-templates select="$field_Characters_nodeset[1]" mode="user_field_Characters_declare"/>
		<xsl:apply-templates select="$field_CharactersWithSpaces_nodeset[1]" mode="user_field_CharactersWithSpaces_declare"/>
		<xsl:apply-templates select="$field_Comments_nodeset[1]" mode="user_field_Comments_declare"/>
		<xsl:apply-templates select="$field_Company_nodeset[1]" mode="user_field_Company_declare"/>
		<xsl:apply-templates select="$field_CreateTime_nodeset[1]" mode="user_field_CreateTime_declare"/>
		<xsl:apply-templates select="$field_HyperlinkBase_nodeset[1]" mode="user_field_HyperlinkBase_declare"/>
		<xsl:apply-templates select="$field_Keywords_nodeset[1]" mode="user_field_Keywords_declare"/>
		<xsl:apply-templates select="$field_LastPrinted_nodeset[1]" mode="user_field_LastPrinted_declare"/>
		<xsl:apply-templates select="$field_LastSavedBy_nodeset[1]" mode="user_field_LastSavedBy_declare"/>
		<xsl:apply-templates select="$field_LastSavedTime_nodeset[1]" mode="user_field_LastSavedTime_declare"/>
		<xsl:apply-templates select="$field_Lines_nodeset[1]" mode="user_field_Lines_declare"/>
		<xsl:apply-templates select="$field_Manager_nodeset[1]" mode="user_field_Manager_declare"/>
		<xsl:apply-templates select="$field_NameofApplication_nodeset[1]" mode="user_field_NameofApplication_declare"/>
		<xsl:apply-templates select="$field_ODMADocId_nodeset[1]" mode="user_field_ODMADocId_declare"/>
		<xsl:apply-templates select="$field_Pages_nodeset[1]" mode="user_field_Pages_declare"/>
		<xsl:apply-templates select="$field_Paragraphs_nodeset[1]" mode="user_field_Paragraphs_declare"/>
		<xsl:apply-templates select="$field_RevisionNumber_nodeset[1]" mode="user_field_RevisionNumber_declare"/>
		<xsl:apply-templates select="$field_Security_nodeset[1]" mode="user_field_Security_declare"/>
		<xsl:apply-templates select="$field_Subject_nodeset[1]" mode="user_field_Subject_declare"/>
		<xsl:apply-templates select="$field_Template_nodeset[1]" mode="user_field_Template_declare"/>
		<xsl:apply-templates select="$field_Title_nodeset[1]" mode="user_field_Title_declare"/>
		<xsl:apply-templates select="$field_TotalEditingTime_nodeset[1]" mode="user_field_TotalEditingTime_declare"/>
		<xsl:apply-templates select="$field_Words_nodeset[1]" mode="user_field_Words_declare"/>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Author_declare">
		<text:user-field-decl text:value-type="string" text:name="Author">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Bytes_declare">
		<text:user-field-decl text:value-type="string" text:name="Bytes">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Category_declare">
		<text:user-field-decl text:value-type="string" text:name="Category">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Characters_declare">
		<text:user-field-decl text:value-type="string" text:name="Characters">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_CharactersWithSpaces_declare">
		<text:user-field-decl text:value-type="string" text:name="CharactersWithSpaces">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Comments_declare">
		<text:user-field-decl text:value-type="string" text:name="Comments">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Company_declare">
		<text:user-field-decl text:value-type="string" text:name="Company">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_CreateTime_declare">
		<text:user-field-decl text:value-type="string" text:name="CreateTime">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_HyperlinkBase_declare">
		<text:user-field-decl text:value-type="string" text:name="HyperlinkBase">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Keywords_declare">
		<text:user-field-decl text:value-type="string" text:name="Keywords">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_LastPrinted_declare">
		<text:user-field-decl text:value-type="string" text:name="LastPrinted">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_LastSavedBy_declare">
		<text:user-field-decl text:value-type="string" text:name="LastSavedBy">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_LastSavedTime_declare">
		<text:user-field-decl text:value-type="string" text:name="LastSavedTime">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Lines_declare">
		<text:user-field-decl text:value-type="string" text:name="Lines">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Manager_declare">
		<text:user-field-decl text:value-type="string" text:name="Manager">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_NameofApplication_declare">
		<text:user-field-decl text:value-type="string" text:name="NameofApplication">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_ODMADocId_declare">
		<text:user-field-decl text:value-type="string" text:name="ODMADocId">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Pages_declare">
		<text:user-field-decl text:value-type="string" text:name="Pages">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Paragraphs_declare">
		<text:user-field-decl text:value-type="string" text:name="Paragraphs">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_RevisionNumber_declare">
		<text:user-field-decl text:value-type="string" text:name="RevisionNumber">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Security_declare">
		<text:user-field-decl text:value-type="string" text:name="Security">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Subject_declare">
		<text:user-field-decl text:value-type="string" text:name="Subject">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Template_declare">
		<text:user-field-decl text:value-type="string" text:name="Template">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Title_declare">
		<text:user-field-decl text:value-type="string" text:name="Title">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_TotalEditingTime_declare">
		<text:user-field-decl text:value-type="string" text:name="TotalEditingTime">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="user_field_Words_declare">
		<text:user-field-decl text:value-type="string" text:name="Words">
			<xsl:variable name="field_content">
				<xsl:choose>
					<xsl:when test="name() = 'w:instrText' ">
						<xsl:call-template name="get-fldchar-content">
							<xsl:with-param name="next_node" select="../following-sibling::w:r[1]"/>
							<xsl:with-param name="sibling_number" select=" 1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="name() = 'w:fldSimple' ">
						<xsl:value-of select=".//w:t"/>
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="text:string-value"><xsl:value-of select="$field_content"/></xsl:attribute>
		</text:user-field-decl>
	</xsl:template>
	<!-- =========this following template to convert the ms number format to OOo wirter format === -->
	<xsl:template name="get_field_num_format">
		<xsl:param name="input_MS_num_format"/>
		<xsl:choose>
			<xsl:when test="contains($input_MS_num_format, 'Arabic' ) ">
				<xsl:text>1</xsl:text>
			</xsl:when>
			<xsl:when test="contains ($input_MS_num_format, 'CircleNum' )">
				<xsl:text>①, ②, ③, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'roman' ) ">
				<xsl:text>i</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'ROMAN' ) ">
				<xsl:text>I</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'CHINESENUM3' )">
				<xsl:text>一, 二, 三, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'CHINESENUM2' )">
				<xsl:text>壹, 	貳, 參, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'DBNUM3' ) ">
				<xsl:text>壱, 弐, 参, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format,  'ZODIAC2' ) ">
				<xsl:text>子, 丑, 寅, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'ZODIAC1' )  ">
				<xsl:text>甲, 乙, 丙, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'Iroha'  ) ">
				<xsl:text>イ, ロ, ハ, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'Aiueo' ) ">
				<xsl:text>ｱ, ｲ, ｳ, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'alphabetic' ) ">
				<xsl:text>a</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'ALPHABETIC' ) ">
				<xsl:text>A</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'hebrew2' ) ">
				<xsl:text>א, ב, ג, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format,  'ArabicAlpha' ) ">
				<xsl:text>أ, ب, ت, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'ThaiLetter' ) ">
				<xsl:text>ก, ข, ฃ, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'Chosung' ) ">
				<xsl:text>ㄱ, ㄴ, ㄷ, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'Ganada' ) ">
				<xsl:text>가, 나, 다, ...</xsl:text>
			</xsl:when>
			<xsl:when test="contains($input_MS_num_format, 'Aiueo' ) ">
				<xsl:text>ア, イ, ウ, ...</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>1</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ========= the following code is to generate the date styles for date/time fields ============ -->
	<!--the default date styel content -->
	<xsl:template name="default_date_style_content">
		<number:year number:style="long">
        </number:year>
		<number:text>/</number:text>
		<number:month>
        </number:month>
		<number:text>/</number:text>
		<number:day>
        </number:day>
		<number:text>  </number:text>
		<number:hours>
		</number:hours>
		<number:text>:</number:text>
		<number:minutes number:style="long">
			</number:minutes>
		<number:text>:</number:text>
		<number:seconds number:style="long">
			</number:seconds>
		<number:am-pm>
			</number:am-pm>
	</xsl:template>
	<!--the default date styel -->
	<xsl:template name="default_date_style">
		<number:date-style style:name="NDF1" style:family="data-style">
			<xsl:call-template name="default_date_style_content"/>
		</number:date-style>
	</xsl:template>
	<xsl:template match="w:instrText | w:fldSimple" mode="style">
		<!-- this template is to generate the date, time styles according to the content of DateFormatString ( the string after \@ ) in w:instrText | w:fldSimple/@w:instr -->
		<xsl:choose>
			<xsl:when test=" name() = 'w:instrText' ">
				<xsl:if test="substring(normalize-space(.),1,4) = 'DATE'  or substring(normalize-space(.),1,4) = 'TIME'  or  substring(normalize-space(.),1,9) = 'PRINTDATE'  or substring(normalize-space(.),1,10) =              'CREATEDATE'  or substring(normalize-space(.),1,8) = 'SAVEDATE' ">
					<number:date-style style:family="data-style">
						<xsl:attribute name="style:name">ND<xsl:number count="w:instrText | w:fldSimple" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="contains(text(), '\@' )">
								<!-- if has the date format string then call the template  parse_field_date_format to produce the style-->
								<xsl:variable name="MS_date_format">
									<xsl:value-of select="normalize-space(substring-before(substring-after(normalize-space(substring-after(text(), '\@')), '&#x22;'), '&#x22;'))"/>
								</xsl:variable>
								<xsl:if test="string-length($MS_date_format) &gt;=1">
									<xsl:call-template name="parse_field_date_format">
										<xsl:with-param name="input_MS_date_format" select="$MS_date_format"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:if test="string-length($MS_date_format) &lt;1">
									<xsl:call-template name="default_date_style_content"/>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<!-- if doesn't have date format string so we use the following default format -->
								<xsl:call-template name="default_date_style_content"/>
							</xsl:otherwise>
						</xsl:choose>
					</number:date-style>
				</xsl:if>
			</xsl:when>
			<xsl:when test="name() = 'w:fldSimple' ">
				<xsl:if test="substring(normalize-space(@w:instr),1,4) = 'DATE'  or substring(normalize-space(@w:instr),1,4) = 'TIME'  or  substring(normalize-space(@w:instr),1,9) = 'PRINTDATE'  or substring(normalize-space(@w:instr),1,10) = 'CREATEDATE'  or substring(normalize-space(@w:instr),1,8) = 'SAVEDATE' ">
					<!-- we use the default date/time style for w:fldsimple -->
					<number:date-style style:family="data-style">
						<xsl:attribute name="style:name">NDF1</xsl:attribute>
						<xsl:call-template name="default_date_style_content"/>
					</number:date-style>
				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="parse_field_date_format">
		<!--this template is to parse and generate the content of the date-time style base on the content of input_MS_date_format -->
		<xsl:param name="input_MS_date_format"/>
		<xsl:if test="string-length($input_MS_date_format) &gt;= 1">
			<xsl:variable name="date_token_start_position">
				<!-- to find the start position of the token ' d, M, yy, YY,m etc. -->
				<xsl:call-template name="find_token_startposition">
					<xsl:with-param name="input_string" select="$input_MS_date_format"/>
					<xsl:with-param name="token_start_position" select="1"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="date_token">
				<!-- get the matched the token such as MM, YYYY, yy,MMMM etc. -->
				<xsl:call-template name="get_date_token">
					<xsl:with-param name="input_string2" select="substring($input_MS_date_format,$date_token_start_position)"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="number($date_token_start_position) &gt; 1">
				<!-- print the text between the tokens -->
				<number:text>
					<xsl:value-of select="substring($input_MS_date_format,1, number($date_token_start_position - 1) )"/>
				</number:text>
			</xsl:if>
			<xsl:call-template name="map_date_format_pattern">
				<xsl:with-param name="input_date_format_pattern" select="$date_token"/>
			</xsl:call-template>
			<xsl:variable name="unparsed_string">
				<xsl:value-of select="substring($input_MS_date_format,$date_token_start_position + string-length($date_token))"/>
			</xsl:variable>
			<xsl:call-template name="parse_field_date_format">
				<xsl:with-param name="input_MS_date_format" select="$unparsed_string"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="find_token_startposition">
		<xsl:param name="input_string"/>
		<xsl:param name="token_start_position"/>
		<xsl:choose>
			<xsl:when test="starts-with( $input_string,'yy') or starts-with($input_string,'YY') or starts-with($input_string,'HH') or starts-with($input_string,'hh') or starts-with($input_string,'ss') or starts-with($input_string,'SS')">
				<xsl:value-of select="$token_start_position"/>
			</xsl:when>
			<xsl:when test="starts-with($input_string, 'M')  or starts-with($input_string,'d') or starts-with($input_string, 'm')  or starts-with($input_string,'D') or starts-with($input_string,'h') or starts-with($input_string,'H') or starts-with($input_string,'s') or starts-with($input_string,'S')">
				<xsl:value-of select="$token_start_position"/>
			</xsl:when>
			<xsl:when test="starts-with($input_string, 'am/pm') or starts-with($input_string, 'AM/PM') ">
				<xsl:value-of select="$token_start_position"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="new_string">
					<xsl:value-of select="substring($input_string, 2)"/>
				</xsl:variable>
				<xsl:call-template name="find_token_startposition">
					<xsl:with-param name="input_string" select="$new_string"/>
					<xsl:with-param name="token_start_position" select="$token_start_position +1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="get_date_token">
		<xsl:param name="input_string2"/>
		<xsl:choose>
			<xsl:when test="starts-with($input_string2, 'am/pm') or starts-with($input_string2, 'AM/PM') ">
				<xsl:value-of select=" 'am/pm' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'yyyy') or starts-with($input_string2, 'YYYY')">
				<xsl:value-of select=" 'yyyy' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'yy') or starts-with($input_string2, 'YY')">
				<xsl:value-of select=" 'yy' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'MMMM') ">
				<xsl:value-of select=" 'MMMM' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'MMM')">
				<xsl:value-of select=" 'MMM' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'MM')">
				<xsl:value-of select=" 'MM' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'M') ">
				<xsl:value-of select=" 'M' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'dddd') or starts-with($input_string2, 'DDDD')">
				<xsl:value-of select=" 'dddd' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'ddd') or starts-with($input_string2, 'DDD')">
				<xsl:value-of select=" 'ddd' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'dd') or starts-with($input_string2, 'dd')">
				<xsl:value-of select=" 'dd' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'd') or starts-with($input_string2, 'D')">
				<xsl:value-of select=" 'd' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'mm')">
				<xsl:value-of select=" 'mm' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'm')">
				<xsl:value-of select=" 'm' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'hh') or starts-with($input_string2, 'HH')">
				<xsl:value-of select=" 'hh' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'h') or starts-with($input_string2, 'H')">
				<xsl:value-of select=" 'h' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 'ss') or starts-with($input_string2, 'SS')">
				<xsl:value-of select=" 'ss' "/>
			</xsl:when>
			<xsl:when test="starts-with($input_string2, 's') or starts-with($input_string2, 'S')">
				<xsl:value-of select=" 's' "/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="map_date_format_pattern">
		<!-- this template map the MS date time format to OOo date time format -->
		<xsl:param name="input_date_format_pattern"/>
		<xsl:choose>
			<xsl:when test="$input_date_format_pattern = 'am/pm' ">
				<number:am-pm>
			</number:am-pm>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'yyyy' ">
				<number:year number:style="long">
			</number:year>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'yy' ">
				<number:year>
			</number:year>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'MMMM' ">
				<number:month number:style="long" number:textual="true">
			</number:month>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'MMM'  ">
				<number:month number:textual="true">
			</number:month>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'MM' ">
				<number:month number:style="long">
			</number:month>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'M' ">
				<number:month>
			</number:month>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'dddd' ">
				<number:day-of-week number:style="long">
			</number:day-of-week>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'ddd' ">
				<number:day-of-week>
			</number:day-of-week>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'dd' ">
				<number:day number:style="long">
			</number:day>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'd' ">
				<number:day>
			</number:day>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'mm' ">
				<number:minutes number:style="long">
			</number:minutes>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'm' ">
				<number:minutes>
			</number:minutes>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'hh' ">
				<number:hours number:style="long">
        </number:hours>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'h' ">
				<number:hours>
			</number:hours>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 'ss' ">
				<number:seconds number:style="long">
        </number:seconds>
			</xsl:when>
			<xsl:when test="$input_date_format_pattern = 's' ">
				<number:seconds>
        </number:seconds>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- end wordml2ooo_field.xsl ======================= -->
	<!-- start wordml2ooo_list.xsl ======================= -->
	<xsl:template match="w:listPr" mode="style">
		<xsl:variable name="currlistid" select="w:ilfo/@w:val"/>
		<xsl:variable name="currlist" select="."/>
		<xsl:variable name="rootlistid" select="/w:wordDocument/w:lists/w:list[@w:ilfo=$currlistid]/w:ilst/@w:val"/>
		<xsl:variable name="rootlist" select="/w:wordDocument/w:lists/w:listDef[@w:listDefId =$rootlistid ]"/>
		<xsl:if test="not(ancestor::w:p/preceding-sibling::w:p/w:pPr/w:listPr[1]/w:ilfo/@w:val= $currlistid) and $rootlist/w:lvl ">
			<xsl:element name="text:list-style">
				<xsl:attribute name="style:name">List<xsl:value-of select="count(preceding::w:listPr)"/></xsl:attribute>
				<xsl:apply-templates select="$rootlist/w:lvl"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:lvl">
		<xsl:variable name="listtype">
			<xsl:choose>
				<xsl:when test="w:nfc/@w:val">
					<xsl:value-of select="w:nfc/@w:val"/>
				</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$listtype =23 and w:lvlPicBulletId">
				<!-- image characters. wym -->
				<xsl:element name="text:list-level-style-image">
					<xsl:call-template name="list-styles-image"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$listtype =23">
				<!-- nfcBullet: Bullet character. glu -->
				<xsl:element name="text:list-level-style-bullet">
					<xsl:call-template name="list-styles-common">
						<xsl:with-param name="listtype" select="$listtype"/>
						<xsl:with-param name="currlevel" select="number(@w:ilvl)+1"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<!-- all kinds of numbering characters. glu :( -->
				<xsl:element name="text:list-level-style-number">
					<xsl:call-template name="list-styles-common">
						<xsl:with-param name="listtype" select="$listtype"/>
						<xsl:with-param name="currlevel" select="number(@w:ilvl)+1"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="list-styles-common">
		<xsl:param name="listtype"/>
		<xsl:param name="currlevel"/>
		<xsl:variable name="startval" select="w:start/@w:val"/>
		<xsl:attribute name="text:level"><xsl:value-of select="$currlevel"/></xsl:attribute>
		<xsl:choose>
			<xsl:when test="$listtype = 23">
				<!-- bullet character. glu -->
				<xsl:attribute name="text:style-name">Bullet Symbols</xsl:attribute>
				<xsl:attribute name="text:bullet-char"><xsl:value-of select="w:lvlText/@w:val"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="($listtype &gt;= 0) and ($listtype &lt; 60)">
				<xsl:attribute name="text:style-name">Numbering Symbols</xsl:attribute>
				<xsl:if test="$startval">
					<xsl:attribute name="text:start-value"><xsl:value-of select="$startval"/></xsl:attribute>
				</xsl:if>
				<xsl:attribute name="text:display-levels"><xsl:value-of select="string-length(w:lvlText/@w:val) - string-length(translate(w:lvlText/@w:val,'%','') )"/></xsl:attribute>
				<xsl:call-template name="nfc2numformat">
					<xsl:with-param name="nfcvalue" select="$listtype"/>
					<xsl:with-param name="prefix" select="substring-before(w:lvlText/@w:val, '%')"/>
					<xsl:with-param name="suffix" select="substring-after(w:lvlText/@w:val, concat('%', $currlevel) )"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="text:style-name">Numbering Symbols</xsl:attribute>
				<xsl:if test="$startval">
					<xsl:attribute name="text:start-value"><xsl:value-of select="$startval"/></xsl:attribute>
				</xsl:if>
				<xsl:attribute name="text:display-levels"><xsl:value-of select="string-length(w:lvlText/@w:val) - string-length(translate(w:lvlText/@w:val,'%','') )"/></xsl:attribute>
				<!-- 'none' in Word 2003. wym -->
				<xsl:attribute name="style:num-format"/>
				<xsl:attribute name="style:num-prefix"><xsl:value-of select="substring-before(w:lvlText/@w:val, '%')"/></xsl:attribute>
				<xsl:attribute name="style:num-suffix"><xsl:value-of select="substring-after(w:lvlText/@w:val, concat('%', $currlevel + 1) )"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:element name="style:properties">
			<xsl:choose>
				<xsl:when test="w:lvlJc/@w:val='right'">
					<xsl:attribute name="fo:text-align">end</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:lvlJc/@w:val='center'">
					<xsl:attribute name="fo:text-align">center</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="fo:text-align">start</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:variable name="labelwidth">
				<xsl:choose>
					<xsl:when test="w:pPr/w:ind/@w:hanging">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="concat(w:pPr/w:ind/@w:hanging,'dxa')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="w:pPr/w:ind/@w:first-line">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="concat('-',w:pPr/w:ind/@w:first-line,'dxa')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="leftwidth">
				<xsl:call-template name="convert2cm">
					<xsl:with-param name="value" select="concat(w:pPr/w:ind/@w:left,'dxa')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:attribute name="text:space-before"><xsl:value-of select="concat(number($leftwidth)-number($labelwidth),'cm')"/></xsl:attribute>
			<xsl:attribute name="text:min-label-width"><xsl:choose><xsl:when test="$labelwidth &gt; 0"><xsl:value-of select="concat($labelwidth,'cm')"/></xsl:when><xsl:otherwise>0cm</xsl:otherwise></xsl:choose></xsl:attribute>
			<!-- In binary word translation, text:min-label-distance do not generate. So, the width of number-symbol will not effect the start position of text. But first line always start same position of second line, no indent. If text:min-label-distance generate, the look of list will change because of uncountable number-symbol's width, now use 0.25cm as default width-->
			<xsl:choose>
				<xsl:when test="w:suff/@w:val='Space'">
					<xsl:attribute name="text:min-label-distance">0.20cm</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:pPr/w:tabs/w:tab/@w:pos">
					<xsl:variable name="tabpos">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="concat(w:pPr/w:tabs/w:tab/@w:pos,'dxa')"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="number($tabpos) &gt; (number($leftwidth)-number($labelwidth))">
						<xsl:attribute name="text:min-label-distance"><xsl:value-of select="concat(number($tabpos)+number($labelwidth)-number($leftwidth)-0.25,'cm')"/></xsl:attribute>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
			<!-- Find the node that corresponds to the level being processed. We can use this to determine the indentation to be used
            <xsl:variable name="currNode" select="/w:wordDocument/w:body//w:listPr[w:ilvl/@w:val = $currlevel][w:ilfo/@w:val = $currlist/w:ilfo/@w:val]"/>
            <xsl:choose>
                <xsl:when test="($currNode/wx:t/@wx:wTabBefore ) and ($currNode/wx:t/@wx:wTabAfter ) and (not($currNode/following-sibling::w:jc) or $currNode/following-sibling::w:jc/@w:val = 'left')">
                    <xsl:attribute name="text:space-before"><xsl:value-of select="(number($currNode/wx:t/@wx:wTabBefore)div 1440) * 2.54"/>cm</xsl:attribute>
                    <xsl:attribute name="text:min-label-distance"><xsl:value-of select="(number($currNode/wx:t/@wx:wTabAfter)div 1440) * 2.54"/>cm</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="text:space-before"><xsl:value-of select="((number(w:pPr/w:ind/@w:left)  div 1440) * 2.54) "/>cm</xsl:attribute>
                    <xsl:attribute name="text:min-label-distance"><xsl:value-of select="(number($currlist/wx:t/@wx:wTabAfter) div 1440) * 2.54"/>cm</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>-->
			<xsl:if test="w:rPr/w:rFonts">
				<xsl:if test="w:rPr/w:rFonts/@w:ascii">
					<xsl:attribute name="style:font-name"><xsl:value-of select="w:rPr/w:rFonts/@w:ascii"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="w:rPr/w:rFonts/@w:fareast">
					<xsl:attribute name="style:font-name-asian"><xsl:value-of select="w:rPr/w:rFonts/@w:fareast"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="w:rPr/w:rFonts/@w:cs">
					<xsl:attribute name="style:font-name-complex"><xsl:value-of select="w:rPr/w:rFonts/@w:cs"/></xsl:attribute>
				</xsl:if>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template name="list-styles-image">
		<xsl:variable name="currlevel" select="number(@w:ilvl)"/>
		<xsl:attribute name="text:level"><xsl:value-of select="$currlevel+1"/></xsl:attribute>
		<xsl:variable name="picid" select="w:lvlPicBulletId/@w:val"/>
		<xsl:element name="style:properties">
			<xsl:attribute name="style:vertical-pos">middle</xsl:attribute>
			<xsl:attribute name="style:vertical-rel">line</xsl:attribute>
			<xsl:variable name="picsize" select="/descendant::w:lists/w:listPicBullet[@w:listPicBulletId=$picid]/w:pict/v:shape/@style"/>
			<xsl:attribute name="fo:width"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="substring-before(substring-after($picsize,'width:'), ';')"/></xsl:call-template><xsl:text>cm</xsl:text></xsl:attribute>
			<xsl:attribute name="fo:height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="substring-after($picsize,'height:')"/></xsl:call-template><xsl:text>cm</xsl:text></xsl:attribute>
			<xsl:variable name="labelwidth">
				<xsl:choose>
					<xsl:when test="w:pPr/w:ind/@w:hanging">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="concat(w:pPr/w:ind/@w:hanging,'dxa')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="w:pPr/w:ind/@w:first-line">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="concat('-',w:pPr/w:ind/@w:first-line,'dxa')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="leftwidth">
				<xsl:call-template name="convert2cm">
					<xsl:with-param name="value" select="concat(w:pPr/w:ind/@w:left,'dxa')"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:attribute name="text:space-before"><xsl:value-of select="concat(number($leftwidth)-number($labelwidth),'cm')"/></xsl:attribute>
			<xsl:attribute name="text:min-label-width"><xsl:choose><xsl:when test="$labelwidth &gt; 0"><xsl:value-of select="concat($labelwidth,'cm')"/></xsl:when><xsl:otherwise>0cm</xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:choose>
				<xsl:when test="w:suff/@w:val='Space'">
					<xsl:attribute name="text:min-label-distance">0.20cm</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:pPr/w:tabs/w:tab/@w:pos">
					<xsl:variable name="tabpos">
						<xsl:call-template name="convert2cm">
							<xsl:with-param name="value" select="concat(w:pPr/w:tabs/w:tab/@w:pos,'dxa')"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="number($tabpos) &gt; (number($leftwidth)-number($labelwidth))">
						<xsl:attribute name="text:min-label-distance"><xsl:value-of select="concat(number($tabpos)+number($labelwidth)-number($leftwidth),'cm')"/></xsl:attribute>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:element>
		<office:binary-data>
			<xsl:value-of select="/descendant::w:lists/w:listPicBullet[@w:listPicBulletId=$picid]/w:pict/w:binData"/>
		</office:binary-data>
	</xsl:template>
	<!-- avoid listPr in textbox. :( glu -->
	<xsl:template match="w:p[w:pPr/w:listPr[w:ilvl and w:ilfo]]">
		<xsl:call-template name="genlist"/>
	</xsl:template>
	<xsl:template name="genlist">
		<xsl:variable name="currlistid" select="w:pPr/w:listPr/w:ilfo/@w:val"/>
		<xsl:variable name="currlistlvl" select="w:pPr/w:listPr/w:ilvl/@w:val"/>
		<xsl:variable name="firstoccur" select="/descendant::w:pPr[w:listPr/w:ilfo/@w:val = $currlistid][1]"/>
		<xsl:variable name="rootlistid" select="/w:wordDocument/w:lists/w:list[@w:ilfo=$currlistid]/w:ilst/@w:val"/>
		<xsl:variable name="rootlistname" select="/w:wordDocument/w:lists/w:listDef[@w:listDefId =$rootlistid ]/w:listStyleLink/@w:val"/>
		<xsl:element name="text:ordered-list">
			<xsl:attribute name="text:style-name"><xsl:choose><xsl:when test="string-length($rootlistname) &gt; 0"><xsl:value-of select="$rootlistname"/></xsl:when><xsl:otherwise>List<xsl:value-of select="count($firstoccur/preceding::w:listPr)"/></xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:choose>
				<xsl:when test="preceding::w:pPr/w:listPr/w:ilfo/@w:val = w:pPr/w:listPr/w:ilfo/@w:val">
					<xsl:attribute name="text:continue-numbering">true</xsl:attribute>
					<xsl:element name="text:list-item">
						<xsl:call-template name="levels">
							<xsl:with-param name="level" select="$currlistlvl"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="text:list-item">
						<xsl:call-template name="levels">
							<xsl:with-param name="level" select="$currlistlvl"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template name="levels">
		<xsl:param name="level"/>
		<xsl:choose>
			<xsl:when test="$level = '0'">
				<xsl:call-template name="process-common-paragraph"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="text:ordered-list">
					<xsl:element name="text:list-item">
						<xsl:call-template name="levels">
							<xsl:with-param name="level" select="$level -1"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:style" mode="list">
		<xsl:variable name="listname" select="@w:styleId"/>
		<xsl:if test="/w:wordDocument/w:lists/w:listDef[w:styleLink/@w:val=$listname]">
			<text:list-style style:name="{$listname}">
				<xsl:apply-templates select="/w:wordDocument/w:lists/w:listDef[w:styleLink/@w:val=$listname]/w:lvl"/>
			</text:list-style>
		</xsl:if>
	</xsl:template>
	<!-- for create outline style in office:styles -->
	<xsl:template name="create-outline-style">
		<xsl:element name="text:outline-style">
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="1"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="2"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="3"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="4"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="5"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="6"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="7"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="8"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="9"/>
			</xsl:call-template>
			<xsl:call-template name="outline-level-style">
				<xsl:with-param name="level" select="10"/>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
	<xsl:template name="outline-level-style">
		<xsl:param name="level"/>
		<xsl:element name="text:outline-level-style">
			<xsl:choose>
				<xsl:when test="w:style[@w:type = 'paragraph' and (w:pPr/w:outlineLvl/@w:val = $level -1) and w:pPr/w:listPr]">
					<xsl:apply-templates select="(w:style[@w:type = 'paragraph' and w:pPr/w:outlineLvl/@w:val = $level -1 and w:pPr/w:listPr ]/w:pPr/w:listPr)[position()=1]" mode="outline">
						<xsl:with-param name="outlinelevel" select="$level"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="text:level"><xsl:value-of select="$level"/></xsl:attribute>
					<xsl:attribute name="style:num-format"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:listPr" mode="outline">
		<xsl:param name="outlinelevel"/>
		<xsl:variable name="currlistid" select="w:ilfo/@w:val"/>
		<xsl:variable name="currlistlevel">
			<xsl:choose>
				<xsl:when test="w:ilvl">
					<xsl:value-of select="w:ilvl/@w:val"/>
				</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="rootlistid" select="/w:wordDocument/w:lists/w:list[@w:ilfo=$currlistid]/w:ilst/@w:val"/>
		<xsl:variable name="rootlist" select="/w:wordDocument/w:lists/w:listDef[@w:listDefId =$rootlistid ]"/>
		<xsl:for-each select="$rootlist/w:lvl[@w:ilvl=$currlistlevel]">
			<xsl:call-template name="list-styles-common">
				<xsl:with-param name="listtype">
					<xsl:choose>
						<xsl:when test="w:nfc/@w:val">
							<xsl:value-of select="w:nfc/@w:val"/>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="currlevel" select="$outlinelevel"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="nfc2numformat">
		<xsl:param name="nfcvalue"/>
		<xsl:param name="prefix"/>
		<xsl:param name="suffix"/>
		<xsl:choose>
			<xsl:when test="$nfcvalue=0">
				<xsl:attribute name="style:num-format">1</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=1">
				<xsl:attribute name="style:num-format">I</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=2">
				<xsl:attribute name="style:num-format">i</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=3">
				<xsl:attribute name="style:num-format">A</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=4">
				<xsl:attribute name="style:num-format">a</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=10 or $nfcvalue=11 or $nfcvalue=17 or $nfcvalue=29 or $nfcvalue=33 or $nfcvalue=35 or $nfcvalue=36 or $nfcvalue=37 or $nfcvalue=39 or $nfcvalue=44">
				<xsl:attribute name="style:num-format">一, 二, 三, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=12">
				<xsl:attribute name="style:num-format">ア, イ, ウ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=13">
				<xsl:attribute name="style:num-format">イ, ロ, ハ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=14 or $nfcvalue=19">
				<xsl:attribute name="style:num-format">１, ２, ３, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=16">
				<xsl:attribute name="style:num-format">壱, 弐, 参, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=18 or $nfcvalue=28">
				<xsl:attribute name="style:num-format">①, ②, ③, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=20">
				<xsl:attribute name="style:num-format">ｱ, ｲ, ｳ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=21">
				<xsl:attribute name="style:num-format">ｲ, ﾛ, ﾊ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=24">
				<xsl:attribute name="style:num-format">가, 나, 다, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=25">
				<xsl:attribute name="style:num-format">ㄱ, ㄴ, ㄷ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=30">
				<xsl:attribute name="style:num-format">甲, 乙, 丙, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=31">
				<xsl:attribute name="style:num-format">子, 丑, 寅, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=34">
				<xsl:attribute name="style:num-format">壹, 貳, 參, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=38">
				<xsl:attribute name="style:num-format">壹, 贰, 叁, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=41 or $nfcvalue=42 or $nfcvalue=43">
				<xsl:attribute name="style:num-format">일, 이, 삼, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=45 or $nfcvalue=47">
				<xsl:attribute name="style:num-format">א, ב, ג, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=46 or $nfcvalue=48">
				<xsl:attribute name="style:num-format">أ, ب, ت, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=53">
				<xsl:attribute name="style:num-format">ก, ข, ฃ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue!=57 and $nfcvalue &gt; 48 and $nfcvalue &lt; 60">
				<xsl:attribute name="style:num-format">Native Numbering</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="style:num-format">1</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$nfcvalue=26">
				<xsl:attribute name="style:num-prefix"><xsl:value-of select="$prefix"/></xsl:attribute>
				<xsl:attribute name="style:num-suffix"><xsl:value-of select="concat( '.' , $suffix )"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=27 or $nfcvalue=29">
				<xsl:attribute name="style:num-prefix"><xsl:value-of select="concat( $prefix, '(' )"/></xsl:attribute>
				<xsl:attribute name="style:num-suffix"><xsl:value-of select="concat( ')' , $suffix )"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$nfcvalue=57">
				<xsl:attribute name="style:num-prefix"><xsl:value-of select="concat( $prefix, '- ' )"/></xsl:attribute>
				<xsl:attribute name="style:num-suffix"><xsl:value-of select="concat( ' -' , $suffix )"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="style:num-prefix"><xsl:value-of select="$prefix"/></xsl:attribute>
				<xsl:attribute name="style:num-suffix"><xsl:value-of select="$suffix"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- end wordml2ooo_list.xsl ======================= -->
	<!--start wordml2ooo_page.xsl    ==================== -->
	<xsl:template match="w:footnotePr" mode="config">
		<text:footnotes-configuration>
			<xsl:if test="w:pos">
				<xsl:choose>
					<xsl:when test="w:pos/@w:val = 'beneath-text'">
						<xsl:attribute name="text:footnotes-position">document</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="text:footnotes-position">page</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="w:numStart">
				<xsl:attribute name="text:start-value"><xsl:value-of select="w:numStart/@w:val - 1"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="w:numFmt">
				<xsl:call-template name="convert-number-format">
					<xsl:with-param name="number-format" select="w:numFmt/@w:val"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="w:numRestart">
				<xsl:choose>
					<xsl:when test="w:numRestart/@w:val = 'continuous'">
						<xsl:attribute name="text:start-numbering-at">document</xsl:attribute>
					</xsl:when>
					<xsl:when test="w:numRestart/@w:val = 'each-sect'">
						<xsl:attribute name="text:start-numbering-at">chapter</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="text:start-numbering-at">page</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="w:footnote[@w:type = 'continuation-separator']">
				<text:footnote-continuation-notice-backward>
					<xsl:value-of select="normalize-space(w:footnote[@w:type = 'continuation-separator'])"/>
				</text:footnote-continuation-notice-backward>
			</xsl:if>
			<xsl:if test="w:footnote[@w:type = 'continuation-notice']">
				<text:footnote-continuation-notice-forward>
					<xsl:value-of select="normalize-space(w:footnote[@w:type = 'continuation-notice'])"/>
				</text:footnote-continuation-notice-forward>
			</xsl:if>
		</text:footnotes-configuration>
	</xsl:template>
	<xsl:template match="w:endnotePr" mode="config">
		<text:endnotes-configuration>
			<xsl:if test="w:numStart">
				<xsl:attribute name="text:start-value"><xsl:value-of select="w:numStart/@w:val - 1"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="w:numFmt">
				<xsl:call-template name="convert-number-format">
					<xsl:with-param name="number-format" select="w:numFmt/@w:val"/>
				</xsl:call-template>
			</xsl:if>
		</text:endnotes-configuration>
	</xsl:template>
	<xsl:template name="convert-number-format">
		<xsl:param name="number-format"/>
		<xsl:choose>
			<xsl:when test="$number-format = 'decimal' or $number-format = 'decimal-half-width'">
				<xsl:attribute name="style:num-format">1</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'decimal-zero'">
				<xsl:attribute name="style:num-format">1</xsl:attribute>
				<xsl:attribute name="style:num-prefix">0</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'decimal-enclosed-fullstop'">
				<xsl:attribute name="style:num-format">1</xsl:attribute>
				<xsl:attribute name="style:num-prefix">.</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'decimal-enclosed-paren'">
				<xsl:attribute name="style:num-format">1</xsl:attribute>
				<xsl:attribute name="style:num-prefix">(</xsl:attribute>
				<xsl:attribute name="style:num-suffix">)</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'number-in-dash'">
				<xsl:attribute name="style:num-format">1</xsl:attribute>
				<xsl:attribute name="style:num-prefix">-</xsl:attribute>
				<xsl:attribute name="style:num-suffix">-</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'upper-letter'">
				<xsl:attribute name="style:num-format">A</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'lower-letter'">
				<xsl:attribute name="style:num-format">a</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'upper-roman'">
				<xsl:attribute name="style:num-format">I</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'lower-roman'">
				<xsl:attribute name="style:num-format">i</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'decimal-full-width' or $number-format = 'decimal-full-width2'">
				<xsl:attribute name="style:num-format">１, ２, ３, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'decimal-enclosed-circle-chinese' or $number-format = 'decimal-enclosed-circle'">
				<xsl:attribute name="style:num-format">①, ②, ③, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'ideograph-enclosed-circle'">
				<xsl:attribute name="style:num-format">一, 二, 三, ...</xsl:attribute>
				<xsl:attribute name="style:num-prefix">(</xsl:attribute>
				<xsl:attribute name="style:num-suffix">)</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'chinese-counting-thousand' or $number-format = 'ideograph-digital' or $number-format = 'japanese-counting' or $number-format = 'japanese-digital-ten-thousand' or $number-format = 'taiwanese-counting-thousand' or $number-format = 'taiwanese-counting' or $number-format = 'taiwanese-digital' or $number-format = 'chinese-counting' or $number-format = 'korean-digital2' or $number-format = 'chinese-not-impl'">
				<xsl:attribute name="style:num-format">一, 二, 三, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'chinese-legal-simplified'">
				<xsl:attribute name="style:num-format">壹, 贰, 叁, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'ideograph-legal-traditional'">
				<xsl:attribute name="style:num-format">壹, 貳, 參, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'ideograph-traditional'">
				<xsl:attribute name="style:num-format">甲, 乙, 丙, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'ideograph-zodiac'">
				<xsl:attribute name="style:num-format">子, 丑, 寅, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'japanese-legal'">
				<xsl:attribute name="style:num-format">壱, 弐, 参, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'aiueo-full-width'">
				<xsl:attribute name="style:num-format">ア, イ, ウ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'aiueo'">
				<xsl:attribute name="style:num-format">ｱ, ｲ, ｳ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'iroha-full-width'">
				<xsl:attribute name="style:num-format">イ, ロ, ハ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'iroha'">
				<xsl:attribute name="style:num-format">ｲ, ﾛ, ﾊ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'korean-digital' or $number-format = 'korean-counting' or $number-format = 'korean-legal'">
				<xsl:attribute name="style:num-format">일, 이, 삼, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'chosung'">
				<xsl:attribute name="style:num-format">ㄱ, ㄴ, ㄷ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'ganada'">
				<xsl:attribute name="style:num-format">가, 나, 다, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'arabic-alpha' or $number-format = 'arabic-abjad'">
				<xsl:attribute name="style:num-format">أ, ب, ت, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'thai-letters' or $number-format = 'thai-numbers' or $number-format = 'thai-counting'">
				<xsl:attribute name="style:num-format">ก, ข, ฃ, ...</xsl:attribute>
			</xsl:when>
			<xsl:when test="$number-format = 'hebrew-1' or $number-format = 'hebrew-2'">
				<xsl:attribute name="style:num-format">א, ב, ג, ...</xsl:attribute>
			</xsl:when>
			<!-- ordinal, cardinal-text, ordinal-text, hex, chicago, bullet, ideograph-zodiac-traditional,
            vietnamese-counting, russian-lower, russian-upper, hindi-vowels, hindi-consonants, hindi-numbers, hindi-counting -->
			<xsl:otherwise>
				<xsl:attribute name="style:num-format">Native Numbering</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:sectPr" mode="page-master">
		<style:page-master>
			<xsl:attribute name="style:name">pm<xsl:number from="/w:wordDocument/w:body" level="any" count="w:sectPr"/></xsl:attribute>
			<style:properties>
				<xsl:attribute name="fo:page-width"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgSz/@w:w,'dxa')"/></xsl:call-template>cm</xsl:attribute>
				<xsl:attribute name="fo:page-height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgSz/@w:h,'dxa')"/></xsl:call-template>cm</xsl:attribute>
				<xsl:choose>
					<xsl:when test="/w:wordDocument/w:docPr/w:gutterAtTop">
						<xsl:attribute name="fo:margin-top"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:top + w:pgMar/@w:gutter,'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-left"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:left,'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-right"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:right,'dxa')"/></xsl:call-template>cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="w:rtlGutter">
						<xsl:attribute name="fo:margin-top"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:top,'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-left"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:left,'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-right"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:right + w:pgMar/@w:gutter,'dxa')"/></xsl:call-template>cm</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="fo:margin-top"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:top,'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-left"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:left + w:pgMar/@w:gutter,'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:attribute name="fo:margin-right"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:right,'dxa')"/></xsl:call-template>cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="fo:margin-bottom"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:bottom,'dxa')"/></xsl:call-template>cm</xsl:attribute>
				<xsl:attribute name="style:footnote-max-height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:footer,'dxa')"/></xsl:call-template>cm</xsl:attribute>
				<xsl:if test="w:pgSz/@w:orient">
					<xsl:attribute name="style:print-orientation"><xsl:value-of select="w:pgSz/@w:orient"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="w:cols/@w:num">
					<!-- create sction property-->
					<style:columns>
						<xsl:attribute name="fo:column-count"><xsl:value-of select="w:cols/@w:num"/></xsl:attribute>
						<xsl:attribute name="fo:column-gap"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:cols/@w:space,'dxa')"/></xsl:call-template>cm</xsl:attribute>
					</style:columns>
				</xsl:if>
			</style:properties>
		</style:page-master>
	</xsl:template>
	<xsl:template match="w:sectPr" mode="master-page">
		<!-- style:page-master style:style-->
		<style:master-page>
			<xsl:variable name="master-page-name">
				<xsl:number count="w:sectPr" from="/w:wordDocument/w:body" level="any"/>
			</xsl:variable>
			<xsl:attribute name="style:name">Standard<xsl:value-of select="$master-page-name"/></xsl:attribute>
			<xsl:attribute name="style:page-master-name"><xsl:value-of select="concat('pm', $master-page-name)"/></xsl:attribute>
			<!-- Headers and footers-->
			<style:header-style>
				<style:properties>
					<xsl:attribute name="fo:min-height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:header,'dxa')"/></xsl:call-template>cm</xsl:attribute>
					<xsl:attribute name="fo:margin-bottom">0.792cm</xsl:attribute>
					<xsl:attribute name="style:dynamic-spacing">true</xsl:attribute>
				</style:properties>
			</style:header-style>
			<style:footer-style>
				<style:properties>
					<xsl:attribute name="fo:min-height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pgMar/@w:footer,'dxa')"/></xsl:call-template>cm</xsl:attribute>
					<xsl:attribute name="fo:margin-top">0.792cm</xsl:attribute>
					<xsl:attribute name="style:dynamic-spacing">true</xsl:attribute>
				</style:properties>
			</style:footer-style>
			<xsl:if test="not(w:titlePg)">
				<xsl:apply-templates select="w:hdr[@w:type='odd']"/>
				<xsl:apply-templates select="w:hdr[@w:type='even']"/>
				<xsl:apply-templates select="w:ftr[@w:type='odd']"/>
				<xsl:apply-templates select="w:ftr[@w:type='even']"/>
			</xsl:if>
		</style:master-page>
	</xsl:template>
	<xsl:template match="w:hdr">
		<xsl:choose>
			<xsl:when test="@w:type = 'odd'">
				<style:header>
					<xsl:apply-templates select="wx:pBdrGroup | w:p | w:tbl"/>
				</style:header>
			</xsl:when>
			<xsl:when test="@w:type = 'even'">
				<style:header-left>
					<xsl:apply-templates select="wx:pBdrGroup | w:p | w:tbl"/>
				</style:header-left>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:ftr">
		<xsl:choose>
			<xsl:when test="@w:type = 'odd'">
				<style:footer>
					<xsl:apply-templates select="wx:pBdrGroup | w:p | w:tbl"/>
				</style:footer>
			</xsl:when>
			<xsl:when test="@w:type = 'even'">
				<style:footer-left>
					<xsl:apply-templates select="wx:pBdrGroup | w:p | w:tbl"/>
				</style:footer-left>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="wx:pBdrGroup">
		<xsl:apply-templates select="w:p | w:tbl"/>
	</xsl:template>
	<!--end wordml2ooo_page.xsl    ==================== -->
	<!-- start wordml2ooo_settings.xsl =================== -->
	<xsl:template match="w:docPr">
		<office:settings>
			<config:config-item-set config:name="view-settings">
				<config:config-item config:name="InBrowseMode" config:type="boolean">
					<xsl:choose>
						<xsl:when test="w:view/@w:val = 'outline'">true</xsl:when>
						<xsl:when test="w:view/@w:val = 'print'">false</xsl:when>
						<!-- others: web, reading, normal, master-pages, none. glu -->
						<xsl:otherwise>true</xsl:otherwise>
					</xsl:choose>
				</config:config-item>
				<config:config-item-map-indexed config:name="Views">
					<config:config-item-map-entry>
						<xsl:if test="w:zoom">
							<!-- VisibleRight and VisibleBottom are arbitrary positive numbers. ;) glu -->
							<config:config-item config:name="VisibleRight" config:type="int">1</config:config-item>
							<config:config-item config:name="VisibleBottom" config:type="int">1</config:config-item>
							<xsl:choose>
								<xsl:when test="w:zoom/@w:val = 'best-fit'">
									<config:config-item config:name="ZoomType" config:type="short">3</config:config-item>
								</xsl:when>
								<xsl:when test="w:zoom/@w:val = 'full-page'">
									<config:config-item config:name="ZoomType" config:type="short">2</config:config-item>
								</xsl:when>
								<xsl:when test="w:zoom/@w:val = 'text-fit'">
									<config:config-item config:name="ZoomType" config:type="short">1</config:config-item>
								</xsl:when>
								<xsl:otherwise>
									<config:config-item config:name="ZoomType" config:type="short">0</config:config-item>
								</xsl:otherwise>
							</xsl:choose>
							<config:config-item config:name="ZoomFactor" config:type="short">
								<xsl:value-of select="w:zoom/@w:percent"/>
							</config:config-item>
						</xsl:if>
					</config:config-item-map-entry>
				</config:config-item-map-indexed>
			</config:config-item-set>
		</office:settings>
	</xsl:template>
	<!-- end wordml2ooo_settings.xsl =================== -->
	<!--start wordml2ooo_table.xsl ===================== -->
	<xsl:template match="w:tblPr" mode="style">
		<xsl:element name="style:style">
			<xsl:attribute name="style:name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
			<xsl:attribute name="style:family">table</xsl:attribute>
			<xsl:if test="w:tblStyle">
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select="w:tblStyle/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:element name="style:properties">
				<xsl:choose>
					<xsl:when test="w:jc/@w:val = 'left' or w:jc/@w:val = 'center' or w:jc/@w:val = 'right'">
						<xsl:attribute name="table:align"><xsl:value-of select="w:jc/@w:val"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="table:align">margins</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<!-- adopt the width of table and column corresponding the width of page and margins. . -->
				<xsl:variable name="sectPr" select="following::w:sectPr[1]"/>
				<xsl:variable name="total-page-size" select="$sectPr/w:pgSz/@w:w"/>
				<xsl:variable name="page-left-mar" select="$sectPr/w:pgMar/@w:left"/>
				<xsl:variable name="page-right-mar" select="$sectPr/w:pgMar/@w:right"/>
				<xsl:variable name="page-size-value" select="$total-page-size - $page-left-mar - $page-right-mar"/>
				<xsl:variable name="page-size-inch">
					<xsl:call-template name="convert2in">
						<xsl:with-param name="value" select="concat($page-size-value, 'dxa') "/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="gridcols" select="../w:tblGrid/w:gridCol"/>
				<xsl:variable name="tblsize" select="sum($gridcols/@w:w)"/>
				<xsl:variable name="table_indent">
					<xsl:choose>
						<xsl:when test="w:tblInd and  w:tblInd/@w:w &gt; 0 ">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat(w:tblInd/@w:w, 'dxa') "/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="number( '0') "/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="rel-tblsize">
					<xsl:choose>
						<xsl:when test="w:tblW/@w:type = 'pct'">
							<xsl:value-of select="(number(w:tblW/@w:w  ) div 5000) * $page-size-inch"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat($tblsize, 'dxa')"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:attribute name="style:width"><xsl:value-of select="concat($rel-tblsize, 'inch' )"/></xsl:attribute>
				<xsl:variable name="tbl_margin_left">
					<xsl:choose>
						<xsl:when test="not(w:tblpPr ) ">
							<xsl:choose>
								<xsl:when test="w:bidiVisual">
									<xsl:choose>
										<xsl:when test=" number($page-size-inch - $table_indent - $rel-tblsize) &gt; 0">
											<xsl:value-of select="$page-size-inch - $table_indent - $rel-tblsize"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>0</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$table_indent"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="w:tblpPr">
							<!-- if the table is  put into a draw:text-box,  fo:margin-left and fo:margin-right should be 0 -->
							<xsl:text>0</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="tbl_margin_right">
					<xsl:choose>
						<xsl:when test="not(w:tblpPr ) ">
							<xsl:choose>
								<xsl:when test="w:bidiVisual">
									<xsl:value-of select="$table_indent"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test=" number($page-size-inch - $table_indent - $rel-tblsize) &gt; 0">
											<xsl:value-of select="$page-size-inch - $table_indent - $rel-tblsize"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>0</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="w:tblpPr">
							<!-- if the table is  put into a draw:text-box,  fo:margin-left and fo:margin-right should be 0 -->
							<xsl:text>0</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:attribute name="fo:margin-left"><xsl:value-of select="concat( $tbl_margin_left, 'inch')"/></xsl:attribute>
				<xsl:attribute name="fo:margin-right"><xsl:value-of select="concat($tbl_margin_right, 'inch')"/></xsl:attribute>
				<!-- If previous w:p has a page break, the table must have the page break attribute applied to it	 May need this for tables starting on new pages -->
				<!--	<xsl:if test="parent::w:tbl/preceding-sibling::w:p[1][descendant::w:br/@w:type='page']">
							<xsl:attribute name="fo:break-before">page</xsl:attribute></xsl:if>	-->
				<!-- initial values for tables-->
			</xsl:element>
		</xsl:element>
		<!-- the following style is for conveting Word table text wrapping to SO Writer. Since SO Writer has no table text wrapping feature, so we use the draw:text-box as a container and put the table in draw:text-box -->
		<xsl:if test="w:tblpPr">
			<xsl:element name="style:style">
				<xsl:attribute name="style:name">TableFrame<xsl:number count="w:tblpPr" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
				<xsl:attribute name="style:family">graphics</xsl:attribute>
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select=" 'Frame' "/></xsl:attribute>
				<xsl:element name="style:properties">
					<xsl:if test="w:tblpPr/@w:leftFromText">
						<xsl:variable name="left_margin_from_text">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat (w:tblpPr/@w:leftFromText, 'dxa') "/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="fo:margin-left"><xsl:value-of select="concat( $left_margin_from_text, 'inch') "/></xsl:attribute>
					</xsl:if>
					<xsl:if test="w:tblpPr/@w:rightFromText">
						<xsl:variable name="right_margin_from_text">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat (w:tblpPr/@w:rightFromText, 'dxa') "/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="fo:margin-right"><xsl:value-of select="concat( $right_margin_from_text, 'inch') "/></xsl:attribute>
					</xsl:if>
					<xsl:if test="w:tblpPr/@w:topFromText">
						<xsl:variable name="top_margin_from_text">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat (w:tblpPr/@w:topFromText, 'dxa') "/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="fo:margin-top"><xsl:value-of select="concat( $top_margin_from_text, 'inch') "/></xsl:attribute>
					</xsl:if>
					<xsl:if test="w:tblpPr/@w:bottomFromText">
						<xsl:variable name="bottom_margin_from_text">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat (w:tblpPr/@w:bottomFromText, 'dxa') "/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="fo:margin-bottom"><xsl:value-of select="concat( $bottom_margin_from_text, 'inch') "/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="style:number-wrapped-paragraphs"><xsl:text>no-limit</xsl:text></xsl:attribute>
					<!--xsl:if test="w:tblpPr/@w:tblpYSpec" to get the vertical alignment-->
					<xsl:variable name="vertical_alignment">
						<xsl:choose>
							<xsl:when test="w:tblpPr/@w:tblpYSpec = 'top' ">
								<xsl:text>top</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpYSpec = 'center' ">
								<xsl:text>middle</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpYSpec= 'bottom' ">
								<xsl:text>bottom</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpYSpec = 'inside' ">
								<xsl:text>from-top</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpYSpec= 'outside' ">
								<xsl:text>top</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>from-top</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="style:vertical-pos"><xsl:value-of select="$vertical_alignment"/></xsl:attribute>
					<!--/xsl:if-->
					<!--xsl:if test="w:tblpPr/@w:vertAnchor" to get the vertical anchor related area type -->
					<xsl:variable name="frame_v_anchor">
						<xsl:choose>
							<xsl:when test="w:tblpPr/@w:vertAnchor = 'text' ">
								<xsl:value-of select=" 'paragraph' "/>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:vertAnchor = 'margin' ">
								<xsl:value-of select=" 'paragraph-content' "/>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:vertAnchor = 'page' ">
								<xsl:value-of select="w:tblpPr/@w:vertAnchor"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select=" 'page-content' "/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="style:vertical-rel"><xsl:value-of select="$frame_v_anchor"/></xsl:attribute>
					<!--/xsl:if-->
					<!--xsl:if test="w:tblpPr/@w:tblpXSpec" to get the horizntal alignment-->
					<xsl:variable name="horizental_alignment">
						<xsl:choose>
							<xsl:when test="w:tblpPr/@w:tblpXSpec = 'left' ">
								<xsl:text>left</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpXSpec = 'center' ">
								<xsl:text>center</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpXSpec = 'right' ">
								<xsl:text>right</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpXSpec = 'inside' ">
								<xsl:text>from-left</xsl:text>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:tblpXSpec = 'outside' ">
								<xsl:text>outside</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>left</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="style:horizontal-pos"><xsl:value-of select="$horizental_alignment"/></xsl:attribute>
					<!--/xsl:if-->
					<!--xsl:if test="w:tblpPr/@w:horzAnchor" to get the horizental anchor related area type-->
					<xsl:variable name="frame_h_anchor">
						<xsl:choose>
							<xsl:when test="w:tblpPr/@w:horzAnchor = 'text' ">
								<xsl:value-of select=" 'paragraph' "/>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:horzAnchor = 'margin' ">
								<xsl:value-of select=" 'page-content' "/>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:horzAnchor = 'page' ">
								<xsl:value-of select="w:tblpPr/@w:horzAnchor"/>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:horzAnchor= 'inside' ">
								<xsl:value-of select=" 'paragraph-start-margin' "/>
							</xsl:when>
							<xsl:when test="w:tblpPr/@w:horzAnchor= 'outside' ">
								<xsl:value-of select=" 'paragraph-end-margin' "/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select=" 'paragraph-content' "/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="style:horizontal-rel"><xsl:value-of select="$frame_h_anchor"/></xsl:attribute>
					<!--/xsl:if-->
					<xsl:attribute name="fo:background-color"><xsl:text>#ffffff</xsl:text></xsl:attribute>
					<xsl:attribute name="style:background-transparency"><xsl:text>100%</xsl:text></xsl:attribute>
					<xsl:attribute name="style:wrap"><xsl:text>parallel</xsl:text></xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:gridCol" mode="style">
		<xsl:element name="style:style">
			<xsl:attribute name="style:family">table-column</xsl:attribute>
			<xsl:attribute name="style:name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/>.C<xsl:number count="w:gridCol" from="/w:wordDocument/w:body" level="single"/></xsl:attribute>
			<xsl:element name="style:properties">
				<xsl:variable name="column_width">
					<xsl:call-template name="convert2in">
						<xsl:with-param name="value" select="concat(@w:w, 'dxa') "/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:attribute name="style:column-width"><xsl:value-of select="concat($column_width,'inch') "/></xsl:attribute>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:trPr" mode="style">
		<!-- to generate style:style of table-row height.  -->
		<xsl:element name="style:style">
			<xsl:attribute name="style:family">table-row</xsl:attribute>
			<xsl:attribute name="style:name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/>.R<xsl:number count="w:tr" from="/w:wordDocument/w:body" level="single"/></xsl:attribute>
			<xsl:element name="style:properties">
				<xsl:choose>
					<xsl:when test="w:trHeight/@w:val">
						<xsl:variable name="tbl_row_height">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat(w:trHeight/@w:val, 'dxa') "/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="style:row-height"><xsl:value-of select="concat($tbl_row_height, 'inch' )"/></xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:tcPr" mode="style">
		<style:style>
			<xsl:attribute name="style:name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/>.R<xsl:number count="w:tr" from="/w:wordDocument/w:body" level="single"/>C<xsl:number count="w:tc" from="/w:wordDocument/w:body" level="single"/></xsl:attribute>
			<xsl:attribute name="style:family">table-cell</xsl:attribute>
			<xsl:variable name="rootStyle" select="ancestor::w:tbl/w:tblPr/w:tblStyle/@w:val"/>
			<xsl:variable name="rootStyleNode" select="/w:wordDocument/w:styles/w:style[@w:styleId = $rootStyle]"/>
			<xsl:element name="style:properties">
				<!-- cell background color start -->
				<xsl:variable name="tbl_cell_background_color">
					<xsl:choose>
						<xsl:when test="w:shd/@w:fill">
							<xsl:value-of select="w:shd/@w:fill"/>
						</xsl:when>
						<xsl:when test="$rootStyleNode/w:tblpr/w:shd/@w:fill">
							<xsl:value-of select="$rootStyleNode/w:tblpr/w:shd/@w:fill"/>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:attribute name="fo:background-color"><xsl:value-of select="concat('#',$tbl_cell_background_color)"/></xsl:attribute>
				<!--cell background color end -->
				<!-- table cell vertical alignment start -->
				<xsl:if test="w:vAlign">
					<xsl:variable name="tbl_cell_alignment">
						<xsl:choose>
							<xsl:when test="w:vAlign/@w:val = 'top' ">
								<xsl:text>top</xsl:text>
							</xsl:when>
							<xsl:when test="w:vAlign/@w:val = 'center' ">
								<xsl:text>middle</xsl:text>
							</xsl:when>
							<xsl:when test="w:vAlign/@w:val = 'bottom' ">
								<xsl:text>bottom</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>automatic</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:attribute name="fo:vertical-align"><xsl:value-of select="$tbl_cell_alignment"/></xsl:attribute>
				</xsl:if>
				<!--table cell alignment end -->
				<!-- cell margin start -->
				<xsl:variable name="tblcell_leftmargin">
					<xsl:choose>
						<xsl:when test="w:tcMar/w:left">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat(w:tcMar/w:left/@w:w , w:tcMar/w:left/@w:type) "/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$rootStyleNode/w:tblPr/w:tblCellMar/w:left">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat($rootStyleNode/w:tblPr/w:tblCellMar/w:left/@w:w , $rootStyleNode/w:tblPr/w:tblCellMar/w:left/@w:type)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="tblcell_rightmargin">
					<xsl:choose>
						<xsl:when test="w:tcMar/w:right">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat(w:tcMar/w:right/@w:w , w:tcMar/w:right/@w:type) "/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$rootStyleNode/w:tblPr/w:tblCellMar/w:right">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat($rootStyleNode/w:tblPr/w:tblCellMar/w:right/@w:w , $rootStyleNode/w:tblPr/w:tblCellMar/w:right/@w:type)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="tblcell_topmargin">
					<xsl:choose>
						<xsl:when test="w:tcMar/w:top">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat(w:tcMar/w:top/@w:w , w:tcMar/w:top/@w:type) "/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$rootStyleNode/w:tblPr/w:tblCellMar/w:top">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat($rootStyleNode/w:tblPr/w:tblCellMar/w:top/@w:w , $rootStyleNode/w:tblPr/w:tblCellMar/w:top/@w:type)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="tblcell_bottommargin">
					<xsl:choose>
						<xsl:when test="w:tcMar/w:bottom">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat(w:tcMar/w:bottom/@w:w , w:tcMar/w:bottom/@w:type) "/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$rootStyleNode/w:tblPr/w:tblCellMar/w:bottom">
							<xsl:call-template name="convert2in">
								<xsl:with-param name="value" select="concat($rootStyleNode/w:tblPr/w:tblCellMar/w:bottom/@w:w , $rootStyleNode/w:tblPr/w:tblCellMar/w:bottom/@w:type)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>0</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:attribute name="fo:padding-left"><xsl:value-of select="concat($tblcell_leftmargin, 'inch' )"/></xsl:attribute>
				<xsl:attribute name="fo:padding-right"><xsl:value-of select="concat($tblcell_rightmargin, 'inch' )"/></xsl:attribute>
				<xsl:attribute name="fo:padding-top"><xsl:value-of select="concat($tblcell_topmargin, 'inch' )"/></xsl:attribute>
				<xsl:attribute name="fo:padding-bottom"><xsl:value-of select="concat($tblcell_bottommargin, 'inch' )"/></xsl:attribute>
				<!-- cell margin end -->
				<xsl:variable name="row-position">
					<xsl:number count="w:tr" from="/w:wordDocument/w:body" level="single"/>
				</xsl:variable>
				<!-- cell borders should be carefully converted. a little complex. glu :( -->
				<xsl:variable name="Borders" select="ancestor::w:tbl/w:tblPr/w:tblBorders"/>
				<xsl:choose>
					<xsl:when test="$row-position &gt; 1">
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'top'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:top"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:insideH"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:insideH"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'top'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:top"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:top"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:top"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="count(ancestor::w:tr/following-sibling::w:tr) &gt; 0">
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'bottom'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:bottom"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:insideH"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:insideH"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'bottom'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:bottom"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:bottom"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:bottom"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="count(ancestor::w:tc/preceding-sibling::w:tc) &gt; 0">
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'left'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:left"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:insideV"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:insideV"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'left'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:left"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:left"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:left"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="count(ancestor::w:tc/following-sibling::w:tc) &gt; 0">
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'right'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:right"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:insideV"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:insideV"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="get-table-border">
							<xsl:with-param name="style-pos" select="'right'"/>
							<xsl:with-param name="style-position-0" select="w:tcBorders/w:right"/>
							<xsl:with-param name="style-position-1" select="$Borders/w:right"/>
							<xsl:with-param name="style-position-2" select="$rootStyleNode/w:tblPr/w:tblBorders/w:right"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</style:style>
	</xsl:template>
	<xsl:template name="get-table-border">
		<xsl:param name="style-pos"/>
		<xsl:param name="style-position-0"/>
		<xsl:param name="style-position-1"/>
		<xsl:param name="style-position-2"/>
		<xsl:variable name="size-style">
			<xsl:choose>
				<xsl:when test="$style-position-0">
					<xsl:value-of select="$style-position-0/@w:sz"/>
				</xsl:when>
				<xsl:when test="$style-position-1">
					<xsl:value-of select="$style-position-1/@w:sz"/>
				</xsl:when>
				<xsl:when test="$style-position-2">
					<xsl:value-of select="$style-position-2/@w:sz"/>
				</xsl:when>
				<xsl:otherwise>2</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="border-style">
			<xsl:choose>
				<xsl:when test="$style-position-0">
					<xsl:value-of select="$style-position-0/@w:val"/>
				</xsl:when>
				<xsl:when test="$style-position-1">
					<xsl:value-of select="$style-position-1/@w:val"/>
				</xsl:when>
				<xsl:when test="$style-position-2">
					<xsl:value-of select="$style-position-2/@w:val"/>
				</xsl:when>
				<xsl:otherwise>single</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- totally basic Word table border styles: nil, none, single, thick, double, dotted, dashed, dot-dash, dot-dot-dash, triple, thin-thick-small-gap, thick-thin-small-gap, thin-thick-thin-small-gap, thin-thick-medium-gap, thick-thin-medium-gap, thin-thick-thin-medium-gap, thin-thick-large-gap, thick-thin-large-gap, thin-thick-thin-large-gap, wave, double-wave, dash-small-gap, dash-dot-stroked, three-d-emboss, three-d-engrave, outset, inset. Others are advanced graphical table border styles. glu -->
		<xsl:variable name="style-border">
			<xsl:choose>
				<xsl:when test="$border-style = 'nil' or $border-style ='none'">hidden</xsl:when>
				<xsl:when test="$border-style = 'single' or $border-style = 'thick' or $border-style = 'dotted' or $border-style = 'dashed' or $border-style = 'dot-dash' or $border-style = 'dot-dot-dash' or $border-style = 'wave' or $border-style = 'dash-small-gap' or $border-style = 'dash-dot-stroked'">solid</xsl:when>
				<xsl:otherwise>double</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="color-border">
			<xsl:choose>
				<xsl:when test="$style-position-0 and string-length($style-position-0/@w:color) = 6">
					<xsl:value-of select="$style-position-0/@w:color"/>
				</xsl:when>
				<xsl:when test="$style-position-0 and $style-position-0/@w:color = 'auto' and contains($border-style, 'set')">
					<xsl:text>c0c0c0</xsl:text>
				</xsl:when>
				<xsl:when test="$style-position-1 and string-length($style-position-1/@w:color) = 6">
					<xsl:value-of select="$style-position-1/@w:color"/>
				</xsl:when>
				<xsl:when test="$style-position-1 and $style-position-1/@w:color = 'auto' and contains($border-style, 'set')">
					<xsl:text>c0c0c0</xsl:text>
				</xsl:when>
				<xsl:when test="$style-position-2 and string-length($style-position-2/@w:color) = 6">
					<xsl:value-of select="$style-position-2/@w:color"/>
				</xsl:when>
				<xsl:when test="$style-position-2 and $style-position-2/@w:color = 'auto' and contains($border-style, 'set')">
					<xsl:text>c0c0c0</xsl:text>
				</xsl:when>
				<xsl:otherwise>000000</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- mapping border line widths. glu -->
		<xsl:choose>
			<xsl:when test="$border-style = 'single'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 7">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.002cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 20">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.035cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 30">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.088cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 40">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.141cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.176cm solid #', $color-border)"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'double'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 10">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.039cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.035cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 15">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.092cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 20">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.106cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.035cm 0.035cm</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.265cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.088cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'triple'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 5">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.039cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.035cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 10">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.092cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">.002cm 0.088cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 15">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.106cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.035cm 0.035cm</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.265cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.088cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'thin-thick-small-gap' or $border-style = 'thick-thin-small-gap'">
				<xsl:choose>
					<xsl:when test="($border-style = 'thin-thick-small-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-small-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
						<xsl:choose>
							<xsl:when test="$size-style &lt; 20">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.125cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:when test="$size-style &lt; 30">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.178cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.231cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'thin-thick-thin-small-gap'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 20">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.178cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.088cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 40">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.231cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.141cm</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'thin-thick-medium-gap' or $border-style = 'thick-thin-medium-gap'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 10">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.039cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.035cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 15">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.106cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.035cm 0.035cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 30">
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-medium-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-medium-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.212cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-medium-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-medium-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.141cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'thin-thick-thin-medium-gap'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 10">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.039cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.035cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 15">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.106cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.035cm 0.035cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 30">
						<xsl:choose>
							<xsl:when test="$style-pos = 'left' or $style-pos = 'top'">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.212cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="$style-pos = 'left' or $style-pos = 'top'">
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.141cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'thin-thick-large-gap' or $border-style = 'thick-thin-large-gap'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 7">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.092cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 10">
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-large-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-large-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.125cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.092cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.002cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$size-style &lt; 15">
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-large-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-large-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.125cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$size-style &lt; 30">
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-large-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-large-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.178cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$size-style &lt; 40">
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-large-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-large-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.231cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="($border-style = 'thin-thick-large-gap' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'thick-thin-large-gap' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.141cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$border-style = 'thin-thick-thin-large-gap'">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 5">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.125cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.035cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 10">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.178cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.088cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 20">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.231cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.141cm</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="contains( $border-style, 'wave') or $border-style = 'dash-dot-stroked'">
				<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.106cm double #', $color-border)"/></xsl:attribute>
				<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.035cm 0.035cm 0.035cm</xsl:attribute>
			</xsl:when>
			<xsl:when test="contains( $border-style, 'three-d')">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 10">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.035cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 20">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.088cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 30">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.176cm solid #', $color-border)"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 40">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.265cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.088cm</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="contains( $border-style, 'set')">
				<xsl:choose>
					<xsl:when test="$size-style &lt; 7">
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.092cm double #', $color-border)"/></xsl:attribute>
						<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.002cm</xsl:attribute>
					</xsl:when>
					<xsl:when test="$size-style &lt; 10">
						<xsl:choose>
							<xsl:when test="($border-style = 'outset' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'inset' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.092cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.002cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.125cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.035cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$size-style &lt; 15">
						<xsl:choose>
							<xsl:when test="($border-style = 'outset' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'inset' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.125cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.035cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$size-style &lt; 30">
						<xsl:choose>
							<xsl:when test="($border-style = 'outset' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'inset' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.178cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$size-style &lt; 40">
						<xsl:choose>
							<xsl:when test="($border-style = 'outset' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'inset' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.159cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.035cm 0.035cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.231cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.002cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.318cm double #', $color-border)"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="($border-style = 'outset' and ($style-pos = 'left' or $style-pos = 'top')) or ($border-style = 'inset' and ($style-pos = 'right' or $style-pos = 'bottom'))">
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.141cm 0.088cm 0.088cm</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="{concat('fo:border-', $style-pos)}"><xsl:value-of select="concat('0.231cm double #', $color-border)"/></xsl:attribute>
								<xsl:attribute name="{concat('style:border-line-width-',$style-pos)}">0.088cm 0.088cm 0.141cm</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="{concat('fo:border-', $style-pos)}">0.002cm solid #000000</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:tbl">
		<xsl:choose>
			<xsl:when test="w:tblPr/w:tblpPr">
				<!-- if the table is surrounded by text then put the table into a draw:text-box -->
				<xsl:element name="text:p">
					<xsl:element name="draw:text-box">
						<xsl:attribute name="draw:style-name"><xsl:text>TableFrame</xsl:text><xsl:number count="w:tblpPr" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						<xsl:attribute name="draw:name">TableFr<xsl:number count="w:tblpPr" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
						<xsl:variable name="tbl_anchor_type">
							<xsl:choose>
								<xsl:when test="name(..) = 'w:tc' ">
									<xsl:text>as-char</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>paragraph</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:attribute name="text:anchor-type"><xsl:value-of select="$tbl_anchor_type"/></xsl:attribute>
						<xsl:variable name="tbl_draw_textbox_width">
							<xsl:call-template name="convert2in">
								<!--  adjust the width of draw:text-box containing a table with 20dxa + table-width -->
								<xsl:with-param name="value" select="concat(string(number(sum(w:tblGrid/w:gridCol/@w:w) +20)), 'dxa' )"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:attribute name="svg:width"><xsl:value-of select="concat ($tbl_draw_textbox_width, 'inch') "/></xsl:attribute>
						<xsl:if test="w:tblPr/w:tblpPr/@w:tblpX">
							<xsl:variable name="x_distance_from_anchor">
								<xsl:call-template name="convert2in">
									<xsl:with-param name="value" select="concat(w:tblPr/w:tblpPr/@w:tblpX, 'dxa' ) "/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:attribute name="svg:x"><xsl:value-of select="concat ($x_distance_from_anchor, 'inch' )"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="w:tblPr/w:tblpPr/@w:tblpY">
							<xsl:variable name="y_distance_from_anchor">
								<xsl:call-template name="convert2in">
									<xsl:with-param name="value" select="concat(w:tblPr/w:tblpPr/@w:tblpY, 'dxa' ) "/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:attribute name="svg:y"><xsl:value-of select="concat ($y_distance_from_anchor, 'inch' )"/></xsl:attribute>
						</xsl:if>
						<!--create table in draw:text-box to produce table wrapping text effect-->
						<xsl:element name="table:table">
							<xsl:if test="w:tblPr">
								<xsl:attribute name="table:style-name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
							</xsl:if>
							<xsl:apply-templates select="w:tblGrid | w:tr"/>
						</xsl:element>
					</xsl:element>
					<!--draw:text-box end  -->
				</xsl:element>
				<!-- text:p end -->
			</xsl:when>
			<xsl:otherwise>
				<!-- if the table is not surrounded by text then put the table into a draw:text-box -->
				<xsl:element name="table:table">
					<xsl:if test="w:tblPr">
						<xsl:attribute name="table:style-name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/></xsl:attribute>
					</xsl:if>
					<xsl:apply-templates select="w:tblGrid | w:tr"/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:tblGrid">
		<xsl:apply-templates select="w:gridCol"/>
	</xsl:template>
	<xsl:template match="w:gridCol">
		<xsl:element name="table:table-column">
			<xsl:attribute name="table:style-name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/>.C<xsl:number count="w:gridCol" from="/w:wordDocument/w:body" level="single"/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:tr">
		<xsl:element name="table:table-row">
			<!-- generate row in table and add attribute of table:style-name if the style:style exists. cp tom chen. -->
			<xsl:if test="w:trPr/w:trHeight">
				<xsl:attribute name="table:style-name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/>.R<xsl:number count="w:tr" from="/w:wordDocument/w:body" level="single"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="w:tc"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:tc">
		<xsl:element name="table:table-cell">
			<xsl:attribute name="table:style-name">Table<xsl:number count="w:tbl" from="/w:wordDocument/w:body" level="any"/>.R<xsl:number count="w:tr" from="/w:wordDocument/w:body" level="single"/>C<xsl:number count="w:tc" from="/w:wordDocument/w:body" level="single"/></xsl:attribute>
			<xsl:if test="w:tcPr/w:gridSpan">
				<xsl:attribute name="table:number-columns-spanned"><xsl:value-of select="w:tcPr/w:gridSpan/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="w:p | w:tbl"/>
		</xsl:element>
	</xsl:template>
	<!-- end wordml2ooo_settings.xsl =================== -->
	<!--start wordml2ooo_text.xsl ===================== -->
	<xsl:template name="create-default-paragraph-styles">
		<xsl:variable name="default-paragraph-style" select="w:style[@w:default = 'on' and @w:type = 'paragraph']"/>
		<xsl:if test="$default-paragraph-style">
			<style:default-style style:family="paragraph">
				<style:properties>
					<xsl:choose>
						<xsl:when test="/w:wordDocument/w:fonts/w:defaultFonts">
							<xsl:attribute name="style:font-name"><xsl:value-of select="/w:wordDocument/w:fonts/w:defaultFonts/@w:ascii"/></xsl:attribute>
							<xsl:attribute name="style:font-name-asian"><xsl:value-of select="/w:wordDocument/w:fonts/w:defaultFonts/@w:fareast"/></xsl:attribute>
							<xsl:attribute name="style:font-name-complex"><xsl:value-of select="/w:wordDocument/w:fonts/w:defaultFonts/@w:cs"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="style:font-name">Times New Roman</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="$default-paragraph-style/w:rPr/w:sz">
						<xsl:attribute name="fo:font-size"><xsl:value-of select="$default-paragraph-style/w:rPr/w:sz/@w:val div 2"/>pt</xsl:attribute>
						<xsl:attribute name="fo:font-size-asian"><xsl:value-of select="$default-paragraph-style/w:rPr/w:sz/@w:val div 2"/>pt</xsl:attribute>
					</xsl:if>
					<xsl:if test="$default-paragraph-style/w:rPr/w:sz-cs">
						<xsl:attribute name="fo:font-size-complex"><xsl:value-of select="$default-paragraph-style/w:rPr/w:sz-cs/@w:val div 2"/>pt</xsl:attribute>
					</xsl:if>
					<!-- if not defined default font size in Word, make it out as 10pt. glu -->
					<xsl:if test="not($default-paragraph-style/w:rPr/w:sz or w:rPr/w:sz-cs)">
						<xsl:attribute name="fo:font-size">10pt</xsl:attribute>
						<xsl:attribute name="fo:font-size-asian">10pt</xsl:attribute>
						<xsl:attribute name="fo:font-size-complex">10pt</xsl:attribute>
					</xsl:if>
					<xsl:if test="$default-paragraph-style/w:rPr/w:lang">
						<xsl:if test="$default-paragraph-style/w:rPr/w:lang/@w:val">
							<xsl:attribute name="fo:language"><xsl:value-of select="substring-before( $default-paragraph-style/w:rPr/w:lang/@w:val, '-')"/></xsl:attribute>
							<xsl:attribute name="fo:country"><xsl:value-of select="substring-after( $default-paragraph-style/w:rPr/w:lang/@w:val, '-')"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="$default-paragraph-style/w:rPr/w:lang/@w:fareast">
							<xsl:attribute name="fo:language-asian"><xsl:value-of select="substring-before( $default-paragraph-style/w:rPr/w:lang/@w:fareast, '-')"/></xsl:attribute>
							<xsl:attribute name="fo:country-asian"><xsl:value-of select="substring-after( $default-paragraph-style/w:rPr/w:lang/@w:fareast, '-')"/></xsl:attribute>
						</xsl:if>
						<xsl:if test="$default-paragraph-style/w:rPr/w:lang/@w:bidi">
							<xsl:attribute name="fo:language-complex"><xsl:value-of select="substring-before( $default-paragraph-style/w:rPr/w:lang/@w:bidi, '-')"/></xsl:attribute>
							<xsl:attribute name="fo:country-complex"><xsl:value-of select="substring-after( $default-paragraph-style/w:rPr/w:lang/@w:bidi, '-')"/></xsl:attribute>
						</xsl:if>
					</xsl:if>
					<xsl:attribute name="style:tab-stop-distance"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(/w:wordDocument/w:docPr/w:defaultTabStop/@w:val,'dxa')"/></xsl:call-template>cm</xsl:attribute>
				</style:properties>
			</style:default-style>
		</xsl:if>
	</xsl:template>
	<xsl:template name="create-default-text-styles">
		<style:style style:name="Numbering Symbols" style:family="text"/>
		<style:style style:name="Bullet Symbols" style:family="text">
			<style:properties style:font-name="StarSymbol" fo:font-size="12pt" style:font-name-asian="StarSymbol" style:font-size-asian="12pt" style:font-name-complex="StarSymbol" style:font-size-complex="12pt"/>
		</style:style>
	</xsl:template>
	<xsl:template match="w:p" mode="style">
		<xsl:variable name="paragraph-number">
			<xsl:number from="/w:wordDocument/w:body" level="any" count="w:p"/>
		</xsl:variable>
		<xsl:variable name="section-property-number" select="count(preceding::w:sectPr)"/>
		<xsl:variable name="last-section-property" select="preceding::w:pPr/w:sectPr[1]"/>
		<style:style style:family="paragraph" style:name="P{$paragraph-number}">
			<xsl:if test="w:pPr/w:pStyle">
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select="w:pPr/w:pStyle/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="generate-id($last-section-property[last()]/following::w:p[1]) = generate-id(.) and not(ancestor::w:sectPr)">
					<xsl:attribute name="style:master-page-name">Standard<xsl:value-of select="$section-property-number + 1"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="$paragraph-number = 1">
					<xsl:attribute name="style:master-page-name">Standard1</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<style:properties>
				<xsl:apply-templates select="w:pPr"/>
			</style:properties>
		</style:style>
		<xsl:if test="w:r/w:br/@w:type='page'">
			<style:style style:family="paragraph" style:name="P{$paragraph-number}page-break">
				<xsl:if test="w:pPr/w:pStyle">
					<xsl:attribute name="style:parent-style-name"><xsl:value-of select="w:pPr/w:pStyle/@w:val"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="generate-id($last-section-property[last()]/following::w:p[1]) = generate-id(.) and not(ancestor::w:sectPr)">
						<xsl:attribute name="style:master-page-name">Standard<xsl:value-of select="$section-property-number + 1"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$paragraph-number = 1">
						<xsl:attribute name="style:master-page-name">Standard1</xsl:attribute>
					</xsl:when>
				</xsl:choose>
				<style:properties fo:break-before="page">
					<xsl:apply-templates select="w:pPr"/>
				</style:properties>
			</style:style>
		</xsl:if>
		<xsl:if test="w:r/w:br/@w:type='column'">
			<style:style style:family="paragraph" style:name="P{$paragraph-number}column-break">
				<xsl:if test="w:pPr/w:pStyle">
					<xsl:attribute name="style:parent-style-name"><xsl:value-of select="w:pPr/w:pStyle/@w:val"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="generate-id($last-section-property[last()]/following::w:p[1]) = generate-id(.) and not(ancestor::w:sectPr)">
						<xsl:attribute name="style:master-page-name">Standard<xsl:value-of select="$section-property-number + 1"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$paragraph-number = 1">
						<xsl:attribute name="style:master-page-name">Standard1</xsl:attribute>
					</xsl:when>
				</xsl:choose>
				<style:properties fo:break-before="column">
					<xsl:apply-templates select="w:pPr"/>
				</style:properties>
			</style:style>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:pPr">
		<xsl:if test="w:ind/@w:left">
			<xsl:attribute name="fo:margin-left"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:ind/@w:left, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:ind/@w:right">
			<xsl:attribute name="fo:margin-right"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:ind/@w:right, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:ind/@w:first-line">
			<xsl:attribute name="fo:text-indent"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:ind/@w:first-line, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:ind/@w:hanging">
			<xsl:attribute name="fo:text-indent"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat('-',w:ind/@w:hanging, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
		</xsl:if>
		<!-- bi-directional support-->
		<xsl:if test="w:bidi">
			<xsl:attribute name="style:writing-mode">rl-tb</xsl:attribute>
			<xsl:attribute name="fo:text-align">end</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:jc">
			<xsl:choose>
				<xsl:when test="w:jc/@w:val = 'center'">
					<xsl:attribute name="fo:text-align">center</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:jc/@w:val = 'left'">
					<xsl:choose>
						<xsl:when test="w:bidi">
							<xsl:attribute name="fo:text-align">end</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="fo:text-align">start</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="w:jc/@w:val = 'right'">
					<xsl:choose>
						<xsl:when test="w:bidi">
							<xsl:attribute name="fo:text-align">start</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="fo:text-align">end</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="fo:text-align">justify</xsl:attribute>
					<xsl:attribute name="style:justify-single-word">false</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:attribute name="style:auto-text-indent">false</xsl:attribute>
		<xsl:if test="w:spacing">
			<xsl:choose>
				<xsl:when test="w:spacing/@w:line-rule = 'at-least'">
					<xsl:attribute name="style:line-height-at-least"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:spacing/@w:line, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:spacing/@w:line-rule = 'auto'">
					<xsl:attribute name="fo:line-height"><xsl:value-of select="round(w:spacing/@w:line div 240 * 100)"/>%</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:spacing/@w:line-rule = 'exact'">
					<xsl:attribute name="fo:line-height"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:spacing/@w:line, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="w:spacing/@w:before">
				<xsl:attribute name="fo:margin-top"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:spacing/@w:before, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
			</xsl:if>
			<xsl:if test="w:spacing/@w:after">
				<xsl:attribute name="fo:margin-bottom"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:spacing/@w:after, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="w:shd">
			<xsl:variable name="background-color">
				<xsl:choose>
					<xsl:when test="string-length(w:shd/@w:fill) = 6">
						<xsl:value-of select="concat('#', w:shd/@w:fill)"/>
					</xsl:when>
					<xsl:otherwise>#000000</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="w:shd/@w:val = 'solid'">
					<xsl:attribute name="fo:background-color"><xsl:value-of select="$background-color"/></xsl:attribute>
				</xsl:when>
				<!-- patterns are necessary in the future. glu -->
				<xsl:otherwise/>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="w:pageBreakBefore">
			<xsl:attribute name="fo:break-before">page</xsl:attribute>
		</xsl:if>

		<xsl:if test="w:keepNext">
			<xsl:attribute name="fo:keep-with-next">true</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:keepLines">
			<xsl:attribute name="style:break-inside">avoid</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:widowControl='on'">
			<xsl:attribute name="fo:widows">2</xsl:attribute>
			<xsl:attribute name="fo:orphans">2</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:suppressAutoHyphens">
			<xsl:attribute name="fo:hyphenate">false</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:kinsoku/@w:val='off'">
			<xsl:attribute name="style:line-break">normal</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:overflowPunct/@w:val='off'">
			<xsl:attribute name="style:punctuation-wrap">simple</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:autoSpaceDE/@w:val='off' or w:autoSpaceDN/@w:val='off'">
			<xsl:attribute name="style:text-autospace">none</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:textAlignment">
			<xsl:choose>
				<xsl:when test="w:textAlignment/@w:val='center'">
					<xsl:attribute name="style:vertical-align">middle</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style:vertical-align"><xsl:value-of select="w:textAlignment/@w:val"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="w:pBdr">
			<xsl:if test="w:pBdr/w:top">
				<xsl:call-template name="get-table-border">
					<xsl:with-param name="style-pos" select="'top'"/>
					<xsl:with-param name="style-position-0" select="w:pBdr/w:top"/>
				</xsl:call-template>
				<xsl:attribute name="fo:padding-top"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pBdr/w:top/@w:space,'pt')"/></xsl:call-template>cm</xsl:attribute>
			</xsl:if>
			<xsl:if test="w:pBdr/w:left">
				<xsl:call-template name="get-table-border">
					<xsl:with-param name="style-pos" select="'left'"/>
					<xsl:with-param name="style-position-0" select="w:pBdr/w:left"/>
				</xsl:call-template>
				<xsl:attribute name="fo:padding-left"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pBdr/w:left/@w:space,'pt')"/></xsl:call-template>cm</xsl:attribute>
			</xsl:if>
			<xsl:if test="w:pBdr/w:right">
				<xsl:call-template name="get-table-border">
					<xsl:with-param name="style-pos" select="'right'"/>
					<xsl:with-param name="style-position-0" select="w:pBdr/w:right"/>
				</xsl:call-template>
				<xsl:attribute name="fo:padding-right"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pBdr/w:right/@w:space,'pt')"/></xsl:call-template>cm</xsl:attribute>
			</xsl:if>
			<xsl:if test="w:pBdr/w:bottom">
				<xsl:call-template name="get-table-border">
					<xsl:with-param name="style-pos" select="'bottom'"/>
					<xsl:with-param name="style-position-0" select="w:pBdr/w:bottom"/>
				</xsl:call-template>
				<xsl:attribute name="fo:padding-bottom"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:pBdr/w:bottom/@w:space,'pt')"/></xsl:call-template>cm</xsl:attribute>
			</xsl:if>
			<xsl:if test="w:pBdr/*/@w:shadow='on'">
				<xsl:attribute name="style:shadow">#000000 0.15cm 0.15cm</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="w:snapToGrid/@w:val='off' ">

			<xsl:attribute name="style:snap-to-layout-grid">false</xsl:attribute>
		</xsl:if>
		<!-- xsl:apply-templates select="w:rPr"/ -->
		<xsl:if test="w:tabs">
		<!--
		<xsl:message><xsl:value-of select=" name(..)"/></xsl:message>
		<xsl:message><xsl:value-of select=" name(.)"/></xsl:message>
		-->
			<xsl:element name="style:tab-stops">
				<xsl:for-each select="w:tabs/w:tab">
					<xsl:element name="style:tab-stop">
						<xsl:attribute name="style:position"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(@w:pos, 'dxa')"/></xsl:call-template>cm</xsl:attribute>
						<xsl:choose>
							<xsl:when test="@w:val = 'decimal'">
								<xsl:attribute name="style:type">char</xsl:attribute>
								<xsl:attribute name="style:char"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style:type"><xsl:value-of select="@w:val"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@w:leader">
							<xsl:attribute name="style:leader-char"><xsl:choose><xsl:when test="hyphen">-</xsl:when><xsl:when test="underscore">_</xsl:when><xsl:when test="dot">.</xsl:when></xsl:choose></xsl:attribute>
						</xsl:if>
						<xsl:if test="@style:leader-char">
							<xsl:choose>
								<xsl:when test="@style:leader-char='-'">
									<xsl:attribute name="w:leader">hyphen</xsl:attribute>
								</xsl:when>
								<xsl:when test="@style:leader-char='_'">
									<xsl:attribute name="w:leader">underscore</xsl:attribute>
								</xsl:when>
								<xsl:when test="@style:leader-char='.'">
									<xsl:attribute name="w:leader">dot</xsl:attribute>
								</xsl:when>
								<xsl:when test="@style:leader-char='·'">
									<xsl:attribute name="w:leader">middle-dot</xsl:attribute>
								</xsl:when>
							</xsl:choose>
						</xsl:if>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:rPr" mode="style">
		<xsl:element name="style:style">
			<xsl:attribute name="style:name">T<xsl:number from="/w:wordDocument/w:body" level="any" count="w:rPr"/></xsl:attribute>
			<xsl:attribute name="style:family">text</xsl:attribute>
			<xsl:if test="w:rStyle">
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select="w:rStyle/@w:val"/></xsl:attribute>
			</xsl:if>
			<xsl:element name="style:properties">
				<xsl:apply-templates select="current()"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:rPr">
		<xsl:if test="w:rFonts">
			<xsl:if test="w:rFonts/@w:ascii">
				<xsl:attribute name="style:font-name"><xsl:value-of select="w:rFonts/@w:ascii"/></xsl:attribute>
				<xsl:if test="ancestor::w:body">
					<xsl:attribute name="style:font-name-asian"><xsl:value-of select="w:rFonts/@w:ascii"/></xsl:attribute>
					<xsl:attribute name="style:font-name-complex"><xsl:value-of select="w:rFonts/@w:ascii"/></xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:if test="ancestor::w:styles">
				<xsl:if test="w:rFonts/@w:fareast">
					<xsl:attribute name="style:font-name-asian"><xsl:value-of select="w:rFonts/@w:fareast"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="w:rFonts/@w:cs">
					<xsl:attribute name="style:font-name-complex"><xsl:value-of select="w:rFonts/@w:cs"/></xsl:attribute>
				</xsl:if>
			</xsl:if>
		</xsl:if>
		<xsl:if test="w:b">
			<xsl:attribute name="fo:font-weight">bold</xsl:attribute>
			<xsl:attribute name="fo:font-weight-asian">bold</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:b-cs">
			<xsl:attribute name="fo:font-weight-complex">bold</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:i">
			<xsl:attribute name="fo:font-style">italic</xsl:attribute>
			<xsl:attribute name="fo:font-style-asian">italic</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:i-cs">
			<xsl:attribute name="fo:font-style-complex">italic</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:caps">
			<xsl:attribute name="fo:text-transform">uppercase</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:smallCaps">
			<xsl:attribute name="fo:font-variant">small-caps</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:strike">
			<xsl:attribute name="style:text-crossing-out">single-line</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:dstrike">
			<xsl:attribute name="style:text-crossing-out">double-line</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:outline">
			<xsl:attribute name="style:text-outline">true</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:shadow">
			<xsl:attribute name="style:text-shadow">1pt 1pt</xsl:attribute>
			<xsl:attribute name="fo:text-shadow">1pt 1pt</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:imprint">
			<xsl:attribute name="style:font-relief">engraved</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:emboss">
			<xsl:attribute name="style:font-relief">embossed</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:vanish">
			<xsl:attribute name="text:display">true</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:color[not(@w:val = 'auto')]">
			<xsl:attribute name="fo:color">#<xsl:value-of select="w:color/@w:val"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="w:spacing">
			<xsl:attribute name="fo:letter-spacing"><xsl:call-template name="convert2cm"><xsl:with-param name="value" select="concat(w:spacing/@w:val,'dxa')"/></xsl:call-template>cm</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:w/@w:val">
			<xsl:attribute name="style:text-scale"><xsl:value-of select="w:w/@w:val"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="w:vertAlign or w:position">
			<xsl:variable name="height">
				<xsl:choose>
					<xsl:when test="w:vertAlign[@w:val = 'superscript' or @w:val = 'subscript']">58%</xsl:when>
					<xsl:otherwise>100%</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="position">
				<xsl:choose>
					<xsl:when test="w:position">
						<!-- con't get font height easily, so just set w:val as percentage. glu -->
						<xsl:value-of select="concat( w:position/@w:val, '%')"/>
					</xsl:when>
					<xsl:when test="w:vertAlign[@w:val = 'superscript']">super</xsl:when>
					<xsl:when test="w:vertAlign[@w:val = 'subscript']">sub</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="style:text-position"><xsl:value-of select="concat($position, ' ', $height)"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="w:sz">
			<xsl:attribute name="fo:font-size"><xsl:value-of select="w:sz/@w:val div 2"/>pt</xsl:attribute>
			<xsl:attribute name="fo:font-size-asian"><xsl:value-of select="w:sz/@w:val div 2"/>pt</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:sz-cs">
			<!--<xsl:message><xsl:value-of select="'dfdf' "/></xsl:message>-->
			<xsl:attribute name="fo:font-size-complex"><xsl:value-of select="w:sz-cs/@w:val div 2"/>pt</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:highlight">
			<xsl:choose>
				<xsl:when test="w:highlight/@w:val='black'">
					<xsl:attribute name="style:text-background-color">#000000</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='yellow'">
					<xsl:attribute name="style:text-background-color">#ffff00</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='green'">
					<xsl:attribute name="style:text-background-color">#00ff00</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='cyan'">
					<xsl:attribute name="style:text-background-color">#00ffff</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='magenta'">
					<xsl:attribute name="style:text-background-color">#ff00ff</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='blue'">
					<xsl:attribute name="style:text-background-color">#0000ff</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='red'">
					<xsl:attribute name="style:text-background-color">#ff0000</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-blue'">
					<xsl:attribute name="style:text-background-color">#000080</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-cyan'">
					<xsl:attribute name="style:text-background-color">#008080</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-green'">
					<xsl:attribute name="style:text-background-color">#008000</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-magenta'">
					<xsl:attribute name="style:text-background-color">#800080</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-red'">
					<xsl:attribute name="style:text-background-color">#800000</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-yellow'">
					<xsl:attribute name="style:text-background-color">#808000</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='dark-gray'">
					<xsl:attribute name="style:text-background-color">#808080</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:highlight/@w:val='light-gray'">
					<xsl:attribute name="style:text-background-color">#c0c0c0</xsl:attribute>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="w:u">
			<xsl:choose>
				<xsl:when test="w:u/@w:val = 'words'">
					<xsl:attribute name="style:text-underline">single</xsl:attribute>
					<xsl:attribute name="fo:score-spaces">false</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'thick'">
					<xsl:attribute name="style:text-underline">bold</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'dotted-heavy'">
					<xsl:attribute name="style:text-underline">bold-dotted</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'dashed-heavy'">
					<xsl:attribute name="style:text-underline">bold-dash</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'dash-long'">
					<xsl:attribute name="style:text-underline">long-dash</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'dash-long-heavy'">
					<xsl:attribute name="style:text-underline">bold-long-dash</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'dash-dot-heavy'">
					<xsl:attribute name="style:text-underline">bold-dot-dash</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'dash-dot-dot-heavy'">
					<xsl:attribute name="style:text-underline">bold-dot-dot-dash</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'wavy-heavy'">
					<xsl:attribute name="style:text-underline">bold-wave</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:u/@w:val = 'wavy-double'">
					<xsl:attribute name="style:text-underline">double-wave</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style:text-underline"><xsl:value-of select="w:u/@w:val"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="w:u/@w:color and not(w:u/@w:color = 'auto')">
				<xsl:attribute name="style:text-underline-color">#<xsl:value-of select="w:u/@w:color"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="w:effect[@w:val = 'blink-background']">
			<xsl:attribute name="style:text-blinking">true</xsl:attribute>
			<xsl:attribute name="style:text-background-color">#000000</xsl:attribute>
		</xsl:if>
		<xsl:if test="w:shd and not(w:highlight)">
			<xsl:if test="string-length(w:shd/@w:fill) = 6">
				<xsl:attribute name="style:text-background-color">#<xsl:value-of select="w:shd/@w:fill"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="w:em">
			<xsl:choose>
				<xsl:when test="w:em/@w:val = 'comma'">
					<xsl:attribute name="style:text-emphasize">accent below</xsl:attribute>
				</xsl:when>
				<xsl:when test="w:em/@w:val = 'under-dot'">
					<xsl:attribute name="style:text-emphasize">disc below</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style:text-emphasize"><xsl:value-of select="concat( w:em/@w:val, ' below')"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="w:lang">
			<xsl:if test="w:lang/@w:val">
				<xsl:attribute name="fo:language"><xsl:value-of select="substring-before( w:lang/@w:val, '-')"/></xsl:attribute>
				<xsl:attribute name="fo:country"><xsl:value-of select="substring-after( w:lang/@w:val, '-')"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="w:lang/@w:fareast">
				<xsl:attribute name="fo:language-asian"><xsl:value-of select="substring-before( w:lang/@w:fareast, '-')"/></xsl:attribute>
				<xsl:attribute name="fo:country-asian"><xsl:value-of select="substring-after( w:lang/@w:fareast, '-')"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="w:lang/@w:bidi">
				<xsl:attribute name="fo:language-complex"><xsl:value-of select="substring-before( w:lang/@w:bidi, '-')"/></xsl:attribute>
				<xsl:attribute name="fo:country-complex"><xsl:value-of select="substring-after( w:lang/@w:bidi, '-')"/></xsl:attribute>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:p">
		<xsl:choose>
			<!-- because word treats page breaks as separate tags, we must split some paragraphs up so that we can
			give the sub para a fo:break-before ="page" or column attribute. -->
			<xsl:when test="w:r[w:br/@w:type='page' or w:br/@w:type='column']">
				<xsl:call-template name="process-breaks-in-paragraph"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="process-common-paragraph"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="process-breaks-in-paragraph">
		<xsl:variable name="textruns-with-break" select="w:r[w:br/@w:type='page' or w:br/@w:type='column']"/>
		<xsl:call-template name="create-sub-paragraph">
			<xsl:with-param name="textruns" select="$textruns-with-break[1]/preceding-sibling::w:r"/>
		</xsl:call-template>
		<xsl:for-each select="$textruns-with-break">
			<xsl:variable name="break-position" select="position()"/>
			<xsl:call-template name="create-sub-paragraph">
				<xsl:with-param name="textruns" select="following-sibling::w:r[not(w:br/@w:type='page' or w:br/@w:type='column') and (count(preceding::w:r[w:br/@w:type='page' or w:br/@w:type='column']) = $break-position)]"/>
				<xsl:with-param name="textruns-with-break" select="current()"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="create-sub-paragraph">
		<xsl:param name="textruns"/>
		<xsl:param name="textruns-with-break"/>
		<xsl:if test="$textruns or $textruns-with-break">
			<xsl:variable name="curr-num">
				<xsl:number from="/w:wordDocument/w:body" level="any" count="w:p"/>
			</xsl:variable>
			<text:p>
				<xsl:choose>
					<xsl:when test="$textruns-with-break">
						<xsl:attribute name="text:style-name"><xsl:value-of select="concat('P',$curr-num,w:br/@w:type, '-break')"/></xsl:attribute>
						<xsl:apply-templates select="$textruns-with-break"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="text:style-name"><xsl:value-of select="concat( 'P', $curr-num)"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="$textruns">
					<xsl:apply-templates select="$textruns"/>
				</xsl:if>
			</text:p>
		</xsl:if>
	</xsl:template>
	<xsl:template name="process-common-paragraph">
		<xsl:variable name="heading-or-paragraph">
			<xsl:choose>
				<xsl:when test="key('heading-style', w:pPr/w:pStyle/@w:val)">text:h</xsl:when>
				<xsl:otherwise>text:p</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:element name="{$heading-or-paragraph}">
			<xsl:if test="$heading-or-paragraph = 'text:h'">
				<xsl:attribute name="text:level"><xsl:value-of select="key('heading-style',w:pPr/w:pStyle/@w:val)/w:pPr/w:outlineLvl/@w:val + 1"/></xsl:attribute>
			</xsl:if>
			<xsl:variable name="curr-num">
				<xsl:number from="/w:wordDocument/w:body" level="any" count="w:p"/>
			</xsl:variable>
			<xsl:attribute name="text:style-name"><xsl:value-of select="concat( 'P', $curr-num)"/></xsl:attribute>
			<xsl:variable name="bookmark-and-paragraph" select="preceding::aml:annotation[(@w:type = 'Word.Bookmark.Start' or @w:type = 'Word.Bookmark.End') and not(ancestor::w:p)] | preceding::w:p"/>
			<xsl:if test="count($bookmark-and-paragraph) &gt; 0 and name($bookmark-and-paragraph[last()]) = 'aml:annotation'">
				<xsl:call-template name="create-bookmark">
					<xsl:with-param name="bookmark-and-paragraph" select="$bookmark-and-paragraph"/>
					<xsl:with-param name="position" select="count($bookmark-and-paragraph)"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:apply-templates select="w:r | w:fldSimple | w:hlink | aml:annotation"/>
			<xsl:if test="not(following::w:p)">
				<xsl:apply-templates select="following::aml:annotation[(@w:type = 'Word.Bookmark.Start' or @w:type = 'Word.Bookmark.End') and not(ancestor::w:p)]"/>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	<xsl:template name="create-bookmark">
		<xsl:param name="bookmark-and-paragraph"/>
		<xsl:param name="position"/>
		<xsl:choose>
			<xsl:when test="name($bookmark-and-paragraph[$position]) = 'aml:annotation'">
				<xsl:if test="$position &gt; 0">
					<xsl:call-template name="create-bookmark">
						<xsl:with-param name="bookmark-and-paragraph" select="$bookmark-and-paragraph"/>
						<xsl:with-param name="position" select="$position - 1"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="output-bookmark">
					<xsl:with-param name="bookmark-and-paragraph" select="$bookmark-and-paragraph"/>
					<xsl:with-param name="position" select="$position + 1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="output-bookmark">
		<xsl:param name="bookmark-and-paragraph"/>
		<xsl:param name="position"/>
		<xsl:apply-templates select="$bookmark-and-paragraph[$position]"/>
		<xsl:if test="$position &lt; count($bookmark-and-paragraph)">
			<xsl:call-template name="output-bookmark">
				<xsl:with-param name="bookmark-and-paragraph" select="$bookmark-and-paragraph"/>
				<xsl:with-param name="position" select="$position + 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- WordML contains multiple w:t within one w:r, so in Star Writer text:span should correspond to w:t glu -->
	<xsl:template match="w:r">
		<xsl:choose>
			<xsl:when test="(preceding-sibling::w:r) or (w:rPr)">
				<!-- add this condition to prevent from  printing the value of DATE, TIME, PRINTDATE, CREATEDATE, SAVEDATE, PAGE, NUMPAGES etc. fields  in-between w:fldchar begin and w:fldchar end   G.Yang.-->
				<xsl:if test="not (preceding-sibling::w:r/w:instrText[substring(normalize-space(.),1,4) = 'DATE'  or substring(normalize-space(.),1,4) = 'TIME'  or  substring(normalize-space(.),1,9) = 'PRINTDATE'  or substring(normalize-space(.),1,10) = 'CREATEDATE'  or substring(normalize-space(.),1,8) = 'SAVEDATE' or substring(normalize-space(.),1,4) = 'PAGE' or substring(normalize-space(.),1,8) = 'NUMPAGES'  or substring(normalize-space(.),1,8) = 'NUMWORDS' or substring(normalize-space(.),1,8) = 'NUMCHARS' or substring(normalize-space(.),1,6) = 'REVNUM' or substring(normalize-space(.),1,7) = 'AUTONUM'  or  substring(normalize-space(.),1,10) = 'AUTONUMLGL' or substring(normalize-space(.),1,10) = 'AUTONUMOUT' or substring(normalize-space(.),1,3) = 'SEQ' or substring(normalize-space(.),1,6) = 'AUTHOR' or substring(normalize-space(.),1,5) = 'TITLE'  or substring(normalize-space(.),1,7) = 'SUBJECT'  or substring(normalize-space(.),1,8) = 'KEYWORDS' or substring(normalize-space(.),1,6) = 'FILLIN'  or substring(normalize-space(.),1,11) = 'DOCPROPERTY' or substring(normalize-space(.),1,10) = 'MERGEFIELD' or substring(normalize-space(.),1,8) = 'MERGEREC' or substring(normalize-space(.),1,4) = 'NEXT' ][1]  and following-sibling::w:r/w:fldChar[@w:fldCharType='end'] )">
					<text:span>
						<xsl:choose>
							<xsl:when test="w:rPr/w:rStyle">
								<xsl:attribute name="text:style-name"><xsl:value-of select="w:rPr/w:rStyle/@w:val"/></xsl:attribute>
							</xsl:when>
							<xsl:when test="w:rPr">
								<xsl:variable name="position">
									<xsl:number from="/w:wordDocument/w:body" level="any" count="w:rPr"/>
								</xsl:variable>
								<xsl:attribute name="text:style-name">T<xsl:value-of select="$position + 1"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>
						<xsl:apply-templates select="w:t | w:pict | w:br | w:instrText | w:fldChar | w:tab | w:footnote | w:endnote | aml:annotation | w:hlink | w:footnote | w:endnote"/>
					</text:span>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!-- add this condition to prevent from printing the value of DATE, TIME, PRINTDATE, CREATEDATE, SAVEDATE, PAGE, NUMPAGES, etc. fields in-between w:fldchar begin and w:fldchar end  G.Yang.-->
				<xsl:if test="not( preceding-sibling::w:r/w:instrText[substring(normalize-space(.),1,4) = 'DATE'  or substring(normalize-space(.),1,4) = 'TIME'  or  substring(normalize-space(.),1,9) = 'PRINTDATE'  or substring(normalize-space(.),1,10) = 'CREATEDATE'  or substring(normalize-space(.),1,8) = 'SAVEDATE' or substring(normalize-space(.),1,4) = 'PAGE' or substring(normalize-space(.),1,8) = 'NUMPAGES'  or substring(normalize-space(.),1,8) = 'NUMWORDS' or substring(normalize-space(.),1,8) = 'NUMCHARS' or substring(normalize-space(.),1,6) = 'REVNUM' or substring(normalize-space(.),1,7) = 'AUTONUM'  or  substring(normalize-space(.),1,10) = 'AUTONUMLGL' or substring(normalize-space(.),1,10) = 'AUTONUMOUT' or substring(normalize-space(.),1,3) = 'SEQ' or substring(normalize-space(.),1,6) = 'AUTHOR' or substring(normalize-space(.),1,5) = 'TITLE'  or substring(normalize-space(.),1,7) = 'SUBJECT'  or substring(normalize-space(.),1,8) = 'KEYWORDS' or substring(normalize-space(.),1,6) = 'FILLIN' or substring(normalize-space(.),1,11) = 'DOCPROPERTY' or substring(normalize-space(.),1,10) = 'MERGEFIELD' or substring(normalize-space(.),1,8) = 'MERGEREC' or substring(normalize-space(.),1,4) = 'NEXT' ][1]  and following-sibling::w:r/w:fldChar[@w:fldCharType='end'] [1])">
					<xsl:apply-templates select="w:t | w:pict | w:br | w:instrText | w:fldChar | w:tab | w:footnote | w:endnote | aml:annotation | w:hlink | w:footnote | w:endnote"/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="aml:annotation">
		<xsl:choose>
			<xsl:when test="@w:type = 'Word.Bookmark.Start'">
				<text:bookmark-start text:name="{@w:name}"/>
			</xsl:when>
			<xsl:when test="@w:type = 'Word.Bookmark.End'">
				<xsl:variable name="id" select="@aml:id"/>
				<text:bookmark-end text:name="{preceding::aml:annotation[@aml:id = $id]/@w:name}"/>
			</xsl:when>
			<xsl:when test="@w:type = 'Word.Comment'">
				<office:annotation office:author="{@aml:author}" office:create-date="{substring(@aml:createdate,1,10)}" office:display="true">
					<xsl:apply-templates select="aml:content/w:p"/>
				</office:annotation>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="w:hlink">
		<xsl:element name="text:a">
			<xsl:attribute name="xlink:type">simple</xsl:attribute>
			<xsl:choose>
				<xsl:when test="@w:dest and @w:bookmark">
					<xsl:attribute name="xlink:href"><xsl:value-of select="concat( @w:dest, concat('#', @w:bookmark) )"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="@w:dest">
					<xsl:attribute name="xlink:href"><xsl:value-of select="@w:dest"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="@w:bookmark">
					<xsl:attribute name="xlink:href"><xsl:value-of select="concat('#', @w:bookmark)"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="@w:target">
				<xsl:attribute name="office:target-frame-name"><xsl:value-of select="@w:target"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="w:r | w:fldSimple | w:hlink"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="w:t">
		<xsl:choose>
			<xsl:when test="string(.) = ' ' ">
				<xsl:element name="text:s"/>
			</xsl:when>
			<xsl:when test="contains(.,'  ')">
				<xsl:call-template name="replace-spaces">
					<xsl:with-param name="curr-string" select="."/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="replace-spaces">
		<xsl:param name="curr-string"/>
		<xsl:if test="contains($curr-string,'  ')">
			<xsl:value-of select="substring-before($curr-string,'  ')"/>
			<text:s text:c="2"/>
			<xsl:variable name="next-string" select="substring-after($curr-string,'  ')"/>
			<xsl:choose>
				<xsl:when test="contains($next-string, '  ')">
					<xsl:call-template name="replace-spaces">
						<xsl:with-param name="curr-string" select="$next-string"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$next-string"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:tab">
		<xsl:element name="text:tab-stop"/>
	</xsl:template>
	<xsl:template match="w:br">
		<xsl:if test="@w:type='text-wrapping' or not(@w:type)">
			<text:line-break/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="w:footnote">
		<xsl:variable name="footnote-position">
			<xsl:number from="/w:wordDocument/w:body" count="w:footnote" level="any"/>
		</xsl:variable>
		<text:footnote text:id="ftn{$footnote-position}">
			<text:footnote-body>
				<xsl:apply-templates select="w:p | w:tbl"/>
			</text:footnote-body>
		</text:footnote>
	</xsl:template>
	<xsl:template match="w:endnote">
		<xsl:variable name="endnote-position">
			<xsl:number from="/w:wordDocument/w:body" count="w:endnote" level="any"/>
		</xsl:variable>
		<text:endnote text:id="edn{$endnote-position}">
			<text:endnote-body>
				<xsl:apply-templates select="w:p | w:tbl"/>
			</text:endnote-body>
		</text:endnote>
	</xsl:template>
	<!-- end wordml2ooo_text.xsl ========================== -->
</xsl:stylesheet>
