/*************************************************************************
 *
 *  $RCSfile: TDMtest.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 09:08:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.reflection.*;
import com.sun.star.uno.TypeClass;
import complexlib.ComplexTestCase;

public final class TDMtest extends ComplexTestCase {
    public String getTestObjectName() {
        return getClass().getName();
    }

    public String[] getTestMethodNames() {
        return new String[] { "test" };
    }

    public void test() throws Exception {
        XInterfaceTypeDescription xITD = (XInterfaceTypeDescription)_xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding" );
        assure("", xITD.getName().equals( "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding" ) );
        assure("", _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding" ) == xITD );

        XInterfaceMemberTypeDescription[] members = xITD.getMembers();
        assure("", members.length == 4 );
        // attribute long RuntimeException
        checkAttribute( members[0], 23, false, "long", "RuntimeException", "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding::RuntimeException", TypeClass.LONG );
        // getFoo()
        checkMethod( members[1], 24, false /*oneway*/,
                     "getFoo", "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding::getFoo",
                     "com.sun.star.comp.typedescriptionmanager.TestXLBBase",
                     new Parameter[0], new String[] { "com.sun.star.uno.RuntimeException" } );
        // setFoo()
        checkMethod( members[2], 25, false /*oneway*/,
                     "setFoo", "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding::setFoo",
                     "unsigned hyper",
                     new Parameter[] {
                         new Parameter( true, true, "hyper", "h" ) },
                     new String[] { "com.sun.star.uno.RuntimeException" } );

        // raiseException()
        checkMethod( members[3], 26, false /*oneway*/,
                     "raiseException", "com.sun.star.comp.typedescriptionmanager.TestXLanguageBinding::raiseException",
                     "com.sun.star.comp.typedescriptionmanager.TestDataElements",
                     new Parameter[] {
                         new Parameter( false, true, "boolean", "bBool" ),
                         new Parameter( false, true, "char", "cChar" ),
                         new Parameter( false, true, "byte", "nByte" ),
                         new Parameter( false, true, "short", "nShort" ),
                         new Parameter( false, true, "unsigned short", "nUShort" ),
                         new Parameter( false, true, "long", "nLong" ),
                         new Parameter( false, true, "unsigned long", "nULong" ),
                         new Parameter( false, true, "hyper", "nHyper" ),
                         new Parameter( false, true, "unsigned hyper", "nUHyper" ),
                         new Parameter( false, true, "float", "fFloat" ),
                         new Parameter( false, true, "double", "fDouble" ),
                         new Parameter( false, true, "com.sun.star.comp.typedescriptionmanager.TestEnum", "eEnum" ),
                         new Parameter( false, true, "string", "aString" ),
                         new Parameter( false, true, "com.sun.star.uno.XInterface", "xInterface" ),
                         new Parameter( false, true, "any", "aAny" ),
                         new Parameter( false, true, "[]com.sun.star.comp.typedescriptionmanager.TestElement", "aSequence" ),
                         new Parameter( false, true, "com.sun.star.comp.typedescriptionmanager.TestDataElements", "aStruct" ) },
                     new String[] {
                         "com.sun.star.lang.IllegalArgumentException",
                         "com.sun.star.uno.RuntimeException" } );

        // base XLBTestBase
        xITD = (XInterfaceTypeDescription)xITD.getBaseType();
        assure("", xITD.getName().equals( "com.sun.star.comp.typedescriptionmanager.TestXLBBase" ) );
        assure("", xITD == _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestXLBBase" ) );
        members = xITD.getMembers();
        assure("", members.length == 20 );
        // attributes
        // [attribute] boolean                   Bool;
        checkAttribute( members[0], 3, false, "boolean", "Bool", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Bool", TypeClass.BOOLEAN );
        checkAttribute( members[1], 4, false, "byte", "Byte", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Byte", TypeClass.BYTE );
        checkAttribute( members[2], 5, false, "char", "Char", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Char", TypeClass.CHAR );
        checkAttribute( members[3], 6, false, "short", "Short", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Short", TypeClass.SHORT );
        checkAttribute( members[4], 7, false, "unsigned short", "UShort", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::UShort", TypeClass.UNSIGNED_SHORT );
        checkAttribute( members[5], 8, false, "long", "Long", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Long", TypeClass.LONG );
        checkAttribute( members[6], 9, false, "unsigned long", "ULong", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::ULong", TypeClass.UNSIGNED_LONG );
        checkAttribute( members[7], 10, false, "hyper", "Hyper", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Hyper", TypeClass.HYPER );
        checkAttribute( members[8], 11, false, "unsigned hyper", "UHyper", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::UHyper", TypeClass.UNSIGNED_HYPER );
        checkAttribute( members[9], 12, false, "float", "Float", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Float", TypeClass.FLOAT );
        checkAttribute( members[10], 13, false, "double", "Double", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Double", TypeClass.DOUBLE );
        checkAttribute( members[11], 14, false, "com.sun.star.comp.typedescriptionmanager.TestEnum", "Enum", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Enum", TypeClass.ENUM );
        checkAttribute( members[12], 15, false, "string", "String", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::String", TypeClass.STRING );
        checkAttribute( members[13], 16, false, "com.sun.star.uno.XInterface", "Interface", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Interface", TypeClass.INTERFACE );
        checkAttribute( members[14], 17, false, "any", "Any", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Any", TypeClass.ANY );
        checkAttribute( members[15], 18, false, "[]com.sun.star.comp.typedescriptionmanager.TestElement", "Sequence", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Sequence", TypeClass.SEQUENCE );
        checkAttribute( members[16], 19, false, "com.sun.star.comp.typedescriptionmanager.TestDataElements", "Struct", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::Struct", TypeClass.STRUCT );
        // setValues()
        checkMethod( members[17], 20, true /*oneway*/,
                     "setValues", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::setValues",
                     "void",
                     new Parameter[] {
                         new Parameter( true, false, "boolean", "bBool" ),
                         new Parameter( true, false, "char", "cChar" ),
                         new Parameter( true, false, "byte", "nByte" ),
                         new Parameter( true, false, "short", "nShort" ),
                         new Parameter( true, false, "unsigned short", "nUShort" ),
                         new Parameter( true, false, "long", "nLong" ),
                         new Parameter( true, false, "unsigned long", "nULong" ),
                         new Parameter( true, false, "hyper", "nHyper" ),
                         new Parameter( true, false, "unsigned hyper", "nUHyper" ),
                         new Parameter( true, false, "float", "fFloat" ),
                         new Parameter( true, false, "double", "fDouble" ),
                         new Parameter( true, false, "com.sun.star.comp.typedescriptionmanager.TestEnum", "eEnum" ),
                         new Parameter( true, false, "string", "aString" ),
                         new Parameter( true, false, "com.sun.star.uno.XInterface", "xInterface" ),
                         new Parameter( true, false, "any", "aAny" ),
                         new Parameter( true, false, "[]com.sun.star.comp.typedescriptionmanager.TestElement", "aSequence" ),
                         new Parameter( true, false, "com.sun.star.comp.typedescriptionmanager.TestDataElements", "aStruct" ) },
                     new String[] {
                         "com.sun.star.uno.RuntimeException" } );
        // setValues2()
        checkMethod( members[18], 21, false /*oneway*/,
                     "setValues2", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::setValues2",
                     "com.sun.star.comp.typedescriptionmanager.TestDataElements",
                     new Parameter[] {
                         new Parameter( true, true, "boolean", "bBool" ),
                         new Parameter( true, true, "char", "cChar" ),
                         new Parameter( true, true, "byte", "nByte" ),
                         new Parameter( true, true, "short", "nShort" ),
                         new Parameter( true, true, "unsigned short", "nUShort" ),
                         new Parameter( true, true, "long", "nLong" ),
                         new Parameter( true, true, "unsigned long", "nULong" ),
                         new Parameter( true, true, "hyper", "nHyper" ),
                         new Parameter( true, true, "unsigned hyper", "nUHyper" ),
                         new Parameter( true, true, "float", "fFloat" ),
                         new Parameter( true, true, "double", "fDouble" ),
                         new Parameter( true, true, "com.sun.star.comp.typedescriptionmanager.TestEnum", "eEnum" ),
                         new Parameter( true, true, "string", "aString" ),
                         new Parameter( true, true, "com.sun.star.uno.XInterface", "xInterface" ),
                         new Parameter( true, true, "any", "aAny" ),
                         new Parameter( true, true, "[]com.sun.star.comp.typedescriptionmanager.TestElement", "aSequence" ),
                         new Parameter( true, true, "com.sun.star.comp.typedescriptionmanager.TestDataElements", "aStruct" ) },
                     new String[] {
                         "com.sun.star.uno.RuntimeException" } );
        // getValues()
        checkMethod( members[19], 22, false /*oneway*/,
                     "getValues", "com.sun.star.comp.typedescriptionmanager.TestXLBBase::getValues",
                     "com.sun.star.comp.typedescriptionmanager.TestDataElements",
                     new Parameter[] {
                         new Parameter( false, true, "boolean", "bBool" ),
                         new Parameter( false, true, "char", "cChar" ),
                         new Parameter( false, true, "byte", "nByte" ),
                         new Parameter( false, true, "short", "nShort" ),
                         new Parameter( false, true, "unsigned short", "nUShort" ),
                         new Parameter( false, true, "long", "nLong" ),
                         new Parameter( false, true, "unsigned long", "nULong" ),
                         new Parameter( false, true, "hyper", "nHyper" ),
                         new Parameter( false, true, "unsigned hyper", "nUHyper" ),
                         new Parameter( false, true, "float", "fFloat" ),
                         new Parameter( false, true, "double", "fDouble" ),
                         new Parameter( false, true, "com.sun.star.comp.typedescriptionmanager.TestEnum", "eEnum" ),
                         new Parameter( false, true, "string", "aString" ),
                         new Parameter( false, true, "com.sun.star.uno.XInterface", "xInterface" ),
                         new Parameter( false, true, "any", "aAny" ),
                         new Parameter( false, true, "[]com.sun.star.comp.typedescriptionmanager.TestElement", "aSequence" ),
                         new Parameter( false, true, "com.sun.star.comp.typedescriptionmanager.TestDataElements", "aStruct" ) },
                     new String[] {
                         "com.sun.star.uno.RuntimeException" } );
        // base XLBTestBase
        xITD = (XInterfaceTypeDescription)xITD.getBaseType();
        assure("", xITD.getName().equals( "com.sun.star.uno.XInterface" ) );
        assure("", xITD == _xTDMgr.getByHierarchicalName( "com.sun.star.uno.XInterface" ) );
        members = xITD.getMembers();
        assure("", members.length == 3 );
        // queryInterface()
        checkMethod( members[0], 0, false /*oneway*/,
                     "queryInterface", "com.sun.star.uno.XInterface::queryInterface",
                     "boolean",
                     new Parameter[] {
                         new Parameter( true, false, "com.sun.star.uno.Uik", "uik" ),
                         new Parameter( false, true, "any", "ifc" ) },
                     new String[] {
                         "com.sun.star.uno.RuntimeException" } );
        // acquire()
        checkMethod( members[1], 1, true /*oneway*/,
                     "acquire", "com.sun.star.uno.XInterface::acquire",
                     "void",
                     new Parameter[0],
                     new String[] {
                         "com.sun.star.uno.RuntimeException" } );
        // release()
        checkMethod( members[2], 2, true /*oneway*/,
                     "release", "com.sun.star.uno.XInterface::release",
                     "void",
                     new Parameter[0],
                     new String[] {
                         "com.sun.star.uno.RuntimeException" } );

        // compound types
        // com.sun.star.comp.typedescriptionmanager.TestDataElements
        XCompoundTypeDescription xTE = (XCompoundTypeDescription)_xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestDataElements" );
        assure("", xTE.getTypeClass() == TypeClass.STRUCT );
        assure("", xTE.getName().equals( "com.sun.star.comp.typedescriptionmanager.TestDataElements" ) );
        assure("", xTE == _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestDataElements" ) );
        XTypeDescription[] cmembers = xTE.getMemberTypes();
        String[] cnames = xTE.getMemberNames();
        assure("", cmembers.length == cnames.length && cmembers.length == 1 );
        assure("", cmembers[0].getName().equals( "[]com.sun.star.comp.typedescriptionmanager.TestElement" ) &&
                cmembers[0] == _xTDMgr.getByHierarchicalName( "[]com.sun.star.comp.typedescriptionmanager.TestElement" ) &&
                cnames[0].equals( "Sequence" ) );
        // com.sun.star.comp.typedescriptionmanager.TestElement
        xTE = (XCompoundTypeDescription)xTE.getBaseType();
        assure("", xTE.getTypeClass() == TypeClass.STRUCT );
        assure("", xTE.getName().equals( "com.sun.star.comp.typedescriptionmanager.TestElement" ) );
        assure("", xTE == _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestElement" ) );
        cmembers = xTE.getMemberTypes();
        cnames = xTE.getMemberNames();
        assure("", cmembers.length == cnames.length && cmembers.length == 3 );
        assure("", cmembers[0].getName().equals( "string" ) &&
                cmembers[0] == _xTDMgr.getByHierarchicalName( "string" ) &&
                cnames[0].equals( "String" ) );
        assure("", cmembers[1].getName().equals( "com.sun.star.uno.XInterface" ) &&
                cmembers[1] == _xTDMgr.getByHierarchicalName( "com.sun.star.uno.XInterface" ) &&
                cnames[1].equals( "Interface" ) );
        assure("", cmembers[2].getName().equals( "any" ) &&
                cmembers[2] == _xTDMgr.getByHierarchicalName( "any" ) &&
                cnames[2].equals( "Any" ) );
        // com.sun.star.comp.typedescriptionmanager.TestSimple
        xTE = (XCompoundTypeDescription)xTE.getBaseType();
        assure("", xTE.getTypeClass() == TypeClass.STRUCT );
        assure("", xTE.getName().equals( "com.sun.star.comp.typedescriptionmanager.TestSimple" ) );
        assure("", xTE == _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestSimple" ) );
        cmembers = xTE.getMemberTypes();
        cnames = xTE.getMemberNames();
        assure("", cmembers.length == cnames.length && cmembers.length == 12 );
        assure("", cmembers[0].getName().equals( "boolean" ) &&
                cmembers[0] == _xTDMgr.getByHierarchicalName( "boolean" ) &&
                cnames[0].equals( "Bool" ) );
        assure("", cmembers[1].getName().equals( "char" ) &&
                cmembers[1] == _xTDMgr.getByHierarchicalName( "char" ) &&
                cnames[1].equals( "Char" ) );
        assure("", cmembers[2].getName().equals( "byte" ) &&
                cmembers[2] == _xTDMgr.getByHierarchicalName( "byte" ) &&
                cnames[2].equals( "Byte" ) );
        assure("", cmembers[3].getName().equals( "short" ) &&
                cmembers[3] == _xTDMgr.getByHierarchicalName( "short" ) &&
                cnames[3].equals( "Short" ) );
        assure("", cmembers[4].getName().equals( "unsigned short" ) &&
                cmembers[4] == _xTDMgr.getByHierarchicalName( "unsigned short" ) &&
                cnames[4].equals( "UShort" ) );
        assure("", cmembers[5].getName().equals( "long" ) &&
                cmembers[5] == _xTDMgr.getByHierarchicalName( "long" ) &&
                cnames[5].equals( "Long" ) );
        assure("", cmembers[6].getName().equals( "unsigned long" ) &&
                cmembers[6] == _xTDMgr.getByHierarchicalName( "unsigned long" ) &&
                cnames[6].equals( "ULong" ) );
        assure("", cmembers[7].getName().equals( "hyper" ) &&
                cmembers[7] == _xTDMgr.getByHierarchicalName( "hyper" ) &&
                cnames[7].equals( "Hyper" ) );
        assure("", cmembers[8].getName().equals( "unsigned hyper" ) &&
                cmembers[8] == _xTDMgr.getByHierarchicalName( "unsigned hyper" ) &&
                cnames[8].equals( "UHyper" ) );
        assure("", cmembers[9].getName().equals( "float" ) &&
                cmembers[9] == _xTDMgr.getByHierarchicalName( "float" ) &&
                cnames[9].equals( "Float" ) );
        assure("", cmembers[10].getName().equals( "double" ) &&
                cmembers[10] == _xTDMgr.getByHierarchicalName( "double" ) &&
                cnames[10].equals( "Double" ) );
        assure("", cmembers[11].getName().equals( "com.sun.star.comp.typedescriptionmanager.TestEnum" ) &&
                cmembers[11] == _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestEnum" ) &&
                cnames[11].equals( "Enum" ) );

        // enum type
        XEnumTypeDescription xEnum = (XEnumTypeDescription)_xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestEnum" );
        assure("", xEnum.getTypeClass() == TypeClass.ENUM );
        assure("", xEnum.getName().equals( "com.sun.star.comp.typedescriptionmanager.TestEnum" ) );
        assure("", xEnum == _xTDMgr.getByHierarchicalName( "com.sun.star.comp.typedescriptionmanager.TestEnum" ) );
        int[] enumValues = xEnum.getEnumValues();
        String[] enumNames = xEnum.getEnumNames();
        assure("", enumNames.length == enumValues.length && enumValues.length == 7 );
        assure("", enumValues[0] == 0 && enumNames[0].equals( "TEST" ) );
        assure("", enumValues[1] == 1 && enumNames[1].equals( "ONE" ) );
        assure("", enumValues[2] == 2 && enumNames[2].equals( "TWO" ) );
        assure("", enumValues[3] == 3 && enumNames[3].equals( "CHECK" ) );
        assure("", enumValues[4] == 4 && enumNames[4].equals( "LOLA" ) );
        assure("", enumValues[5] == 5 && enumNames[5].equals( "PALOO" ) );
        assure("", enumValues[6] == 6 && enumNames[6].equals( "ZA" ) );
    }

    private void checkAttribute( XInterfaceMemberTypeDescription xMember, int nPos,
                                 boolean bReadOnly, String type,
                                 String memberName, String name, TypeClass typeClass )
        throws Exception
    {
        XInterfaceAttributeTypeDescription xAttribute = (XInterfaceAttributeTypeDescription)xMember;
        assure( "attribute "+memberName+": wrong type class \""+xAttribute.getTypeClass()+
                "\" (should be \"INTERFACE_ATTRIBUTE\" !",
                xAttribute.getTypeClass() == TypeClass.INTERFACE_ATTRIBUTE );
        assure( "attribute "+memberName+": wrong member name \""+xAttribute.getMemberName()+"\" !",
                 xAttribute.getMemberName().equals( memberName ) );
        assure( "attribute "+memberName+": wrong name \""+xAttribute.getName()+"\" !",
                xAttribute.getName().equals( name ) );
        assure( "attribute "+memberName+": wrong position: "+xAttribute.getPosition()+" (should be "+nPos+")!",
                xAttribute.getPosition() == nPos );

        assure( "attribute "+memberName+": read only flag differs!",
                xAttribute.isReadOnly() == bReadOnly );
        assure( "attribute "+memberName+": wrong type \""+xAttribute.getType().getName()+
                "\" (should be \""+type+"\") !",
                xAttribute.getType().getName().equals( type ) );
        assure( "attribute "+memberName+": table type differs!",
                xAttribute.getType() == _xTDMgr.getByHierarchicalName( type ) );
        assure( "attribute "+memberName+": wrong type class \""+xAttribute.getType().getTypeClass()+
                "\" (should be \""+typeClass+"\" !",
                xAttribute.getType().getTypeClass() == typeClass );
    }

    private void checkMethod( XInterfaceMemberTypeDescription xMember, int nPos, boolean bOneWay,
                              String memberName, String name,
                              String returnType, Parameter[] params, String[] exceptions )
        throws Exception
    {
        XInterfaceMethodTypeDescription xMethod = (XInterfaceMethodTypeDescription)xMember;
        assure( "method "+memberName+": wrong type class \""+xMethod.getTypeClass()+
                "\" (should be \"INTERFACE_METHOD\" !",
                xMethod.getTypeClass() == TypeClass.INTERFACE_METHOD );
        assure( "method "+memberName+": wrong member name \""+xMethod.getMemberName()+"\" !",
                 xMethod.getMemberName().equals( memberName ) );
        assure( "method "+memberName+": wrong name \""+xMethod.getName()+"\" !",
                 xMethod.getName().equals( name ) );
        assure( "method "+memberName+": wrong position: "+xMethod.getPosition()+
                " (should be "+nPos+")!",
                xMethod.getPosition() == nPos );
        // return type
        assure( "method "+memberName+": wrong return type \""+xMethod.getReturnType().getName()+
                "\" (should be \""+returnType+"\") !",
                xMethod.getReturnType().getName().equals( returnType ) );
        assure( "method "+memberName+": table type differs!",
                xMethod.getReturnType() == _xTDMgr.getByHierarchicalName( returnType ) );
        // exceptions
        XTypeDescription[] exc = xMethod.getExceptions();
        assure( "method "+memberName+": exceptions lists length differ!",
                exc.length == exceptions.length );
        int i;
        for ( i = 0; i < exc.length; ++i )
        {
            assure( "exception \""+exc[i].getName()+"\" has wrong typeclass \""+exc[i].getTypeClass()+"\" !",
                    exc[i].getTypeClass() == TypeClass.EXCEPTION );
            assure( "method "+memberName+": wrong exception types ["+i+
                    "] (should be \""+exceptions[i]+"\") !",
                    exc[i].getName().equals( exceptions[i] ) );
            assure( "method "+memberName+": table type differs!",
                    exc[i] == _xTDMgr.getByHierarchicalName( exceptions[i] ) );
        }
        // params
        XMethodParameter[] mparams = xMethod.getParameters();
        assure( "method "+memberName+": parameter lists length differ!",
                mparams.length == params.length );
        for ( i = 0; i < mparams.length; ++i )
        {
            XMethodParameter xParam = mparams[i];
            Parameter param = params[i];
            assure( "method "+memberName+", parameter "+i+": position differs!",
                     xParam.getPosition() == i );
            assure( "method "+memberName+", parameter "+i+": IN flag differs!",
                    xParam.isIn() == param.bIn );
            assure( "method "+memberName+", parameter "+i+": OUT flag differs!",
                     xParam.isOut() == param.bOut );
            // param names get lost reading type description from java reflection... so
//              ENSURE( xParam.getName().equals( param.name ),
//                      "method "+memberName+", parameter "+i+": name differs!" );
//              ENSURE( xParam.getName().equals( "Parameter "+i ),
//                      "method "+memberName+", parameter "+i+": name differs!" );
            assure( "method "+memberName+", parameter "+i+": wrong type \""+
                    xParam.getType().getName()+"\" (should be \""+param.type+"\") !",
                    xParam.getType().getName().equals( param.type ) );
            assure( "method "+memberName+", parameter "+i+": table type differs!",
                    xParam.getType() == _xTDMgr.getByHierarchicalName( param.type ) );
        }
    }

    private static final class Parameter {
        public final boolean bIn;
        public final boolean bOut;
        public final String type;
        public final String name;

        public Parameter(boolean bIn, boolean bOut, String type, String name) {
            this.bIn = bIn;
            this.bOut = bOut;
            this.type = type;
            this.name = name;
        }
    }

    private final XHierarchicalNameAccess _xTDMgr
    = new TypeDescriptionManager();
}
