
package org.netbeans.modules.openoffice.wizard.nodes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.nodes.AbstractNode;
import org.openide.util.actions.SystemAction;
import org.netbeans.modules.openoffice.wizard.util.*;
import org.netbeans.modules.openoffice.wizard.nodes.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.openide.nodes.Children;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import java.util.Vector;
import org.openide.src.Identifier;
import org.netbeans.modules.openoffice.*;


public abstract class BaseNode extends AbstractNode 
implements EditCookie, ModuleCreator, StructCreator, ConstantCreator, 
ExceptionCreator, AliasCreator, UnionCreator, EnumCreator, InterfaceCreator, 
ValueBoxCreator, FwdDclCreator, ServiceCreator, ConstantsCreator
{

   protected SystemAction actions[];
   protected static final String SPACE = "    ";
   protected Dialog dialog;
     
   protected final NameKey key;
   
   public BaseNode(Children Children,NameKey key1)
    {
        super(Children);
        key = key1;
        
    }

    public boolean canCut()
    {
        return false;
    }

    public boolean canCopy()
    {
        return false;
    }

    public boolean canDestroy()
    {
        return true;
    }

    public boolean canRename()
    {
        return true;
    }

    public SystemAction[] getActions()
    {
        if(actions == null)
            actions = createActions();
        return actions;
    }

    public void moveUp()
    {
        Children children = getParentNode().getChildren();
       ((IDLBaseChildren)children).moveUp(this);
    }

    public void moveDown()
    {
        Children children = getParentNode().getChildren();
        ((IDLBaseChildren)children).moveDown(this);
    }

    public abstract String generateSelf(int i);

    public abstract SystemAction[] createActions();

    public abstract void reInit(BasePanel expanel);

    public abstract BasePanel getEditPanel();

    public abstract boolean canMoveUp();
    
    public abstract boolean canMoveDown();
    
    
     public void createModule()
    {
        final ModuleCreatePanel modulepanel = new ModuleCreatePanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(modulepanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateModule"));
         exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                    String s = modulepanel.getName();
                    NameKey namedkey = new NameKey(1, s);
                    ((IDLBaseChildren)getChildren()).addKey(namedkey);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
        
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
    }
    
     public void createConstants() {
         final ConstantsPanel constantspanel = new ConstantsPanel();
         TopManager topmanager = TopManager.getDefault();
         DialogDescriptor exdialogdescriptor = new DialogDescriptor(
         constantspanel, 
         ResourceBundle.getBundle(
         "org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString(
         "TXT_CreateConstants"));
         exdialogdescriptor.setButtonListener( new ActionListener() {
             
             public void actionPerformed(ActionEvent actionevent) {
                 if(actionevent.getActionCommand().equals("OK")) {
                     String s = constantspanel.getName();
                     NameKey namedkey = new NameKey(20, s);
                     ((IDLBaseChildren)getChildren()).addKey(namedkey);
                 }
                 dialog.setVisible(false);
                 dialog.dispose();
             }
             
         });
         
         dialog = topmanager.createDialog(exdialogdescriptor);
         dialog.setVisible(true);
     }
    
     public void createService()
    {
        final ModuleCreatePanel modulepanel = new ModuleCreatePanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(modulepanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateService"));
         exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                    String s = modulepanel.getName();
                    NameKey namedkey = new NameKey(19, s);
                    ((IDLBaseChildren)getChildren()).addKey(namedkey);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
        
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
    }

    public void createValueBox()
    {
        final ValueBoxPanel valueboxpanel = new ValueBoxPanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(valueboxpanel, "ValueBox");
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = valueboxpanel.getName();
                        String s1 = valueboxpanel.getType();
                        AliasKey aliaskey = new AliasKey(15, s, s1);
                        ((IDLBaseChildren)getChildren()).addKey(aliaskey);            
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
       
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
    }
    
    public void createConstant()
    {
        final ConstPanel constpanel = new ConstPanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(constpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateConstant"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = constpanel.getName();
                        String s1 = constpanel.getType();
                        String s2 = constpanel.getValue();
                        ConstKey constkey = new ConstKey(5, s, s1, s2);
                       ((IDLBaseChildren)getChildren()).addKey(constkey);
               }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
       
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        

        
    }

    public void createStruct()
    {
        final InterfacePanel structpanel = new InterfacePanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(structpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateStruct"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = structpanel.getName();
                        String s1 = structpanel.getBase();
                        StructKey structkey = new StructKey(8, s, s1);
                        ((IDLBaseChildren)getChildren()).addKey(structkey);
                        
               }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
       
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
    }

    public void createForwardDcl()
    {
        final ForwardDclPanel forwarddclpanel = new ForwardDclPanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(forwarddclpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateFwdDcl"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = forwarddclpanel.getName();
                        boolean flag = forwarddclpanel.isInterface();
                        ForwardDclKey forwarddclkey = new ForwardDclKey(14, s, flag);
                        ((IDLBaseChildren)getChildren()).addKey(forwarddclkey);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
       
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
    }    

    public void createException()
    {
        final ModuleCreatePanel modulepanel = new ModuleCreatePanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(modulepanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateException"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

           public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = modulepanel.getName();
                        NameKey NameKey = new NameKey(7, s);
                        ((IDLBaseChildren)getChildren()).addKey(NameKey);
                 }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
               
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
          
    }

    public void createAlias()
    {
        final AliasPanel aliaspanel = new AliasPanel();
        TopManager topmanager = TopManager.getDefault();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(aliaspanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateAlias"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = aliaspanel.getName();
                        String s1 = aliaspanel.getType();
                        AliasKey aliaskey = new AliasKey(6, s, s1);
                        ((IDLBaseChildren)getChildren()).addKey(aliaskey);
                 }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });        
                        
        dialog = topmanager.createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
                
    }

    public void createUnion()
    {
        final UnionPanel unionpanel = new UnionPanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(unionpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateUnion"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                        String s = unionpanel.getName();
                        String s1 = unionpanel.getType();
                        AliasKey aliaskey = new AliasKey(9, s, s1);
                        ((IDLBaseChildren)getChildren()).addKey(aliaskey);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });
         dialog = TopManager.getDefault().createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
    }

    public void createEnum()
    {
        final EnumPanel enumpanel = new EnumPanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(enumpanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateEnum"));
        exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { 
                          String s = enumpanel.getName();
                          String s1 = enumpanel.getValues();
                          EnumKey enumkey = new EnumKey(10, s, s1);
                          ((IDLBaseChildren)getChildren()).addKey(enumkey);
                 }
                dialog.setVisible(false);
                dialog.dispose();
            }

        });  
        dialog = TopManager.getDefault().createDialog(exdialogdescriptor);
        dialog.setVisible(true);
   
    }

    public void createInterface()
    {
        final InterfacePanel interfacepanel = new InterfacePanel();
        DialogDescriptor exdialogdescriptor = new DialogDescriptor(interfacepanel, ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/Bundle").getString("TXT_CreateInterface"));
         exdialogdescriptor.setButtonListener( new ActionListener() {

            public void actionPerformed(ActionEvent actionevent)
            {
                if(actionevent.getActionCommand().equals("OK"))
                { String s = interfacepanel.getName();
                  String s1 = interfacepanel.getBase();
                  InterfaceKey interfacekey = new InterfaceKey(2, s, s1);
                 ((IDLBaseChildren)getChildren()).addKey(interfacekey);

                 }
                dialog.setVisible(false);
                dialog.dispose();
            }

        }); 
        dialog = TopManager.getDefault().createDialog(exdialogdescriptor);
        dialog.setVisible(true);
        
                
    }

    
    public abstract void generateImports(Vector Imports1);
  
}
