/*************************************************************************
 *
 *  $RCSfile: sbaexpl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _OFA_SBAEXPL_HXX
#define _OFA_SBAEXPL_HXX

#ifndef _SBA_DBDEFOBJ_HXX
#include "dbdefobj.hxx"
#endif

#ifndef _SBA_DBEXCH_HXX
#include "dbexch.hxx"
#endif

#ifndef _OFF_APP_HXX
#include "app.hxx"
#endif

#ifndef _EXPFILE_HXX //autogen
#include <sfx2/expfile.hxx>
#endif

#ifndef _EXPCONT_HXX //autogen
#include <sfx2/expcont.hxx>
#endif

#ifndef _SFXDIR_HXX //autogen
#include <sfx2/sfxdir.hxx>
#endif

#ifndef _EXPVIEW_HXX //autogen
#include <sfx2/expview.hxx>
#endif

#ifndef _EXPLORER_HXX //autogen
#include <sfx2/explorer.hxx>
#endif

#define	SBAOBJ()					\
	OFF_APP()->GetSbaObject()

#define	SBAEXPL()					\
	SBAOBJ()->GetSbaObjectExt()


class SbaObject;
class SbaDatabase;

//-------------------------------------------------------------------------
// Container von Datenbanken(Explorer)

class SbaDatabaseContainer: public SfxExplorerFile
{
	String  aConnectStr;

public:
	TYPEINFO();
	SbaDatabaseContainer();

protected:
	virtual void Open(const String&);
	virtual void Load(BOOL=FALSE);
	virtual BOOL Initialize(SfxExplorerContent*);
	virtual void Initialize(SfxExtDirEntry* pDirEntry);
	virtual BOOL Initialize(const String&);
	virtual Icon GetIcon();

	virtual void Destroy();
	virtual BOOL TitleEdited(SfxExplorerContentView*, const String& rNewTitel);
	virtual void EditProperties();
	virtual void PrepareContextMenu(SfxExplorerContextMenu& rMenu);
	String ToURL(BOOL bInTrash = FALSE) const;
	virtual BOOL QueryFeature(SfxExplorerFeature eFeature);
	virtual BOOL Save();
	virtual void Actualize();
	virtual Image GetImage(SfxExplorerContentImage eImage);
	virtual void StateChanged(SfxExplorerContentView* pView,
							  SfxExplorerStateChange eChange );
	virtual SvDataObjectRef CreateDataObject(SfxTransferOptions& rOptions);

public:
	static void  Register(SfxExplorer*);
	void ShowError();
	SbaDatabase* GetDatabase( BOOL bShowError= TRUE );

private:
	BOOL ReadTitle(String& rTitle);
	DECL_LINK( OnSQL, void* );
};

class SbaDBFolder: public SfxExplorerContent , public SfxListener
{
	friend class SbaDatabaseContainer;

protected:
	SbaDatabase* pDatabase;
	SbaExplorerExchObj* pDataExchObj;
	DBObject	 eDBObj;
	ULONG		 nWizardEvent;
	ULONG		 nCopyEvent;

	SbaDBFolder(DBObject eObj);
	virtual ~SbaDBFolder();

public:
	TYPEINFO();

	SbaDatabase* GetDatabase(SfxExplorerContent* pParent = NULL);
	virtual String GetUniqueName();

	SfxExplorerContent* IsChild(const String& rTitle) const;
	ULONG CountChildren(const String& rTitle) const;

	virtual BOOL QueryInsertObject( SfxExchangeObject* pObj,
									SfxTransferOptions& rOptions,
									SfxTransferMode& rDefMode );
	virtual BOOL QueryInsertObject( SfxExchangeObject* pObj, SbaExplorerExchObj*& rpExplorerExchObj );
	virtual BOOL InsertObject( SfxExchangeObject* pObj, SfxTransferMode eMode );

	void CallWizard();

protected:
	virtual void SFX_NOTIFY( SfxBroadcaster& rBC,
							 const TypeId& rBCType,
							 const SfxHint& rHint,
							 const TypeId& rHintType );
	virtual void Open(const String&);
	virtual BOOL Initialize(SfxExplorerContent*);
	virtual BOOL Initialize(const String&);

	virtual BOOL TitleEdited(SfxExplorerContentView*, const String& rNewTitel);
	virtual void PrepareContextMenu( SfxExplorerContextMenu& rMenu );
	virtual void EditProperties();
	virtual BOOL QueryFeature(SfxExplorerFeature eFeature);
	virtual BOOL Save();
	virtual void Actualize();
	virtual void StateChanged( SfxExplorerContentView* pView, SfxExplorerStateChange eChange );
	virtual SvDataObjectRef CreateDataObject(SfxTransferOptions& rOptions);
	virtual void CallWizardImpl() = 0;

private:
	DECL_LINK( OnWizard, void* );
	DECL_LINK( OnCopy, void* );
};

class SbaDBContent: public SfxExplorerContent
{
protected:
	SbaDatabase*	pDatabase;
	BOOL			bModeNew,
					bReload;	// aktualisieren des dbObj
	DBObject		eObj;
	SbaDBDefRef		aDBObj;


	SbaDBContent(DBObject eO);
	SbaDBContent(DBObject eO, SfxExplorerContentStyle nStyle, BOOL bNew = FALSE);
	SbaDBContent(SbaDBDef& rObj,
				 SfxExplorerContentStyle nStyle = CONTENT_URLTOOPEN | CONTENT_DOCVIEWAVAILABLE);

public:
	TYPEINFO();
	SbaDBContent(const String& rTitle, SbaDatabase* pDatabase, DBObject eOb);
	SbaDBContent(const String& rTitle, SbaDatabase* pDatabase, DBObject eOb,
				 SfxExplorerContentStyle nStyle);
	virtual ~SbaDBContent();

	virtual SbaDBDef* GetDBObj() const;
	//SbaDatabase* GetDatabase() const {return pDatabase;}
	DBObject GetDBObjType(){ return eObj; }

protected:
	virtual TypeId GetViewType(SfxExplorerViewType eView);
	virtual Window* CreateContentView(Window* pParent, SfxExplorerViewType eView);
	virtual SvDataObjectRef CreateDataObject(SfxTransferOptions& rOptions);
	virtual void EditProperties();
	virtual void PrepareContextMenu( SfxExplorerContextMenu& rMenu );
	virtual BOOL Initialize(SfxExplorerContent* pParent);
	BOOL Initialize(const INetURLObject& rObj,
					const String& rTitle);
	virtual BOOL QueryFeature(SfxExplorerFeature eFeature);
	virtual void Open(const String&);
	virtual void Destroy();
	virtual BOOL Save();
	virtual void Actualize();
	virtual String ToURL() const;
};

#endif


