/*************************************************************************
 *
 *  $RCSfile: appimp.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: pb $ $Date: 2002/08/14 09:27:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "appimp.hxx"

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#ifndef _SFXSMPLHINT_HXX //autogen
#include <svtools/smplhint.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_SETTINGS_HXX
#include <vcl/settings.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_ACCESSIBILITYOPTIONS_HXX
#include "svtools/accessibilityoptions.hxx"
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#ifndef _XTABLE_HXX
#include <svx/xtable.hxx>
#endif
#ifndef _XPOOL_HXX
#include <svx/xpool.hxx>
#endif

#include "app.hxx"
#include "osplcfg.hxx"
#include "htmlcfg.hxx"
#include "fltrcfg.hxx"
#include "ofaaccfg.hxx"
#include "apearcfg.hxx"
#include "splnote.hxx"

#define HELP_TIP_TIMEOUT 0xffff     // max. timeout setting to pretend a non-timeout

using namespace com::sun::star::uno;

// ------------------------------------------------------------------------

OfficeData_Impl::OfficeData_Impl( SfxBroadcaster& rBroadcast) :
		pHtmlOptions( NULL ),
		pAutoCorrCfg( NULL ),
        //pBasicIDE( NULL ),
		pSearchEngCfg( NULL ),
		pFontSubstCfg( NULL ),
		pStdColorTable( NULL ),
		pXOutdevItemPool( NULL ),
		pTabAppearanceConfig( NULL ),
		pSpellNote( NULL ),
		pWordDeInitFct( NULL ),
		pFilterOptions( NULL ),
		nChangeUserDataEvent( 0 ),
        bDoSearchCfg( sal_True ),
        pAccessibilityOptions(new SvtAccessibilityOptions)
{
    StartListening(rBroadcast);
    StartListening(*pAccessibilityOptions);
}
/* -----------------------------22.05.2002 13:50------------------------------

 ---------------------------------------------------------------------------*/
OfficeData_Impl::~OfficeData_Impl()
{
    delete pAccessibilityOptions;
}
/* -----------------------------22.05.2002 13:24------------------------------

 ---------------------------------------------------------------------------*/
void OfficeData_Impl::SetVCLSettings()
{
	AllSettings aAllSettings = Application::GetSettings();
    HelpSettings aHelpSettings = aAllSettings.GetHelpSettings();
    aHelpSettings.SetTipTimeout(
        pAccessibilityOptions->GetIsHelpTipsDisappear() ?
            pAccessibilityOptions->GetHelpTipSeconds() * 1000 : HELP_TIP_TIMEOUT);
    aAllSettings.SetHelpSettings(aHelpSettings);
    if(aAllSettings.GetStyleSettings().GetUseSystemUIFonts() != pAccessibilityOptions->GetIsSystemFont() )
    {
        StyleSettings aStyleSettings = aAllSettings.GetStyleSettings();
        aStyleSettings.SetUseSystemUIFonts( pAccessibilityOptions->GetIsSystemFont()  );
        aAllSettings.SetStyleSettings(aStyleSettings);
        Application::MergeSystemSettings( aAllSettings );
    }
    Application::SetSettings(aAllSettings);
}

// ------------------------------------------------------------------------

OfaHtmlOptions*	OfficeApplication::GetHtmlOptions()
{
	if(!pDataImpl->pHtmlOptions)
	{
		pDataImpl->pHtmlOptions = new OfaHtmlOptions();
	}
	return pDataImpl->pHtmlOptions;
}

// ------------------------------------------------------------------------

OfaFilterOptions* OfficeApplication::GetFilterOptions()
{
	if( !pDataImpl->pFilterOptions )
	{
		pDataImpl->pFilterOptions = new OfaFilterOptions();
	}
	return pDataImpl->pFilterOptions;
}

// ------------------------------------------------------------------------

XColorTable* OfficeApplication::GetStdColorTable()
{
	if(!pDataImpl->pStdColorTable)
		pDataImpl->pStdColorTable = new XColorTable( SvtPathOptions().GetPalettePath() );
	return pDataImpl->pStdColorTable;
}

// ------------------------------------------------------------------------

XOutdevItemPool* OfficeApplication::GetXOutdevItemPool()
{
	if(!pDataImpl->pXOutdevItemPool)
		pDataImpl->pXOutdevItemPool = new XOutdevItemPool;

	return pDataImpl->pXOutdevItemPool;
}

// ------------------------------------------------------------------------

OfaTabAppearanceCfg*	OfficeApplication::GetTabAppearanceConfig()
{
	if(!pDataImpl->pTabAppearanceConfig)
	{
		pDataImpl->pTabAppearanceConfig = new OfaTabAppearanceCfg();
	}
	return pDataImpl->pTabAppearanceConfig;
}

// ------------------------------------------------------------------------

void OfficeApplication::CreateDataImpl()
{
}

// ------------------------------------------------------------------------
// ConfigItems muessen frueher geloescht werden
void OfficeData_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    if(rHint.ISA(SfxSimpleHint))
    {
        switch(((SfxSimpleHint&)rHint).GetId())
        {
            case SFX_HINT_DEINITIALIZING:
            {
                DELETEZ(pHtmlOptions		);
                DELETEZ(pAutoCorrCfg		);
                DELETEZ(pTabAppearanceConfig);
                DELETEZ(pFilterOptions		);
            }
            break;

            case SFX_HINT_ACCESSIBILITY_CHANGED :
                SetVCLSettings();
            break;
        }
    }
}
// ------------------------------------------------------------------------
void OfficeApplication::DeleteDataImpl()
{

	delete pDataImpl->pStdColorTable;
	delete pDataImpl->pXOutdevItemPool;
	delete pDataImpl->pSpellNote;
	delete pDataImpl->pSearchEngCfg;
	delete pDataImpl->pFontSubstCfg;
	delete pDataImpl;
}

// ------------------------------------------------------------------------

	// Autokorrektur
OfaAutoCorrCfg*	OfficeApplication::GetAutoCorrConfig()
{
	if( !pDataImpl->pAutoCorrCfg )
	{
		pDataImpl->pAutoCorrCfg = new OfaAutoCorrCfg;
	}
	return pDataImpl->pAutoCorrCfg;
}

// ------------------------------------------------------------------------

	// Autokorrektur
SvxAutoCorrect*	OfficeApplication::GetAutoCorrect()
{
	if( !pDataImpl->pAutoCorrCfg )
		GetAutoCorrConfig();
	return pDataImpl->pAutoCorrCfg->GetAutoCorrect();
}

IMPL_LINK( OfficeApplication, ImplGetAutoCorrect, void*, EMPTY_ARG )
{
	return (long)GetAutoCorrect();
}

// ------------------------------------------------------------------------

