/*************************************************************************
 *
 *  $RCSfile: unotest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <tools/debug.hxx>

#ifndef _LIBCALL_HXX //autogen
#include <svtools/libcall.hxx>
#endif

#include <vcl/window.hxx>
#include <usr/uno.hxx>
#include <usr/comp.hxx>
#include <usr/serinfo.hxx>
#include <sfx2/xcollect.hxx>
#include <vcl/msgbox.hxx>

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif

#ifndef _VCL_FILEDLG_HXX //autogen
#include <vcl/filedlg.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif

#ifndef _SVX_BRWBOX_HXX //autogen
#include <svtools/brwbox.hxx>
#endif

#ifndef __SBX_SBXVALUE //autogen
#include <svtools/sbxvar.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX //autogen
#include <tools/resmgr.hxx>
#endif

#include <svx/dbengine.hxx>
#include <svx/dbdatbas.hxx>
#include <svx/dbconn.hxx>
#include <svx/dbworksp.hxx>
#include <svx/dbtable.hxx>
#include <svx/dbdoc.hxx>
#include <svx/dbrel.hxx>
#include <svx/dbquery.hxx>
#include <svx/dbcursor.hxx>
#include <svx/dbfield.hxx>

#include "sbadb.hxx"			// nur ein define abholen


#ifndef __SVTOOLS_SVTNUMF_HXX__
#include <svtools/svtnumf.hxx>
#endif

#include "gridctrl.hxx"

ResMgr* pResMgr = NULL;



class Browser: public BrowseBox
{
	friend class MyWindow;
	XDatabaseCursorRef	m_xCursor;
	SbxVariableRef  m_xConverter;

protected:
	void			Fill(XDatabaseCursorRef xCursor);
	virtual BOOL    SeekRow( long nRow );
	virtual void	PaintField(OutputDevice& rDev, const Rectangle& rRect,
							   USHORT nColumnId) const;

public:
	Browser(Window* pParent);
};

#define DISPOSE(pComponent)												\
	if (pComponent)														\
	{																	\
		XComponentRef xCp = pComponent->queryInterface(XComponent::getSmartUik());  \
		if (xCp.Is())													\
			xCp->dispose();												\
	}

//==================================================================

Browser::Browser(Window* pParent)
		:BrowseBox(pParent, WinBits(WB_DRAG|WB_BORDER|WB_CLIPCHILDREN),
				   BROWSER_COLUMNSELECTION | BROWSER_MULTISELECTION | BROWSER_KEEPSELECTION |
				   BROWSER_HLINESFULL | BROWSER_VLINESFULL | BROWSER_HEADERBAR_NEW)
		,m_xConverter(new SbxVariable())
{

	Font aFont("MS Sans Serif",Size(0,8));
	SetFont(aFont);
	aFont.SetWeight(WEIGHT_BOLD);
	SetTitleFont(aFont);
}

void Browser::Fill(XDatabaseCursorRef xCursor)
{
	Clear();
	RemoveColumns();

	// max 200 cachen
	if (m_xCursor.is())
		m_xCursor->dispose();

	m_xCursor = xCursor;
	if (m_xCursor.is())
	{
		m_xCursor->moveToPosition(200);
		XPropertySetRef xSet = (XPropertySet*)m_xCursor->queryInterface(XPropertySet::getSmartUik());
		UsrAny aVal = xSet->getPropertyValue("RecordCount");
		RowInserted(0, aVal.getUINT32(), TRUE);

		InsertHandleColumn(GetTextSize( "0" ).Width()*4, TRUE);
		XDatabaseFieldsRef xFields = m_xCursor->getFields();

		XIndexAccessRef xAccess = (XIndexAccess*)xFields->queryInterface(XIndexAccess::getSmartUik());
		UINT16 nCount = (UINT16)xAccess->getCount();

		for (UINT16 i = 0; i < nCount; i++)
			InsertDataColumn(i + 1, xFields->getFieldByIndex(i)->getName(), 85);

		if (i)
			FreezeColumn(1);
	}
}

//------------------------------------------------------------------
BOOL Browser::SeekRow(long nRow)
{
	if (nRow >= 0 && nRow < GetRowCount())
	{
		 m_xCursor->moveToPosition(nRow);
		return TRUE;
	}
	return FALSE;
}

//------------------------------------------------------------------
void Browser::PaintField( OutputDevice& rDev, const Rectangle& rRect,
						  USHORT nColumnId ) const
{
	if (nColumnId == 0 || !m_xCursor.Is())
		return;

	XDatabaseFieldRef xField = m_xCursor->getFields()->getFieldByIndex(nColumnId - 1);
	if (!xField.Is())
		return;

	XPropertySetRef xSet = (XPropertySet*)xField->queryInterface(XPropertySet::getSmartUik());
	UsrAny		  aValue = xSet->getPropertyValue("Value");

	USHORT nStyle = TEXT_DRAW_CLIP;
	String aText;
	if (aValue.get())
	{
		switch (xField->getType())
		{
			case DBTYPE_CHAR:
			case DBTYPE_VARCHAR:
				nStyle |= TEXT_DRAW_LEFT;
				aText = aValue.getString();
				break;
			case DBTYPE_BOOL:
				nStyle |= TEXT_DRAW_CENTER;
				m_xConverter->PutBool(aValue.getBOOL());
				aText = m_xConverter->GetString();
				break;
			case DBTYPE_BYTE:
				nStyle |= TEXT_DRAW_RIGHT;
				m_xConverter->PutByte(aValue.getBYTE());
				aText = m_xConverter->GetString();
				break;
			case DBTYPE_SMALLINT:
				nStyle |= TEXT_DRAW_RIGHT;
				m_xConverter->PutInteger(aValue.getINT16());
				aText = m_xConverter->GetString();
				break;
			case DBTYPE_COUNTER:
			case DBTYPE_INT:
				nStyle |= TEXT_DRAW_RIGHT;
				m_xConverter->PutLong(aValue.getINT32());
				aText = m_xConverter->GetString();
				break;
			case DBTYPE_DOUBLE:
			case DBTYPE_DECIMAL:
			case DBTYPE_CURRENCY:
				nStyle |= TEXT_DRAW_RIGHT;
				m_xConverter->PutDouble(aValue.getDouble());
				aText = m_xConverter->GetString();
				break;
			case DBTYPE_DATE:
			case DBTYPE_TIME:
			case DBTYPE_DATETIME:
				nStyle |= TEXT_DRAW_RIGHT;
				m_xConverter->PutDate(aValue.getDouble());
				aText = m_xConverter->GetString();
				break;
			default:
				aText = "<Object>";
				break;
		}
	}
	rDev.DrawText(rRect, aText, nStyle);
}

class MyWindow : public Window
{
	PushButton	m_pbOpen;
	ListBox		m_TblBox, m_QryBox, m_FrmBox, m_RepBox, m_RelBox;
	FixedText	m_TblTxt, m_QryTxt, m_FrmTxt, m_RepTxt , m_RelTxt, m_BrowserTxt;
	DBGridControl	m_Browser;

	XDatabaseEngineRef		m_xEngine;
	XDatabaseWorkspaceRef   m_xWorkspace;

	XDatabaseRef		 m_xDatabase;

public:
	MyWindow( Window *pParent );

private:
	DECL_LINK( OnFile, PushButton* );
	DECL_LINK( OnTable, ListBox* );
	DECL_LINK( OnQuery, ListBox* );
};

MyWindow::MyWindow( Window *pParent )
		: Window( pParent )
		,m_pbOpen(this)
		,m_TblBox(this, WB_3DLOOK | WB_BORDER)
		,m_QryBox(this, WB_3DLOOK | WB_BORDER)
		,m_FrmBox(this, WB_3DLOOK | WB_BORDER)
		,m_RepBox(this, WB_3DLOOK | WB_BORDER)
		,m_RelBox(this, WB_3DLOOK | WB_BORDER)
		,m_TblTxt(this, WB_3DLOOK)
		,m_QryTxt(this, WB_3DLOOK)
		,m_FrmTxt(this, WB_3DLOOK)
		,m_RepTxt(this, WB_3DLOOK)
		,m_RelTxt(this, WB_3DLOOK)
		,m_BrowserTxt(this,WB_3DLOOK)
		,m_Browser(this)
{
	XServiceManagerRef xMgr   = getGlobalServiceManager();
	XServiceProviderRef xProv = xMgr->getServiceProvider("stardiv.desktop.DatabaseEngine", UikSequence(), UikSequence());
	m_xEngine		= (XDatabaseEngine*) xProv->newInstance()->queryInterface(XDatabaseEngine::getSmartUik());
	m_xWorkspace	= m_xEngine->getWorkspaces()->getWorkspaceByIndex(0);

	m_pbOpen.SetText("Open ...");
	m_pbOpen.SetPosSizePixel(LogicToPixel(Point(50,8),MAP_APPFONT),
		LogicToPixel(Size(50,14),MAP_APPFONT));
	m_pbOpen.SetClickHdl(LINK(this, MyWindow, OnFile));
	m_pbOpen.Show();

	m_TblBox.SetPosSizePixel(LogicToPixel(Point(50,40),MAP_APPFONT),
			LogicToPixel(Size(100,100),MAP_APPFONT));
	m_TblBox.SetDoubleClickHdl(LINK(this, MyWindow, OnTable));
	m_TblBox.Disable();
	m_TblBox.Show();

	m_TblTxt.SetPosSizePixel(LogicToPixel(Point(50,26),MAP_APPFONT),
			LogicToPixel(Size(100,10),MAP_APPFONT));
	m_TblTxt.SetText("Tables");
	m_TblTxt.Show();

	m_QryBox.SetPosSizePixel(LogicToPixel(Point(160,40),MAP_APPFONT),
			LogicToPixel(Size(100,100),MAP_APPFONT));
	m_QryBox.SetDoubleClickHdl(LINK(this, MyWindow, OnQuery));
	m_QryBox.Disable();
	m_QryBox.Show();

	m_QryTxt.SetPosSizePixel(LogicToPixel(Point(160,26),MAP_APPFONT),
			LogicToPixel(Size(100,10),MAP_APPFONT));
	m_QryTxt.SetText("Queries");
	m_QryTxt.Show();

	m_FrmBox.SetPosSizePixel(LogicToPixel(Point(270,40),MAP_APPFONT),
			LogicToPixel(Size(100,100),MAP_APPFONT));
	m_FrmBox.Disable();
	m_FrmBox.Show();

	m_FrmTxt.SetPosSizePixel(LogicToPixel(Point(270,26),MAP_APPFONT),
			LogicToPixel(Size(100,10),MAP_APPFONT));
	m_FrmTxt.SetText("Forms");
	m_FrmTxt.Show();

	m_RepBox.SetPosSizePixel(LogicToPixel(Point(380,40),MAP_APPFONT),
			LogicToPixel(Size(100,100),MAP_APPFONT));
	m_RepBox.Disable();
	m_RepBox.Show();

	m_RepTxt.SetPosSizePixel(LogicToPixel(Point(380,26),MAP_APPFONT),
			LogicToPixel(Size(100,10),MAP_APPFONT));
	m_RepTxt.SetText("Reports");
	m_RepTxt.Show();

	m_RelBox.SetPosSizePixel(LogicToPixel(Point(490,40),MAP_APPFONT),
			LogicToPixel(Size(100,100),MAP_APPFONT));
	m_RelBox.Disable();
	m_RelBox.Show();

	m_RelTxt.SetPosSizePixel(LogicToPixel(Point(490,26),MAP_APPFONT),
			LogicToPixel(Size(100,10),MAP_APPFONT));
	m_RelTxt.SetText("Relations");
	m_RelTxt.Show();


	m_Browser.SetPosSizePixel(LogicToPixel(Point(50,200),MAP_APPFONT),
			LogicToPixel(Size(200,100),MAP_APPFONT));
	m_Browser.Disable();

	m_BrowserTxt.SetPosSizePixel(LogicToPixel(Point(50,186),MAP_APPFONT),
			LogicToPixel(Size(100,10),MAP_APPFONT));
	m_BrowserTxt.SetText("Data");
	m_BrowserTxt.Show();
}

//-------------------------------------------------------------------------
IMPL_LINK(MyWindow, OnFile, PushButton*, EMPTYARG )
{
	VclFileDialog* pDlg = GetpApp()->CreateFileDialog(this, 0);
	pDlg->SetDefaultExt("*.sdb");
	if (pDlg->Execute() == RET_OK)
	{
		INetURLObject aUrlObj(pDlg->GetPath());

		String aDatabaseName = aUrlObj.GetURLPath();
		aDatabaseName.Erase(0,strlen(SDB_DATABASE_MARK));

		DatabaseStatus aStatus = m_xWorkspace->openDatabase(m_xDatabase, pDlg->GetPath());
		if (aStatus.isOk())
		{
			XDatabaseConnectionRef xConnection = (XDatabaseConnection*)m_xDatabase->queryInterface(XDatabaseConnection::getSmartUik());
			m_TblBox.Clear();
			m_TblBox.Enable();

			m_QryBox.Clear();
			m_QryBox.Enable();

			m_FrmBox.Clear();
			m_FrmBox.Enable();

			m_RepBox.Clear();
			m_RepBox.Enable();

			m_RelBox.Clear();
			m_RelBox.Enable();

			XDatabaseTablesRef xTables = xConnection->getTables();
			XNameAccessRef xAccess = (XNameAccess*)xTables->queryInterface(XNameAccess::getSmartUik());
			WSStringSequence aSeq  = xAccess->getElementNames();
			const XubString* pArray = aSeq.getConstArray();

			UINT16 nCount = aSeq.getLen();
			for (UINT16 i = 0; i < nCount; i++)
				m_TblBox.InsertEntry(pArray[i]);

			XDatabaseQueriesRef xQueries = m_xDatabase->getQueries();
			xAccess = (XNameAccess*)xQueries->queryInterface(XNameAccess::getSmartUik());
			aSeq  = xAccess->getElementNames();
			nCount = aSeq.getLen();
			pArray = aSeq.getConstArray();
			for (i = 0; i < nCount; i++)
				m_QryBox.InsertEntry(pArray[i]);

			XDatabaseDocumentsRef xDocuments = m_xDatabase->getForms();
			xAccess = (XNameAccess*)xDocuments->queryInterface(XNameAccess::getSmartUik());
			aSeq  = xAccess->getElementNames();
			nCount = aSeq.getLen();
			pArray = aSeq.getConstArray();
			for (i = 0; i < nCount; i++)
				m_FrmBox.InsertEntry(pArray[i]);

			xDocuments = m_xDatabase->getReports();
			xAccess = (XNameAccess*)xDocuments->queryInterface(XNameAccess::getSmartUik());
			aSeq  = xAccess->getElementNames();
			nCount = aSeq.getLen();
			pArray = aSeq.getConstArray();
			for (i = 0; i < nCount; i++)
				m_RepBox.InsertEntry(pArray[i]);

			XDatabaseRelationsRef xRelations = xConnection->getRelations();
			XIndexAccessRef xIndexAccess = (XIndexAccess*)xRelations->queryInterface(XIndexAccess::getSmartUik());
			nCount = xIndexAccess->getCount();
			for (i = 0; i < nCount; i++)
				m_RelBox.InsertEntry(xRelations->getRelationByIndex(i)->getName());

			XNumberFormatterRef  xFormatter = (XNumberFormatter*)m_xDatabase->queryInterface(XNumberFormatter::getSmartUik());
			m_Browser.SetNumberFormatter(xFormatter);
		}
		else
		{
			m_TblBox.Clear();
			m_TblBox.Disable();

			m_QryBox.Clear();
			m_QryBox.Disable();

			m_FrmBox.Clear();
			m_FrmBox.Disable();

			m_RepBox.Clear();
			m_RepBox.Disable();

			m_RelBox.Clear();
			m_RelBox.Disable();

			m_Browser.SetNumberFormatter(XNumberFormatterRef());
		}
	}
	delete pDlg;
	return 0L;
}

//-------------------------------------------------------------------------
IMPL_LINK(MyWindow, OnTable, ListBox*, pListBox )
{
	XubString aName = pListBox->GetSelectEntry();
	XDatabaseConnectionRef xConnection = (XDatabaseConnection*)m_xDatabase->queryInterface(XDatabaseConnection::getSmartUik());
	XDatabaseTableRef	xTable = xConnection->getTables()->getTableByName(aName);
	if (!xTable)
		return -1;

	XDatabaseCursorRef xCursor;
	DatabaseStatus aStatus = xTable->createCursor(xCursor, DBCURSORTYPE_KEYSET, DBCURSOR_SEEDELETED);

	XDatabaseCursorRef xOldCursor = m_Browser.GetSource();
	if (xOldCursor.is())
		xOldCursor->dispose();

	if (aStatus.isOk())
	{
		m_Browser.Enable();
		m_Browser.Show();
	}
	else
	{
		m_Browser.Clear();
		m_Browser.Disable();
	}

	m_Browser.SetSource(xCursor);
	return 0L;
}

//-------------------------------------------------------------------------
IMPL_LINK(MyWindow, OnQuery, ListBox*, pListBox )
{
	XubString aName = pListBox->GetSelectEntry();
	XDatabaseQueryRef	xQuery = m_xDatabase->getQueries()->getQueryByName(aName);
	if (!xQuery)
		return -1;
	XDatabaseCursorRef xCursor;
	DatabaseStatus aStatus =  xQuery->createCursor(xCursor, DBCURSORTYPE_KEYSET, 0);

	XDatabaseCursorRef xOldCursor = m_Browser.GetSource();
	if (xOldCursor.is())
		xOldCursor->dispose();

	if (aStatus.isOk())
	{
		m_Browser.Enable();
		m_Browser.Show();
	}
	else
	{
		m_Browser.Clear();
		m_Browser.Disable();
	}

	m_Browser.SetSource(xCursor);
	return 0L;
}

extern "C" Window* __LOADONCALLAPI CreateWindow( Window *pParent, const String& rParam )
{
	LanguageType nType = Application::GetAppInternational().GetLanguage();
	String aMgrName = "tst";
	aMgrName += String( SOLARUPD );
	pResMgr = ResMgr::CreateResMgr(aMgrName, nType);

	MyWindow *pWin = new MyWindow( pParent );
	return pWin;
}
