/*************************************************************************
 *
 *  $RCSfile: mutximpl.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <osl/semaphor.h>

#include "semaimpl.h"

/*****************************************************************************/
/* NewMutex */
/*****************************************************************************/
MutexRef NewMutex()
{
	MutexRef	pMutex = malloc(sizeof(struct _oslMutexImpl));

	if (pMutex)
	{
		pMutex->owner = NULL;
		pMutex->locks = 0;
		pMutex->state = kMutexNoError;
	}

	return pMutex;
}

/*****************************************************************************/
/* DisposeMutex */
/*****************************************************************************/
OSErr DisposeMutex(MutexRef pMutex)
{
	OSErr	status;

	status = CancelMutex(pMutex, kMutexDisposed);
	if (status == kMutexNoError)
		free(pMutex);

	return status;
}

/*****************************************************************************/
/* CancelMutex */
/*****************************************************************************/
OSErr CancelMutex(MutexRef pMutex, int state)
{
	if (pMutex == NULL)
		return kMutexInvalid;

	pMutex->state = state;
	while (pMutex->owner)
		ReleaseMutex(pMutex);
	pMutex->state = kMutexNoError;

	return kMutexNoError;
}

/*****************************************************************************/
/* GetMutex */
/*****************************************************************************/
OSErr GetMutex(MutexRef pMutex)
{
	ThreadID	curThreadID;

	if (pMutex == NULL)
		return kMutexInvalid;

	GetCurrentThread(&curThreadID);

	if (pMutex->owner)
	{
		if (curThreadID == pMutex->owner->id) /* we own the mutex - lock */
			pMutex->locks++;
		else /* someone else owns the mutex - put us at end of queue */
		{
			struct	_ThreadElem	*pLastElem = pMutex->owner;
			int		result;

			while (pLastElem->next)
				pLastElem = pLastElem->next;

			pLastElem->next = malloc(sizeof(struct _ThreadElem));

			if (pLastElem->next == NULL)
				return kMutexNoMem;

			pLastElem->next->id = curThreadID;
			pLastElem->next->result = &result;
			pLastElem->next->next = NULL;

			SetThreadState(curThreadID, kStoppedThreadState, kNoThreadID);
			return result;
		}
	}
	else /* nobody owns the mutex so we can get it */
	{
		pMutex->owner = malloc(sizeof(struct _ThreadElem));

		if (pMutex->owner == NULL)
			return kMutexNoMem;

		pMutex->owner->next = NULL;
		pMutex->owner->id = curThreadID;
	}

	return kMutexNoError;
}

/*****************************************************************************/
/* IsMutexAvailiable */
/*****************************************************************************/
sal_Bool IsMutexAvailiable(MutexRef pMutex)
{
	ThreadID	curThreadID;

	GetCurrentThread(&curThreadID);
	return (sal_Bool)(pMutex && (pMutex->owner == NULL || pMutex->owner->id == curThreadID));
}

/*****************************************************************************/
/* ReleaseMutex */
/*****************************************************************************/
OSErr ReleaseMutex(MutexRef pMutex)
{
	ThreadID	curThreadID;

	if (pMutex == NULL)
		return kMutexInvalid;

	GetCurrentThread(&curThreadID);

	if (pMutex->owner)
	{
		if (pMutex->owner->id == curThreadID)	/* we own the mutex */
		{
			if (pMutex->locks == 0) /* no more locks so activate next thread in queue */
			{
				struct _ThreadElem	*newOwner = pMutex->owner->next;

				free(pMutex->owner);
				pMutex->owner = newOwner;
				if (pMutex->owner) /* do we get a new owner ? */
					SetThreadState(pMutex->owner->id, kReadyThreadState, kNoThreadID);
			}
			else
				pMutex->locks--;
			return kMutexNoError;
		}
		else	/* someon else owns the mutex */
			return kMutexInvalidOwner;
	}
	else	/* nobody owns the mutex, nothing to release */
		return kMutexNoOwner;
}

