/*************************************************************************
 *
 *  $RCSfile: testowstring.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:48:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#include <stdio.h>

#ifdef UNX
#include <wchar.h>
#endif
#ifdef OS2
#include <wcstr.h>
#endif

#ifndef	_OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef	_RTL_USTRING_HXX
#include <rtl/ustring.hxx>
#endif

#ifndef	_RTL_STRING_HXX
#include <rtl/string.hxx>
#endif

#if OSL_DEBUG_LEVEL > 0
#define TEST_ENSHURE(c, m)   OSL_ENSURE(c, m)
#else
#define TEST_ENSHURE(c, m)   OSL_VERIFY(c)
#endif

using namespace rtl;

void test_OWString()
{
	//          "Mein erster RTL OUString\n"
	//	         |	  |    |    |	 |
	//	Index    0	  5	   10   15	 20
	OUString s1(OUString::createFromAscii("Mein erster RTL OUString\n"));
	TEST_ENSHURE( s1 == OUString::createFromAscii("Mein erster RTL OUString\n"), "test_OWString error 1");
	TEST_ENSHURE( s1.getLength() == 25, "test_OWString error 2");

	OUString s2 = s1;
	TEST_ENSHURE( s2[16] == (sal_Unicode)'O', "test_OWString error 3");
	TEST_ENSHURE( s2.equals(s1), "test_OWString error 4");
	TEST_ENSHURE( OUString( OUString::createFromAscii("hallo")) == OUString::createFromAscii( "hallo"), "test_OWString error 4");
	TEST_ENSHURE( s2.indexOf((sal_Unicode)'O') == 16, "test_OWString error 5");
	TEST_ENSHURE( s2.indexOf((sal_Unicode)'O', 5) == 16, "test_OWString error 5a");
	TEST_ENSHURE( s2.lastIndexOf((sal_Unicode)'r') == 20, "test_OWString error 6");
	TEST_ENSHURE( s2[20] == (sal_Unicode)'r', "test_OWString error 7");
	TEST_ENSHURE( s2[24] == (sal_Unicode)'\n', "test_OWString error 8");
	TEST_ENSHURE( s2.lastIndexOf((sal_Unicode)'\n') == 24, "test_OWString error 9");
	TEST_ENSHURE( s2.lastIndexOf((sal_Unicode)'M') == 0, "test_OWString error 10");
	TEST_ENSHURE( s2.lastIndexOf((sal_Unicode)'t', s2.getLength() - 8) == 8, "test_OWString error 9");


	//          "Mein erster RTL OUString ist ein String aus der RTL Library\n"
	//           |    |    |    |	 |	  |	   |	| 	 |	  |	   |	|
	//  Index    0    5	   10   15	 20   25   30	35	 40   45   50	55
	OUString s3 = s2.copy(0, s2.getLength() - 1);
	OUString s4 = s3.concat( OUString::createFromAscii(" ist ein String aus der RTL Library\n") );
	TEST_ENSHURE( s4.getLength() == 60, "test_OWString error 11");

	s1 = s4.copy(0, 39);
	OUString s5;
	s5 = s1 + OUString::createFromAscii( " aus der RTL Library\n" );
	TEST_ENSHURE( s5.compareTo(s4) == 0 , "test_OWString error 12");
	TEST_ENSHURE( s5.indexOf(OUString::createFromAscii("RTL")) == 12, "test_OWString error 13");
	TEST_ENSHURE( s5.lastIndexOf(OUString::createFromAscii("RTL")) == 48, "test_OWString error 13");

	sal_Bool b = sal_False;
	OUString s6 = s5.valueOf(b);
	TEST_ENSHURE( s6.compareTo(OUString::createFromAscii("False")) == 0, "test_OWString error 14");
	s6 = s5.valueOf((sal_Unicode)'H');
	TEST_ENSHURE( s6.compareTo(OUString::createFromAscii("H")) == 0, "test_OWString error 15");
	sal_Int32 n = 123456789L;
	s6 = s5.valueOf(n);
	TEST_ENSHURE( s6.compareTo(OUString::createFromAscii("123456789")) == 0, "test_OWString error 16");

#ifndef SAL_OS2
#ifdef SAL_UNX
	sal_Int64 m = -3223372036854775807LL;
#elif defined(SAL_OS2)
    sal_Int64 m;
    sal_setInt64(&m, 3965190145L, -750499787L);
#else
	sal_Int64 m = -3223372036854775807;
#endif
	s6 = s5.valueOf(m);
	TEST_ENSHURE( s6.compareTo( OUString::createFromAscii( "-3223372036854775807" ) ) == 0, "test_OWString error 17");
#endif

   	::rtl::OLocale locale = ::rtl::OLocale::getDefault();

	OUString s61(OUString::createFromAscii("HaLLo"));
	s61 = s61.toLowerCase(locale);
	TEST_ENSHURE( s61 == OUString::createFromAscii("hallo"), "test_OWString error 17a");
	s61 = s61.toUpperCase();
	TEST_ENSHURE( s61 == OUString::createFromAscii("HALLO"), "test_OWString error 17b");
	s61 = s61.toLowerCase();
	TEST_ENSHURE( s61 == OUString::createFromAscii("hallo"), "test_OWString error 17c");

	::rtl::OLocale::setDefault( OUString::createFromAscii( "de" ), OUString::createFromAscii( "DE" ), OUString() );
	locale = OLocale::getDefault();

	// AB, 24.3.2000, removed NAMESPACE_RTL(OLocale)::getENGLISH() and error 18

	OUString s7(OUString::createFromAscii("HaLLo"));
	s7 = s7.toLowerCase(locale);
	TEST_ENSHURE( s7 == OUString::createFromAscii("hallo"), "test_OWString error 19");
	s7 = s7.toUpperCase(locale);
	TEST_ENSHURE( s7 == OUString::createFromAscii("HALLO"), "test_OWString error 20");

	OUString s8(OUString::createFromAscii("HaLLo ICH BIn eIn "));
	s8 += OUString::valueOf( (sal_Unicode)0xDF );
	locale = OLocale::registerLocale( OUString::createFromAscii("tr"), OUString::createFromAscii("TR"), OUString());
	s8 = s8.toLowerCase(locale);
	s8 = s8.toUpperCase(locale);
	TEST_ENSHURE( s8 == OUString::createFromAscii("HALLO ICH BIN EIN SS"), "test_OWString error 21");

	s7 = OUString::createFromAscii("Hallo ich bIn ein I");
	s7 = s8.toUpperCase(locale);
	TEST_ENSHURE( s7 != OUString::createFromAscii("HALLO ICH BIN EIN I"), "test_OWString error 21.b");

	s7 = OUString::createFromAscii("          ");
	s8 = s7 + s8 + OUString::createFromAscii("          " );
	TEST_ENSHURE( s8 == OUString::createFromAscii("          HALLO ICH BIN EIN SS          "),
				  "test_OWString error 22");

	s7 = s8.trim();
	TEST_ENSHURE( s7 == OUString::createFromAscii("HALLO ICH BIN EIN SS"), "test_OWString error 23");
	TEST_ENSHURE( wcscmp(s7.getStr(), L"HALLO ICH BIN EIN SS") == 0, "test_OWString error 24");

	s7 = OUString::createFromAscii("Hallo");
	s8 = OUString::createFromAscii("aber Hallo");

	TEST_ENSHURE( s7 < s8, "test_OWString error 25");
	TEST_ENSHURE( s8 > s7, "test_OWString error 26");
	TEST_ENSHURE( s7 != s8, "test_OWString error 27");
	TEST_ENSHURE( s7 != OUString::createFromAscii("blabla"), "test_OWString error 28");
	TEST_ENSHURE( OUString::createFromAscii("blabla") != s7, "test_OWString error 29");

	s8 = OUString::createFromAscii("Hallo");	
	TEST_ENSHURE( s7 <= s8, "test_OWString error 30");	
	TEST_ENSHURE( s7 >= s8, "test_OwString error 31");	

	s8 = s8.replace((sal_Unicode)'l', (sal_Unicode)'r');
	TEST_ENSHURE( s8 == OUString::createFromAscii("Harro"), "test_OWString error 32");	
	TEST_ENSHURE( s8.len() == 5, "test_OWString error 33");	
	
	//       "Ich bin ein String mit einem A und C und vielen m, m, m, m"
	//		  |	   |	|	 |	  |	   |	|	 |	  |	   |	|	 |
	//index	  0	   5	10	 15	  20   25	30	 35	  40   45	50	 55
	s8 = OUString::createFromAscii("Ich bin ein String mit einem A und C und vielen m, m, m, m");
	TEST_ENSHURE( s8.search((sal_Unicode)'I') == 0, "test_OWString error 34");	
	TEST_ENSHURE( s8.search((sal_Unicode)'A') == 29, "test_OWString error 35");	
	s7 = OUString::createFromAscii("A und C");
	TEST_ENSHURE( s8.search(s7) == 29, "test_OWString error 36");	
	TEST_ENSHURE( s8.search(OUString::createFromAscii("mit einem A")) == 19, "test_OWString error 37");	

	s8 = OUString::createFromAscii("||token1|token2|token3||token4|token5||" );
	TEST_ENSHURE( s8.getTokenCount('|') == 10, "test_OWString error 38a");	
	TEST_ENSHURE( s8.getToken(10,'|') == OUString(), "test_OWString error 39a");	

	s8 = OUString::createFromAscii("token1");
	TEST_ENSHURE( s8.getTokenCount('|') == 1, "test_OWString error 38b");	
	TEST_ENSHURE( s8.getToken(0,'|') == OUString::createFromAscii("token1"), "test_OWString error 39b");	
	TEST_ENSHURE( s8.getToken(-1,'|') == OUString(), "test_OWString error 39c");	
	TEST_ENSHURE( s8.getToken(1,'|') == OUString(), "test_OWString error 39d");	
	
	s8 = OUString::createFromAscii("|hallo1|hallo2|hallo3|hallo4|hallo5|hallo6|hallo7|hallo8|");
	TEST_ENSHURE( s8.getTokenCount((sal_Unicode)'|') == 10, "test_OWString error 38");	
	TEST_ENSHURE( s8.getToken(3, (sal_Unicode)'|') == OUString::createFromAscii("hallo3"), "test_OWString error 39");	

	s7 = OUString();
	s7 += s8;
	TEST_ENSHURE( s7 == s8, "test_OWString error 40");	

	s7 = s8.replaceAt(8, 6, OUString::createFromAscii("mmmmmmmmmm"));	
	TEST_ENSHURE( s7.getLength() == 61, "test_OWString error 41");	

	s8 = s7.replaceAt(8, 11, OUString());	
	TEST_ENSHURE( s8.getLength() == 50, "test_OWString error 42");	

	s7 = s8.replaceAt(8, 0, OUString::createFromAscii("hallo2|"));	
	TEST_ENSHURE( s7.getLength() == 57, "test_OWString error 43");	

	sal_Int32 pos = 0;
	while ((pos = s7.indexOf(OUString::createFromAscii("|"))) >= 0)
	{
		s8 = s7.replaceAt(pos, 1, OUString::createFromAscii("**"));
		s7 = s8;
	}	
	TEST_ENSHURE( s7.getLength() == 66, "test_OWString error 44");	

	TEST_ENSHURE( OUString::createFromAscii("aaa" ).compareTo( OUString::createFromAscii("bbb" ) ) < 0, "test_OWString error 46" );
	TEST_ENSHURE( OUString::createFromAscii("aaa" ).compareTo( OUString::createFromAscii("aaa" ) ) == 0, "test_OWString error 46" );
	TEST_ENSHURE( OUString::createFromAscii("bbb" ).compareTo( OUString::createFromAscii("aaa" ) ) > 0, "test_OWString error 47" );
	TEST_ENSHURE( OUString::createFromAscii("aaaa" ).compareTo( OUString::createFromAscii("bbb" ) ) < 0, "test_OWString error 48" );
	TEST_ENSHURE( OUString::createFromAscii("aaa" ).compareTo( OUString::createFromAscii("bbbb" ) ) < 0, "test_OWString error 49" );
	TEST_ENSHURE( OUString::createFromAscii("aaa" ).compareTo( OUString::createFromAscii("aaaa" ) ) < 0, "test_OWString error 50" );
	TEST_ENSHURE( OUString::createFromAscii("aaaa" ).compareTo( OUString::createFromAscii("aaa" ) ) > 0, "test_OWString error 51" );
	TEST_ENSHURE( OUString::createFromAscii("bbbb" ).compareTo( OUString::createFromAscii("bbb" ) ) > 0, "test_OWString error 52" );
	TEST_ENSHURE( OUString::createFromAscii("bbb" ) == OUString::createFromAscii("bbb" ), "test_OWString error 53" );
	TEST_ENSHURE( OUString::createFromAscii("bbb" ) == OUString::createFromAscii("bbb" ), "test_OWString error 54" );

	{
		OUString uStr = OUString::createFromAscii( "Hallo" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("Hallo"), 5 ) == 0, "test_OWString error 54.2.1" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("Halloa"), 6 ) < 0 , "test_OWString error 54.2.2" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("1Hallo"), 6 ) > 0, "test_OWString error 54.2.3" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("Aallo"), 5 ) > 0, "test_OWString error 54.2.4" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("Halla"), 5 ) > 0, "test_OWString error 54.2.5" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("Mallo"), 5 ) < 0, "test_OWString error 54.2.6" );
		TEST_ENSHURE( uStr.compareTo( OUString::createFromAscii("Hallp"), 5 ) < 0, "test_OWString error 54.2.7" );
	}

	s7 = OUString::createFromAscii("Hallo jetzt komm ich");
	s8 = s7.copy(0, s7.indexOf((sal_Unicode)':'));
	TEST_ENSHURE( s8.getLength() == 0, "test_OWString error 55");
	TEST_ENSHURE( s8.compareTo(OUString()) == 0, "test_OWString error 56");


	// ASCII-Schnittstellen, AB 15.10.1999

	//       "Ich bin ein reiner ASCII-String mit ein paar Zahlen 0123456789 und Zeichen"
	//		  |	   |	|	 |	  |	   |	|	 |	  |	   |	|    |    |    |    |
	//index	  0	   5	10	 15	  20   25	30	 35	  40   45	50	 55   60   65   70
	//
	//       "Ich bin ein weiterer ASCII-String"
	//		  |	   |	|	 |	  |	   |	|
	//index	  0	   5	10	 15	  20   25	30
	sal_Char ascii_str1[] = "Ich bin ein reiner ASCII-String mit ein paar Zahlen 0123456789 und Zeichen";
	sal_Char ascii_str2[] = "Ich bin ein weiterer ASCII-String";
	OUString OWAsciiStr1 = OUString::createFromAscii( ascii_str1 );
	sal_Int32 nLen1 = OWAsciiStr1.getLength();
	TEST_ENSHURE( nLen1 == 74, "test_OWString error 57" );
	OUString OWAsciiStr2 = OUString::createFromAscii( ascii_str2 );
	sal_Int32 nLen2 = OWAsciiStr2.getLength();
	TEST_ENSHURE( nLen2 == 33, "test_OWString error 58" );

	sal_Int32 nCompareResult11 = OWAsciiStr1.compareToAscii( ascii_str1 );
	TEST_ENSHURE( nCompareResult11 == 0, "test_OWString error 59" );
	sal_Int32 nCompareResult12 = OWAsciiStr1.compareToAscii( ascii_str2 );
	TEST_ENSHURE( nCompareResult12 < 0, "test_OWString error 60" );

	sal_Int32 nCompareResult21 = OWAsciiStr2.compareToAscii( ascii_str1 );
	TEST_ENSHURE( nCompareResult21 > 0, "test_OWString error 61" );
	sal_Int32 nCompareResult22 = OWAsciiStr2.compareToAscii( ascii_str2 );
	TEST_ENSHURE( nCompareResult22 == 0, "test_OWString error 62" );

	sal_Int32 nCompareResult12_Len12 = OWAsciiStr1.compareToAscii( ascii_str2, 12 );
	TEST_ENSHURE( nCompareResult12_Len12 == 0, "test_OWString error 63" );
	sal_Int32 nCompareResult12_Len13 = OWAsciiStr1.compareToAscii( ascii_str2, 13 );
	TEST_ENSHURE( nCompareResult12_Len13 < 0, "test_OWString error 64" );

	sal_Int32 nCompareResult21_Len12 = OWAsciiStr2.compareToAscii( ascii_str1, 12 );
	TEST_ENSHURE( nCompareResult12_Len12 == 0, "test_OWString error 65" );
	sal_Int32 nCompareResult21_Len13 = OWAsciiStr2.compareToAscii( ascii_str1, 13 );
	TEST_ENSHURE( nCompareResult21_Len13 > 0, "test_OWString error 66" );

	{
		OUString uStr = OUString::createFromAscii( "Hallo" );
		TEST_ENSHURE( uStr.equalsAsciiL( "Hallo", 5 ), "test_OWString error 66.1.1" );
		TEST_ENSHURE( !uStr.equalsAsciiL( "Hallo1", 6 ), "test_OWString error 66.1.2" );
		TEST_ENSHURE( !uStr.equalsAsciiL( "1Hallo", 6 ), "test_OWString error 66.1.3" );
		TEST_ENSHURE( !uStr.equalsAsciiL( "aallo", 5 ), "test_OWString error 66.1.2" );
		TEST_ENSHURE( !uStr.equalsAsciiL( "Halla", 5 ), "test_OWString error 66.1.3" );

		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "Hallo", 5 ) == 0, "test_OWString error 66.2.1" );
		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "Halloa", 6 ) > 0 , "test_OWString error 66.2.2" );
		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "1Hallo", 6 ) < 0, "test_OWString error 66.2.3" );
		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "Aallo", 5 ) > 0, "test_OWString error 66.2.4" );
		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "Halla", 5 ) > 0, "test_OWString error 66.2.5" );
		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "Mallo", 5 ) < 0, "test_OWString error 66.2.6" );
		TEST_ENSHURE( uStr.reverseCompareToAsciiL( "Hallp", 5 ) < 0, "test_OWString error 66.2.7" );
	}

	// toInt64
	OUString s9( OUString::createFromAscii(" -3223372036854775807") );
	sal_Int64 ln1 = s9.toInt64();
	TEST_ENSHURE( ln1 == -3223372036854775807, "test_OWString error 67" );

	OUString s10( OUString::createFromAscii("13243A65f1H45") );
	sal_Int64 ln2 = s10.toInt64();
	TEST_ENSHURE( ln2 == 13243, "test_OWString error 68" );

	sal_Int64 ln3 = s10.toInt64( 16 );
	TEST_ENSHURE( ln3 == 0x13243A65F1, "test_OWString error 69" );

	// Exotic base
	OUString s11( OUString::createFromAscii("H4A") );
	sal_Int64 ln4 = s11.toInt64( 23 );
	TEST_ENSHURE( ln4 == 23*23*17 + 4 * 23 + 10, "test_OWString error 70" );

	// toInt32
	OUString s12( OUString::createFromAscii(" -220368507") );
	sal_Int32 n1 = s12.toInt32();
	TEST_ENSHURE( n1 == -220368507, "test_OWString error 71" );

	OUString s13( OUString::createFromAscii("4423A61H45") );
	sal_Int64 n2 = s13.toInt32();
	TEST_ENSHURE( n2 == 4423, "test_OWString error 72" );

	sal_Int64 n3 = s13.toInt64( 16 );
	TEST_ENSHURE( n3 == 0x4423A61, "test_OWString error 73" );

	double d = 1.23456781;
	OUString sDouble = OUString::valueOf( d );
	char str[] = "1.2345678099999999";
	sal_Int32 nLength = sDouble.getLength();
	TEST_ENSHURE( nLength == strlen( str ), "test_OWString error 74" );
	sal_Int32 nCompare = sDouble.compareToAscii( str );
	TEST_ENSHURE( nCompare == 0, "test_OWString error 75" );

	printf("test_OWString OK !!!\n");
	return;
}

void test_OString2OWStringAndViceVersa()
{
	OString s1("Hallo jetzt komm ich");
	OUString u1 = OStringToOUString(s1, RTL_TEXTENCODING_MS_1252);
	TEST_ENSHURE( u1.equals(OUString::createFromAscii("Hallo jetzt komm ich")), "test_OString2OWStringAndViceVersa error 1" );
	u1 = OStringToOUString(s1, RTL_TEXTENCODING_IBM_850);
	TEST_ENSHURE( u1.equals(OUString::createFromAscii("Hallo jetzt komm ich")), "test_OString2OWStringAndViceVersa error 2" );
	u1 = OStringToOUString(s1, RTL_TEXTENCODING_ISO_8859_15);
	TEST_ENSHURE( u1.equals(OUString::createFromAscii("Hallo jetzt komm ich")), "test_OString2OWStringAndViceVersa error 3" );
	u1 = OStringToOUString(s1, RTL_TEXTENCODING_ASCII_US);
	TEST_ENSHURE( u1.equals(OUString::createFromAscii("Hallo jetzt komm ich")), "test_OString2OWStringAndViceVersa error 4" );

	OString s2 = OUStringToOString(u1, RTL_TEXTENCODING_MS_1252);
	TEST_ENSHURE( s2.equals("Hallo jetzt komm ich"), "test_OString2OWStringAndViceVersa error 5" );
	s2 = OUStringToOString(u1, RTL_TEXTENCODING_IBM_850);
	TEST_ENSHURE( s2.equals("Hallo jetzt komm ich"), "test_OString2OWStringAndViceVersa error 6" );
	s2 = OUStringToOString(u1, RTL_TEXTENCODING_ISO_8859_15);
	TEST_ENSHURE( s2.equals("Hallo jetzt komm ich"), "test_OString2OWStringAndViceVersa error 7" );
	s2 = OUStringToOString(u1, RTL_TEXTENCODING_ASCII_US);
	TEST_ENSHURE( s2.equals("Hallo jetzt komm ich"), "test_OString2OWStringAndViceVersa error 8" );

	/*
	s1 = ", 1 2 3 ! \"  $ % & ( ) = ? ";
	u1 = OStringToOUString(s1, RTL_TEXTENCODING_MS_1252);
	TEST_ENSHURE( u1.equals(OUString::createFromAscii(", 1 2 3 ! \"  $ % & ( ) = ? ")), "test_OString2OWStringAndViceVersa error 9" );

	s2 = OUStringToOString(u1, RTL_TEXTENCODING_MS_1252);
	TEST_ENSHURE( s2.equals(", 1 2 3 ! \"  $ % & ( ) = ? "), "test_OString2OWStringAndViceVersa error 10" );
	*/

	printf("test_OString2OWStringAndViceVersa OK !!!\n");
}

